/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.AddFieldPatch;
import com.pclewis.mcpatcher.AddMethodPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.InterfaceMethodRef;
import com.pclewis.mcpatcher.MakeMemberPublicPatch;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.OrSignature;
import java.io.IOException;
import javassist.bytecode.BadBytecode;

public class BaseTexturePackMod
extends Mod {
    public static final String NAME = "__TexturePackBase";
    protected final MethodRef checkForTexturePackChange = new MethodRef("com.pclewis.mcpatcher.TexturePackAPI$ChangeHandler", "checkForTexturePackChange", "()V");
    protected final boolean haveFolderTexturePacks;
    protected final boolean haveITexturePack;
    protected final String texturePackType;

    protected BaseTexturePackMod(MinecraftVersion minecraftVersion) {
        this.name = NAME;
        this.author = "MCPatcher";
        this.description = "Internal mod required by the patcher.";
        this.version = "1.1";
        this.haveFolderTexturePacks = minecraftVersion.compareTo("12w08a") >= 0;
        this.haveITexturePack = minecraftVersion.compareTo("12w15a") >= 0;
        this.texturePackType = this.haveITexturePack ? "LITexturePack;" : "LTexturePackBase;";
        this.classMods.add(new MinecraftMod());
        this.classMods.add(new RenderEngineMod());
        this.classMods.add(new TexturePackListMod());
        if (this.haveITexturePack) {
            this.classMods.add(new ITexturePackMod());
        }
        this.classMods.add(new TexturePackBaseMod());
        this.classMods.add(new TexturePackDefaultMod());
        this.classMods.add(new TexturePackCustomMod());
        if (this.haveFolderTexturePacks) {
            this.classMods.add(new TexturePackFolderMod());
        }
        this.classMods.add(new GetResourceMod());
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.TexturePackAPI"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.TexturePackAPI$ChangeHandler"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.TexturePackAPI$ChangeHandler$1"));
    }

    private class GetResourceMod
    extends ClassMod {
        GetResourceMod() {
            this.global = true;
            final MethodRef getResource = new MethodRef("java.lang.Class", "getResource", "(Ljava/lang/String;)Ljava/net/URL;");
            final MethodRef readURL = new MethodRef("javax.imageio.ImageIO", "read", "(Ljava/net/URL;)Ljava/awt/image/BufferedImage;");
            final MethodRef getResourceAsStream = new MethodRef("java.lang.Class", "getResourceAsStream", "(Ljava/lang/String;)Ljava/io/InputStream;");
            final MethodRef readStream = new MethodRef("javax.imageio.ImageIO", "read", "(Ljava/io/InputStream;)Ljava/awt/image/BufferedImage;");
            this.classSignatures.add(new OrSignature(new ConstSignature(getResource), new ConstSignature(getResourceAsStream)));
            this.classSignatures.add(new OrSignature(new ConstSignature(readURL), new ConstSignature(readStream)));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "ImageIO.read(getResource(...)) -> getImage(...)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(this.buildExpression(this.reference(182, getResource), this.reference(184, readURL)), this.buildExpression(this.reference(182, getResourceAsStream), this.reference(184, readStream))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.TexturePackAPI", "getImage", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/awt/image/BufferedImage;"))});
                }
            });
        }
    }

    private class TexturePackFolderMod
    extends ClassMod {
        TexturePackFolderMod() {
            this.parentClass = "TexturePackBase";
            String fileFieldName = BaseTexturePackMod.this.haveITexturePack ? "file" : "folder";
            final FieldRef file = new FieldRef(this.getDeobfClass(), fileFieldName, "Ljava/io/File;");
            MethodRef getFolder = new MethodRef(this.getDeobfClass(), "getFolder", "()Ljava/io/File;");
            final MethodRef substring = new MethodRef("java/lang/String", "substring", "(I)Ljava/lang/String;");
            this.classSignatures.add(new ConstSignature(new ClassRef("java.io.FileInputStream")));
            if (BaseTexturePackMod.this.haveITexturePack) {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(43, this.push(1), this.reference(182, substring));
                    }
                });
            } else {
                this.classSignatures.add(new ConstSignature("pack.txt"));
                this.classSignatures.add(new ConstSignature("pack.png"));
                this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(file));
            }
            this.patches.add(new AddMethodPatch(getFolder){

                public byte[] generateMethod() throws BadBytecode, IOException {
                    return this.buildCode(42, this.reference(180, file), 176);
                }
            });
        }
    }

    private class TexturePackCustomMod
    extends ClassMod {
        TexturePackCustomMod() {
            this.parentClass = "TexturePackBase";
            FieldRef file = new FieldRef(this.getDeobfClass(), "file", "Ljava/io/File;");
            FieldRef zipFile = new FieldRef(this.getDeobfClass(), "zipFile", "Ljava/util/zip/ZipFile;");
            this.classSignatures.add(new ConstSignature(new MethodRef("java/util/zip/ZipFile", "getEntry", "(Ljava/lang/String;)Ljava/util/zip/ZipEntry;")));
            this.classSignatures.add(new ConstSignature(new MethodRef("java/util/zip/ZipFile", "close", "()V")));
            if (!BaseTexturePackMod.this.haveITexturePack) {
                this.classSignatures.add(new ConstSignature("pack.txt"));
                this.classSignatures.add(new ConstSignature("pack.png"));
                this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(file));
                this.patches.add(new MakeMemberPublicPatch(file));
            }
            this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(zipFile));
            this.patches.add(new MakeMemberPublicPatch(zipFile));
            this.patches.add(new AddFieldPatch(new FieldRef(this.getDeobfClass(), "origZip", "Ljava/util/zip/ZipFile;")));
            this.patches.add(new AddFieldPatch(new FieldRef(this.getDeobfClass(), "tmpFile", "Ljava/io/File;")));
            this.patches.add(new AddFieldPatch(new FieldRef(this.getDeobfClass(), "lastModified", "J")));
        }
    }

    private class TexturePackDefaultMod
    extends ClassMod {
        TexturePackDefaultMod() {
            this.parentClass = "TexturePackBase";
            this.classSignatures.add(new ConstSignature("The default look of Minecraft"));
        }
    }

    private class TexturePackBaseMod
    extends ClassMod {
        TexturePackBaseMod() {
            FieldRef file = new FieldRef(this.getDeobfClass(), "file", "Ljava/io/File;");
            FieldRef texturePackFileName = new FieldRef(this.getDeobfClass(), "texturePackFileName", "Ljava/lang/String;");
            MethodRef getInputStream = new MethodRef(this.getDeobfClass(), "getInputStream", "(Ljava/lang/String;)Ljava/io/InputStream;");
            final MethodRef getResourceAsStream = new MethodRef("java.lang.Class", "getResourceAsStream", "(Ljava/lang/String;)Ljava/io/InputStream;");
            this.classSignatures.add(new ConstSignature(getResourceAsStream));
            if (BaseTexturePackMod.this.haveITexturePack) {
                this.interfaces = new String[]{"ITexturePack"};
                this.classSignatures.add(new ConstSignature("/pack.txt"));
                this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(file));
                this.patches.add(new MakeMemberPublicPatch(file));
            } else {
                this.classSignatures.add(new ConstSignature("pack.txt").negate(true));
            }
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(43, this.reference(182, getResourceAsStream), 176);
                }
            }.setMethod(getInputStream));
            this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(texturePackFileName));
            this.patches.add(new MakeMemberPublicPatch(texturePackFileName));
        }
    }

    private class ITexturePackMod
    extends ClassMod {
        ITexturePackMod() {
            this.prerequisiteClasses.add("TexturePackBase");
            this.memberMappers.add((ClassMod)this.new ClassMod.MethodMapper(new MethodRef(this.getDeobfClass(), "getInputStream", "(Ljava/lang/String;)Ljava/io/InputStream;")));
        }
    }

    private class TexturePackListMod
    extends ClassMod {
        TexturePackListMod() {
            MethodRef getDefaultTexturePack = new MethodRef(this.getDeobfClass(), "getDefaultTexturePack", "()LTexturePackBase;");
            MethodRef getSelectedTexturePack = new MethodRef(this.getDeobfClass(), "getSelectedTexturePack", "()LTexturePackBase;");
            MethodRef setTexturePack = new MethodRef(this.getDeobfClass(), "setTexturePack", "(" + BaseTexturePackMod.this.texturePackType + ")Z");
            MethodRef updateAvailableTexturePacks = new MethodRef(this.getDeobfClass(), "updateAvailableTexturePacks", "()V");
            final ClassRef texturePackClass = new ClassRef("TexturePackBase");
            this.classSignatures.add(new ConstSignature(".zip"));
            this.classSignatures.add(new ConstSignature("texturepacks"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), 43, this.reference(185, new InterfaceMethodRef("java/util/List", "removeAll", "(Ljava/util/Collection;)Z")), 87);
                }
            }.setMethod(updateAvailableTexturePacks));
            this.memberMappers.add((ClassMod)this.new ClassMod.MethodMapper(setTexturePack));
            if (BaseTexturePackMod.this.haveITexturePack) {
                final FieldRef selectedTexturePack = new FieldRef(this.getDeobfClass(), "selectedTexturePack", "LITexturePack;");
                final FieldRef defaultTexturePack = new FieldRef(this.getDeobfClass(), "defaultTexturePack", "LITexturePack;");
                this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(selectedTexturePack).accessFlag(2, true).accessFlag(8, false).accessFlag(16, false));
                this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(defaultTexturePack).accessFlag(2, true).accessFlag(8, true).accessFlag(16, true));
                this.patches.add(new AddMethodPatch(getDefaultTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(this.reference(178, defaultTexturePack), this.reference(192, texturePackClass), 176);
                    }
                });
                this.patches.add(new AddMethodPatch(getSelectedTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, selectedTexturePack), this.reference(192, texturePackClass), 176);
                    }
                });
            } else {
                final FieldRef selectedTexturePack = new FieldRef(this.getDeobfClass(), "selectedTexturePack", "LTexturePackBase;");
                final FieldRef defaultTexturePack = new FieldRef(this.getDeobfClass(), "defaultTexturePack", "LTexturePackBase;");
                this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(selectedTexturePack).accessFlag(1, true));
                this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(defaultTexturePack).accessFlag(2, true));
                this.patches.add(new AddMethodPatch(getDefaultTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, defaultTexturePack), 176);
                    }
                });
                this.patches.add(new AddMethodPatch(getSelectedTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, selectedTexturePack), 176);
                    }
                });
            }
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "handle texture pack change";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(1), 172);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, BaseTexturePackMod.this.checkForTexturePackChange)});
                }
            }.targetMethod(setTexturePack));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "handle texture pack list change";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, BaseTexturePackMod.this.checkForTexturePackChange)});
                }
            }.targetMethod(updateAvailableTexturePacks));
        }
    }

    private class RenderEngineMod
    extends BaseMod.RenderEngineMod {
        RenderEngineMod() {
            MethodRef deleteTexture = new MethodRef(this.getDeobfClass(), "deleteTexture", "(I)V");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glDeleteTextures", "(Ljava/nio/IntBuffer;)V"))});
                }
            }.setMethod(deleteTexture));
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod() {
            FieldRef texturePackList = new FieldRef(this.getDeobfClass(), "texturePackList", "LTexturePackList;");
            FieldRef renderEngine = new FieldRef(this.getDeobfClass(), "renderEngine", "LRenderEngine;");
            MethodRef startGame = new MethodRef(this.getDeobfClass(), "startGame", "()V");
            MethodRef runGameLoop = new MethodRef(this.getDeobfClass(), "runGameLoop", "()V");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org/lwjgl/opengl/Display", "setTitle", "(Ljava/lang/String;)V"))});
                }
            }.setMethod(startGame));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org/lwjgl/opengl/Display", "isCloseRequested", "()Z"))});
                }
            }.setMethod(runGameLoop));
            this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(texturePackList));
            this.memberMappers.add((ClassMod)this.new ClassMod.FieldMapper(renderEngine));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "init texture pack handlers on startup";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, BaseTexturePackMod.this.checkForTexturePackChange)});
                }
            }.targetMethod(startGame));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "check for texture pack change";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, BaseTexturePackMod.this.checkForTexturePackChange)});
                }
            }.targetMethod(runGameLoop));
        }
    }
}

