/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.BinaryMatcher;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.Logger;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.MethodInfo;

public class BytecodeMatcher
extends BinaryMatcher {
    public static final String anyALOAD = BinaryRegex.or(BinaryRegex.build(42), BinaryRegex.build(43), BinaryRegex.build(44), BinaryRegex.build(45), BinaryRegex.build(25, BinaryRegex.any()), BinaryRegex.build(196, 25, BinaryRegex.any(2)));
    public static final String anyASTORE = BinaryRegex.or(BinaryRegex.build(75), BinaryRegex.build(76), BinaryRegex.build(77), BinaryRegex.build(78), BinaryRegex.build(58, BinaryRegex.any()), BinaryRegex.build(196, 58, BinaryRegex.any(2)));
    public static final String anyILOAD = BinaryRegex.or(BinaryRegex.build(26), BinaryRegex.build(27), BinaryRegex.build(28), BinaryRegex.build(29), BinaryRegex.build(21, BinaryRegex.any()), BinaryRegex.build(196, 21, BinaryRegex.any(2)));
    public static final String anyISTORE = BinaryRegex.or(BinaryRegex.build(59), BinaryRegex.build(60), BinaryRegex.build(61), BinaryRegex.build(62), BinaryRegex.build(54, BinaryRegex.any()), BinaryRegex.build(196, 54, BinaryRegex.any(2)));
    public static final String anyFLOAD = BinaryRegex.or(BinaryRegex.build(34), BinaryRegex.build(35), BinaryRegex.build(36), BinaryRegex.build(37), BinaryRegex.build(23, BinaryRegex.any()), BinaryRegex.build(196, 23, BinaryRegex.any(2)));
    public static final String anyFSTORE = BinaryRegex.or(BinaryRegex.build(67), BinaryRegex.build(68), BinaryRegex.build(69), BinaryRegex.build(70), BinaryRegex.build(56, BinaryRegex.any()), BinaryRegex.build(196, 56, BinaryRegex.any(2)));
    public static final String anyDLOAD = BinaryRegex.or(BinaryRegex.build(38), BinaryRegex.build(39), BinaryRegex.build(40), BinaryRegex.build(41), BinaryRegex.build(24, BinaryRegex.any()), BinaryRegex.build(196, 24, BinaryRegex.any(2)));
    public static final String anyDSTORE = BinaryRegex.or(BinaryRegex.build(71), BinaryRegex.build(72), BinaryRegex.build(73), BinaryRegex.build(74), BinaryRegex.build(57, BinaryRegex.any()), BinaryRegex.build(196, 57, BinaryRegex.any(2)));
    public static final String anyLDC = BinaryRegex.or(BinaryRegex.build(18, BinaryRegex.any()), BinaryRegex.build(19, BinaryRegex.any(2)));
    public static final String IFEQ_or_IFNE;
    public static final String IFNE_or_IFEQ;
    public static final String IFGE_or_IFLT;
    public static final String IFLT_or_IFGE;
    public static final String IFLE_or_IFGT;
    public static final String IFGT_or_IFLE;
    public static final String IFNULL_or_IFNONNULL;
    public static final String IFNONNULL_or_IFNULL;
    public static final String IF_ACMPEQ_or_IF_ACMPNE;
    public static final String IF_ACMPNE_or_IF_ACMPEQ;
    public static final String IF_ICMPEQ_or_IF_ICMPNE;
    public static final String IF_ICMPNE_or_IF_ICMPEQ;
    public static final String IF_ICMPGE_or_IF_ICMPLT;
    public static final String IF_ICMPLT_or_IF_ICMPGE;
    public static final String IF_ICMPLE_or_IF_ICMPGT;
    public static final String IF_ICMPGT_or_IF_ICMPLE;
    private static final int[] ALOAD_OPCODES;
    private static final int[] ASTORE_OPCODES;
    private static final int[] ILOAD_OPCODES;
    private static final int[] ISTORE_OPCODES;
    private static final int[] LLOAD_OPCODES;
    private static final int[] LSTORE_OPCODES;
    private static final int[] FLOAD_OPCODES;
    private static final int[] FSTORE_OPCODES;
    private static final int[] DLOAD_OPCODES;
    private static final int[] DSTORE_OPCODES;

    public static String anyReference(int opcode) {
        return BinaryRegex.build(opcode, BinaryRegex.any(opcode == 185 ? 4 : 2));
    }

    public static String captureReference(int opcode) {
        return BinaryRegex.capture(BytecodeMatcher.anyReference(opcode));
    }

    private static byte[] registerLoadStore(int[] x, int y, int register) {
        if (register < 0 || register > 255) {
            throw new IllegalArgumentException("invalid register " + register);
        }
        if (register < x.length) {
            return new byte[]{(byte)x[register]};
        }
        return new byte[]{(byte)y, (byte)register};
    }

    public static byte[] registerLoadStore(int opcode, int register) {
        switch (opcode) {
            case 25: {
                return BytecodeMatcher.registerLoadStore(ALOAD_OPCODES, 25, register);
            }
            case 58: {
                return BytecodeMatcher.registerLoadStore(ASTORE_OPCODES, 58, register);
            }
            case 21: {
                return BytecodeMatcher.registerLoadStore(ILOAD_OPCODES, 21, register);
            }
            case 54: {
                return BytecodeMatcher.registerLoadStore(ISTORE_OPCODES, 54, register);
            }
            case 22: {
                return BytecodeMatcher.registerLoadStore(LLOAD_OPCODES, 22, register);
            }
            case 55: {
                return BytecodeMatcher.registerLoadStore(LSTORE_OPCODES, 55, register);
            }
            case 23: {
                return BytecodeMatcher.registerLoadStore(FLOAD_OPCODES, 23, register);
            }
            case 56: {
                return BytecodeMatcher.registerLoadStore(FSTORE_OPCODES, 56, register);
            }
            case 24: {
                return BytecodeMatcher.registerLoadStore(DLOAD_OPCODES, 24, register);
            }
            case 57: {
                return BytecodeMatcher.registerLoadStore(DSTORE_OPCODES, 57, register);
            }
        }
        throw new IllegalArgumentException("invalid opcode " + opcode);
    }

    public BytecodeMatcher(Object ... objects) {
        super(objects);
    }

    public boolean match(ClassFile classFile) {
        for (Object o : classFile.getMethods()) {
            MethodInfo mi = (MethodInfo)o;
            if (!this.match(mi)) continue;
            return true;
        }
        return false;
    }

    public boolean match(MethodInfo methodInfo) {
        return this.match(methodInfo, 0);
    }

    public boolean match(MethodInfo methodInfo, int offset) {
        CodeAttribute ca = methodInfo.getCodeAttribute();
        CodeIterator ci = ca.iterator();
        byte[] code = ca.getCode();
        while (offset < code.length && this.match(code, offset)) {
            int next;
            try {
                next = offset;
                while (next < this.getStart() && ci.hasNext()) {
                    next = ci.next();
                }
            }
            catch (BadBytecode e) {
                Logger.log(e);
                break;
            }
            if (next == this.getStart()) {
                return true;
            }
            offset = next;
        }
        return false;
    }

    static {
        IFNE_or_IFEQ = IFEQ_or_IFNE = BinaryRegex.subset(new int[]{153, 154}, true);
        IFLT_or_IFGE = IFGE_or_IFLT = BinaryRegex.subset(new int[]{156, 155}, true);
        IFGT_or_IFLE = IFLE_or_IFGT = BinaryRegex.subset(new int[]{158, 157}, true);
        IFNONNULL_or_IFNULL = IFNULL_or_IFNONNULL = BinaryRegex.subset(new int[]{198, 199}, true);
        IF_ACMPNE_or_IF_ACMPEQ = IF_ACMPEQ_or_IF_ACMPNE = BinaryRegex.subset(new int[]{165, 166}, true);
        IF_ICMPNE_or_IF_ICMPEQ = IF_ICMPEQ_or_IF_ICMPNE = BinaryRegex.subset(new int[]{159, 160}, true);
        IF_ICMPLT_or_IF_ICMPGE = IF_ICMPGE_or_IF_ICMPLT = BinaryRegex.subset(new int[]{162, 161}, true);
        IF_ICMPGT_or_IF_ICMPLE = IF_ICMPLE_or_IF_ICMPGT = BinaryRegex.subset(new int[]{164, 163}, true);
        ALOAD_OPCODES = new int[]{42, 43, 44, 45};
        ASTORE_OPCODES = new int[]{75, 76, 77, 78};
        ILOAD_OPCODES = new int[]{26, 27, 28, 29};
        ISTORE_OPCODES = new int[]{59, 60, 61, 62};
        LLOAD_OPCODES = new int[]{30, 31, 32, 33};
        LSTORE_OPCODES = new int[]{63, 64, 65, 66};
        FLOAD_OPCODES = new int[]{34, 35, 36, 37};
        FSTORE_OPCODES = new int[]{67, 68, 69, 70};
        DLOAD_OPCODES = new int[]{38, 39, 40, 41};
        DSTORE_OPCODES = new int[]{71, 72, 73, 74};
    }
}

