/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.BinaryMatcher;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ConstPoolUtils;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.InterfaceMethodRef;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.Util;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarOutputStream;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMap {
    private static final String DESCRIPTOR_CHARS = BinaryRegex.subset("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_$/.[<>;".getBytes(), true);
    private HashMap<String, ClassMapEntry> classMap = new HashMap();

    ClassMap() {
    }

    public static String filenameToClassName(String filename) {
        return filename.replaceAll("\\.class$", "").replaceAll("^/", "").replace('/', '.');
    }

    public static String classNameToFilename(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static String descriptorToClassName(String descriptor) {
        return descriptor.replaceFirst("^\\[*L(.*);$", "$1").replace('/', '.');
    }

    private ClassMapEntry getEntry(String descName) {
        ClassMapEntry entry = this.classMap.get(descName = descName.replace('.', '/'));
        return entry == null ? null : entry.getEntry();
    }

    private void putEntry(ClassMapEntry entry) {
        this.classMap.put(entry.descName, entry);
    }

    public void addClassMap(String descName, String obfName) {
        String oldName;
        ClassMapEntry entry = this.getEntry(descName);
        if (entry == null) {
            entry = new ClassMapEntry(descName, obfName);
            this.putEntry(entry);
            if (descName.equals("Minecraft") || descName.equals("MinecraftApplet")) {
                this.putEntry(new ClassMapEntry("net.minecraft.client." + descName, entry));
            } else if (!descName.contains(".")) {
                this.putEntry(new ClassMapEntry("net.minecraft.src." + descName, entry));
            }
        }
        if ((oldName = entry.getObfName()) == null) {
            entry.setObfName(obfName);
        } else if (!oldName.equals(obfName.replace('.', '/'))) {
            throw new RuntimeException(String.format("cannot add class map %1$s -> %2$s because there is already a class map for %1$s -> %3$s", descName, obfName, oldName));
        }
    }

    public void addMethodMap(String classDescName, String descName, String obfName, String obfType) {
        ClassMapEntry entry = this.getEntry(classDescName);
        if (entry == null) {
            throw new RuntimeException(String.format("cannot add method map %s.%s -> %s because there is no class map for %s", classDescName, descName, obfName, classDescName));
        }
        String oldName = entry.getMethod(descName);
        if (oldName != null && !oldName.equals(obfName)) {
            throw new RuntimeException(String.format("cannot add method map %1$s.%2$s -> %3$s because it is already mapped to %4$s", classDescName, descName, obfName, oldName));
        }
        entry.addMethod(descName, obfName, obfType);
    }

    public void addFieldMap(String classDescName, String descName, String obfName, String obfType) {
        ClassMapEntry entry = this.getEntry(classDescName);
        if (entry == null) {
            throw new RuntimeException(String.format("cannot add field map %s.%s -> %s because there is no class map for %s", classDescName, descName, obfName, classDescName));
        }
        String oldName = entry.getField(descName);
        if (oldName != null && !oldName.equals(obfName)) {
            throw new RuntimeException(String.format("cannot add field map %1$s.%2$s -> %3$s because it is already mapped to %4$s", classDescName, descName, obfName, oldName));
        }
        entry.addField(descName, obfName, obfType);
    }

    public void addMap(JavaRef from, JavaRef to) {
        if (!from.getClass().equals(to.getClass())) {
            throw new IllegalArgumentException(String.format("cannot map %s to %s", from.toString(), to.toString()));
        }
        this.addClassMap(from.getClassName(), to.getClassName());
        if (from instanceof MethodRef || from instanceof InterfaceMethodRef) {
            this.addMethodMap(from.getClassName(), from.getName(), to.getName(), to.getType());
            this.addTypeDescriptorMap(from.getType(), to.getType());
        } else if (from instanceof FieldRef) {
            this.addFieldMap(from.getClassName(), from.getName(), to.getName(), to.getType());
            this.addTypeDescriptorMap(from.getType(), to.getType());
        }
    }

    public void addTypeDescriptorMap(String fromType, String toType) {
        int i = 0;
        int j = 0;
        while (i < fromType.length() && j < toType.length()) {
            int i1 = i;
            int j1 = j;
            if (fromType.charAt(i) == 'L') {
                String to;
                i1 = fromType.indexOf(59, i);
                j1 = toType.indexOf(59, j);
                if (i1 < 0) {
                    throw new IllegalArgumentException(String.format("invalid type descriptor %s", fromType));
                }
                if (j1 < 0) {
                    throw new IllegalArgumentException(String.format("invalid type descriptor %s", toType));
                }
                String from = fromType.substring(i + 1, i1).replace('.', '/');
                if (!from.equals(to = toType.substring(j + 1, j1).replace('.', '/'))) {
                    this.addClassMap(from, to);
                }
            } else if (fromType.charAt(i) != toType.charAt(j)) break;
            i = i1 + 1;
            j = j1 + 1;
        }
        if (i < fromType.length() || j < toType.length()) {
            throw new IllegalArgumentException(String.format("incompatible type descriptors %s and %s", fromType, toType));
        }
    }

    public void addInheritance(String parent, String child) {
        ClassMapEntry childEntry;
        ClassMapEntry parentEntry = this.getEntry(parent);
        if (parentEntry == null) {
            parentEntry = new ClassMapEntry(parent);
            this.putEntry(parentEntry);
        }
        if ((childEntry = this.getEntry(child)) == null) {
            childEntry = new ClassMapEntry(child, child, parentEntry);
            this.putEntry(childEntry);
        } else {
            childEntry.setParent(parentEntry);
        }
    }

    public boolean isEmpty() {
        return this.classMap.isEmpty();
    }

    public HashMap<String, String> getClassMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, ClassMapEntry> e : this.classMap.entrySet()) {
            map.put(e.getKey(), e.getValue().getObfName());
        }
        return map;
    }

    public HashMap<String, String> getReverseClassMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, ClassMapEntry> e : this.classMap.entrySet()) {
            if (e.getValue().aliasFor != null) continue;
            map.put(e.getValue().getObfName(), e.getKey());
        }
        return map;
    }

    public HashMap<String, MemberEntry> getMethodMap(String classDescName) {
        ClassMapEntry entry = this.getEntry(classDescName);
        return entry == null ? new HashMap<String, MemberEntry>() : entry.getMethodMap();
    }

    public HashMap<String, MemberEntry> getFieldMap(String classDescName) {
        ClassMapEntry entry = this.getEntry(classDescName);
        return entry == null ? new HashMap<String, MemberEntry>() : entry.getFieldMap();
    }

    void print(PrintStream out, String indent) {
        ArrayList<Map.Entry<String, ClassMapEntry>> sortedClasses = new ArrayList<Map.Entry<String, ClassMapEntry>>(this.classMap.entrySet());
        Collections.sort(sortedClasses, new Comparator<Map.Entry<String, ClassMapEntry>>(){

            @Override
            public int compare(Map.Entry<String, ClassMapEntry> o1, Map.Entry<String, ClassMapEntry> o2) {
                if (o1.getValue().aliasFor == null && o2.getValue().aliasFor != null) {
                    return -1;
                }
                if (o1.getValue().aliasFor != null && o2.getValue().aliasFor == null) {
                    return 1;
                }
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry<String, ClassMapEntry> e : sortedClasses) {
            out.printf("%1$sclass %2$s\n", indent, e.getValue().toString());
            if (e.getValue().aliasFor != null) continue;
            ArrayList<Map.Entry<String, MemberEntry>> sortedMembers = new ArrayList<Map.Entry<String, MemberEntry>>(e.getValue().getMethodMap().entrySet());
            Collections.sort(sortedMembers, new Comparator<Map.Entry<String, MemberEntry>>(){

                @Override
                public int compare(Map.Entry<String, MemberEntry> o1, Map.Entry<String, MemberEntry> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            for (Map.Entry<String, MemberEntry> e1 : sortedMembers) {
                out.printf("%1$s%1$smethod %2$s -> %3$s %4$s\n", indent, e1.getKey(), e1.getValue().name, e1.getValue().type);
            }
            sortedMembers = new ArrayList<Map.Entry<String, MemberEntry>>(e.getValue().getFieldMap().entrySet());
            Collections.sort(sortedMembers, new Comparator<Map.Entry<String, MemberEntry>>(){

                @Override
                public int compare(Map.Entry<String, MemberEntry> o1, Map.Entry<String, MemberEntry> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            for (Map.Entry<String, MemberEntry> e1 : sortedMembers) {
                out.printf("%1$s%1$sfield %2$s -> %3$s %4$s\n", indent, e1.getKey(), e1.getValue().name, e1.getValue().type);
            }
        }
    }

    void apply(ClassFile cf) throws BadBytecode {
        String newName;
        HashMap<String, MemberEntry> map;
        String newType;
        String oldType;
        String oldClass = cf.getName();
        ConstPool cp = cf.getConstPool();
        ClassMapEntry classEntry = this.getEntry(oldClass);
        if (classEntry != null) {
            cf.renameClass(cf.getName(), classEntry.getObfName());
        }
        for (Object o : cf.getMethods()) {
            MethodInfo mi = (MethodInfo)o;
            oldType = mi.getDescriptor();
            if (!oldType.equals(newType = this.mapTypeString(oldType))) {
                Logger.log(3, "method signature %s -> %s", oldType, newType);
                mi.setDescriptor(newType);
            }
            if (classEntry == null || !(map = classEntry.getMethodMap()).containsKey(mi.getName())) continue;
            newName = map.get((Object)mi.getName()).name;
            Logger.log(3, "method %s -> %s", mi.getName(), newName);
            mi.setName(newName);
        }
        for (Object o : cf.getFields()) {
            FieldInfo fi = (FieldInfo)o;
            oldType = fi.getDescriptor();
            if (!oldType.equals(newType = this.mapTypeString(oldType))) {
                Logger.log(3, "field signature %s -> %s", oldType, newType);
                fi.setDescriptor(newType);
            }
            if (classEntry == null || !(map = classEntry.getFieldMap()).containsKey(fi.getName())) continue;
            newName = map.get((Object)fi.getName()).name;
            Logger.log(3, "field %s -> %s", fi.getName(), newName);
            fi.setName(newName);
        }
        int origSize = cp.getSize();
        block8: for (int i = 1; i < origSize; ++i) {
            String oldType2;
            String oldName;
            final int tag = cp.getTag(i);
            switch (tag) {
                case 7: {
                    oldClass = cp.getClassInfo(i);
                    oldName = null;
                    oldType2 = null;
                    break;
                }
                case 9: {
                    oldClass = cp.getFieldrefClassName(i);
                    oldName = cp.getFieldrefName(i);
                    oldType2 = cp.getFieldrefType(i);
                    break;
                }
                case 10: {
                    oldClass = cp.getMethodrefClassName(i);
                    oldName = cp.getMethodrefName(i);
                    oldType2 = cp.getMethodrefType(i);
                    break;
                }
                case 11: {
                    oldClass = cp.getInterfaceMethodrefClassName(i);
                    oldName = cp.getInterfaceMethodrefName(i);
                    oldType2 = cp.getInterfaceMethodrefType(i);
                    break;
                }
                default: {
                    continue block8;
                }
            }
            String newClass = oldClass;
            newName = oldName;
            String newType2 = null;
            ClassMapEntry entry = this.getEntry(oldClass);
            if (entry != null) {
                HashMap<String, MemberEntry> map2;
                newClass = entry.getObfName();
                HashMap<String, MemberEntry> hashMap = map2 = tag == 9 ? entry.getFieldMap() : entry.getMethodMap();
                if (map2.containsKey(oldName)) {
                    newName = map2.get((Object)oldName).name;
                }
            }
            if (oldType2 != null) {
                newType2 = this.mapTypeString(oldType2);
            }
            if (!(!oldClass.equals(newClass) || oldName != null && !oldName.equals(newName) || oldType2 != null && !oldType2.equals(newType2))) continue;
            final String oldClass2 = oldClass;
            final String oldName2 = oldName;
            final String oldType22 = oldType2;
            final String newClass2 = newClass;
            final String newName2 = newName;
            final String newType22 = newType2;
            ClassMod mod = new ClassMod(){

                public String getDeobfClass() {
                    return newClass2;
                }
            };
            mod.classFile = cf;
            BytecodePatch patch = new BytecodePatch(){
                private final String typeStr;
                private final byte[] opcodes;
                private final JavaRef oldRef;
                private final JavaRef newRef;
                {
                    switch (tag) {
                        case 7: {
                            this.typeStr = "class";
                            this.opcodes = ConstPoolUtils.CLASSREF_OPCODES;
                            this.oldRef = new ClassRef(oldClass2);
                            this.newRef = new ClassRef(newClass2);
                            break;
                        }
                        case 9: {
                            this.typeStr = "field";
                            this.opcodes = ConstPoolUtils.FIELDREF_OPCODES;
                            this.oldRef = new FieldRef(oldClass2, oldName2, oldType22);
                            this.newRef = new FieldRef(newClass2, newName2, newType22);
                            break;
                        }
                        case 10: {
                            this.typeStr = "method";
                            this.opcodes = ConstPoolUtils.METHODREF_OPCODES;
                            this.oldRef = new MethodRef(oldClass2, oldName2, oldType22);
                            this.newRef = new MethodRef(newClass2, newName2, newType22);
                            break;
                        }
                        case 11: {
                            this.typeStr = "interface method";
                            this.opcodes = ConstPoolUtils.INTERFACEMETHODREF_OPCODES;
                            this.oldRef = new InterfaceMethodRef(oldClass2, oldName2, oldType22);
                            this.newRef = new InterfaceMethodRef(newClass2, newName2, newType22);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Unreachable");
                        }
                    }
                }

                public String getDescription() {
                    if (tag == 7) {
                        return String.format("%s ref %s -> %s", this.typeStr, oldClass2, newClass2);
                    }
                    return String.format("%s ref %s.%s %s -> %s.%s %s", this.typeStr, oldClass2, oldName2, oldType22, newClass2, newName2, newType22);
                }

                public String getMatchExpression() {
                    return BinaryRegex.build(BinaryRegex.capture(BinaryRegex.subset(this.opcodes, true)), ConstPoolUtils.reference(this.getMethodInfo().getConstPool(), this.oldRef, false));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), ConstPoolUtils.reference(this.getMethodInfo().getConstPool(), this.newRef, true));
                }
            };
            patch.setClassMod(mod);
            patch.apply(cf);
        }
    }

    public String map(String className) {
        ClassMapEntry entry = this.getEntry(className);
        return entry == null ? className : entry.getObfName();
    }

    public JavaRef map(JavaRef javaRef) {
        if (javaRef instanceof MethodRef) {
            return this.map((MethodRef)javaRef);
        }
        if (javaRef instanceof InterfaceMethodRef) {
            return this.map((InterfaceMethodRef)javaRef);
        }
        if (javaRef instanceof FieldRef) {
            return this.map((FieldRef)javaRef);
        }
        if (javaRef instanceof ClassRef) {
            return this.map((ClassRef)javaRef);
        }
        return javaRef;
    }

    private MethodRef map(MethodRef methodRef) {
        String oldClass = methodRef.getClassName();
        String oldName = methodRef.getName();
        String oldType = methodRef.getType();
        String newClass = oldClass;
        String newName = oldName;
        String newType = this.mapTypeString(oldType);
        ClassMapEntry entry = this.getEntry(oldClass);
        if (entry != null) {
            newClass = entry.getObfName();
            HashMap<String, MemberEntry> map = entry.getMethodMap();
            if (map.containsKey(oldName)) {
                newName = map.get((Object)oldName).name;
            }
        }
        return new MethodRef(newClass, newName, newType);
    }

    private InterfaceMethodRef map(InterfaceMethodRef methodRef) {
        String oldClass = methodRef.getClassName();
        String oldName = methodRef.getName();
        String oldType = methodRef.getType();
        String newClass = oldClass;
        String newName = oldName;
        String newType = this.mapTypeString(oldType);
        ClassMapEntry entry = this.getEntry(oldClass);
        if (entry != null) {
            newClass = entry.getObfName();
            HashMap<String, MemberEntry> map = entry.getMethodMap();
            if (map.containsKey(oldName)) {
                newName = map.get((Object)oldName).name;
            }
        }
        return new InterfaceMethodRef(newClass, newName, newType);
    }

    private FieldRef map(FieldRef fieldRef) {
        String oldClass = fieldRef.getClassName();
        String oldName = fieldRef.getName();
        String oldType = fieldRef.getType();
        String newClass = oldClass;
        String newName = oldName;
        String newType = this.mapTypeString(oldType);
        ClassMapEntry entry = this.getEntry(oldClass);
        if (entry != null) {
            newClass = entry.getObfName();
            HashMap<String, MemberEntry> map = entry.getFieldMap();
            if (map.containsKey(oldName)) {
                newName = map.get((Object)oldName).name;
            }
        }
        return new FieldRef(newClass, newName, newType);
    }

    private ClassRef map(ClassRef classRef) {
        String oldClass;
        String newClass = oldClass = classRef.getClassName();
        ClassMapEntry entry = this.getEntry(oldClass);
        if (entry != null) {
            newClass = entry.getObfName();
        }
        return new ClassRef(newClass);
    }

    public boolean hasMap(String className) {
        return this.getEntry(className) != null;
    }

    public boolean hasMap(JavaRef javaRef) {
        if (javaRef instanceof MethodRef) {
            return this.hasMap((MethodRef)javaRef);
        }
        if (javaRef instanceof InterfaceMethodRef) {
            return this.hasMap((InterfaceMethodRef)javaRef);
        }
        if (javaRef instanceof FieldRef) {
            return this.hasMap((FieldRef)javaRef);
        }
        if (javaRef instanceof ClassRef) {
            return this.hasMap((ClassRef)javaRef);
        }
        return false;
    }

    private boolean hasMap(MethodRef methodRef) {
        HashMap<String, MemberEntry> map;
        String oldClass = methodRef.getClassName();
        String oldName = methodRef.getName();
        ClassMapEntry entry = this.getEntry(oldClass);
        return entry != null && (map = entry.getMethodMap()).containsKey(oldName);
    }

    private boolean hasMap(InterfaceMethodRef methodRef) {
        HashMap<String, MemberEntry> map;
        String oldClass = methodRef.getClassName();
        String oldName = methodRef.getName();
        ClassMapEntry entry = this.getEntry(oldClass);
        return entry != null && (map = entry.getMethodMap()).containsKey(oldName);
    }

    private boolean hasMap(FieldRef fieldRef) {
        HashMap<String, MemberEntry> map;
        String oldClass = fieldRef.getClassName();
        String oldName = fieldRef.getName();
        ClassMapEntry entry = this.getEntry(oldClass);
        return entry != null && (map = entry.getFieldMap()).containsKey(oldName);
    }

    private boolean hasMap(ClassRef classRef) {
        return this.getEntry(classRef.getClassName()) != null;
    }

    public String mapTypeString(String old) {
        if (old == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < old.length(); ++i) {
            char c = old.charAt(i);
            if (c == 'L') {
                String oldType;
                int end = old.indexOf(59, i);
                String newType = oldType = old.substring(i + 1, end).replace('/', '.');
                ClassMapEntry entry = this.getEntry(oldType);
                if (entry != null && entry.getObfName() != null) {
                    newType = entry.getObfName();
                }
                sb.append('L');
                sb.append(newType.replace('.', '/'));
                sb.append(';');
                i = end;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    void stringReplace(ClassFile cf, JarOutputStream jar) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        cf.write(new DataOutputStream(baos));
        byte[] data = baos.toByteArray();
        for (Map.Entry<String, ClassMapEntry> e : this.classMap.entrySet()) {
            String oldClass = e.getKey();
            String newClass = e.getValue().getObfName().replace('.', '/');
            data = this.stringReplace1(data, oldClass, newClass);
            data = this.stringReplace2(data, oldClass, newClass);
        }
        jar.write(data);
    }

    private byte[] stringReplace1(byte[] data, String oldString, String newString) throws IOException {
        if (oldString.equals(newString)) {
            return data;
        }
        byte[] oldData = Util.marshalString(oldString);
        byte[] newData = Util.marshalString(newString);
        BinaryMatcher bm = new BinaryMatcher(BinaryRegex.build(new Object[]{oldData}));
        int offset = 0;
        while (bm.match(data, offset)) {
            Logger.log(3, "string replace %s -> %s @%d", oldString, newString, bm.getStart());
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            baos2.write(data, 0, bm.getStart());
            baos2.write(newData);
            baos2.write(data, bm.getEnd(), data.length - bm.getEnd());
            offset = bm.getStart() + newData.length;
            data = baos2.toByteArray();
        }
        return data;
    }

    private byte[] stringReplace2(byte[] data, String oldString, String newString) throws IOException {
        if (oldString.equals(newString)) {
            return data;
        }
        String fastExpr = BinaryRegex.build(Character.valueOf('L'), oldString.getBytes(), Character.valueOf(';'));
        BinaryMatcher bmFast = new BinaryMatcher(fastExpr);
        BinaryMatcher bm = new BinaryMatcher(BinaryRegex.build(0, BinaryRegex.any(), BinaryRegex.nonGreedy(BinaryRegex.repeat(DESCRIPTOR_CHARS, 0, 255 - oldString.length())), fastExpr));
        int offset = 0;
        while (bmFast.match(data, offset) && bm.match(data, offset)) {
            String oldStringFull;
            int length;
            int start = bm.getStart();
            int end = start + (length = Util.demarshal(data, bm.getStart(), 2)) + 2;
            if (end >= data.length || length + 2 < bm.getMatchLength()) {
                ++offset;
                continue;
            }
            try {
                oldStringFull = new String(data, start + 2, length, "UTF-8");
            }
            catch (Throwable e) {
                Logger.log(e);
                ++offset;
                continue;
            }
            String newStringFull = oldStringFull.replaceAll("\\b(L?)" + oldString + "\\b", "$1" + newString);
            if (oldStringFull.equals(newStringFull) || newStringFull.matches(".*net/minecraft.*net/minecraft.*")) {
                offset = end;
                continue;
            }
            Logger.log(3, "string replace %s -> %s @%d", oldStringFull, newStringFull, start);
            byte[] newData = Util.marshalString(newStringFull);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(data, 0, bm.getStart());
            baos.write(newData);
            baos.write(data, end, data.length - end);
            offset = bm.getStart() + newData.length;
            data = baos.toByteArray();
        }
        return data;
    }

    void merge(ClassMap from) {
        for (Map.Entry<String, ClassMapEntry> e : from.classMap.entrySet()) {
            this.merge(e.getValue());
        }
    }

    private ClassMapEntry merge(ClassMapEntry entry) {
        ClassMapEntry newEntry = this.classMap.get(entry.descName);
        if (newEntry != null) {
            if (newEntry.obfName == null && entry.obfName != null) {
                newEntry.setObfName(entry.obfName);
            }
        } else {
            newEntry = entry.aliasFor != null ? new ClassMapEntry(entry.descName, this.merge(entry.aliasFor)) : (entry.parent != null ? new ClassMapEntry(entry.descName, entry.obfName, this.merge(entry.parent)) : new ClassMapEntry(entry.descName, entry.obfName));
        }
        for (ClassMapEntry iface : entry.interfaces) {
            newEntry.addInterface(this.merge(iface));
        }
        newEntry.methodMap.putAll(entry.methodMap);
        newEntry.fieldMap.putAll(entry.fieldMap);
        this.putEntry(newEntry);
        return newEntry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassMapEntry {
        private String descName = null;
        private String obfName = null;
        private HashMap<String, MemberEntry> methodMap = new HashMap();
        private HashMap<String, MemberEntry> fieldMap = new HashMap();
        private ClassMapEntry parent = null;
        private ArrayList<ClassMapEntry> interfaces = new ArrayList();
        private ClassMapEntry aliasFor = null;

        private ClassMapEntry(String descName) {
            this.descName = descName.replace('.', '/');
        }

        ClassMapEntry(String descName, String obfName) {
            this(descName);
            this.obfName = obfName.replace('.', '/');
        }

        ClassMapEntry(String descName, ClassMapEntry aliasFor) {
            this(descName);
            this.aliasFor = aliasFor;
        }

        ClassMapEntry(String descName, String obfName, ClassMapEntry parent) {
            this(descName, obfName);
            this.parent = parent;
        }

        void setParent(ClassMapEntry parent) {
            this.parent = parent;
        }

        void addInterface(ClassMapEntry iface) {
            this.interfaces.add(iface);
        }

        void addMethod(String descName, String obfName, String obfType) {
            this.methodMap.put(descName, new MemberEntry(obfName, obfType));
        }

        void addField(String descName, String obfName, String obfType) {
            this.fieldMap.put(descName, new MemberEntry(obfName, obfType));
        }

        ClassMapEntry getEntry() {
            return this.aliasFor == null ? this : this.aliasFor.getEntry();
        }

        String getObfName() {
            return this.getEntry().obfName;
        }

        void setObfName(String obfName) {
            this.getEntry().obfName = obfName.replace('.', '/');
        }

        String getMethod(String descName) {
            String obfName;
            if (this.aliasFor != null && (obfName = this.aliasFor.getMethod(descName)) != null) {
                return obfName;
            }
            MemberEntry member = this.methodMap.get(descName);
            if (member != null) {
                return member.name;
            }
            if (this.parent != null && (obfName = this.parent.getMethod(descName)) != null) {
                return obfName;
            }
            for (ClassMapEntry entry : this.interfaces) {
                obfName = entry.getMethod(descName);
                if (obfName == null) continue;
                return obfName;
            }
            return null;
        }

        String getField(String descName) {
            String obfName;
            if (this.aliasFor != null && (obfName = this.aliasFor.getField(descName)) != null) {
                return obfName;
            }
            MemberEntry member = this.fieldMap.get(descName);
            if (member != null) {
                return member.name;
            }
            if (this.parent != null && (obfName = this.parent.getField(descName)) != null) {
                return obfName;
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.descName.replace('/', '.'));
            if (this.obfName != null && !this.obfName.equals(this.descName)) {
                sb.append(" (");
                sb.append(this.obfName);
                sb.append(".class)");
            }
            if (this.aliasFor != null) {
                sb.append(" alias for ");
                sb.append(this.aliasFor.descName.replace('/', '.'));
            }
            if (this.parent != null) {
                sb.append(" extends ");
                sb.append(this.parent.descName.replace('/', '.'));
            }
            if (!this.interfaces.isEmpty()) {
                sb.append(" implements");
                for (ClassMapEntry entry : this.interfaces) {
                    sb.append(' ');
                    sb.append(entry.descName.replace('/', '.'));
                }
            }
            return sb.toString();
        }

        HashMap<String, MemberEntry> getMethodMap() {
            if (this.aliasFor != null) {
                return this.aliasFor.getMethodMap();
            }
            HashMap<String, MemberEntry> map = new HashMap<String, MemberEntry>();
            this.addMethodMap(map);
            return map;
        }

        private void addMethodMap(HashMap<String, MemberEntry> map) {
            for (ClassMapEntry entry : this.interfaces) {
                entry.addMethodMap(map);
            }
            if (this.parent != null) {
                this.parent.addMethodMap(map);
            }
            map.putAll(this.methodMap);
        }

        HashMap<String, MemberEntry> getFieldMap() {
            if (this.aliasFor != null) {
                return this.aliasFor.getFieldMap();
            }
            HashMap<String, MemberEntry> map = new HashMap<String, MemberEntry>();
            this.addFieldMap(map);
            return map;
        }

        void addFieldMap(HashMap<String, MemberEntry> map) {
            if (this.parent != null) {
                this.parent.addFieldMap(map);
            }
            map.putAll(this.fieldMap);
        }
    }

    static class MemberEntry {
        String name;
        String type;

        MemberEntry(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof MemberEntry)) {
                return false;
            }
            MemberEntry that = (MemberEntry)o;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }
    }
}

