/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassPatch;
import com.pclewis.mcpatcher.ClassSignature;
import com.pclewis.mcpatcher.ConstPoolUtils;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.PatchComponent;
import com.pclewis.mcpatcher.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Mnemonic;

public abstract class ClassMod
implements PatchComponent {
    protected Mod mod;
    protected ArrayList<String> prerequisiteClasses = new ArrayList();
    protected ArrayList<ClassSignature> classSignatures = new ArrayList();
    protected ArrayList<ClassPatch> patches = new ArrayList();
    protected ArrayList<MemberMapper> memberMappers = new ArrayList();
    protected boolean global = false;
    protected String parentClass;
    protected String[] interfaces;
    ArrayList<String> targetClasses = new ArrayList();
    ArrayList<String> errors = new ArrayList();
    boolean addToConstPool = false;
    ClassFile classFile;
    MethodInfo methodInfo;
    int bestMatchCount;
    String bestMatch;
    private ArrayList<Label> labels = new ArrayList();
    private HashMap<String, Integer> labelPositions = new HashMap();

    boolean matchClassFile(String filename, ClassFile classFile) {
        this.addToConstPool = false;
        this.classFile = classFile;
        if (!this.filterFile(filename)) {
            return false;
        }
        ClassMap newMap = new ClassMap();
        String deobfName = this.getDeobfClass();
        int sigIndex = 0;
        for (ClassSignature cs : this.classSignatures) {
            boolean found = false;
            if (cs.match(filename, classFile, newMap)) {
                found = true;
            }
            if (found == cs.negate) {
                return false;
            }
            newMap.addClassMap(deobfName, ClassMap.filenameToClassName(filename));
            if (this.bestMatch == null || sigIndex > this.bestMatchCount) {
                this.bestMatch = filename;
                this.bestMatchCount = sigIndex;
            }
            ++sigIndex;
        }
        for (ClassSignature cs : this.classSignatures) {
            this.addToConstPool = false;
            if (cs.afterMatch()) continue;
            return false;
        }
        this.targetClasses.add(classFile.getName());
        if (this.targetClasses.size() == 1 && !this.global) {
            this.mod.classMap.merge(newMap);
            if (this.parentClass != null) {
                this.mod.classMap.addClassMap(this.parentClass, classFile.getSuperclass());
                this.mod.classMap.addInheritance(this.parentClass, deobfName);
            }
            if (this.interfaces != null) {
                String[] obfInterfaces = classFile.getInterfaces();
                for (int i = 0; i < Math.min(this.interfaces.length, obfInterfaces.length); ++i) {
                    this.mod.classMap.addClassMap(this.interfaces[i], obfInterfaces[i]);
                    this.mod.classMap.addInheritance(this.interfaces[i], deobfName);
                }
            }
        }
        return true;
    }

    public String getDeobfClass() {
        return this.getClass().getSimpleName().replaceFirst("^_", "").replaceFirst("Mod$", "");
    }

    boolean okToApply() {
        return this.errors.size() == 0;
    }

    void addError(String error) {
        this.errors.add(error);
    }

    protected boolean filterFile(String filename) {
        String className = ClassMap.filenameToClassName(filename);
        if (this.global) {
            return !className.startsWith("com.jcraft.") && !className.startsWith("paulscode.");
        }
        return className.startsWith("net.minecraft.client.") || className.matches("^[a-z]{1,4}$");
    }

    protected boolean mapClassMembers(String filename, ClassFile classFile) throws Exception {
        boolean ok = true;
        for (MemberMapper mapper : this.memberMappers) {
            String name;
            String mapperType = mapper.getMapperType();
            if (mapper.descriptor != null) {
                mapper.descriptor = this.mod.getClassMap().mapTypeString(mapper.descriptor);
            }
            if (mapper instanceof FieldMapper) {
                FieldMapper fm = (FieldMapper)mapper;
                for (Object o : classFile.getFields()) {
                    FieldInfo fi = (FieldInfo)o;
                    if (!fm.match(fi)) continue;
                    name = fm.getName();
                    if (name != null) {
                        Logger.log(3, "%s %s matches %s %s", mapperType, name, fi.getName(), fi.getDescriptor());
                        this.mod.getClassMap().addFieldMap(this.getDeobfClass(), name, fi.getName(), fi.getDescriptor());
                    }
                    fm.afterMatch();
                }
            } else if (mapper instanceof MethodMapper) {
                MethodMapper mm = (MethodMapper)mapper;
                for (Object o : classFile.getMethods()) {
                    MethodInfo mi = (MethodInfo)o;
                    if (!mm.match(mi)) continue;
                    name = mm.getName();
                    if (name != null) {
                        Logger.log(3, "%s %s matches %s %s", mapperType, name, mi.getName(), mi.getDescriptor());
                        this.mod.getClassMap().addMethodMap(this.getDeobfClass(), name, mi.getName(), mi.getDescriptor());
                    }
                    mm.afterMatch();
                }
            } else {
                throw new AssertionError((Object)"invalid type");
            }
            if (mapper.allMatched()) continue;
            this.addError(String.format("no match found for %s %s", mapperType, mapper.getName()));
            Logger.log(3, "no match found for %s %s", mapperType, mapper.getName());
            ok = false;
        }
        return ok;
    }

    public void prePatch(String filename, ClassFile classFile) throws Exception {
    }

    public void postPatch(String filename, ClassFile classFile) throws Exception {
    }

    protected final Label label(String key) {
        return new Label(key, true);
    }

    protected final Label branch(String key) {
        return new Label(key, false);
    }

    void resetLabels() {
        this.labels.clear();
        this.labelPositions.clear();
    }

    void resolveLabels(byte[] code, int start, int labelOffset) {
        for (Map.Entry<String, Integer> e : this.labelPositions.entrySet()) {
            Logger.log(5, "label %s -> instruction %d", e.getKey(), start + e.getValue());
        }
        for (Label label : this.labels) {
            if (!this.labelPositions.containsKey(label.name)) {
                throw new RuntimeException("no label " + label.name + " defined");
            }
            int to = this.labelPositions.get(label.name);
            int diff = to - label.from + 1;
            int codepos = label.from + labelOffset;
            Logger.log(5, "branch offset %s %s -> %+d @%d", Mnemonic.OPCODE[code[codepos - 1] & 0xFF].toUpperCase(), label.name, diff, label.from - 1 + start);
            code[codepos] = Util.b(diff, 1);
            code[codepos + 1] = Util.b(diff, 0);
        }
    }

    public final ClassFile getClassFile() {
        return this.classFile;
    }

    public final MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public final String buildExpression(Object ... objects) {
        return BinaryRegex.build(objects);
    }

    public final byte[] buildCode(Object ... objects) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildCode1(baos, objects);
        return baos.toByteArray();
    }

    private void buildCode1(ByteArrayOutputStream baos, Object[] objects) throws IOException {
        for (Object o : objects) {
            if (o instanceof Byte) {
                baos.write(((Byte)o).byteValue());
                continue;
            }
            if (o instanceof byte[]) {
                baos.write((byte[])o);
                continue;
            }
            if (o instanceof Integer) {
                baos.write((Integer)o);
                continue;
            }
            if (o instanceof int[]) {
                for (int i : (int[])o) {
                    baos.write(i);
                }
                continue;
            }
            if (o instanceof Label) {
                Label label = (Label)o;
                if (label.save) {
                    int offset = baos.size();
                    if (this.labelPositions.containsKey(label.name)) {
                        throw new RuntimeException("label " + label.name + " already defined");
                    }
                    this.labelPositions.put(label.name, offset);
                    continue;
                }
                label.from = baos.size();
                this.labels.add(label);
                baos.write(0);
                baos.write(0);
                continue;
            }
            if (o instanceof Object[]) {
                this.buildCode1(baos, (Object[])o);
                continue;
            }
            throw new AssertionError((Object)("invalid type: " + o.getClass().toString()));
        }
    }

    public final Object push(Object value) {
        return ConstPoolUtils.push(this.getMethodInfo().getConstPool(), value, this.addToConstPool);
    }

    public final byte[] reference(int opcode, JavaRef ref) {
        return ConstPoolUtils.reference(this.getMethodInfo().getConstPool(), opcode, this.map(ref), this.addToConstPool);
    }

    public final Mod getMod() {
        return this.mod;
    }

    public final ClassMap getClassMap() {
        return this.mod.getClassMap();
    }

    public final JavaRef map(JavaRef ref) {
        return this.mod.getClassMap().map(ref);
    }

    public class MethodMapper
    extends MemberMapper {
        public MethodMapper(MethodRef ... refs) {
            super(refs);
        }

        public MethodMapper(String[] names, String descriptor) {
            super(names, descriptor);
        }

        public MethodMapper(String name, String descriptor) {
            super(name, descriptor);
        }

        final String getMapperType() {
            return "method";
        }

        public boolean match(MethodInfo methodInfo) {
            return this.matchInfo(methodInfo.getDescriptor(), methodInfo.getAccessFlags());
        }
    }

    public class FieldMapper
    extends MemberMapper {
        public FieldMapper(FieldRef ... refs) {
            super(refs);
        }

        public FieldMapper(String[] names, String descriptor) {
            super(names, descriptor);
        }

        public FieldMapper(String name, String descriptor) {
            super(name, descriptor);
        }

        final String getMapperType() {
            return "field";
        }

        public boolean match(FieldInfo fieldInfo) {
            return this.matchInfo(fieldInfo.getDescriptor(), fieldInfo.getAccessFlags());
        }
    }

    public abstract class MemberMapper {
        protected String[] names;
        protected String descriptor;
        private int setAccessFlags;
        private int clearAccessFlags;
        private int count;

        MemberMapper(JavaRef ... refs) {
            this.names = new String[refs.length];
            for (int i = 0; i < refs.length; ++i) {
                if (refs[i] == null) continue;
                this.names[i] = refs[i].getName();
                if (this.descriptor != null) continue;
                this.descriptor = refs[i].getType();
            }
            if (this.descriptor == null) {
                throw new RuntimeException("refs list is empty");
            }
        }

        MemberMapper(String[] names, String descriptor) {
            this.names = (String[])names.clone();
            this.descriptor = descriptor;
        }

        MemberMapper(String name, String descriptor) {
            this(new String[]{name}, descriptor);
        }

        public MemberMapper accessFlag(int flags, boolean set) {
            if (set) {
                this.setAccessFlags |= flags;
            } else {
                this.clearAccessFlags |= flags;
            }
            return this;
        }

        boolean matchInfo(String descriptor, int flags) {
            return descriptor.equals(this.descriptor) && (flags & this.setAccessFlags) == this.setAccessFlags && (flags & this.clearAccessFlags) == 0;
        }

        String getName() {
            return this.count < this.names.length ? this.names[this.count] : null;
        }

        void afterMatch() {
            ++this.count;
        }

        boolean allMatched() {
            return this.count >= this.names.length;
        }

        abstract String getMapperType();
    }

    public static final class Label {
        String name;
        boolean save;
        int from;

        Label(String name, boolean save) {
            this.name = name;
            this.save = save;
        }
    }
}

