/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.PatchComponent;
import java.io.IOException;
import java.util.HashMap;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.MethodInfo;

public abstract class ClassPatch
implements PatchComponent {
    ClassMod classMod;
    HashMap<String, Integer> numMatches = new HashMap();
    boolean optional;

    public abstract String getDescription();

    abstract boolean apply(ClassFile var1) throws BadBytecode, DuplicateMemberException, IOException;

    void setClassMod(ClassMod classMod) {
        this.classMod = classMod;
    }

    private void addPatch(String desc) {
        int val = 0;
        if (this.numMatches.containsKey(desc)) {
            val = this.numMatches.get(desc);
        }
        this.numMatches.put(desc, val + 1);
    }

    protected void recordPatch() {
        String desc = this.getDescription();
        this.addPatch(desc);
        Logger.log(4, "%s", desc);
    }

    protected void recordPatch(String extra) {
        String desc = this.getDescription();
        this.addPatch(desc);
        Logger.log(4, "%s %s", desc, extra);
    }

    public final ClassFile getClassFile() {
        return this.classMod.getClassFile();
    }

    public final MethodInfo getMethodInfo() {
        return this.classMod.getMethodInfo();
    }

    public final String buildExpression(Object ... objects) {
        return this.classMod.buildExpression(objects);
    }

    public final byte[] buildCode(Object ... objects) throws IOException {
        return this.classMod.buildCode(objects);
    }

    public final Object push(Object value) {
        return this.classMod.push(value);
    }

    public final byte[] reference(int opcode, JavaRef ref) {
        return this.classMod.reference(opcode, ref);
    }

    public final Mod getMod() {
        return this.classMod.getMod();
    }

    public final ClassMap getClassMap() {
        return this.classMod.getClassMap();
    }

    public final JavaRef map(JavaRef ref) {
        return this.classMod.map(ref);
    }
}

