/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.pclewis.mcpatcher.MainForm;
import com.pclewis.mcpatcher.Mod;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConflictDialog {
    private JPanel contentPane;
    private JTextArea conflictsText;

    static String getText(HashMap<String, ArrayList<Mod>> conflicts) {
        HashMap<ArrayList<Mod>, ArrayList<String>> conflictGroups = new HashMap<ArrayList<Mod>, ArrayList<String>>();
        for (Map.Entry<String, ArrayList<Mod>> entry : conflicts.entrySet()) {
            String filename = entry.getKey();
            ArrayList<Mod> arrayList = entry.getValue();
            ArrayList<String> fileList = (ArrayList<String>)conflictGroups.get(arrayList);
            if (fileList == null) {
                fileList = new ArrayList<String>();
                conflictGroups.put(arrayList, fileList);
            }
            fileList.add(filename);
        }
        StringBuilder message = new StringBuilder();
        ArrayList conflictEntries = new ArrayList();
        conflictEntries.addAll(conflictGroups.entrySet());
        Collections.sort(conflictEntries, new Comparator<Map.Entry<ArrayList<Mod>, ArrayList<String>>>(){

            @Override
            public int compare(Map.Entry<ArrayList<Mod>, ArrayList<String>> o1, Map.Entry<ArrayList<Mod>, ArrayList<String>> o2) {
                ArrayList<Mod> a1 = o1.getKey();
                ArrayList<Mod> a2 = o2.getKey();
                for (int i = 0; i < a1.size() && i < a2.size(); ++i) {
                    Mod mod2;
                    Mod mod1 = a1.get(i);
                    if (mod1 == (mod2 = a2.get(i))) continue;
                    return mod1.getName().compareTo(mod2.getName());
                }
                return a1.size() - a2.size();
            }
        });
        for (Map.Entry entry : conflictEntries) {
            ArrayList mods = (ArrayList)entry.getKey();
            ArrayList filenames = (ArrayList)entry.getValue();
            Collections.sort(filenames);
            for (Mod mod : mods) {
                message.append(mod.getName()).append('\n');
            }
            for (String filename : filenames) {
                message.append("    ").append(filename).append('\n');
            }
            message.append("Only the files from ").append(((Mod)mods.get(mods.size() - 1)).getName()).append(" will be used.\n\n");
        }
        return message.toString().trim();
    }

    ConflictDialog(HashMap<String, ArrayList<Mod>> conflicts) {
        this.$$$setupUI$$$();
        String text = ConflictDialog.getText(conflicts);
        this.conflictsText.setRows(Math.max(6, Math.min(24, text.split("\n").length + 1)));
        this.conflictsText.setText(text);
    }

    int getResult(JPanel parent) {
        JOptionPane pane = new JOptionPane(this.contentPane, 3, 0);
        JDialog dialog = pane.createDialog(parent, "Mod conflict detected");
        dialog.setModal(true);
        dialog.setResizable(true);
        MainForm.setIconImage(dialog);
        dialog.setVisible(true);
        Object result = pane.getValue();
        return result instanceof Integer ? (Integer)result : 1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Conflicts detected between the selected mods:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Continue patching anyway?");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.conflictsText = jTextArea = new JTextArea();
        jTextArea.setRows(20);
        ((Component)jTextArea).setBackground(new Color(-2697514));
        jTextArea.setLineWrap(true);
        jTextArea.setColumns(36);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jScrollPane.setViewportView(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

