/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassPatch;
import com.pclewis.mcpatcher.Config;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MinecraftJar;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.ModList;
import com.pclewis.mcpatcher.UserInterface;
import com.pclewis.mcpatcher.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MCPatcher {
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 4;
    public static final int RELEASE_VERSION = 3;
    public static final int PATCH_VERSION = 2;
    public static final int BETA_VERSION = 0;
    public static final String VERSION_STRING = String.format("%d.%d.%d", 2, 4, 3) + String.format("_%02d", 2) + "";
    static MinecraftJar minecraft = null;
    static ModList modList;
    private static boolean ignoreSavedMods;
    private static boolean ignoreBuiltInMods;
    private static boolean ignoreCustomMods;
    private static boolean enableAllMods;
    static boolean experimentalMods;
    private static UserInterface ui;

    private MCPatcher() {
    }

    public static void main(String[] args) {
        int exitStatus = 1;
        boolean guiEnabled = true;
        String enteredMCDir = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-loglevel") && i + 1 < args.length) {
                ++i;
                try {
                    Logger.setLogLevel(Integer.parseInt(args[i]));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (args[i].equals("-version")) {
                System.out.println(VERSION_STRING);
                System.exit(0);
                continue;
            }
            if (args[i].equals("-mcdir") && i + 1 < args.length) {
                enteredMCDir = args[++i];
                continue;
            }
            if (args[i].equals("-auto")) {
                guiEnabled = false;
                continue;
            }
            if (args[i].equals("-ignoresavedmods")) {
                ignoreSavedMods = true;
                continue;
            }
            if (args[i].equals("-ignorebuiltinmods")) {
                ignoreBuiltInMods = true;
                continue;
            }
            if (args[i].equals("-ignorecustommods")) {
                ignoreCustomMods = true;
                continue;
            }
            if (args[i].equals("-enableallmods")) {
                enableAllMods = true;
                continue;
            }
            if (!args[i].equals("-experimental")) continue;
            experimentalMods = true;
        }
        ui = guiEnabled ? new UserInterface.GUI() : new UserInterface.CLI();
        if (!ui.locateMinecraftDir(enteredMCDir)) {
            System.exit(exitStatus);
        }
        ui.show();
        Util.logOSInfo();
        if (!MCPatcherUtils.getString("lastVersion", "").equals(VERSION_STRING)) {
            MCPatcherUtils.set("lastVersion", VERSION_STRING);
            MCPatcherUtils.set("betaWarningShown", false);
            MCPatcherUtils.set("debug", false);
            MinecraftJar.fixJarNames();
        }
        if (ui.go()) {
            exitStatus = 0;
        }
        if (ui.shouldExit()) {
            MCPatcher.saveProperties();
            System.exit(exitStatus);
        }
    }

    static void saveProperties() {
        if (!ignoreSavedMods && modList != null && MCPatcherUtils.config.selectedProfile != null) {
            modList.updateProperties();
            MCPatcherUtils.config.saveProperties();
        }
    }

    static void checkInterrupt() throws InterruptedException {
        Thread.sleep(0L);
    }

    static boolean setMinecraft(File file, boolean createBackup) {
        if (minecraft != null) {
            minecraft.closeStreams();
        }
        if (file == null) {
            minecraft = null;
            return false;
        }
        try {
            minecraft = new MinecraftJar(file);
            if (createBackup) {
                minecraft.createBackup();
            }
            minecraft.logVersion();
            String defaultProfile = Config.getDefaultProfileName(minecraft.getVersion().getProfileString());
            MCPatcherUtils.config.setDefaultProfileName(defaultProfile);
            String selectedProfile = MCPatcherUtils.config.getConfigValue("selectedProfile");
            if (Config.isDefaultProfile(selectedProfile)) {
                MCPatcherUtils.config.selectProfile(defaultProfile);
            } else {
                MCPatcherUtils.config.selectProfile();
            }
            MCPatcher.getAllMods();
        }
        catch (IOException e) {
            minecraft = null;
            Logger.log(e);
            return false;
        }
        return true;
    }

    static void getAllMods() {
        if (modList != null) {
            modList.close();
        }
        modList = new ModList();
        if (!ignoreSavedMods) {
            modList.loadSavedMods();
        }
        if (!ignoreBuiltInMods) {
            modList.loadBuiltInMods();
        }
        if (!ignoreCustomMods) {
            modList.loadCustomMods(MCPatcherUtils.getMinecraftPath("mcpatcher-mods"));
        }
        ui.setModList(modList);
    }

    static void getApplicableMods() throws IOException, InterruptedException {
        JarFile origJar = minecraft.getInputJar();
        for (Mod mod : modList.getAll()) {
            mod.setRefs();
        }
        MCPatcher.mapModClasses(origJar);
        MCPatcher.mapModDependentClasses(origJar);
        MCPatcher.checkAllClassesMapped();
        MCPatcher.mapModClassMembers(origJar);
        MCPatcher.resolveModDependencies();
        MCPatcher.printModList();
        modList.enableValidMods(enableAllMods);
    }

    private static void mapModClasses(JarFile origJar) throws IOException, InterruptedException {
        int totalFiles = origJar.size();
        Logger.log(0);
        Logger.log(0, "Analyzing %s (%d files)", origJar.getName(), totalFiles);
        int procFiles = 0;
        for (JarEntry entry : Collections.list(origJar.entries())) {
            ui.updateProgress(++procFiles, origJar.size());
            String name = entry.getName();
            if (!MinecraftJar.isClassFile(name)) continue;
            ClassFile classFile = new ClassFile(new DataInputStream(origJar.getInputStream(entry)));
            for (Mod mod : modList.getAll()) {
                for (ClassMod classMod : mod.getClassMods()) {
                    if (!classMod.prerequisiteClasses.isEmpty()) continue;
                    try {
                        if (!classMod.matchClassFile(name, classFile)) continue;
                        MCPatcher.checkInterrupt();
                        if (classMod.global) continue;
                        Logger.log(2, "%s matches %s", classMod.getDeobfClass(), name);
                        for (Map.Entry<String, ClassMap.MemberEntry> e : mod.classMap.getMethodMap(classMod.getDeobfClass()).entrySet()) {
                            Logger.log(3, "%s matches %s %s", e.getKey(), e.getValue().name, e.getValue().type);
                        }
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        classMod.addError(e.toString());
                        Logger.log(e);
                    }
                }
            }
        }
    }

    private static void mapModDependentClasses(JarFile origJar) throws IOException, InterruptedException {
        ArrayList<ClassMod> todoList = new ArrayList<ClassMod>();
        for (Mod mod : modList.getAll()) {
            for (ClassMod classMod : mod.getClassMods()) {
                if (!classMod.okToApply() || classMod.prerequisiteClasses.isEmpty()) continue;
                todoList.add(classMod);
            }
        }
        int numTodo = todoList.size();
        if (numTodo > 0) {
            Logger.log(0);
            Logger.log(0, "Analyzing %s (%d dependent classes)", origJar.getName(), numTodo);
            ui.setStatusText("Mapping remaining classes...", new Object[0]);
            ui.updateProgress(0, numTodo);
            boolean keepGoing = true;
            for (int pass = 2; keepGoing && !todoList.isEmpty() && pass < 100; ++pass) {
                keepGoing = MCPatcher.mapModDependentClasses(origJar, todoList, pass);
                ui.updateProgress(numTodo - todoList.size(), numTodo);
            }
            for (ClassMod classMod : todoList) {
                classMod.addError("not all prerequisite classes matched");
            }
        }
    }

    private static boolean mapModDependentClasses(JarFile origJar, ArrayList<ClassMod> todoList, int pass) throws IOException, InterruptedException {
        boolean progress = false;
        boolean done = true;
        Iterator<ClassMod> iterator = todoList.iterator();
        block3: while (iterator.hasNext()) {
            ArrayList<JarEntry> candidateEntries;
            ClassMod classMod = iterator.next();
            if (!classMod.okToApply()) continue;
            Mod mod = classMod.mod;
            HashMap<String, String> classMap = mod.classMap.getClassMap();
            for (String reqClass : classMod.prerequisiteClasses) {
                done = false;
                if (classMap.get(reqClass) == null) continue block3;
                for (ClassMod classMod1 : mod.classMods) {
                    if (!classMod1.getDeobfClass().equals(reqClass) || classMod1.targetClasses.size() == 1) continue;
                    continue block3;
                }
            }
            String targetClass = classMap.get(classMod.getDeobfClass());
            if (targetClass == null) {
                candidateEntries = Collections.list(origJar.entries());
            } else {
                JarEntry entry = origJar.getJarEntry(ClassMap.classNameToFilename(targetClass));
                if (entry == null) {
                    classMod.addError("maps to non-existent class " + targetClass);
                    continue;
                }
                candidateEntries = new ArrayList();
                candidateEntries.add(entry);
            }
            for (JarEntry entry : candidateEntries) {
                if (!MinecraftJar.isClassFile(entry.getName())) continue;
                ClassFile classFile = new ClassFile(new DataInputStream(origJar.getInputStream(entry)));
                try {
                    if (!classMod.matchClassFile(entry.getName(), classFile)) continue;
                    MCPatcher.checkInterrupt();
                    if (!classMod.global) {
                        Logger.log(2, "%s matches %s (pass %d)", classMod.getDeobfClass(), entry.getName(), pass);
                        for (Map.Entry<String, ClassMap.MemberEntry> e : mod.classMap.getMethodMap(classMod.getDeobfClass()).entrySet()) {
                            Logger.log(3, "%s matches %s %s", e.getKey(), e.getValue().name, e.getValue().type);
                        }
                    }
                    iterator.remove();
                    progress = true;
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Throwable e) {
                    classMod.addError(e.toString());
                    Logger.log(e);
                }
            }
        }
        return progress && !done;
    }

    private static void checkAllClassesMapped() throws IOException, InterruptedException {
        for (Mod mod : modList.getAll()) {
            for (ClassMod classMod : mod.getClassMods()) {
                if (classMod.global || !classMod.okToApply()) continue;
                MCPatcher.checkInterrupt();
                if (classMod.targetClasses.size() > 1) {
                    StringBuilder sb = new StringBuilder();
                    for (String s : classMod.targetClasses) {
                        sb.append(" ");
                        sb.append(s);
                    }
                    classMod.addError(String.format("multiple classes matched:%s", sb.toString()));
                    Logger.log(1, "multiple classes matched %s:%s", classMod.getDeobfClass(), sb.toString());
                    continue;
                }
                if (classMod.targetClasses.size() != 0) continue;
                String bestInfo = classMod.bestMatch == null ? "" : String.format(" (best match: %s, %d signatures)", classMod.bestMatch, classMod.bestMatchCount + 1);
                classMod.addError("no classes matched" + bestInfo);
                Logger.log(1, "no classes matched %s%s", classMod.getDeobfClass(), bestInfo);
            }
        }
    }

    private static void mapModClassMembers(JarFile origJar) throws IOException, InterruptedException {
        Logger.log(0);
        Logger.log(0, "Analyzing %s (methods and fields)", origJar.getName());
        int numMappings = 0;
        int mappingProgress = 0;
        for (Mod mod : modList.getAll()) {
            for (ClassMod classMod : mod.classMods) {
                if (classMod.global || !classMod.okToApply()) continue;
                numMappings += classMod.memberMappers.size();
            }
        }
        ui.setStatusText("Mapping class members...", new Object[0]);
        ui.updateProgress(mappingProgress, numMappings);
        for (Mod mod : modList.getAll()) {
            for (ClassMod classMod : mod.getClassMods()) {
                MCPatcher.checkInterrupt();
                try {
                    if (classMod.global || !classMod.okToApply()) continue;
                    String name = ClassMap.classNameToFilename(classMod.targetClasses.get(0));
                    Logger.log(2, "%s (%s)", classMod.getDeobfClass(), name);
                    ClassFile classFile = new ClassFile(new DataInputStream(origJar.getInputStream(new ZipEntry(name))));
                    classMod.addToConstPool = false;
                    classMod.mapClassMembers(name, classFile);
                    ui.updateProgress(mappingProgress += classMod.memberMappers.size(), numMappings);
                }
                catch (Throwable e) {
                    classMod.addError(e.toString());
                    Logger.log(e);
                }
            }
        }
    }

    private static void resolveModDependencies() throws IOException, InterruptedException {
        boolean didSomething = true;
        while (didSomething) {
            didSomething = false;
            block1: for (Mod mod : modList.getAll()) {
                if (!mod.okToApply()) continue;
                for (Mod.Dependency dep : mod.dependencies) {
                    Mod dmod = modList.get(dep.name);
                    MCPatcher.checkInterrupt();
                    if (!dep.required || dmod != null && dmod.okToApply()) continue;
                    mod.addError(String.format("requires %s, which cannot be applied", dep.name));
                    didSomething = true;
                    continue block1;
                }
            }
        }
    }

    private static void printModList() {
        Logger.log(0);
        Logger.log(0, "%d available mods:", modList.getVisible().size());
        for (Mod mod : modList.getAll()) {
            Logger.log(0, "[%3s] %s %s - %s", mod.okToApply() ? "YES" : "NO", mod.getName(), mod.getVersion(), mod.getDescription());
            for (ClassMod cm : mod.classMods) {
                if (cm.okToApply()) continue;
                if (cm.targetClasses.size() == 0) {
                    Logger.log(1, "no classes matched %s", cm.getDeobfClass());
                    continue;
                }
                if (cm.targetClasses.size() <= 1) continue;
                StringBuilder sb = new StringBuilder();
                for (String s : cm.targetClasses) {
                    sb.append(" ");
                    sb.append(s);
                }
                Logger.log(1, "multiple classes matched %s:%s", cm.getDeobfClass(), sb.toString());
            }
        }
    }

    static void showClassMaps(PrintStream out) {
        if (minecraft == null) {
            out.println("No minecraft jar selected.");
            out.println("Click Browse to choose the input file.");
            out.println();
        } else {
            for (Mod mod : modList.getAll()) {
                if (mod.getClassMap().getClassMap().isEmpty()) continue;
                out.printf("%s\n", mod.getName());
                mod.getClassMap().print(out, "    ");
                out.println();
            }
        }
    }

    static void showPatchResults(PrintStream out) {
        if (modList == null || !modList.isApplied()) {
            out.println("No patches applied yet.");
            out.println("Click Patch on the Mods tab.");
            out.println();
        } else {
            for (Mod mod : modList.getSelected()) {
                if (mod.getClassMods().size() == 0 && mod.filesAdded.isEmpty()) continue;
                out.printf("%s\n", mod.getName());
                ArrayList<Map.Entry<String, String>> filesAdded = new ArrayList<Map.Entry<String, String>>();
                filesAdded.addAll(mod.filesAdded.entrySet());
                Collections.sort(filesAdded, new Comparator<Map.Entry<String, String>>(){

                    private void split(String s, String[] v) {
                        int slash = s.lastIndexOf(47);
                        if (slash >= 0) {
                            v[0] = s.substring(0, slash);
                            v[1] = s.substring(slash + 1);
                        } else {
                            v[0] = "";
                            v[1] = s;
                        }
                    }

                    @Override
                    public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                        String[] s1 = new String[2];
                        String[] s2 = new String[2];
                        this.split(o1.getKey(), s1);
                        this.split(o2.getKey(), s2);
                        int result = s1[0].compareTo(s2[0]);
                        if (result != 0) {
                            return result;
                        }
                        return s1[1].compareTo(s2[1]);
                    }
                });
                for (Map.Entry entry : filesAdded) {
                    out.printf("    %s %s\n", entry.getValue(), entry.getKey());
                }
                for (String string : mod.filesToAdd) {
                    if (mod.filesAdded.containsKey(string)) continue;
                    out.printf("    WARNING: %s not added (possible conflict)\n", string);
                }
                ArrayList<ClassMod> classMods = new ArrayList<ClassMod>();
                classMods.addAll(mod.getClassMods());
                Collections.sort(classMods, new Comparator<ClassMod>(){

                    @Override
                    public int compare(ClassMod o1, ClassMod o2) {
                        return o1.getDeobfClass().compareTo(o2.getDeobfClass());
                    }
                });
                for (ClassMod classMod : classMods) {
                    ArrayList<String> tc = classMod.targetClasses;
                    out.printf("    %s", classMod.getDeobfClass());
                    if (tc.size() != 0) {
                        if (tc.size() == 1) {
                            out.printf(" (%s)", ClassMap.classNameToFilename(tc.get(0)));
                        } else {
                            out.print(" (multiple matches:");
                            for (String s : tc) {
                                out.print(' ');
                                out.print(s);
                            }
                            out.print(")");
                        }
                    }
                    out.println();
                    ArrayList<Map.Entry<String, Integer>> sortedList = new ArrayList<Map.Entry<String, Integer>>();
                    for (int i = 0; i < classMod.patches.size(); ++i) {
                        ClassPatch classPatch = classMod.patches.get(i);
                        if (classPatch.numMatches.isEmpty() && !classPatch.optional) {
                            String desc = null;
                            Throwable e = null;
                            try {
                                desc = classPatch.getDescription();
                            }
                            catch (Throwable e1) {
                                e = e1;
                            }
                            if (desc == null) {
                                desc = String.format("patch %d (%s)", i, e == null ? "no description" : e.getMessage());
                            }
                            final String desc2 = desc;
                            sortedList.add(new Map.Entry<String, Integer>(){

                                @Override
                                public String getKey() {
                                    return desc2;
                                }

                                @Override
                                public Integer getValue() {
                                    return 0;
                                }

                                @Override
                                public Integer setValue(Integer value) {
                                    return value;
                                }
                            });
                            continue;
                        }
                        sortedList.addAll(classPatch.numMatches.entrySet());
                    }
                    Collections.sort(sortedList, new Comparator<Map.Entry<String, Integer>>(){

                        @Override
                        public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                            return o1.getKey().compareTo(o2.getKey());
                        }
                    });
                    for (Map.Entry entry : sortedList) {
                        out.printf("        [%d] %s\n", entry.getValue(), entry.getKey());
                    }
                }
                out.println();
            }
        }
    }

    static HashMap<String, ArrayList<Mod>> getConflicts() {
        HashMap<String, ArrayList<Mod>> conflicts = new HashMap<String, ArrayList<Mod>>();
        ArrayList<Mod> mods = modList.getSelected();
        for (Mod mod : mods) {
            for (String filename : mod.filesToAdd) {
                ArrayList<Mod> modArray = (ArrayList<Mod>)conflicts.get(filename);
                if (modArray == null) {
                    modArray = new ArrayList<Mod>();
                    conflicts.put(filename, modArray);
                }
                modArray.add(mod);
            }
        }
        ArrayList entriesToRemove = new ArrayList();
        for (Map.Entry entry : conflicts.entrySet()) {
            if (((ArrayList)entry.getValue()).size() > 1) continue;
            entriesToRemove.add(entry.getKey());
        }
        for (String filename : entriesToRemove) {
            conflicts.remove(filename);
        }
        return conflicts;
    }

    static boolean patch() {
        modList.setApplied(true);
        boolean patchOk = false;
        try {
            Logger.log(0);
            Logger.log(0, "Patching...", new Object[0]);
            for (Mod mod : modList.getAll()) {
                mod.resetCounts();
            }
            MCPatcher.applyMods();
            minecraft.checkOutput();
            minecraft.closeStreams();
            Logger.log(0);
            Logger.log(0, "Done!", new Object[0]);
            patchOk = true;
        }
        catch (Throwable e) {
            Logger.log(e);
            Logger.log(0);
            Logger.log(0, "Restoring original minecraft.jar due to previous error", new Object[0]);
            try {
                minecraft.restoreBackup();
            }
            catch (IOException e1) {
                Logger.log(e1);
            }
        }
        return patchOk;
    }

    private static void applyMods() throws Exception {
        JarFile origJar = minecraft.getInputJar();
        JarOutputStream outputJar = minecraft.getOutputJar();
        int procFiles = 0;
        for (JarEntry entry : Collections.list(origJar.entries())) {
            InputStream inputStream;
            MCPatcher.checkInterrupt();
            ui.updateProgress(++procFiles, origJar.size());
            String name = entry.getName();
            boolean patched = false;
            if (MinecraftJar.isGarbageFile(name)) continue;
            if (entry.isDirectory()) {
                outputJar.putNextEntry(new ZipEntry(name));
                outputJar.closeEntry();
                continue;
            }
            Mod fromMod = null;
            for (Mod mod : modList.getSelected()) {
                if (!mod.filesToAdd.contains(name)) continue;
                fromMod = mod;
            }
            if (fromMod == null) {
                inputStream = origJar.getInputStream(entry);
            } else {
                inputStream = fromMod.openFile(name);
                if (inputStream == null) {
                    throw new IOException(String.format("could not open %s for %s", name, fromMod.getName()));
                }
                Logger.log(1, "replacing %s for %s", name, fromMod.getName());
                fromMod.filesAdded.put(name, "replaced");
            }
            if (MinecraftJar.isClassFile(name)) {
                ArrayList<ClassMod> classMods = new ArrayList<ClassMod>();
                ClassFile classFile = new ClassFile(new DataInputStream(inputStream));
                String className = ClassMap.filenameToClassName(name);
                for (Mod mod : modList.getSelected()) {
                    int i = modList.indexOf(fromMod);
                    int j = modList.indexOf(mod);
                    if (j > 0 && i > j) continue;
                    for (ClassMod classMod : mod.getClassMods()) {
                        if (!classMod.targetClasses.contains(className)) continue;
                        classMods.add(classMod);
                    }
                }
                patched = MCPatcher.applyPatches(name, classFile, classMods);
                if (patched) {
                    outputJar.putNextEntry(new ZipEntry(name));
                    classFile.compact();
                    classFile.write(new DataOutputStream(outputJar));
                    outputJar.closeEntry();
                }
            }
            if (!patched) {
                outputJar.putNextEntry(new ZipEntry(name));
                MCPatcherUtils.close(inputStream);
                inputStream = fromMod == null ? origJar.getInputStream(entry) : fromMod.openFile(name);
                Util.copyStream(inputStream, outputJar);
                outputJar.closeEntry();
            }
            MCPatcherUtils.close(inputStream);
        }
        HashMap<String, Mod> allFilesToAdd = new HashMap<String, Mod>();
        for (Mod mod : modList.getSelected()) {
            for (String name : mod.filesToAdd) {
                if (origJar.getEntry(name) != null) continue;
                allFilesToAdd.put(name, mod);
            }
        }
        if (!allFilesToAdd.isEmpty()) {
            ui.setStatusText("Adding files to %s...", minecraft.getOutputFile().getName());
            int filesAdded = 0;
            for (Mod mod : modList.getSelected()) {
                for (String name : mod.filesToAdd) {
                    if (mod != allFilesToAdd.get(name)) continue;
                    MCPatcher.addFile(mod, name, outputJar);
                    ui.updateProgress(++filesAdded, allFilesToAdd.size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addFile(Mod mod, String filename, JarOutputStream outputJar) throws IOException, BadBytecode {
        String resource = "/" + filename;
        InputStream inputStream = mod.openFile(resource);
        if (inputStream == null) {
            throw new IOException(String.format("could not open %s for %s", resource, mod.getName()));
        }
        Logger.log(2, "adding %s for %s", filename, mod.getName());
        try {
            outputJar.putNextEntry(new ZipEntry(filename));
            ClassMap classMap = mod.classMap;
            if (MinecraftJar.isClassFile(filename) && !classMap.isEmpty()) {
                ClassFile classFile = new ClassFile(new DataInputStream(inputStream));
                classMap.apply(classFile);
                classFile.compact();
                classMap.stringReplace(classFile, outputJar);
            } else {
                Util.copyStream(inputStream, outputJar);
            }
            outputJar.closeEntry();
            mod.filesAdded.put(filename, "added");
        }
        catch (ZipException e) {
            if (!e.toString().contains("duplicate entry")) {
                throw e;
            }
        }
        finally {
            MCPatcherUtils.close(inputStream);
        }
        return true;
    }

    private static boolean applyPatches(String filename, ClassFile classFile, ArrayList<ClassMod> classMods) throws Exception {
        boolean patched = false;
        for (ClassMod cm : classMods) {
            MCPatcher.checkInterrupt();
            if (!cm.targetClasses.contains(classFile.getName())) continue;
            cm.addToConstPool = true;
            cm.classFile = classFile;
            cm.methodInfo = null;
            cm.prePatch(filename, classFile);
            if (cm.patches.size() > 0) {
                Logger.log(1, "applying %s patch to %s for mod %s", cm.getDeobfClass(), filename, cm.mod.getName());
            }
            for (ClassPatch cp : cm.patches) {
                cp.classMod = cm;
                if (!cp.apply(classFile)) continue;
                patched = true;
            }
            cm.addToConstPool = true;
            cm.postPatch(filename, classFile);
        }
        return patched;
    }

    static {
        ignoreSavedMods = false;
        ignoreBuiltInMods = false;
        ignoreCustomMods = false;
        enableAllMods = false;
        experimentalMods = false;
    }
}

