/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.pclewis.mcpatcher.AddModDialog;
import com.pclewis.mcpatcher.ConflictDialog;
import com.pclewis.mcpatcher.ExternalMod;
import com.pclewis.mcpatcher.JTextAreaPrintStream;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MCPatcher;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MainMenu;
import com.pclewis.mcpatcher.MinecraftJar;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.ModList;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultCaret;

class MainForm {
    private static final int TAB_MODS = 0;
    private static final int TAB_OPTIONS = 1;
    private static final int TAB_LOG = 2;
    private static final int TAB_CLASS_MAP = 3;
    private static final int TAB_PATCH_SUMMARY = 4;
    private static final Color MOD_BUSY_COLOR = new Color(192, 192, 192);
    private static final String MOD_DESC_FORMAT1 = "<html><table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" style=\"padding-top: 2px; padding-bottom: 2px; font-weight: normal;\" width=\"%1$d\"><tr><td align=\"left\">%2$s<font size=\"5\"><b>%3$s</b></font></td><td align=\"right\"><b>%4$s</b></td></tr>";
    private static final String MOD_DESC_FORMAT2 = "<tr><td colspan=\"2\"><i>%1$s</i></td></tr>";
    private static final String MOD_DESC_FORMAT3 = "</table></html>";
    private static Image programIcon;
    private JPanel mainPanel;
    JFrame frame;
    private int frameWidth = 518;
    private MainMenu mainMenu;
    private JTextField origField;
    JButton origBrowseButton;
    private JTextField outputField;
    JButton outputBrowseButton;
    JButton testButton;
    JButton patchButton;
    JButton undoButton;
    private JTable modTable;
    private JLabel statusText;
    private JButton refreshButton;
    private JProgressBar progressBar;
    private JTabbedPane tabbedPane;
    private JTextArea logText;
    private JButton copyLogButton;
    private JTextArea classMap;
    private JTextArea patchResults;
    private JButton copyClassMapButton;
    private JButton copyPatchResultsButton;
    private JScrollPane modTableScrollPane;
    private JPanel optionsPanel;
    JButton upButton;
    JButton addButton;
    JButton downButton;
    JButton removeButton;
    private AddModDialog addModDialog;
    private boolean shift;
    private boolean busy = true;
    private Thread workerThread = null;

    MainForm() {
        this.$$$setupUI$$$();
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue(){
            private boolean reenter;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void dispatchEvent(AWTEvent event) {
                block8: {
                    try {
                        KeyEvent keyEvent;
                        if (event instanceof KeyEvent && (event.getID() == 401 || event.getID() == 402) && (keyEvent = (KeyEvent)event).getKeyCode() == 16) {
                            MainForm.this.shift = event.getID() == 401;
                        }
                        super.dispatchEvent(event);
                    }
                    catch (Throwable e) {
                        Logger.log(0);
                        Logger.log(0, "Unexpected error while handling UI event %s", event.toString());
                        e.printStackTrace();
                        if (this.reenter) break block8;
                        this.reenter = true;
                        try {
                            MainForm.this.setBusy(false);
                            MainForm.this.tabbedPane.setSelectedIndex(2);
                            MainForm.this.updateActiveTab();
                            MainForm.this.cancelWorker();
                        }
                        catch (Throwable e1) {
                            e.printStackTrace();
                        }
                        finally {
                            this.reenter = false;
                        }
                    }
                }
            }
        });
        this.frame = new JFrame("Minecraft Patcher " + MCPatcher.VERSION_STRING);
        this.frame.setResizable(true);
        this.frame.setContentPane(this.mainPanel);
        MainForm.setIconImage(this.frame);
        this.frame.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                MainForm.this.cancelWorker();
                MainForm.this.frame.setVisible(false);
                MainForm.this.frame.dispose();
                MCPatcher.saveProperties();
                System.exit(0);
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.frame.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                MainForm.this.frameWidth = (int)((Component)e.getSource()).getSize().getWidth();
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        this.frame.setMinimumSize(new Dimension(470, 488));
        this.frame.pack();
        this.origBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.setStatusText("", new Object[0]);
                JFileChooser fd = new JFileChooser();
                fd.setFileSelectionMode(0);
                fd.setFileHidingEnabled(false);
                fd.setDialogTitle("Select input file");
                fd.setCurrentDirectory(MCPatcherUtils.getMinecraftPath("bin"));
                fd.setAcceptAllFileFilterUsed(false);
                fd.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".jar");
                    }

                    public String getDescription() {
                        return "*.jar";
                    }
                });
                if (fd.showOpenDialog(MainForm.this.frame) == 0) {
                    if (MCPatcher.setMinecraft(fd.getSelectedFile(), false)) {
                        MCPatcher.saveProperties();
                        MainForm.this.updateModList();
                    } else {
                        MainForm.this.showCorruptJarError(fd.getSelectedFile());
                    }
                }
                MainForm.this.updateControls();
            }
        });
        this.outputBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.setStatusText("", new Object[0]);
                JFileChooser fd = new JFileChooser();
                fd.setFileSelectionMode(0);
                fd.setFileHidingEnabled(false);
                fd.setDialogTitle("Select output file");
                fd.setCurrentDirectory(MCPatcherUtils.getMinecraftPath("bin"));
                fd.setSelectedFile(MCPatcherUtils.getMinecraftPath("bin", "minecraft.jar"));
                fd.setAcceptAllFileFilterUsed(false);
                fd.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".jar");
                    }

                    public String getDescription() {
                        return "*.jar";
                    }
                });
                if (fd.showSaveDialog(MainForm.this.frame) == 0) {
                    MCPatcher.minecraft.setOutputFile(fd.getSelectedFile());
                }
                MainForm.this.updateControls();
            }
        });
        this.modTable.setRowSelectionAllowed(true);
        this.modTable.setColumnSelectionAllowed(false);
        this.modTable.setAutoResizeMode(3);
        this.setModList(null);
        this.modTableScrollPane.getViewport().setBackground(this.modTable.getBackground());
        this.modTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MainForm.this.setStatusText("", new Object[0]);
                if (MainForm.this.modTable.isEnabled()) {
                    int row = MainForm.this.modTable.getSelectedRow();
                    int col = MainForm.this.modTable.getSelectedColumn();
                    AbstractTableModel model = (AbstractTableModel)MainForm.this.modTable.getModel();
                    Mod mod = (Mod)model.getValueAt(row, col);
                    if (col == 0 && mod != null && mod.okToApply()) {
                        MCPatcher.modList.selectMod(mod, !mod.isEnabled());
                    }
                    model.fireTableRowsUpdated(0, model.getRowCount());
                    if (e.getClickCount() == 2 && mod instanceof ExternalMod) {
                        ExternalMod extMod = (ExternalMod)mod;
                        MainForm.this.addModDialog = new AddModDialog(MainForm.this.mainPanel, extMod);
                        MainForm.this.addModDialog.setLocationRelativeTo(MainForm.this.frame);
                        MainForm.this.addModDialog.setVisible(true);
                        if (MainForm.this.addModDialog.getMod() == extMod) {
                            MainForm.this.modTable.addRowSelectionInterval(row, row);
                            ModTextRenderer renderer = (ModTextRenderer)MainForm.this.modTable.getColumnModel().getColumn(1).getCellRenderer();
                            renderer.resetRowHeights();
                            model.fireTableDataChanged();
                        }
                    }
                }
                super.mouseClicked(e);
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = MainForm.this.modTable.getSelectedRow();
                if (row >= 0) {
                    int newRow = MCPatcher.modList.moveUp(row, MainForm.this.shift);
                    MainForm.this.modTable.clearSelection();
                    AbstractTableModel model = (AbstractTableModel)MainForm.this.modTable.getModel();
                    model.fireTableRowsUpdated(Math.min(row, newRow), Math.max(row, newRow));
                    ModTextRenderer renderer = (ModTextRenderer)MainForm.this.modTable.getColumnModel().getColumn(1).getCellRenderer();
                    renderer.resetRowHeights();
                    MainForm.this.modTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = MainForm.this.modTable.getSelectedRow();
                if (row >= 0) {
                    int newRow = MCPatcher.modList.moveDown(row, MainForm.this.shift);
                    MainForm.this.modTable.clearSelection();
                    AbstractTableModel model = (AbstractTableModel)MainForm.this.modTable.getModel();
                    model.fireTableRowsUpdated(Math.min(row, newRow), Math.max(row, newRow));
                    ModTextRenderer renderer = (ModTextRenderer)MainForm.this.modTable.getColumnModel().getColumn(1).getCellRenderer();
                    renderer.resetRowHeights();
                    MainForm.this.modTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    MainForm.this.addModDialog = new AddModDialog(MainForm.this.mainPanel);
                    if (!MainForm.this.addModDialog.showBrowseDialog(MainForm.this.mainPanel)) {
                        return;
                    }
                    MainForm.this.addModDialog.setLocationRelativeTo(MainForm.this.frame);
                    MainForm.this.addModDialog.setVisible(true);
                    ExternalMod mod = MainForm.this.addModDialog.getMod();
                    if (mod != null) {
                        int row = MCPatcher.modList.addFirst(mod);
                        mod.setEnabled(true);
                        MainForm.this.modTable.clearSelection();
                        AbstractTableModel model = (AbstractTableModel)MainForm.this.modTable.getModel();
                        model.fireTableRowsInserted(row, row);
                        ModTextRenderer renderer = (ModTextRenderer)MainForm.this.modTable.getColumnModel().getColumn(1).getCellRenderer();
                        renderer.resetRowHeights();
                    }
                }
                catch (Throwable e1) {
                    Logger.log(e1);
                }
                finally {
                    this.hideDialog();
                    MainForm.this.updateControls();
                }
            }

            private void hideDialog() {
                if (MainForm.this.addModDialog != null) {
                    MainForm.this.addModDialog.setVisible(false);
                    MainForm.this.addModDialog.dispose();
                    MainForm.this.addModDialog = null;
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = MainForm.this.modTable.getSelectedRow();
                Mod mod = (Mod)MainForm.this.modTable.getModel().getValueAt(row, 0);
                if (mod instanceof ExternalMod) {
                    MCPatcher.modList.remove(mod);
                    MainForm.this.modTable.clearSelection();
                    AbstractTableModel model = (AbstractTableModel)MainForm.this.modTable.getModel();
                    model.fireTableRowsDeleted(row, row);
                    if (row >= model.getRowCount()) {
                        --row;
                    }
                    MainForm.this.modTable.addRowSelectionInterval(row, row);
                    ModTextRenderer renderer = (ModTextRenderer)MainForm.this.modTable.getColumnModel().getColumn(1).getCellRenderer();
                    renderer.resetRowHeights();
                }
            }
        });
        this.patchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.setBusy(true);
                MainForm.this.setStatusText("Patching %s...", MCPatcher.minecraft.getOutputFile().getName());
                MainForm.this.runWorker(new PatchThread());
            }

            class PatchThread
            implements Runnable {
                PatchThread() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ConflictDialog dialog;
                        int result;
                        boolean patchOk = true;
                        HashMap<String, ArrayList<Mod>> conflicts = MCPatcher.getConflicts();
                        if (conflicts.size() > 0 && (result = (dialog = new ConflictDialog(conflicts)).getResult(MainForm.this.mainPanel)) != 0) {
                            patchOk = false;
                        }
                        if (patchOk && !MCPatcher.patch()) {
                            MainForm.this.tabbedPane.setSelectedIndex(2);
                            JOptionPane.showMessageDialog(MainForm.this.frame, "There was an error during patching.  See log for more information.  Your original minecraft.jar has been restored.", "Error", 0);
                        }
                    }
                    catch (Throwable e) {
                        Logger.log(e);
                        MainForm.this.tabbedPane.setSelectedIndex(2);
                    }
                    finally {
                        MainForm.this.setBusy(false);
                    }
                }
            }
        });
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.setStatusText("", new Object[0]);
                try {
                    MCPatcher.minecraft.restoreBackup();
                    MinecraftJar.setDefaultTexturePack();
                    JOptionPane.showMessageDialog(MainForm.this.frame, "Restored original minecraft jar and reset texture pack to default.", "", 1);
                }
                catch (IOException e1) {
                    Logger.log(e1);
                    JOptionPane.showMessageDialog(MainForm.this.frame, "Failed to restore minecraft jar from backup:\n\n" + e1.getMessage(), "Error", 0);
                }
                MainForm.this.updateControls();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.setStatusText("", new Object[0]);
                MCPatcher.getAllMods();
                MainForm.this.updateModList();
            }
        });
        this.testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.tabbedPane.setSelectedIndex(2);
                MainForm.this.setBusy(true);
                MainForm.this.setStatusText("Launching %s...", MCPatcher.minecraft.getOutputFile().getName());
                MCPatcher.saveProperties();
                MainForm.this.runWorker(new MinecraftThread());
            }

            class MinecraftThread
            implements Runnable {
                MinecraftThread() {
                }

                public void run() {
                    MCPatcher.minecraft.run();
                    MainForm.this.setBusy(false);
                }
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MainForm.this.updateActiveTab();
            }
        });
        ((DefaultCaret)this.logText.getCaret()).setUpdatePolicy(2);
        JTextAreaPrintStream output = new JTextAreaPrintStream(this.logText);
        System.setOut(output);
        System.setErr(output);
        this.copyLogButton.addActionListener(new CopyToClipboardListener(this.logText));
        ((DefaultCaret)this.classMap.getCaret()).setUpdatePolicy(1);
        this.copyClassMapButton.addActionListener(new CopyToClipboardListener(this.classMap));
        ((DefaultCaret)this.patchResults.getCaret()).setUpdatePolicy(1);
        this.copyPatchResultsButton.addActionListener(new CopyToClipboardListener(this.patchResults));
        this.mainMenu = new MainMenu(this);
        this.frame.setJMenuBar(this.mainMenu.menuBar);
    }

    static void setIconImage(Window window) {
        try {
            if (programIcon == null) {
                programIcon = Toolkit.getDefaultToolkit().getImage(MainForm.class.getResource("/resources/icon.png"));
            }
            window.setIconImage(programIcon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void show() {
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    File chooseMinecraftDir(File minecraftDir) {
        JOptionPane.showMessageDialog(null, "Minecraft not found in\n" + minecraftDir.getPath() + "\n\n" + "If the game is installed somewhere else, please select the game\n" + "folder (the one containing bin, resources, saves, etc., subfolders).", "Minecraft not found", 0);
        JFileChooser fd = new JFileChooser();
        fd.setFileSelectionMode(1);
        fd.setFileHidingEnabled(false);
        fd.setDialogTitle("Select Minecraft directory");
        int result = fd.showDialog(null, null);
        if (result != 0) {
            return null;
        }
        return fd.getSelectedFile();
    }

    void showBetaWarning() {
        JOptionPane.showMessageDialog(this.frame, "This is a pre-release version of MCPatcher and is not intended\nfor general use.\n\nPlease make backups of your mods, save files, and texture packs\nbefore using.  Report any problems in the thread for MCPatcher beta at\nhttp://www.minecraftforum.net/topic/1496369-", "For testing only", 1);
    }

    void showCorruptJarError(File defaultMinecraft) {
        if (defaultMinecraft.exists()) {
            this.tabbedPane.setSelectedIndex(2);
            JOptionPane.showMessageDialog(this.frame, "There was an error opening minecraft.jar. This may be because:\n - You selected the launcher jar and not the main minecraft.jar in the bin folder.\n - You selected a texture pack and not minecraft.jar.\n - The file has already been patched.\n - There was an update that this patcher cannot handle.\n - There is another, conflicting mod applied.\n - The jar file is invalid or corrupt.\n\nYou can re-download the original minecraft.jar by using the Force Update\nbutton in the Minecraft Launcher.\n", "Invalid or Corrupt minecraft.jar", 0);
        } else {
            JOptionPane.showMessageDialog(this.frame, "Could not find minecraft.jar in\n" + defaultMinecraft.getParentFile().getPath() + "\n" + "\n" + "Use the Browse button to select a different\n" + "input file before patching.", "Missing minecraft.jar", 0);
        }
    }

    private void cancelWorker() {
        if (this.workerThread != null && this.workerThread.isAlive()) {
            try {
                this.workerThread.interrupt();
                this.setStatusText("Waiting for current task to finish...", new Object[0]);
                this.workerThread.join();
            }
            catch (InterruptedException e) {
                Logger.log(e);
            }
            this.setStatusText("", new Object[0]);
        }
        this.workerThread = null;
    }

    private void runWorker(Runnable runnable) {
        this.cancelWorker();
        this.workerThread = new Thread(runnable);
        this.workerThread.start();
    }

    synchronized void setBusy(boolean busy) {
        this.busy = busy;
        if (!busy) {
            this.setStatusText("", new Object[0]);
            this.updateProgress(0, 0);
        }
        this.updateControls();
    }

    synchronized void setStatusText(String format, Object ... params) {
        this.statusText.setText(String.format(format, params));
    }

    synchronized void updateProgress(int value, int max) {
        if (max > 0) {
            this.progressBar.setVisible(true);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(max);
            this.progressBar.setValue(value);
        } else {
            this.progressBar.setVisible(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(1);
            this.progressBar.setValue(0);
        }
    }

    void updateControls() {
        String currentProfile = MCPatcherUtils.config.getConfigValue("selectedProfile");
        if (currentProfile == null || currentProfile.equals("")) {
            this.frame.setTitle("MCPatcher " + MCPatcher.VERSION_STRING);
        } else {
            this.frame.setTitle("MCPatcher " + MCPatcher.VERSION_STRING + " [" + currentProfile + "]");
        }
        if (MCPatcher.minecraft == null) {
            this.origField.setText("");
            this.outputField.setText("");
        } else {
            this.origField.setText(MCPatcher.minecraft.getInputFile().getPath());
            this.outputField.setText(MCPatcher.minecraft.getOutputFile().getPath());
        }
        this.origField.setToolTipText(this.origField.getText());
        this.outputField.setToolTipText(this.outputField.getText());
        boolean outputSet = !this.outputField.getText().equals("");
        File orig = new File(this.origField.getText());
        File output = new File(this.outputField.getText());
        boolean origOk = orig.exists();
        boolean outputOk = output.exists();
        this.origBrowseButton.setEnabled(!this.busy);
        this.outputBrowseButton.setEnabled(!this.busy);
        this.modTable.setEnabled(!this.busy && origOk && outputSet);
        this.upButton.setEnabled(!this.busy && origOk);
        this.downButton.setEnabled(!this.busy && origOk);
        this.addButton.setEnabled(!this.busy && origOk);
        this.removeButton.setEnabled(!this.busy && origOk);
        this.refreshButton.setEnabled(!this.busy && origOk);
        this.testButton.setEnabled(!this.busy && outputOk && MCPatcherUtils.getMinecraftPath(new String[0]).equals(MCPatcherUtils.getDefaultGameDir()));
        this.patchButton.setEnabled(!this.busy && origOk && !output.equals(orig));
        this.undoButton.setEnabled(!this.busy && origOk && !output.equals(orig));
        this.tabbedPane.setEnabled(!this.busy);
        this.updateActiveTab();
        this.mainMenu.updateControls(this.busy);
    }

    private void updateActiveTab() {
        if (this.tabbedPane.getSelectedIndex() != 1) {
            this.saveOptions();
        }
        switch (this.tabbedPane.getSelectedIndex()) {
            case 1: {
                this.loadOptions();
                break;
            }
            case 3: {
                this.showClassMaps();
                break;
            }
            case 4: {
                this.showPatchResults();
                break;
            }
        }
    }

    private void saveOptions() {
        if (MCPatcher.modList != null) {
            for (Mod mod : MCPatcher.modList.getAll()) {
                if (mod.configPanel == null) continue;
                try {
                    mod.configPanel.save();
                }
                catch (Throwable e) {
                    Logger.log(e);
                }
            }
        }
        MCPatcher.saveProperties();
    }

    private void loadOptions() {
        this.optionsPanel.removeAll();
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
        if (MCPatcher.modList != null) {
            for (Mod mod : MCPatcher.modList.getAll()) {
                try {
                    if (mod.configPanel == null) continue;
                    mod.loadOptions();
                    JPanel panel = mod.configPanel.getPanel();
                    if (panel == null) continue;
                    String name = mod.configPanel.getPanelName();
                    if (name == null) {
                        name = mod.getName();
                    }
                    if (panel.getParent() != null) {
                        panel.getParent().remove(panel);
                    }
                    panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), name));
                    this.optionsPanel.add(panel);
                    this.optionsPanel.add(Box.createRigidArea(new Dimension(1, 16)));
                }
                catch (Throwable e) {
                    Logger.log(e);
                }
            }
        }
        this.optionsPanel.validate();
    }

    private void showClassMaps() {
        this.classMap.setText("");
        JTextAreaPrintStream out = new JTextAreaPrintStream(this.classMap);
        MCPatcher.showClassMaps(out);
        out.close();
    }

    private void showPatchResults() {
        this.patchResults.setText("");
        JTextAreaPrintStream out = new JTextAreaPrintStream(this.patchResults);
        MCPatcher.showPatchResults(out);
        out.close();
    }

    void setModList(final ModList modList) {
        this.modTable.setModel(new DefaultTableModel(){

            @Override
            public int getRowCount() {
                return modList == null ? 0 : modList.getVisible().size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return Mod.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (modList == null || rowIndex < 0) {
                    return null;
                }
                Vector<Mod> visible = modList.getVisible();
                return rowIndex < visible.size() ? visible.get(rowIndex) : null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }
        });
        this.redrawModList();
    }

    void updateModList() {
        this.setBusy(true);
        this.setStatusText("Analyzing %s...", MCPatcher.minecraft.getInputFile().getName());
        this.runWorker(new Runnable(){

            public void run() {
                try {
                    MCPatcher.getApplicableMods();
                    if (MCPatcher.minecraft.isModded()) {
                        JOptionPane.showMessageDialog(MainForm.this.frame, "Your minecraft.jar appears to be an older version or is already modded.\nIf you are using other mods, it is highly recommended that you install them via\nMCPatcher instead.\n - Close MCPatcher.\n - Delete both minecraft.jar and minecraft-" + MCPatcher.minecraft.getVersion() + ".jar.\n" + " - Re-download the game using the launcher.\n" + " - Run MCPatcher and select mods to add using the Add (+) button in the main window.\n" + "Doing this will prevent most conflicts between MCPatcher and other mods.", "Warning", 2);
                    }
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                    Logger.log(e);
                    MainForm.this.showCorruptJarError(MCPatcher.minecraft.getInputFile());
                }
                MainForm.this.redrawModList();
                MainForm.this.setBusy(false);
            }
        });
    }

    void redrawModList() {
        this.modTable.getColumnModel().getColumn(0).setCellRenderer(new ModCheckBoxRenderer());
        this.modTable.getColumnModel().getColumn(1).setCellRenderer(new ModTextRenderer());
        AbstractTableModel model = (AbstractTableModel)this.modTable.getModel();
        model.fireTableDataChanged();
    }

    void redrawModListCheckboxes() {
        AbstractTableModel model = (AbstractTableModel)this.modTable.getModel();
        model.fireTableChanged(new TableModelEvent(model, 0, this.modTable.getRowCount(), 0));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextArea jTextArea;
        JButton jButton2;
        JTextArea jTextArea2;
        JButton jButton3;
        JTextArea jTextArea3;
        JPanel jPanel;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JButton jButton8;
        JButton jButton9;
        JButton jButton10;
        JButton jButton11;
        JTable jTable;
        JScrollPane jScrollPane;
        JTabbedPane jTabbedPane;
        JProgressBar jProgressBar;
        JLabel jLabel;
        JButton jButton12;
        JTextField jTextField;
        JButton jButton13;
        JTextField jTextField2;
        JPanel jPanel2;
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(512, 512));
        jPanel2.setOpaque(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 0, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Files", 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Original");
        jLabel2.setToolTipText("Input file used for patching");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.origField = jTextField2 = new JTextField();
        jTextField2.setColumns(25);
        jTextField2.setEditable(false);
        jTextField2.setMinimumSize(new Dimension(300, 21));
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.origBrowseButton = jButton13 = new JButton();
        jButton13.setToolTipText("Select input file");
        jButton13.setText("Browse");
        jButton13.setMnemonic('B');
        jButton13.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton13, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Output");
        jLabel3.setToolTipText("Output file that will be written");
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputField = jTextField = new JTextField();
        jTextField.setColumns(25);
        jTextField.setEditable(false);
        jTextField.setMinimumSize(new Dimension(300, 21));
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.outputBrowseButton = jButton12 = new JButton();
        jButton12.setToolTipText("Select output file");
        jButton12.setText("Browse");
        jButton12.setMnemonic('O');
        jButton12.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jButton12, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 0, null, new Dimension(-1, 32), null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.statusText = jLabel = new JLabel();
        jLabel.setText("");
        ((Component)jLabel).setEnabled(true);
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.progressBar = jProgressBar = new JProgressBar();
        jProgressBar.setStringPainted(true);
        jPanel4.add((Component)jProgressBar, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, new Dimension(200, -1), null));
        this.tabbedPane = jTabbedPane = new JTabbedPane();
        jPanel2.add((Component)jTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Mods", null, jPanel5, "Select mods to apply");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.modTableScrollPane = jScrollPane = new JScrollPane();
        jPanel6.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 225), null, null));
        this.modTable = jTable = new JTable();
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(3);
        ((Component)jTable).setEnabled(false);
        jTable.setShowHorizontalLines(false);
        jTable.setPreferredScrollableViewportSize(new Dimension(-1, -1));
        jTable.setIntercellSpacing(new Dimension(0, 0));
        jScrollPane.setViewportView(jTable);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.undoButton = jButton11 = new JButton();
        jButton11.setToolTipText("Restore original minecraft.jar");
        jButton11.setText("Unpatch");
        jButton11.setMnemonic('U');
        jButton11.setDisplayedMnemonicIndex(0);
        ((Component)jButton11).setEnabled(false);
        jPanel7.add((Component)jButton11, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.refreshButton = jButton10 = new JButton();
        jButton10.setToolTipText("Reload list of mods");
        jButton10.setText("Refresh Mod List");
        jButton10.setMnemonic('R');
        jButton10.setDisplayedMnemonicIndex(0);
        ((Component)jButton10).setVisible(false);
        ((Component)jButton10).setEnabled(false);
        jPanel7.add((Component)jButton10, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.patchButton = jButton9 = new JButton();
        jButton9.setToolTipText("Apply selected mods");
        jButton9.setText("Patch");
        jButton9.setMnemonic('P');
        jButton9.setDisplayedMnemonicIndex(0);
        ((Component)jButton9).setEnabled(false);
        jPanel7.add((Component)jButton9, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, true, true));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.upButton = jButton8 = new JButton();
        jButton8.setToolTipText("<html>Move selected item up the list<br>(Shift-click: Move to top)</html>");
        jButton8.setIcon(new ImageIcon(this.getClass().getResource("/resources/uparrow.png")));
        ((Component)jButton8).setEnabled(false);
        jPanel8.add((Component)jButton8, new GridConstraints(0, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        this.addButton = jButton7 = new JButton();
        jButton7.setToolTipText("Add an external zip-based mod");
        jButton7.setIcon(new ImageIcon(this.getClass().getResource("/resources/add.png")));
        ((Component)jButton7).setEnabled(false);
        jPanel8.add((Component)jButton7, new GridConstraints(0, 2, 1, 1, 0, 1, 1, 0, null, null, null));
        this.downButton = jButton6 = new JButton();
        jButton6.setToolTipText("<html>Move selected item down the list<br>(Shift-click: Move to bottom)</html>");
        jButton6.setIcon(new ImageIcon(this.getClass().getResource("/resources/downarrow.png")));
        ((Component)jButton6).setEnabled(false);
        jPanel8.add((Component)jButton6, new GridConstraints(0, 1, 1, 1, 0, 1, 1, 0, null, null, null));
        this.removeButton = jButton5 = new JButton();
        jButton5.setToolTipText("Remove the selected item");
        jButton5.setIcon(new ImageIcon(this.getClass().getResource("/resources/remove.png")));
        ((Component)jButton5).setEnabled(false);
        jPanel8.add((Component)jButton5, new GridConstraints(0, 3, 1, 1, 0, 1, 1, 0, null, null, null));
        this.testButton = jButton4 = new JButton();
        jButton4.setToolTipText("Test Minecraft (single-player only)");
        jButton4.setText("Test Minecraft");
        jButton4.setMnemonic('T');
        jButton4.setDisplayedMnemonicIndex(0);
        ((Component)jButton4).setEnabled(false);
        jPanel7.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Options", null, jPanel9, "Configure animations, etc.");
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel9.add((Component)jScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jScrollPane2.setViewportView(jPanel10);
        this.optionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel10.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel10.add((Component)spacer2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel10.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel10.add((Component)spacer4, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Log", null, jPanel11, "View detailed log output");
        JScrollPane jScrollPane3 = new JScrollPane();
        jPanel11.add((Component)jScrollPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.logText = jTextArea3 = new JTextArea();
        jTextArea3.setLineWrap(true);
        jTextArea3.setEditable(false);
        jScrollPane3.setViewportView(jTextArea3);
        this.copyLogButton = jButton3 = new JButton();
        jButton3.setText("Copy to clipboard");
        jPanel11.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Class Map", null, jPanel12, "View mapping to obfuscated names");
        JScrollPane jScrollPane4 = new JScrollPane();
        jPanel12.add((Component)jScrollPane4, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.classMap = jTextArea2 = new JTextArea();
        jTextArea2.setLineWrap(true);
        jTextArea2.setEditable(false);
        jScrollPane4.setViewportView(jTextArea2);
        this.copyClassMapButton = jButton2 = new JButton();
        jButton2.setText("Copy to clipboard");
        jPanel12.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Patch Summary", null, jPanel13, "View list of patches applied");
        JScrollPane jScrollPane5 = new JScrollPane();
        jPanel13.add((Component)jScrollPane5, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.patchResults = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jScrollPane5.setViewportView(jTextArea);
        this.copyPatchResultsButton = jButton = new JButton();
        jButton.setText("Copy to clipboard");
        jPanel13.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel2.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private class CopyToClipboardListener
    implements ActionListener {
        JTextArea textArea;

        public CopyToClipboardListener(JTextArea textArea) {
            this.textArea = textArea;
        }

        public void actionPerformed(ActionEvent e) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("[spoiler][code]\n" + this.textArea.getText() + "[/code][/spoiler]\n"), null);
        }
    }

    private class ModTextRenderer
    extends JLabel
    implements TableCellRenderer {
        private HashMap<Integer, Integer> rowSizeFull = new HashMap();
        private HashMap<Integer, Integer> rowSizeShort = new HashMap();

        private ModTextRenderer() {
        }

        private String htmlEscape(String s) {
            return s == null ? "" : s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }

        public void resetRowHeights() {
            this.rowSizeFull.clear();
            this.rowSizeShort.clear();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int h;
            if (!(value instanceof Mod)) {
                Logger.log(0, "table cell %d,%d is of wrong type %s", row, column, value == null ? "(null)" : value.getClass().getName());
                return this;
            }
            Mod mod = (Mod)value;
            HashMap<Integer, Integer> rowSize = this.rowSizeFull;
            boolean rowSelected = row == table.getSelectedRow();
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(MainForm.MOD_DESC_FORMAT1, Math.max(MainForm.this.frameWidth - 75, 350), ModList.isExperimental(mod.getName()) ? "<font color=\"red\" size=\"3\">(Experimental)</font> " : "", this.htmlEscape(mod.getName()), this.htmlEscape(mod.getVersion())));
            if (rowSelected) {
                rowSize = this.rowSizeShort;
                sb.append(String.format(MainForm.MOD_DESC_FORMAT2, this.htmlEscape(mod.getDescription())));
            }
            sb.append(MainForm.MOD_DESC_FORMAT3);
            this.setText(sb.toString());
            if (!table.isEnabled() || !mod.okToApply()) {
                this.setBackground(table.getBackground());
                this.setForeground(MOD_BUSY_COLOR);
            } else if (rowSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setEnabled(table.isEnabled() && mod.okToApply());
            if (rowSize.containsKey(row)) {
                h = rowSize.get(row);
            } else {
                h = (int)this.getPreferredSize().getHeight();
                rowSize.put(row, h);
            }
            if (h != table.getRowHeight(row)) {
                table.setRowHeight(row, h);
            }
            ArrayList<String> errors = mod.getErrors();
            sb = new StringBuilder();
            if (table.isEnabled()) {
                if (errors.size() == 0) {
                    String author = this.htmlEscape(mod.getAuthor());
                    String website = this.htmlEscape(mod.getWebsite());
                    if (author.length() > 0 || website.length() > 0) {
                        sb.append("<html>");
                        if (mod.getAuthor().length() > 0) {
                            sb.append(String.format("Author: %s<br>", author));
                        }
                        if (mod.getWebsite().length() > 0) {
                            sb.append(String.format("Website: <a href=\"%1$s\">%1$s</a><br>", website));
                        }
                        sb.append("</html>");
                    }
                } else {
                    sb.append("<html><b>");
                    sb.append(this.htmlEscape(mod.getName()));
                    sb.append(" cannot be applied:</b><br>");
                    for (String s : errors) {
                        sb.append("&nbsp;");
                        sb.append(s);
                        sb.append("<br>");
                    }
                    sb.append("</html>");
                }
            }
            this.setToolTipText(sb.length() == 0 ? null : sb.toString());
            this.setOpaque(true);
            return this;
        }
    }

    private class ModCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private boolean widthSet = false;

        private ModCheckBoxRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!(value instanceof Mod)) {
                Logger.log(0, "table cell %d,%d is of wrong type %s", row, column, value == null ? "(null)" : value.getClass().getName());
                return this;
            }
            Mod mod = (Mod)value;
            if (!table.isEnabled() || !mod.okToApply()) {
                this.setBackground(table.getBackground());
                this.setForeground(MOD_BUSY_COLOR);
            } else if (row == table.getSelectedRow()) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setSelected(mod.isEnabled());
            this.setEnabled(table.isEnabled() && mod.okToApply());
            if (!this.widthSet) {
                TableColumn col = table.getColumnModel().getColumn(column);
                double width = this.getPreferredSize().getWidth();
                col.setMinWidth((int)width);
                col.setMaxWidth((int)(1.5 * width));
                col.setPreferredWidth((int)(1.5 * width));
                this.widthSet = true;
            }
            return this;
        }
    }
}

