/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import java.io.IOException;

public class BetterSkies
extends Mod {
    private final boolean haveNewWorld;
    private final boolean haveNewWorldTime;
    private final String worldObjClass;

    public BetterSkies(MinecraftVersion minecraftVersion) {
        this.name = "Better Skies";
        this.author = "MCPatcher";
        this.description = "Adds support for custom skyboxes.";
        this.version = "1.1";
        this.addDependency("__TexturePackBase");
        this.haveNewWorld = minecraftVersion.compareTo("12w18a") >= 0;
        this.haveNewWorldTime = minecraftVersion.compareTo("12w32a") >= 0;
        this.classMods.add(new BaseMod.MinecraftMod().addWorldGetter(minecraftVersion));
        this.classMods.add(new WorldMod());
        if (this.haveNewWorld) {
            this.classMods.add(new BaseMod.WorldServerMPMod(minecraftVersion));
            this.classMods.add(new BaseMod.WorldServerMod(minecraftVersion));
            this.worldObjClass = "WorldServerMP";
        } else {
            this.worldObjClass = "World";
        }
        this.classMods.add(new RenderGlobalMod());
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.SkyRenderer"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.SkyRenderer$1"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.SkyRenderer$WorldEntry"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.SkyRenderer$Layer"));
    }

    private class RenderGlobalMod
    extends ClassMod {
        private final MethodRef renderSky = new MethodRef(this.getDeobfClass(), "renderSky", "(F)V");

        RenderGlobalMod() {
            MethodRef getTexture = new MethodRef("RenderEngine", "getTexture", "(Ljava/lang/String;)I");
            MethodRef bindTexture = new MethodRef("RenderEngine", "bindTexture", "(I)V");
            final MethodRef getCelestialAngle = new MethodRef(BetterSkies.this.worldObjClass, "getCelestialAngle", "(F)F");
            MethodRef getRainStrength = new MethodRef("World", "getRainStrength", "(F)F");
            MethodRef startDrawingQuads = new MethodRef("Tessellator", "startDrawingQuads", "()V");
            MethodRef setColorOpaque_I = new MethodRef("Tessellator", "setColorOpaque_I", "(I)V");
            MethodRef addVertexWithUV = new MethodRef("Tessellator", "addVertexWithUV", "(DDDDD)V");
            MethodRef draw = new MethodRef("Tessellator", "draw", "()I");
            final MethodRef glRotatef = new MethodRef("org.lwjgl.opengl.GL11", "glRotatef", "(FFFF)V");
            final MethodRef glCallList = new MethodRef("org.lwjgl.opengl.GL11", "glCallList", "(I)V");
            FieldRef tessellator = new FieldRef("Tessellator", "instance", "LTessellator;");
            final FieldRef renderEngine = new FieldRef(this.getDeobfClass(), "renderEngine", "LRenderEngine;");
            FieldRef mc = new FieldRef(this.getDeobfClass(), "mc", "LMinecraft;");
            FieldRef worldProvider = new FieldRef("World", "worldProvider", "LWorldProvider;");
            FieldRef worldType = new FieldRef("WorldProvider", "worldType", "I");
            final FieldRef worldObj = new FieldRef(this.getDeobfClass(), "worldObj", "L" + BetterSkies.this.worldObjClass + ";");
            FieldRef glSkyList = new FieldRef(this.getDeobfClass(), "glSkyList", "I");
            FieldRef glSkyList2 = new FieldRef(this.getDeobfClass(), "glSkyList2", "I");
            final FieldRef glStarList = new FieldRef(this.getDeobfClass(), "glStarList", "I");
            final FieldRef active = new FieldRef("com.pclewis.mcpatcher.mod.SkyRenderer", "active", "Z");
            this.classSignatures.add(new ConstSignature("smoke"));
            this.classSignatures.add(new ConstSignature("/environment/clouds.png"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), BinaryRegex.any(3), BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), 4, BinaryRegex.any(0, 100), 42, BytecodeMatcher.captureReference(180), 42, BinaryRegex.backReference(4), this.push("/misc/tunnel.png"), BytecodeMatcher.captureReference(182), BytecodeMatcher.captureReference(182), BytecodeMatcher.captureReference(178), BytecodeMatcher.anyASTORE, BinaryRegex.any(0, 1000), this.push(Float.valueOf(1.0f)), 42, BytecodeMatcher.captureReference(180), 35, BytecodeMatcher.captureReference(182), 102, BinaryRegex.or(BinaryRegex.build(BytecodeMatcher.anyFSTORE), BinaryRegex.build(141, BytecodeMatcher.anyDSTORE)), BinaryRegex.any(0, 500), 42, BinaryRegex.backReference(8), 35, BytecodeMatcher.captureReference(182), this.push(Float.valueOf(360.0f)), 106, this.push(Float.valueOf(1.0f)), this.push(Float.valueOf(0.0f)), this.push(Float.valueOf(0.0f)), this.reference(184, glRotatef));
                }
            }.setMethod(this.renderSky).addXref(1, mc).addXref(2, worldProvider).addXref(3, worldType).addXref(4, renderEngine).addXref(5, getTexture).addXref(6, bindTexture).addXref(7, tessellator).addXref(8, worldObj).addXref(9, getRainStrength).addXref(10, getCelestialAngle));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), this.reference(184, glCallList), BinaryRegex.nonGreedy(BinaryRegex.any(0, 1000)), 42, BytecodeMatcher.captureReference(180), this.reference(184, glCallList), BinaryRegex.nonGreedy(BinaryRegex.any(0, 1000)), 42, BytecodeMatcher.captureReference(180), this.reference(184, glCallList));
                }
            }.setMethod(this.renderSky).addXref(1, glSkyList).addXref(2, glStarList).addXref(3, glSkyList2));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(44, BytecodeMatcher.captureReference(182), 44, BytecodeMatcher.anyLDC, BytecodeMatcher.captureReference(182), 44, this.push(-100.0), this.push(-100.0), this.push(-100.0), this.push(0.0), this.push(0.0), BytecodeMatcher.captureReference(182), 44, this.push(-100.0), this.push(-100.0), this.push(100.0), this.push(0.0), this.push(16.0), BinaryRegex.backReference(3), 44, this.push(100.0), this.push(-100.0), this.push(100.0), this.push(16.0), this.push(16.0), BinaryRegex.backReference(3), 44, this.push(100.0), this.push(-100.0), this.push(-100.0), this.push(16.0), this.push(0.0), BinaryRegex.backReference(3), 44, BytecodeMatcher.captureReference(182), 87);
                }
            }.addXref(1, startDrawingQuads).addXref(2, setColorOpaque_I).addXref(3, addVertexWithUV).addXref(4, draw));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "setup for sky rendering";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, worldObj), 42, this.reference(180, renderEngine), 35, 42, this.reference(180, worldObj), 35, this.reference(182, getCelestialAngle), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.SkyRenderer", "setup", "(LWorld;LRenderEngine;FF)V")));
                }
            }.targetMethod(this.renderSky));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "render custom sky";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, worldObj), 35, this.reference(182, getCelestialAngle), this.push(Float.valueOf(360.0f)), 106, this.push(Float.valueOf(1.0f)), this.push(Float.valueOf(0.0f)), this.push(Float.valueOf(0.0f)), this.reference(184, glRotatef));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.SkyRenderer", "renderAll", "()V"))});
                }
            }.targetMethod(this.renderSky));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "disable default stars";
                }

                public String getMatchExpression() {
                    return this.buildExpression(23, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.backReference(1), 23, BinaryRegex.backReference(1), 23, BinaryRegex.backReference(1), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glColor4f", "(FFFF)V")), 42, this.reference(180, glStarList), this.reference(184, glCallList));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(178, active), 154, RenderGlobalMod.this.branch("A"), this.getMatch(), RenderGlobalMod.this.label("A"));
                }
            }.targetMethod(this.renderSky));
            this.addCelestialObjectPatch("sun", "/terrain/sun.png");
            this.addCelestialObjectPatch("moon", "/terrain/moon_phases.png");
        }

        private void addCelestialObjectPatch(final String objName, final String textureName) {
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "override " + objName + " texture";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(textureName));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.SkyRenderer", "setupCelestialObject", "(Ljava/lang/String;)Ljava/lang/String;"))});
                }
            }.targetMethod(this.renderSky));
        }
    }

    private class WorldMod
    extends BaseMod.WorldMod {
        WorldMod() {
            MethodRef getWorldTime = new MethodRef(this.getDeobfClass(), "getWorldTime", "()J");
            if (BetterSkies.this.haveNewWorldTime) {
                this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, null, null, getWorldTime));
            } else {
                this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, null, getWorldTime));
            }
        }
    }
}

