/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import com.pclewis.mcpatcher.mod.RenderPassAPI;
import com.pclewis.mcpatcher.mod.SuperTessellator;
import com.pclewis.mcpatcher.mod.TileOverride;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Properties;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class CTMUtils {
    private static final boolean enableGlass = MCPatcherUtils.getBoolean("Connected Textures", "glass", true);
    private static final boolean enableGlassPane = MCPatcherUtils.getBoolean("Connected Textures", "glassPane", true);
    private static final boolean enableBookshelf = MCPatcherUtils.getBoolean("Connected Textures", "bookshelf", true);
    private static final boolean enableSandstone = MCPatcherUtils.getBoolean("Connected Textures", "sandstone", true);
    private static final boolean enableStandard = MCPatcherUtils.getBoolean("Connected Textures", "standard", true);
    private static final boolean enableNonStandard = MCPatcherUtils.getBoolean("Connected Textures", "nonStandard", true);
    private static final boolean enableOutline = MCPatcherUtils.getBoolean("Connected Textures", "outline", false);
    static final int BLOCK_ID_LOG = 17;
    static final int BLOCK_ID_GLASS = 20;
    static final int BLOCK_ID_BED = 26;
    static final int BLOCK_ID_GLASS_PANE = 102;
    static final int BLOCK_ID_BOOKSHELF = 47;
    static final int NUM_TILES = 256;
    static final int TILE_NUM_STILL_LAVA = 237;
    static final int TILE_NUM_FLOWING_LAVA = 238;
    static final int TILE_NUM_STILL_WATER = 205;
    static final int TILE_NUM_FLOWING_WATER = 206;
    static final int TILE_NUM_FIRE_E_W = 31;
    static final int TILE_NUM_FIRE_N_S = 47;
    static final int TILE_NUM_PORTAL = 14;
    static final int TILE_NUM_SANDSTONE_SIDE = 192;
    static final int TILE_NUM_GLASS = 49;
    static final int TILE_NUM_GLASS_PANE_SIDE = 148;
    static TileOverride lastOverride;
    static int terrainTexture;
    private static final TileOverride[][] blockOverrides;
    private static final TileOverride[][] tileOverrides;
    static boolean active;
    public static int newTextureIndex;
    public static Tessellator newTessellator;

    public static void start() {
        lastOverride = null;
        if (terrainTexture >= 0) {
            SuperTessellator.instance.texture = terrainTexture;
            active = true;
        } else {
            SuperTessellator.instance.texture = -1;
            active = false;
        }
    }

    private static boolean check(IBlockAccess blockAccess, int blockID) {
        return active && blockAccess != null && blockID != 26 && blockID != 102 && Tessellator.instance instanceof SuperTessellator;
    }

    public static boolean setup(RenderBlocks renderBlocks, Block block, int i, int j, int k, int face, int origTexture) {
        IBlockAccess blockAccess = renderBlocks.blockAccess;
        if (!enableStandard || !CTMUtils.check(blockAccess, block.blockID) || face < 0 || face > 5) {
            return false;
        }
        if (CTMUtils.getConnectedTexture(renderBlocks, blockAccess, block, origTexture, i, j, k, face)) {
            return true;
        }
        CTMUtils.reset();
        return false;
    }

    public static boolean setup(RenderBlocks renderBlocks, Block block, int i, int j, int k, int origTexture) {
        IBlockAccess blockAccess = renderBlocks.blockAccess;
        if (!enableNonStandard || !CTMUtils.check(blockAccess, block.blockID)) {
            return false;
        }
        if (CTMUtils.getConnectedTexture(renderBlocks, blockAccess, block, origTexture, i, j, k, -1)) {
            return true;
        }
        CTMUtils.reset();
        return false;
    }

    public static void reset() {
    }

    public static void finish() {
        CTMUtils.reset();
        RenderPassAPI.instance.finish();
        SuperTessellator.instance.texture = -1;
        lastOverride = null;
        active = false;
    }

    public static boolean skipDefaultRendering(Block block) {
        return RenderPassAPI.instance.skipDefaultRendering(block);
    }

    static boolean getConnectedTexture(RenderBlocks renderBlocks, IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
        lastOverride = null;
        return CTMUtils.getConnectedTexture(renderBlocks, blockAccess, block, origTexture, i, j, k, face, tileOverrides, origTexture) || CTMUtils.getConnectedTexture(renderBlocks, blockAccess, block, origTexture, i, j, k, face, blockOverrides, block.blockID);
    }

    private static boolean getConnectedTexture(RenderBlocks renderBlocks, IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face, TileOverride[][] allOverrides, int index) {
        if (index < 0 || index >= allOverrides.length) {
            return false;
        }
        TileOverride[] overrides = allOverrides[index];
        if (overrides == null) {
            return false;
        }
        for (int n = 0; n < overrides.length; ++n) {
            TileOverride override = overrides[n];
            if (override == null) continue;
            if (override.disabled) {
                overrides[n] = null;
                continue;
            }
            lastOverride = override;
            newTextureIndex = override.getTile(renderBlocks, blockAccess, block, origTexture, i, j, k, face);
            if (newTextureIndex < 0) continue;
            newTessellator = SuperTessellator.instance.getTessellator(override.texture);
            return true;
        }
        return false;
    }

    private static void registerOverride(TileOverride override) {
        if (override != null) {
            CTMUtils.registerOverride(override, override.blockIDs, blockOverrides);
            CTMUtils.registerOverride(override, override.tileIDs, tileOverrides);
        }
    }

    private static void registerOverride(TileOverride override, int[] ids, TileOverride[][] allOverrides) {
        if (override == null || ids == null || allOverrides == null) {
            return;
        }
        for (int index : ids) {
            TileOverride[] oldList = allOverrides[index];
            if (oldList == null) {
                allOverrides[index] = new TileOverride[]{override};
                continue;
            }
            TileOverride[] newList = new TileOverride[oldList.length + 1];
            System.arraycopy(oldList, 0, newList, 0, oldList.length);
            newList[oldList.length] = override;
            allOverrides[index] = newList;
        }
    }

    private static void setupOutline() {
        BufferedImage terrain = TexturePackAPI.getImage("/terrain.png");
        if (terrain == null) {
            return;
        }
        BufferedImage template = TexturePackAPI.getImage("/ctm/template.png");
        if (template == null) {
            return;
        }
        int width = terrain.getWidth();
        int height = terrain.getHeight();
        if (template.getWidth() != width) {
            BufferedImage newImage = new BufferedImage(width, height, 2);
            Graphics2D graphics2D = newImage.createGraphics();
            graphics2D.drawImage(template, 0, 0, width, height, null);
            template = newImage;
        }
        for (int i = 0; i < tileOverrides.length; ++i) {
            TileOverride override = CTMUtils.setupOutline(i, terrain, template);
            if (override == null) continue;
            TileOverride[] oldList = tileOverrides[i];
            if (oldList == null) {
                CTMUtils.tileOverrides[i] = new TileOverride[]{override};
                continue;
            }
            TileOverride[] newList = new TileOverride[oldList.length + 1];
            System.arraycopy(oldList, 0, newList, 0, oldList.length);
            newList[oldList.length] = override;
            CTMUtils.tileOverrides[i] = newList;
        }
    }

    private static TileOverride setupOutline(int tileNum, BufferedImage terrain, BufferedImage template) {
        switch (tileNum) {
            case 14: 
            case 31: 
            case 47: 
            case 205: 
            case 206: 
            case 237: 
            case 238: {
                return null;
            }
        }
        int tileSize = terrain.getWidth() / 16;
        int tileX = tileNum % 16 * tileSize;
        int tileY = tileNum / 16 * tileSize;
        BufferedImage newImage = new BufferedImage(template.getWidth(), template.getHeight(), 2);
        for (int x = 0; x < template.getWidth(); ++x) {
            for (int y = 0; y < template.getHeight(); ++y) {
                int rgb = template.getRGB(x, y);
                if ((rgb & 0xFF000000) == 0) {
                    rgb = terrain.getRGB(tileX + x % tileSize, tileY + y % tileSize);
                }
                newImage.setRGB(x, y, rgb);
            }
        }
        return TileOverride.create(newImage, tileNum);
    }

    static int getTexture(String name) {
        if (name == null) {
            return -1;
        }
        if (TexturePackAPI.hasResource(name)) {
            return MCPatcherUtils.getMinecraft().renderEngine.getTexture(name);
        }
        return -1;
    }

    static {
        terrainTexture = -1;
        blockOverrides = new TileOverride[Block.blocksList.length][];
        tileOverrides = new TileOverride[256][];
        TexturePackAPI.ChangeHandler.register(new TexturePackAPI.ChangeHandler("Connected Textures", 2){

            protected void onChange() {
                terrainTexture = CTMUtils.getTexture("/terrain.png");
                SuperTessellator.instance.clearTessellators();
                Arrays.fill((Object[])blockOverrides, null);
                Arrays.fill((Object[])tileOverrides, null);
                if (enableStandard || enableNonStandard) {
                    for (String s : TexturePackAPI.listResources("/ctm", ".properties")) {
                        CTMUtils.registerOverride(TileOverride.create(s.replace(".properties", ""), null));
                    }
                }
                Properties properties = new Properties();
                if (enableGlass) {
                    properties.clear();
                    properties.setProperty("method", "glass");
                    properties.setProperty("connect", "block");
                    properties.setProperty("blockIDs", "20");
                    CTMUtils.registerOverride(TileOverride.create("/ctm", properties));
                }
                if (enableGlassPane) {
                    properties.clear();
                    properties.setProperty("method", "glass");
                    properties.setProperty("connect", "block");
                    properties.setProperty("blockIDs", "102");
                    CTMUtils.registerOverride(TileOverride.create("/ctm", properties));
                }
                if (enableBookshelf) {
                    properties.clear();
                    properties.setProperty("method", "bookshelf");
                    properties.setProperty("connect", "block");
                    properties.setProperty("blockIDs", "47");
                    CTMUtils.registerOverride(TileOverride.create("/ctm", properties));
                }
                if (enableSandstone) {
                    properties.clear();
                    properties.setProperty("method", "sandstone");
                    properties.setProperty("connect", "tile");
                    properties.setProperty("tileIDs", "192");
                    properties.setProperty("metadata", "0");
                    CTMUtils.registerOverride(TileOverride.create("/ctm", properties));
                }
                if (enableOutline) {
                    CTMUtils.setupOutline();
                }
                RenderPassAPI.instance.clear();
                for (int i = 0; i < blockOverrides.length; ++i) {
                    if (blockOverrides[i] == null || Block.blocksList[i] == null) continue;
                    for (TileOverride override : blockOverrides[i]) {
                        if (override == null || override.disabled || override.renderPass < 0) continue;
                        RenderPassAPI.instance.setRenderPassForBlock(Block.blocksList[i], override.renderPass);
                    }
                }
                GL11.glBindTexture((int)3553, (int)terrainTexture);
            }
        });
    }
}

