/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import com.pclewis.mcpatcher.mod.BiomeHelper;
import com.pclewis.mcpatcher.mod.ColorMap;
import com.pclewis.mcpatcher.mod.Lightmap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemDye;
import net.minecraft.src.MapColor;
import net.minecraft.src.Potion;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class Colorizer {
    private static final String COLOR_PROPERTIES = "/color.properties";
    private static final String REDSTONE_COLORS = "/misc/redstonecolor.png";
    private static final String STEM_COLORS = "/misc/stemcolor.png";
    private static final String LAVA_DROP_COLORS = "/misc/lavadropcolor.png";
    private static final String MYCELIUM_COLORS = "/misc/myceliumparticlecolor.png";
    private static final String XPORB_COLORS = "/misc/xporbcolor.png";
    private static final String PALETTE_BLOCK_KEY = "palette.block.";
    private static final String TEXT_KEY = "text.";
    private static final String TEXT_CODE_KEY = "text.code.";
    public static final int COLOR_MAP_SWAMP_GRASS = 0;
    public static final int COLOR_MAP_SWAMP_FOLIAGE = 1;
    public static final int COLOR_MAP_PINE = 2;
    public static final int COLOR_MAP_BIRCH = 3;
    public static final int COLOR_MAP_FOLIAGE = 4;
    public static final int COLOR_MAP_WATER = 5;
    public static final int COLOR_MAP_UNDERWATER = 6;
    public static final int COLOR_MAP_FOG0 = 7;
    public static final int COLOR_MAP_SKY0 = 8;
    public static final int NUM_FIXED_COLOR_MAPS = 9;
    private static final String[] MAP_MATERIALS = new String[]{"air", "grass", "sand", "cloth", "tnt", "ice", "iron", "foliage", "snow", "clay", "dirt", "stone", "water", "wood"};
    private static Properties properties;
    private static final ColorMap[] fixedColorMaps;
    private static ColorMap[] blockColorMaps;
    private static final HashMap<Float, ColorMap> blockMetaColorMaps;
    private static int lilypadColor;
    private static float[] waterBaseColor;
    private static float[] lavaDropColors;
    private static int waterBottleColor;
    private static float[][] redstoneColor;
    private static int[] stemColors;
    private static ArrayList<Potion> potions;
    private static final Random random;
    private static final boolean useWaterColors;
    private static final boolean useSwampColors;
    private static final boolean useTreeColors;
    private static final boolean usePotionColors;
    private static final boolean useParticleColors;
    private static final boolean useFogColors;
    private static final boolean useCloudType;
    private static final boolean useRedstoneColors;
    private static final boolean useStemColors;
    private static final boolean useEggColors;
    private static final boolean useMapColors;
    private static final boolean useDyeColors;
    private static final boolean useBlockColors;
    private static final boolean useTextColors;
    private static final boolean useXPOrbColors;
    private static final int fogBlendRadius;
    private static final float fogBlendScale;
    private static final int blockBlendRadius;
    private static final float blockBlendScale;
    public static final float[] setColor;
    public static float[] waterColor;
    public static float[] portalColor;
    private static final HashMap<Integer, String> entityNamesByID;
    private static final HashMap<Integer, Integer> spawnerEggShellColors;
    private static final HashMap<Integer, Integer> spawnerEggSpotColors;
    private static final int CLOUDS_DEFAULT = 0;
    private static final int CLOUDS_FAST = 1;
    private static final int CLOUDS_FANCY = 2;
    private static int cloudType;
    private static final ArrayList<BiomeGenBase> biomes;
    private static boolean biomesLogged;
    private static Entity fogCamera;
    public static float[] netherFogColor;
    public static float[] endFogColor;
    public static int endSkyColor;
    private static int[] myceliumColors;
    private static int[] xpOrbColors;
    private static final HashMap<Integer, Integer> textColorMap;
    private static final int[] textCodeColors;
    private static final boolean[] textCodeColorSet;
    private static int signTextColor;
    private static final int[] origDyeColors;
    private static final float[][] origFleeceColors;
    public static final float[][] armorColors;
    public static int undyedLeatherColor;
    public static final float[][] collarColors;

    public static int colorizeBiome(int defaultColor, int index, double temperature, double rainfall) {
        return fixedColorMaps[index].colorize(defaultColor, temperature, rainfall);
    }

    public static int colorizeBiome(int defaultColor, int index) {
        return fixedColorMaps[index].colorize(defaultColor);
    }

    public static int colorizeBiome(int defaultColor, int index, int i, int j, int k) {
        return fixedColorMaps[index].colorize(defaultColor, i, j, k);
    }

    public static int colorizeBiomeWithBlending(int defaultColor, int index, int i, int j, int k) {
        return Colorizer.colorizeWithBlending(fixedColorMaps[index], defaultColor, i, j, k);
    }

    public static int colorizeWater(Object dummy, int i, int k) {
        return fixedColorMaps[5].colorize(BiomeHelper.instance.getWaterColorMultiplier(i, 64, k), i, 64, k);
    }

    public static int colorizeBlock(Block block, int i, int j, int k, int metadata) {
        ColorMap colorMap = null;
        if (!blockMetaColorMaps.isEmpty()) {
            colorMap = blockMetaColorMaps.get(Float.valueOf(ColorMap.getBlockMetaKey(block.blockID, metadata)));
        }
        if (colorMap == null && block.blockID >= 0 && block.blockID < blockColorMaps.length) {
            colorMap = blockColorMaps[block.blockID];
        }
        return Colorizer.colorizeWithBlending(colorMap, 0xFFFFFF, i, j, k);
    }

    private static int colorizeWithBlending(ColorMap colorMap, int defaultColor, int i, int j, int k) {
        if (colorMap == null || !colorMap.isCustom() || !BiomeHelper.instance.useBlockBlending() || blockBlendRadius <= 0) {
            return defaultColor;
        }
        float[] sum = new float[3];
        float[] sample = new float[3];
        for (int di = -blockBlendRadius; di <= blockBlendRadius; ++di) {
            for (int dk = -blockBlendRadius; dk <= blockBlendRadius; ++dk) {
                int rgb = colorMap.colorize(defaultColor, i + di, j, k + dk);
                Colorizer.intToFloat3(rgb, sample);
                sum[0] = sum[0] + sample[0];
                sum[1] = sum[1] + sample[1];
                sum[2] = sum[2] + sample[2];
            }
        }
        sum[0] = sum[0] * blockBlendScale;
        sum[1] = sum[1] * blockBlendScale;
        sum[2] = sum[2] * blockBlendScale;
        return Colorizer.float3ToInt(sum);
    }

    public static int colorizeBlock(Block block) {
        ColorMap colorMap = blockColorMaps[block.blockID];
        if (colorMap == null) {
            return 0xFFFFFF;
        }
        return colorMap.colorize(0xFFFFFF);
    }

    public static int colorizeStem(int defaultColor, int blockMetadata) {
        if (stemColors == null) {
            return defaultColor;
        }
        return stemColors[blockMetadata & 7];
    }

    public static int colorizeSpawnerEgg(int defaultColor, int entityID, int spots) {
        String name;
        HashMap<Integer, Integer> eggMap;
        if (!useEggColors) {
            return defaultColor;
        }
        Integer value = null;
        HashMap<Integer, Integer> hashMap = eggMap = spots == 0 ? spawnerEggShellColors : spawnerEggSpotColors;
        if (eggMap.containsKey(entityID)) {
            value = eggMap.get(entityID);
        } else if (entityNamesByID.containsKey(entityID) && (name = entityNamesByID.get(entityID)) != null) {
            int[] tmp = new int[]{defaultColor};
            Colorizer.loadIntColor((spots == 0 ? "egg.shell." : "egg.spots.") + name, tmp, 0);
            eggMap.put(entityID, tmp[0]);
            value = tmp[0];
        }
        return value == null ? defaultColor : value;
    }

    public static int colorizeText(int defaultColor) {
        int high = defaultColor & 0xFF000000;
        Integer newColor = textColorMap.get(defaultColor &= 0xFFFFFF);
        if (newColor == null) {
            return high | defaultColor;
        }
        return high | newColor;
    }

    public static int colorizeText(int defaultColor, int index) {
        if (index < 0 || index >= textCodeColors.length || !textCodeColorSet[index]) {
            return defaultColor;
        }
        return defaultColor & 0xFF000000 | textCodeColors[index];
    }

    public static int colorizeSignText() {
        return signTextColor;
    }

    public static int colorizeXPOrb(int origColor, float timer) {
        if (xpOrbColors == null || xpOrbColors.length == 0) {
            return origColor;
        }
        return xpOrbColors[(int)((Math.sin((double)timer / 4.0) + 1.0) * (double)(xpOrbColors.length - 1) / 2.0)];
    }

    public static int getWaterBottleColor() {
        return waterBottleColor;
    }

    public static int getLilyPadColor() {
        return lilypadColor;
    }

    public static int getItemColorFromDamage(int defaultColor, int blockID, int damage) {
        if (blockID == 8 || blockID == 9) {
            return Colorizer.colorizeBiome(defaultColor, 5);
        }
        return defaultColor;
    }

    public static boolean computeRedstoneWireColor(int current) {
        if (redstoneColor == null) {
            return false;
        }
        System.arraycopy(redstoneColor[Math.max(Math.min(current, 15), 0)], 0, setColor, 0, 3);
        return true;
    }

    public static int colorizeRedstoneWire(IBlockAccess blockAccess, int i, int j, int k, int defaultColor) {
        if (redstoneColor == null) {
            return defaultColor;
        }
        int metadata = Math.max(Math.min(blockAccess.getBlockMetadata(i, j, k), 15), 0);
        return Colorizer.float3ToInt(redstoneColor[metadata]);
    }

    public static boolean computeWaterColor(double x, double y, double z) {
        if (useParticleColors && fixedColorMaps[5].isCustom()) {
            int rgb = Colorizer.colorizeBiome(0xFFFFFF, 5, (int)x, (int)y, (int)z);
            float[] multiplier = new float[3];
            Colorizer.intToFloat3(rgb, multiplier);
            for (int i = 0; i < 3; ++i) {
                Colorizer.waterColor[i] = multiplier[i] * waterBaseColor[i];
            }
            return true;
        }
        return false;
    }

    public static void computeWaterColor() {
        int rgb = Colorizer.colorizeBiome(0xFFFFFF, 5);
        Colorizer.intToFloat3(rgb, waterColor);
    }

    public static void colorizeWaterBlockGL(int blockID) {
        if (blockID == 8 || blockID == 9) {
            Colorizer.computeWaterColor();
            GL11.glColor4f((float)waterColor[0], (float)waterColor[1], (float)waterColor[2], (float)1.0f);
        }
    }

    public static boolean computeLavaDropColor(int age) {
        if (lavaDropColors == null) {
            return false;
        }
        int offset = 3 * Math.max(Math.min(lavaDropColors.length / 3 - 1, age - 20), 0);
        System.arraycopy(lavaDropColors, offset, setColor, 0, 3);
        return true;
    }

    public static void setupBlockAccess(IBlockAccess blockAccess, boolean newBiomes) {
        BiomeHelper.instance = blockAccess == null ? new BiomeHelper.Stub() : (newBiomes ? new BiomeHelper.New(blockAccess) : new BiomeHelper.Old(blockAccess));
    }

    public static void setupForFog(Entity entity) {
        fogCamera = entity;
        if (!biomesLogged) {
            biomesLogged = true;
            for (BiomeGenBase biome : biomes) {
                int x = ColorMap.getX(biome.temperature, biome.rainfall);
                int y = ColorMap.getY(biome.temperature, biome.rainfall);
                MCPatcherUtils.debug("setupBiome #%d \"%s\" %06x (%d,%d)", biome.biomeID, biome.biomeName, biome.waterColorMultiplier, x, y);
            }
        }
    }

    public static boolean computeFogColor(int index) {
        if (index < 0 || index >= fixedColorMaps.length || fogCamera == null || !fixedColorMaps[index].isCustom()) {
            return false;
        }
        float[] f = new float[3];
        int x = (int)Colorizer.fogCamera.posX;
        int y = (int)Colorizer.fogCamera.posY;
        int z = (int)Colorizer.fogCamera.posZ;
        Colorizer.setColor[0] = 0.0f;
        Colorizer.setColor[1] = 0.0f;
        Colorizer.setColor[2] = 0.0f;
        for (int i = -fogBlendRadius; i <= fogBlendRadius; ++i) {
            for (int j = -fogBlendRadius; j <= fogBlendRadius; ++j) {
                int rgb = Colorizer.colorizeBiome(0xFFFFFF, index, x + i, y, z + j);
                Colorizer.intToFloat3(rgb, f);
                setColor[0] = setColor[0] + f[0];
                setColor[1] = setColor[1] + f[1];
                setColor[2] = setColor[2] + f[2];
            }
        }
        setColor[0] = setColor[0] * fogBlendScale;
        setColor[1] = setColor[1] * fogBlendScale;
        setColor[2] = setColor[2] * fogBlendScale;
        return true;
    }

    public static boolean computeFogColor(World world, float f) {
        if (world.worldProvider.worldType == 0 && Colorizer.computeFogColor(7)) {
            Colorizer.computeLightningFlash(world, f);
            return true;
        }
        return false;
    }

    public static boolean computeSkyColor(World world, float f) {
        if (world.worldProvider.worldType == 0 && Colorizer.computeFogColor(8)) {
            Colorizer.computeLightningFlash(world, f);
            return true;
        }
        return false;
    }

    private static void computeLightningFlash(World world, float f) {
        if (world.lightningFlash > 0) {
            f = 0.45f * Colorizer.clamp((float)world.lightningFlash - f);
            Colorizer.setColor[0] = setColor[0] * (1.0f - f) + 0.8f * f;
            Colorizer.setColor[1] = setColor[1] * (1.0f - f) + 0.8f * f;
            Colorizer.setColor[2] = setColor[2] * (1.0f - f) + 0.8f * f;
        }
    }

    public static boolean computeMyceliumParticleColor() {
        if (myceliumColors == null) {
            return false;
        }
        Colorizer.setColorF(myceliumColors[random.nextInt(myceliumColors.length)]);
        return true;
    }

    public static void setColorF(int color) {
        Colorizer.intToFloat3(color, setColor);
    }

    public static void setupBiome(BiomeGenBase biome) {
        biomes.add(biome);
    }

    public static void setupPotion(Potion potion) {
        MCPatcherUtils.debug("setupPotion #%d \"%s\" %06x", potion.id, potion.name, potion.color);
        potion.origColor = potion.color;
        potions.add(potion);
    }

    public static void setupSpawnerEgg(String entityName, int entityID, int defaultShellColor, int defaultSpotColor) {
        MCPatcherUtils.debug("setupSpawnerEgg #%d \"%s\" %06x %06x", entityID, entityName, defaultShellColor, defaultSpotColor);
        entityNamesByID.put(entityID, entityName);
    }

    public static boolean drawFancyClouds(boolean fancyGraphics) {
        switch (cloudType) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return fancyGraphics;
    }

    private static void reset() {
        int i;
        properties = new Properties();
        Colorizer.fixedColorMaps[0] = new ColorMap(0x4E4E4E);
        Colorizer.fixedColorMaps[1] = new ColorMap(0x4E4E4E);
        Colorizer.fixedColorMaps[2] = new ColorMap(0x619961);
        Colorizer.fixedColorMaps[3] = new ColorMap(8431445);
        Colorizer.fixedColorMaps[4] = new ColorMap(4764952);
        Colorizer.fixedColorMaps[5] = new ColorMap(0xFFFFFF);
        Colorizer.fixedColorMaps[6] = new ColorMap(329011);
        Colorizer.fixedColorMaps[7] = new ColorMap(12638463);
        Colorizer.fixedColorMaps[8] = new ColorMap(0xFFFFFF);
        netherFogColor = new float[]{0.2f, 0.03f, 0.03f};
        endFogColor = new float[]{0.075f, 0.075f, 0.094f};
        endSkyColor = 0x181818;
        blockColorMaps = new ColorMap[Block.blocksList.length];
        blockMetaColorMaps.clear();
        lilypadColor = 2129968;
        waterBaseColor = new float[]{0.2f, 0.3f, 1.0f};
        waterColor = new float[]{0.2f, 0.3f, 1.0f};
        portalColor = new float[]{1.0f, 0.3f, 0.9f};
        lavaDropColors = null;
        waterBottleColor = 3694022;
        redstoneColor = null;
        stemColors = null;
        Lightmap.clear();
        spawnerEggShellColors.clear();
        spawnerEggSpotColors.clear();
        cloudType = 0;
        for (Potion potion : potions) {
            potion.color = potion.origColor;
        }
        for (MapColor mapColor : MapColor.mapColorArray) {
            if (mapColor == null) continue;
            mapColor.colorValue = mapColor.origColorValue;
        }
        System.arraycopy(origDyeColors, 0, ItemDye.dyeColors, 0, origDyeColors.length);
        for (i = 0; i < origFleeceColors.length; ++i) {
            EntitySheep.fleeceColorTable[i] = (float[])origFleeceColors[i].clone();
            Colorizer.armorColors[i] = (float[])origFleeceColors[i].clone();
            Colorizer.collarColors[i] = (float[])origFleeceColors[i].clone();
        }
        undyedLeatherColor = 10511680;
        myceliumColors = null;
        xpOrbColors = null;
        textColorMap.clear();
        for (i = 0; i < textCodeColorSet.length; ++i) {
            Colorizer.textCodeColorSet[i] = false;
        }
        signTextColor = 0;
    }

    private static void reloadColorProperties() {
        if (TexturePackAPI.getProperties(COLOR_PROPERTIES, properties)) {
            MCPatcherUtils.debug("reloading %s", COLOR_PROPERTIES);
        }
    }

    private static void reloadColorMaps() {
        fixedColorMaps[0].loadColorMap(useSwampColors, "/misc/swampgrasscolor.png");
        fixedColorMaps[1].loadColorMap(useSwampColors, "/misc/swampfoliagecolor.png");
        fixedColorMaps[2].loadColorMap(useTreeColors, "/misc/pinecolor.png");
        fixedColorMaps[3].loadColorMap(useTreeColors, "/misc/birchcolor.png");
        fixedColorMaps[4].loadColorMap(useTreeColors, "/misc/foliagecolor.png");
        fixedColorMaps[4].clear();
        fixedColorMaps[5].loadColorMap(useWaterColors, "/misc/watercolorX.png");
        fixedColorMaps[6].loadColorMap(useWaterColors, "/misc/underwatercolor.png");
        fixedColorMaps[7].loadColorMap(useFogColors, "/misc/fogcolor0.png");
        fixedColorMaps[8].loadColorMap(useFogColors, "/misc/skycolor0.png");
    }

    private static void reloadFogColors() {
        Colorizer.loadFloatColor("fog.nether", netherFogColor);
        Colorizer.loadFloatColor("fog.end", endFogColor);
        endSkyColor = Colorizer.loadIntColor("sky.end", endSkyColor);
    }

    private static void reloadPotionColors() {
        for (Potion potion : potions) {
            Colorizer.loadIntColor(potion.name, potion);
        }
        int[] temp = new int[]{waterBottleColor};
        Colorizer.loadIntColor("potion.water", temp, 0);
        waterBottleColor = temp[0];
    }

    private static void reloadSwampColors() {
        int[] temp = new int[]{lilypadColor};
        Colorizer.loadIntColor("lilypad", temp, 0);
        lilypadColor = temp[0];
    }

    private static void reloadBlockColors() {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(PALETTE_BLOCK_KEY)) continue;
            key = key.substring(PALETTE_BLOCK_KEY.length()).trim();
            ColorMap colorMap = new ColorMap(0xFFFFFF);
            colorMap.loadColorMap(true, key);
            if (!colorMap.isCustom()) continue;
            block7: for (String idString : value.split("\\s+")) {
                String[] tokens = idString.split(":");
                int[] tokensInt = new int[tokens.length];
                try {
                    for (int i = 0; i < tokens.length; ++i) {
                        tokensInt[i] = Integer.parseInt(tokens[i]);
                    }
                }
                catch (NumberFormatException e) {
                    continue;
                }
                switch (tokensInt.length) {
                    case 1: {
                        if (tokensInt[0] < 0 || tokensInt[0] >= blockColorMaps.length) continue block7;
                        Colorizer.blockColorMaps[tokensInt[0]] = colorMap;
                        break;
                    }
                    case 2: {
                        blockMetaColorMaps.put(Float.valueOf(ColorMap.getBlockMetaKey(tokensInt[0], tokensInt[1])), colorMap);
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                MCPatcherUtils.debug("using %s for block %s, default color %06x", key, idString, colorMap.colorize());
            }
        }
    }

    private static void reloadParticleColors() {
        Colorizer.loadFloatColor("drop.water", waterBaseColor);
        Colorizer.loadFloatColor("particle.water", waterBaseColor);
        Colorizer.loadFloatColor("particle.portal", portalColor);
        int[] rgb = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(LAVA_DROP_COLORS));
        if (rgb != null) {
            lavaDropColors = new float[3 * rgb.length];
            for (int i = 0; i < rgb.length; ++i) {
                Colorizer.intToFloat3(rgb[i], lavaDropColors, 3 * i);
            }
        }
        myceliumColors = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(MYCELIUM_COLORS));
    }

    private static void reloadRedstoneColors() {
        int[] rgb = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(REDSTONE_COLORS));
        if (rgb != null && rgb.length >= 16) {
            redstoneColor = new float[16][];
            for (int i = 0; i < 16; ++i) {
                float[] f = new float[3];
                Colorizer.intToFloat3(rgb[i], f);
                Colorizer.redstoneColor[i] = f;
            }
        }
    }

    private static void reloadStemColors() {
        int[] rgb = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(STEM_COLORS));
        if (rgb != null && rgb.length >= 8) {
            stemColors = rgb;
        }
    }

    private static void reloadCloudType() {
        String value = properties.getProperty("clouds", "").trim().toLowerCase();
        if (value.equals("fast")) {
            cloudType = 1;
        } else if (value.equals("fancy")) {
            cloudType = 2;
        }
    }

    private static void reloadMapColors() {
        for (int i = 0; i < MapColor.mapColorArray.length; ++i) {
            if (MapColor.mapColorArray[i] == null) continue;
            int[] rgb = new int[]{MapColor.mapColorArray[i].origColorValue};
            Colorizer.loadIntColor("map." + Colorizer.getStringKey(MAP_MATERIALS, i), rgb, 0);
            MapColor.mapColorArray[i].colorValue = rgb[0];
        }
    }

    private static void reloadDyeColors() {
        int i;
        for (i = 0; i < ItemDye.dyeColors.length; ++i) {
            Colorizer.loadIntColor("dye." + Colorizer.getStringKey(ItemDye.dyeColorNames, i), ItemDye.dyeColors, i);
        }
        for (i = 0; i < EntitySheep.fleeceColorTable.length; ++i) {
            String key = Colorizer.getStringKey(ItemDye.dyeColorNames, EntitySheep.fleeceColorTable.length - 1 - i);
            Colorizer.loadFloatColor("sheep." + key, EntitySheep.fleeceColorTable[i]);
            Colorizer.loadFloatColor("armor." + key, armorColors[i]);
            Colorizer.loadFloatColor("collar." + key, collarColors[i]);
        }
        undyedLeatherColor = Colorizer.loadIntColor("armor.default", undyedLeatherColor);
    }

    private static void reloadTextColors() {
        for (int i = 0; i < textCodeColors.length; ++i) {
            Colorizer.textCodeColorSet[i] = Colorizer.loadIntColor(TEXT_CODE_KEY + i, textCodeColors, i);
            if (!textCodeColorSet[i] || i + 16 >= textCodeColors.length) continue;
            Colorizer.textCodeColors[i + 16] = (textCodeColors[i] & 0xFCFCFC) >> 2;
            Colorizer.textCodeColorSet[i + 16] = true;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(TEXT_KEY) || key.startsWith(TEXT_CODE_KEY)) continue;
            key = key.substring(TEXT_KEY.length()).trim();
            try {
                int oldColor = key.equals("xpbar") ? 8453920 : (key.equals("boss") ? 0xFF00FF : Integer.parseInt(key, 16));
                int newColor = Integer.parseInt(value, 16);
                textColorMap.put(oldColor, newColor);
            }
            catch (NumberFormatException e) {}
        }
        signTextColor = Colorizer.loadIntColor("text.sign", 0);
    }

    private static void reloadXPOrbColors() {
        xpOrbColors = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(XPORB_COLORS));
    }

    private static String getStringKey(String[] keys, int index) {
        if (keys != null && index >= 0 && index < keys.length && keys[index] != null) {
            return keys[index];
        }
        return "" + index;
    }

    private static void loadIntColor(String key, Potion potion) {
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                potion.color = Integer.parseInt(value, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static boolean loadIntColor(String key, int[] color, int index) {
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                color[index] = Integer.parseInt(value, 16);
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return false;
    }

    private static int loadIntColor(String key, int color) {
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                color = Integer.parseInt(value, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    private static void loadFloatColor(String key, float[] color) {
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                Colorizer.intToFloat3(Integer.parseInt(value, 16), color);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static float[] loadFloatColor(String key) {
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                float[] color = new float[3];
                Colorizer.intToFloat3(Integer.parseInt(value, 16), color);
                return color;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static void intToFloat3(int rgb, float[] f, int offset) {
        f[offset] = (float)(rgb & 0xFF0000) / 1.671168E7f;
        f[offset + 1] = (float)(rgb & 0xFF00) / 65280.0f;
        f[offset + 2] = (float)(rgb & 0xFF) / 255.0f;
    }

    static void intToFloat3(int rgb, float[] f) {
        Colorizer.intToFloat3(rgb, f, 0);
    }

    static int float3ToInt(float[] f, int offset) {
        return (int)(255.0f * f[offset]) << 16 | (int)(255.0f * f[offset + 1]) << 8 | (int)(255.0f * f[offset + 2]);
    }

    static int float3ToInt(float[] f) {
        return Colorizer.float3ToInt(f, 0);
    }

    static float clamp(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    static double clamp(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d > 1.0) {
            return 1.0;
        }
        return d;
    }

    static void clamp(float[] f) {
        for (int i = 0; i < f.length; ++i) {
            f[i] = Colorizer.clamp(f[i]);
        }
    }

    private static void interpolate(int[] map, int offset1, float x, float[] rgb, int offset2) {
        int x1;
        int x0 = (int)Math.floor(x);
        if (x0 == (x1 = (int)Math.ceil(x))) {
            Colorizer.intToFloat3(map[offset1 + x0], rgb, offset2);
        } else {
            float xf = x - (float)x0;
            float xg = 1.0f - xf;
            float[] rgb0 = new float[3];
            float[] rgb1 = new float[3];
            Colorizer.intToFloat3(map[offset1 + x0], rgb0);
            Colorizer.intToFloat3(map[offset1 + x1], rgb1);
            for (int i = 0; i < 3; ++i) {
                rgb[offset2 + i] = xg * rgb0[i] + xf * rgb1[i];
            }
        }
    }

    private static float getBlendScale(int radius) {
        return 1.0f / (float)((2 * radius + 1) * (2 * radius + 1));
    }

    static {
        fixedColorMaps = new ColorMap[9];
        blockMetaColorMaps = new HashMap();
        potions = new ArrayList();
        random = new Random();
        useWaterColors = MCPatcherUtils.getBoolean("Custom Colors", "water", true);
        useSwampColors = MCPatcherUtils.getBoolean("Custom Colors", "swamp", true);
        useTreeColors = MCPatcherUtils.getBoolean("Custom Colors", "tree", true);
        usePotionColors = MCPatcherUtils.getBoolean("Custom Colors", "potion", true);
        useParticleColors = MCPatcherUtils.getBoolean("Custom Colors", "particle", true);
        useFogColors = MCPatcherUtils.getBoolean("Custom Colors", "fog", true);
        useCloudType = MCPatcherUtils.getBoolean("Custom Colors", "clouds", true);
        useRedstoneColors = MCPatcherUtils.getBoolean("Custom Colors", "redstone", true);
        useStemColors = MCPatcherUtils.getBoolean("Custom Colors", "stem", true);
        useEggColors = MCPatcherUtils.getBoolean("Custom Colors", "egg", true);
        useMapColors = MCPatcherUtils.getBoolean("Custom Colors", "map", true);
        useDyeColors = MCPatcherUtils.getBoolean("Custom Colors", "dye", true);
        useBlockColors = MCPatcherUtils.getBoolean("Custom Colors", "otherBlocks", true);
        useTextColors = MCPatcherUtils.getBoolean("Custom Colors", "text", true);
        useXPOrbColors = MCPatcherUtils.getBoolean("Custom Colors", "xporb", true);
        fogBlendRadius = MCPatcherUtils.getInt("Custom Colors", "fogBlendRadius", 7);
        fogBlendScale = Colorizer.getBlendScale(fogBlendRadius);
        blockBlendRadius = MCPatcherUtils.getInt("Custom Colors", "blockBlendRadius", 1);
        blockBlendScale = Colorizer.getBlendScale(blockBlendRadius);
        setColor = new float[3];
        portalColor = new float[]{1.0f, 0.3f, 0.9f};
        entityNamesByID = new HashMap();
        spawnerEggShellColors = new HashMap();
        spawnerEggSpotColors = new HashMap();
        cloudType = 0;
        biomes = new ArrayList();
        textColorMap = new HashMap();
        textCodeColors = new int[32];
        textCodeColorSet = new boolean[32];
        origDyeColors = (int[])ItemDye.dyeColors.clone();
        origFleeceColors = new float[EntitySheep.fleeceColorTable.length][];
        armorColors = new float[EntitySheep.fleeceColorTable.length][];
        collarColors = new float[EntitySheep.fleeceColorTable.length][];
        try {
            for (int i = 0; i < EntitySheep.fleeceColorTable.length; ++i) {
                Colorizer.origFleeceColors[i] = (float[])EntitySheep.fleeceColorTable[i].clone();
                Colorizer.armorColors[i] = (float[])EntitySheep.fleeceColorTable[i].clone();
                Colorizer.collarColors[i] = (float[])EntitySheep.fleeceColorTable[i].clone();
            }
            Colorizer.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        TexturePackAPI.ChangeHandler.register(new TexturePackAPI.ChangeHandler("Custom Colors", 2){

            protected void onChange() {
                Colorizer.reset();
                Colorizer.reloadColorProperties();
                Colorizer.reloadColorMaps();
                if (useFogColors) {
                    Colorizer.reloadFogColors();
                }
                if (usePotionColors) {
                    Colorizer.reloadPotionColors();
                }
                if (useSwampColors) {
                    Colorizer.reloadSwampColors();
                }
                if (useBlockColors) {
                    Colorizer.reloadBlockColors();
                }
                if (useParticleColors) {
                    Colorizer.reloadParticleColors();
                }
                if (useRedstoneColors) {
                    Colorizer.reloadRedstoneColors();
                }
                if (useStemColors) {
                    Colorizer.reloadStemColors();
                }
                if (useCloudType) {
                    Colorizer.reloadCloudType();
                }
                if (useMapColors) {
                    Colorizer.reloadMapColors();
                }
                if (useDyeColors) {
                    Colorizer.reloadDyeColors();
                }
                if (useTextColors) {
                    Colorizer.reloadTextColors();
                }
                if (useXPOrbColors) {
                    Colorizer.reloadXPOrbColors();
                }
            }
        });
    }
}

