/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import com.pclewis.mcpatcher.mod.TextureUtils;
import com.pclewis.mcpatcher.mod.TileSize;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class CustomAnimation {
    private static final String CLASS_NAME = CustomAnimation.class.getSimpleName();
    private static Random rand = new Random();
    private static final ArrayList<CustomAnimation> animations = new ArrayList();
    private final String textureName;
    private final String srcName;
    private final ByteBuffer imageData;
    private final int tileCount;
    private final int x;
    private final int y;
    private final int w;
    private final int h;
    private int currentFrame;
    private int currentDelay;
    private int numFrames;
    private Delegate delegate;

    public static void updateAll() {
        for (CustomAnimation animation : animations) {
            animation.update();
        }
    }

    static void clear() {
        animations.clear();
    }

    static void addStrip(Properties properties) {
        if (properties == null) {
            return;
        }
        try {
            String textureName = properties.getProperty("to", "");
            String srcName = properties.getProperty("from", "");
            int tileCount = Integer.parseInt(properties.getProperty("tiles", "1"));
            int x = Integer.parseInt(properties.getProperty("x", ""));
            int y = Integer.parseInt(properties.getProperty("y", ""));
            int w = Integer.parseInt(properties.getProperty("w", ""));
            int h = Integer.parseInt(properties.getProperty("h", ""));
            if (!"".equals(textureName) && !"".equals(srcName)) {
                CustomAnimation.add(CustomAnimation.newStrip(textureName, tileCount, srcName, TexturePackAPI.getImage(srcName), x, y, w, h, properties));
            }
        }
        catch (IOException e) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static void addStripOrTile(String textureName, String name, int tileNumber, int tileCount, int minScrollDelay, int maxScrollDelay) {
        if (!CustomAnimation.addStrip(textureName, name, tileNumber, tileCount)) {
            CustomAnimation.add(CustomAnimation.newTile(textureName, tileCount, tileNumber, minScrollDelay, maxScrollDelay));
        }
    }

    static boolean addStrip(String textureName, String name, int tileNumber, int tileCount) {
        String srcName = "/anim/custom_" + name + ".png";
        if (TexturePackAPI.hasResource(srcName)) {
            try {
                BufferedImage srcImage = TexturePackAPI.getImage(srcName);
                if (srcImage != null) {
                    CustomAnimation.add(CustomAnimation.newStrip(textureName, tileCount, srcName, srcImage, tileNumber % 16 * TileSize.int_size, tileNumber / 16 * TileSize.int_size, TileSize.int_size, TileSize.int_size, null));
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void add(CustomAnimation animation) {
        if (animation != null) {
            animations.add(animation);
            MCPatcherUtils.debug("new %s %s %dx%d -> %s @ %d,%d (%d frames)", CLASS_NAME, animation.srcName, animation.w, animation.h, animation.textureName, animation.x, animation.y, animation.numFrames);
        }
    }

    private static CustomAnimation newStrip(String textureName, int tileCount, String srcName, BufferedImage srcImage, int x, int y, int w, int h, Properties properties) throws IOException {
        if (srcImage == null) {
            MCPatcherUtils.error("%s: image %s not found in texture pack", CLASS_NAME, srcName);
            return null;
        }
        if (x < 0 || y < 0 || w <= 0 || h <= 0 || tileCount <= 0) {
            MCPatcherUtils.error("%s: %s invalid dimensions x=%d,y=%d,w=%d,h=%d,count=%d", CLASS_NAME, srcName, x, y, w, h, tileCount);
            return null;
        }
        int textureID = MCPatcherUtils.getMinecraft().renderEngine.getTexture(textureName);
        if (textureID <= 0) {
            MCPatcherUtils.error("%s: invalid id %d for texture %s", CLASS_NAME, textureID, textureName);
            return null;
        }
        GL11.glBindTexture((int)3553, (int)textureID);
        int destWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int destHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        if (x + tileCount * w > destWidth || y + tileCount * h > destHeight) {
            MCPatcherUtils.error("%s: %s invalid dimensions x=%d,y=%d,w=%d,h=%d,count=%d", CLASS_NAME, srcName, x, y, w, h, tileCount);
            return null;
        }
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        if (width != w) {
            srcImage = TextureUtils.resizeImage(srcImage, w);
            width = srcImage.getWidth();
            height = srcImage.getHeight();
        }
        if (width != w || height < h) {
            MCPatcherUtils.error("%s: %s dimensions %dx%d do not match %dx%d", CLASS_NAME, srcName, width, height, w, h);
            return null;
        }
        ByteBuffer imageData = ByteBuffer.allocateDirect(4 * width * height);
        int[] argb = new int[width * height];
        byte[] rgba = new byte[4 * width * height];
        srcImage.getRGB(0, 0, width, height, argb, 0, width);
        CustomAnimation.ARGBtoRGBA(argb, rgba);
        imageData.put(rgba);
        return new CustomAnimation(srcName, textureName, tileCount, x, y, w, h, imageData, height / h, properties);
    }

    private static CustomAnimation newTile(String textureName, int tileCount, int tileNumber, int minScrollDelay, int maxScrollDelay) {
        int x = tileNumber % 16 * TileSize.int_size;
        int y = tileNumber / 16 * TileSize.int_size;
        int w = TileSize.int_size;
        int h = TileSize.int_size;
        if (x < 0 || y < 0 || w <= 0 || h <= 0 || x + tileCount * w > 16 * TileSize.int_size || y + tileCount * h > 16 * TileSize.int_size) {
            MCPatcherUtils.error("%s: %s invalid dimensions x=%d,y=%d,w=%d,h=%d", CLASS_NAME, textureName, x, y, w, h);
            return null;
        }
        try {
            return new CustomAnimation(textureName, tileCount, x, y, w, h, minScrollDelay, maxScrollDelay);
        }
        catch (IOException e) {
            return null;
        }
    }

    private CustomAnimation(String srcName, String textureName, int tileCount, int x, int y, int w, int h, ByteBuffer imageData, int numFrames, Properties properties) {
        this.srcName = srcName;
        this.textureName = textureName;
        this.tileCount = tileCount;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.imageData = imageData;
        this.numFrames = numFrames;
        this.currentFrame = -1;
        this.delegate = new Strip(properties);
    }

    private CustomAnimation(String textureName, int tileCount, int x, int y, int w, int h, int minScrollDelay, int maxScrollDelay) throws IOException {
        this.srcName = textureName;
        this.textureName = textureName;
        this.tileCount = tileCount;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.imageData = ByteBuffer.allocateDirect(4 * w * h);
        this.numFrames = h;
        this.currentFrame = -1;
        this.delegate = new Tile(minScrollDelay, maxScrollDelay);
    }

    void update() {
        int texture = TexturePackAPI.getTextureIfLoaded(this.textureName);
        if (texture < 0) {
            return;
        }
        if (--this.currentDelay > 0) {
            return;
        }
        if (++this.currentFrame >= this.numFrames) {
            this.currentFrame = 0;
        }
        for (int i = 0; i < this.tileCount; ++i) {
            for (int j = 0; j < this.tileCount; ++j) {
                this.delegate.update(texture, i * this.w, j * this.h);
            }
        }
        this.currentDelay = this.delegate.getDelay();
    }

    static void ARGBtoRGBA(int[] src, byte[] dest) {
        for (int i = 0; i < src.length; ++i) {
            int v = src[i];
            dest[i * 4 + 3] = (byte)(v >> 24 & 0xFF);
            dest[i * 4 + 0] = (byte)(v >> 16 & 0xFF);
            dest[i * 4 + 1] = (byte)(v >> 8 & 0xFF);
            dest[i * 4 + 2] = (byte)(v >> 0 & 0xFF);
        }
    }

    private class Strip
    implements Delegate {
        private int[] tileOrder;
        private int[] tileDelay;
        private final int numTiles;

        Strip(Properties properties) {
            this.numTiles = CustomAnimation.this.numFrames;
            if (properties == null) {
                properties = TexturePackAPI.getProperties(CustomAnimation.this.srcName.replace(".png", ".properties"));
            }
            this.loadProperties(properties);
        }

        private void loadProperties(Properties properties) {
            int i;
            this.loadTileOrder(properties);
            if (this.tileOrder == null) {
                this.tileOrder = new int[CustomAnimation.this.numFrames];
                for (i = 0; i < CustomAnimation.this.numFrames; ++i) {
                    this.tileOrder[i] = i % this.numTiles;
                }
            }
            this.tileDelay = new int[CustomAnimation.this.numFrames];
            this.loadTileDelay(properties);
            for (i = 0; i < CustomAnimation.this.numFrames; ++i) {
                this.tileDelay[i] = Math.max(this.tileDelay[i], 1);
            }
        }

        private void loadTileOrder(Properties properties) {
            if (properties == null) {
                return;
            }
            int i = 0;
            while (this.getIntValue(properties, "tile.", i) != null) {
                ++i;
            }
            if (i > 0) {
                CustomAnimation.this.numFrames = i;
                this.tileOrder = new int[CustomAnimation.this.numFrames];
                for (i = 0; i < CustomAnimation.this.numFrames; ++i) {
                    this.tileOrder[i] = Math.abs(this.getIntValue(properties, "tile.", i)) % this.numTiles;
                }
            }
        }

        private void loadTileDelay(Properties properties) {
            if (properties == null) {
                return;
            }
            Integer defaultValue = this.getIntValue(properties, "duration");
            for (int i = 0; i < CustomAnimation.this.numFrames; ++i) {
                Integer value = this.getIntValue(properties, "duration.", i);
                if (value != null) {
                    this.tileDelay[i] = value;
                    continue;
                }
                if (defaultValue == null) continue;
                this.tileDelay[i] = defaultValue;
            }
        }

        private Integer getIntValue(Properties properties, String key) {
            try {
                String value = properties.getProperty(key);
                if (value != null && value.matches("^\\d+$")) {
                    return Integer.parseInt(value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }

        private Integer getIntValue(Properties properties, String prefix, int index) {
            return this.getIntValue(properties, prefix + index);
        }

        public void update(int texture, int dx, int dy) {
            GL11.glBindTexture((int)3553, (int)texture);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)(CustomAnimation.this.x + dx), (int)(CustomAnimation.this.y + dy), (int)CustomAnimation.this.w, (int)CustomAnimation.this.h, (int)6408, (int)5121, (ByteBuffer)((ByteBuffer)CustomAnimation.this.imageData.position(4 * CustomAnimation.this.w * CustomAnimation.this.h * this.tileOrder[CustomAnimation.this.currentFrame])));
        }

        public int getDelay() {
            return this.tileDelay[CustomAnimation.this.currentFrame];
        }
    }

    private class Tile
    implements Delegate {
        private final int minScrollDelay;
        private final int maxScrollDelay;
        private final boolean isScrolling;

        Tile(int minScrollDelay, int maxScrollDelay) throws IOException {
            this.minScrollDelay = minScrollDelay;
            this.maxScrollDelay = maxScrollDelay;
            this.isScrolling = this.minScrollDelay >= 0;
            BufferedImage tiles = TexturePackAPI.getImage(CustomAnimation.this.textureName);
            int[] rgbInt = new int[CustomAnimation.this.w * CustomAnimation.this.h];
            byte[] rgbByte = new byte[4 * CustomAnimation.this.w * CustomAnimation.this.h];
            tiles.getRGB(CustomAnimation.this.x, CustomAnimation.this.y, CustomAnimation.this.w, CustomAnimation.this.h, rgbInt, 0, CustomAnimation.this.w);
            CustomAnimation.ARGBtoRGBA(rgbInt, rgbByte);
            CustomAnimation.this.imageData.put(rgbByte);
        }

        public void update(int texture, int dx, int dy) {
            if (this.isScrolling) {
                GL11.glBindTexture((int)3553, (int)texture);
                int rowOffset = CustomAnimation.this.h - CustomAnimation.this.currentFrame;
                GL11.glTexSubImage2D((int)3553, (int)0, (int)(CustomAnimation.this.x + dx), (int)(CustomAnimation.this.y + dy + CustomAnimation.this.h - rowOffset), (int)CustomAnimation.this.w, (int)rowOffset, (int)6408, (int)5121, (ByteBuffer)((ByteBuffer)CustomAnimation.this.imageData.position(0)));
                GL11.glTexSubImage2D((int)3553, (int)0, (int)(CustomAnimation.this.x + dx), (int)(CustomAnimation.this.y + dy), (int)CustomAnimation.this.w, (int)(CustomAnimation.this.h - rowOffset), (int)6408, (int)5121, (ByteBuffer)((ByteBuffer)CustomAnimation.this.imageData.position(4 * CustomAnimation.this.w * rowOffset)));
            }
        }

        public int getDelay() {
            if (this.maxScrollDelay > 0) {
                return rand.nextInt(this.maxScrollDelay - this.minScrollDelay + 1) + this.minScrollDelay;
            }
            return 0;
        }
    }

    private static interface Delegate {
        public void update(int var1, int var2, int var3);

        public int getDelay();
    }
}

