/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.AddFieldPatch;
import com.pclewis.mcpatcher.AddMethodPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.MakeMemberPublicPatch;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import java.io.IOException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.MethodInfo;

public class HDFont
extends Mod {
    private final boolean haveAlternateFont;
    private final boolean haveFontHeight;
    private final boolean haveUnicode;
    private final boolean haveGetCharWidth;

    public HDFont(MinecraftVersion minecraftVersion) {
        this.name = "HD Font";
        this.author = "MCPatcher";
        this.description = "Provides support for higher resolution fonts.";
        this.version = "1.4";
        this.addDependency("__TexturePackBase");
        this.haveAlternateFont = minecraftVersion.compareTo("Beta 1.9 Prerelease 3") >= 0;
        this.haveFontHeight = minecraftVersion.compareTo("Beta 1.9 Prerelease 6") >= 0;
        this.haveUnicode = minecraftVersion.compareTo("11w49a") >= 0 || minecraftVersion.compareTo("1.0.1") >= 0;
        this.haveGetCharWidth = minecraftVersion.compareTo("1.2.4") >= 0;
        this.classMods.add(new MinecraftMod());
        this.classMods.add(new FontRendererMod());
        this.classMods.add(new BaseMod.RenderEngineMod());
        this.classMods.add(new BaseMod.GameSettingsMod());
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.FontUtils"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.FontUtils$1"));
    }

    private class FontRendererMod
    extends BaseMod.FontRendererMod {
        private final FieldRef charWidth = new FieldRef(this.getDeobfClass(), "charWidth", "[I");
        private final FieldRef charWidthf = new FieldRef(this.getDeobfClass(), "charWidthf", "[F");
        private final FieldRef fontHeight = new FieldRef(this.getDeobfClass(), "FONT_HEIGHT", "I");
        private final FieldRef isUnicode = new FieldRef(this.getDeobfClass(), "isUnicode", "Z");
        private final MethodRef getStringWidth = new MethodRef(this.getDeobfClass(), "getStringWidth", "(Ljava/lang/String;)I");
        private final MethodRef constructor = new MethodRef(this.getDeobfClass(), "<init>", "(LGameSettings;Ljava/lang/String;LRenderEngine;" + (HDFont.access$100(HDFont.this) ? "Z" : "") + ")V");

        FontRendererMod() {
            if (HDFont.this.haveFontHeight) {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(42, BinaryRegex.or(BinaryRegex.build(this.push(8)), BinaryRegex.build(this.push(9))), BytecodeMatcher.captureReference(181));
                    }
                }.matchConstructorOnly(true).setMethod(this.constructor).addXref(1, this.fontHeight));
            } else {
                this.patches.add(new AddFieldPatch(this.fontHeight));
            }
            if (HDFont.this.haveUnicode) {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(42, 21, 4, BytecodeMatcher.captureReference(181));
                    }
                }.matchConstructorOnly(true).addXref(1, this.isUnicode));
                this.patches.add(new MakeMemberPublicPatch(this.isUnicode));
            } else {
                this.patches.add(new AddFieldPatch(this.isUnicode));
            }
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, this.getStringWidth));
            this.patches.add(new AddFieldPatch(this.charWidthf));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "FontUtils.computeCharWidths on init";
                }

                public String getMatchExpression() {
                    return this.buildExpression(3, 54, BinaryRegex.capture(BinaryRegex.any()), 21, BinaryRegex.backReference(1), this.push(256), 162, BinaryRegex.any(2), BinaryRegex.any(1, 180), 132, BinaryRegex.backReference(1), 1, 167, BinaryRegex.any(2));
                }

                public byte[] getReplacementBytes() throws IOException {
                    int registerOffset = this.getCaptureGroup(1)[0] - 8;
                    return this.buildCode(42, 42, 44, 25, 4 + registerOffset, 25, 7 + registerOffset, 42, this.reference(180, FontRendererMod.this.charWidth), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.FontUtils", "computeCharWidths", "(LFontRenderer;Ljava/lang/String;Ljava/awt/image/BufferedImage;[I[I)[F")), this.reference(181, FontRendererMod.this.charWidthf));
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "use charWidthf intead of charWidth";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, FontRendererMod.this.charWidth), BinaryRegex.capture(BinaryRegex.any(1, 4)), 46, 134, 174);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, FontRendererMod.this.charWidthf), this.getCaptureGroup(1), 48, 42, this.reference(180, FontRendererMod.this.fontHeight), 134, 106, this.push(Float.valueOf(8.0f)), 110, 174);
                }
            });
            this.patches.add(new AddMethodPatch(new MethodRef(this.getDeobfClass(), "initialize", "()V")){
                MethodInfo constructor;

                public void prePatch(ClassFile classFile) {
                    this.constructor = null;
                }

                public byte[] generateMethod() {
                    this.getDescriptor();
                    CodeAttribute ca = this.constructor.getCodeAttribute();
                    this.getMethodInfo().setDescriptor(this.constructor.getDescriptor().replace("Z)", ")"));
                    this.maxStackSize = ca.getMaxStack();
                    this.numLocals = ca.getMaxLocals();
                    this.exceptionTable = ca.getExceptionTable();
                    byte[] code = (byte[])ca.getCode().clone();
                    if (HDFont.this.haveUnicode) {
                        code[0] = 3;
                        code[1] = 54;
                        code[2] = 4;
                    } else {
                        code[0] = 0;
                        code[1] = 0;
                        code[2] = 0;
                    }
                    code[3] = 0;
                    return code;
                }

                public String getDescriptor() {
                    if (this.constructor == null) {
                        for (Object o : this.getClassFile().getMethods()) {
                            MethodInfo method = (MethodInfo)o;
                            if (!method.isConstructor() || (!HDFont.this.haveUnicode || !method.getDescriptor().contains("Z)")) && (HDFont.this.haveUnicode || method.getDescriptor().equals("()V"))) continue;
                            this.constructor = method;
                            break;
                        }
                        if (this.constructor == null) {
                            throw new RuntimeException("could not find FontRenderer constructor");
                        }
                    }
                    return this.constructor.getDescriptor().replace("Z)", ")");
                }
            });
            if (HDFont.this.haveGetCharWidth) {
                this.addStringWidthPatchesV2();
            } else {
                this.addStringWidthPatchesV1();
            }
        }

        private void addStringWidthPatchesV1() {
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "use charWidthf in getStringWidth (init)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(3, 61);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(11, 69);
                }
            }.targetMethod(this.getStringWidth));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "use charWidthf in getStringWidth (loop)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(28, 42, this.reference(180, FontRendererMod.this.charWidth), BinaryRegex.capture(BytecodeMatcher.anyILOAD), 16, 32, 96, 46, 96, 61);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(36, 42, this.reference(180, FontRendererMod.this.charWidthf), this.getCaptureGroup(1), 16, 32, 96, 48, 98, 69);
                }
            }.targetMethod(this.getStringWidth));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "use charWidthf in getStringWidth (return value)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(28, 172, BinaryRegex.end());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(36, this.reference(184, new MethodRef("java.lang.Math", "round", "(F)I")), 172);
                }
            }.targetMethod(this.getStringWidth));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "getStringWidth int -> float";
                }

                public String getMatchExpression() {
                    return this.buildExpression(28, BinaryRegex.capture(BinaryRegex.any(0, 20)), 96, 61);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(36, this.getCaptureGroup(1), 134, 98, 69);
                }
            }.targetMethod(this.getStringWidth));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "4.0f -> charWidthf[32]";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(42, 89, BytecodeMatcher.anyReference(180))), this.push(Float.valueOf(4.0f)), BinaryRegex.capture(BinaryRegex.build(98, BytecodeMatcher.anyReference(181))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), 42, this.reference(180, FontRendererMod.this.charWidthf), this.push(32), 48, this.getCaptureGroup(2));
                }
            });
        }

        private void addStringWidthPatchesV2() {
            final MethodRef getStringWidthf = new MethodRef("com.pclewis.mcpatcher.mod.FontUtils", "getStringWidthf", "(LFontRenderer;Ljava/lang/String;)F");
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getCharWidth", "(C)I")));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "replace getStringWidth";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), BinaryRegex.any(0, 1000), BinaryRegex.end());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, 43, this.reference(184, getStringWidthf), 139, 172);
                }
            }.targetMethod(this.getStringWidth));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "4.0f -> charWidthf[32]";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(4.0f)), 174);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, FontRendererMod.this.charWidthf), this.push(32), 48, 174);
                }
            });
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod() {
            FieldRef fontRenderer = new FieldRef(this.getDeobfClass(), "fontRenderer", "LFontRenderer;");
            FieldRef alternateFontRenderer = new FieldRef(this.getDeobfClass(), "alternateFontRenderer", "LFontRenderer;");
            FieldRef renderEngine = new FieldRef(this.getDeobfClass(), "renderEngine", "LRenderEngine;");
            FieldRef gameSettings = new FieldRef(this.getDeobfClass(), "gameSettings", "LGameSettings;");
            if (HDFont.this.haveAlternateFont) {
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, fontRenderer, alternateFontRenderer));
            } else {
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, fontRenderer));
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, alternateFontRenderer));
            }
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, renderEngine));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, gameSettings));
        }
    }
}

