/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.AddMethodPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BaseTexturePackMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.FixedBytecodeSignature;
import com.pclewis.mcpatcher.InterfaceMethodRef;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.MakeMemberPublicPatch;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.mod.HDTextureConfig;
import com.pclewis.mcpatcher.mod.TileSizePatch;
import java.io.IOException;

public class HDTexture
extends BaseTexturePackMod {
    private final boolean haveColorizerWater;
    private final boolean haveGetImageRGB;

    public HDTexture(MinecraftVersion minecraftVersion) {
        super(minecraftVersion);
        this.clearPatches();
        this.name = "HD Textures";
        this.author = "MCPatcher";
        this.description = "Provides support for high-resolution texture packs and custom animations.";
        this.version = "1.4";
        this.configPanel = new HDTextureConfig();
        this.addDependency("__TexturePackBase");
        this.haveColorizerWater = minecraftVersion.compareTo("Beta 1.6") >= 0;
        this.haveGetImageRGB = minecraftVersion.compareTo("Beta 1.6") >= 0;
        this.classMods.add(new RenderEngineMod());
        this.classMods.add(new TextureFXMod());
        this.classMods.add(new CompassMod());
        this.classMods.add(new FireMod());
        this.classMods.add(new FluidMod("StillLava"));
        this.classMods.add(new FluidMod("FlowLava"));
        this.classMods.add(new FluidMod("StillWater"));
        this.classMods.add(new FluidMod("FlowWater"));
        this.classMods.add(new ItemRendererMod());
        this.classMods.add(new WatchMod());
        this.classMods.add(new PortalMod());
        this.classMods.add(new MinecraftMod());
        this.classMods.add(new BaseMod.GLAllocationMod());
        this.classMods.add(new ColorizerMod("ColorizerWater", this.haveColorizerWater ? "/misc/watercolor.png" : "/misc/foliagecolor.png"));
        this.classMods.add(new ColorizerMod("ColorizerGrass", "/misc/grasscolor.png"));
        this.classMods.add(new ColorizerMod("ColorizerFoliage", "/misc/foliagecolor.png"));
        if (minecraftVersion.compareTo("12w22a") < 0) {
            this.classMods.add(new GuiContainerCreativeMod());
        }
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TileSize"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TextureUtils"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TextureUtils$1"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TextureUtils$2"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.CustomAnimation"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.CustomAnimation$Delegate"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.CustomAnimation$Tile"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.CustomAnimation$Strip"));
    }

    private class GuiContainerCreativeMod
    extends ClassMod {
        GuiContainerCreativeMod() {
            this.global = true;
            this.classSignatures.add(new ConstSignature("/gui/allitems.png"));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "use allitemsx.png for creative mode inventory background";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/gui/allitems.png"));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.push(true), this.reference(179, new FieldRef("com.pclewis.mcpatcher.mod.TextureUtils", "oldCreativeGui", "Z")));
                }
            });
        }
    }

    private class ColorizerMod
    extends ClassMod {
        private final String name;

        ColorizerMod(String name, String resource) {
            this.name = name;
            FieldRef colorBuffer = new FieldRef(this.getDeobfClass(), "colorBuffer", "[I");
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, colorBuffer));
            this.patches.add(new MakeMemberPublicPatch(colorBuffer));
            if (HDTexture.this.haveColorizerWater) {
                this.prerequisiteClasses.add("Minecraft");
            } else {
                this.classSignatures.add(new ConstSignature(resource));
            }
        }

        public String getDeobfClass() {
            return this.name;
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod() {
            FieldRef renderEngine = new FieldRef(this.getDeobfClass(), "renderEngine", "LRenderEngine;");
            if (HDTexture.this.haveColorizerWater) {
                this.addColorizerSignature("Water");
                this.addColorizerSignature("Grass");
                this.addColorizerSignature("Foliage");
            }
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, renderEngine));
        }

        private void addColorizerSignature(final String name) {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/misc/" + name.toLowerCase() + "color.png"), BytecodeMatcher.anyReference(182), BytecodeMatcher.captureReference(184));
                }
            }.addXref(1, new MethodRef("Colorizer" + name, "loadColorBuffer", "([I)V")));
        }
    }

    private class PortalMod
    extends ClassMod {
        PortalMod() {
            final MethodRef atan2 = new MethodRef("java.lang.Math", "atan2", "(DD)D");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(23, BinaryRegex.any(), 141, 23, BinaryRegex.any(), 141, this.reference(184, atan2), 144);
                }
            }.matchConstructorOnly(true));
            this.patches.add(new TileSizePatch(Float.valueOf(16.0f), "float_size"));
            this.patches.add(new TileSizePatch.WhilePatch(16, "int_size"));
            this.patches.add(new TileSizePatch.ArraySize2DPatch(1024, "int_numBytes", 32));
            this.patches.add(new TileSizePatch.MultiplyPatch(16, "int_size"));
            this.patches.add(new TileSizePatch.MultiplyPatch(8, "int_sizeHalf"));
            this.patches.add(new TileSizePatch.WhilePatch(256, "int_numPixels"));
            this.patches.add(new TileSizePatch.IfLessPatch(256, "int_numPixels"));
        }
    }

    private class WatchMod
    extends ClassMod {
        public WatchMod() {
            this.classSignatures.add(new ConstSignature("/misc/dial.png"));
            this.patches.add(new TileSizePatch(16.0, "double_size"));
            this.patches.add(new TileSizePatch(15.0, "double_sizeMinus1"));
            this.patches.add(new TileSizePatch.GetRGBPatch());
            this.patches.add(new TileSizePatch.ArraySizePatch(256, "int_numPixels"));
            this.patches.add(new TileSizePatch.MultiplyPatch(16, "int_size"));
            this.patches.add(new TileSizePatch.WhilePatch(256, "int_numPixels"));
            this.patches.add(new TileSizePatch.BitMaskPatch(15, "int_sizeMinus1"));
            this.patches.add(new TileSizePatch.DivPatch(16, "int_size"));
            this.patches.add(new TileSizePatch.ModPatch(16, "int_size"){

                public boolean filterMethod() {
                    return !this.getMethodInfo().isConstructor();
                }
            });
        }
    }

    private class ItemRendererMod
    extends ClassMod {
        ItemRendererMod() {
            this.classSignatures.add(new ConstSignature(Float.valueOf(-0.9375f)));
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.0625f)));
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.001953125f)));
            this.patches.add(new TileSizePatch.ToolPixelTopPatch());
            this.patches.add(new TileSizePatch(Float.valueOf(16.0f), "float_size"));
            this.patches.add(new TileSizePatch.WhilePatch(16, "int_size"));
            this.patches.add(new TileSizePatch.ToolTexPatch());
            this.patches.add(new TileSizePatch(Float.valueOf(0.001953125f), "float_texNudge"));
        }
    }

    private class FluidMod
    extends ClassMod {
        private String name;

        FluidMod(String name) {
            byte[] byArray;
            this.name = name;
            boolean lava = name.contains("Lava");
            boolean flow = name.contains("Flow");
            Object[] objectArray = new Object[7];
            objectArray[0] = 42;
            objectArray[1] = 178;
            objectArray[2] = BinaryRegex.any(2);
            objectArray[3] = 180;
            objectArray[4] = BinaryRegex.any(2);
            if (flow) {
                byte[] byArray2 = new byte[2];
                byArray2[0] = 4;
                byArray = byArray2;
                byArray2[1] = 96;
            } else {
                byArray = new byte[]{};
            }
            objectArray[5] = byArray;
            objectArray[6] = 183;
            this.classSignatures.add(new FixedBytecodeSignature(objectArray));
            final double rand = lava ? 0.005 : (flow ? 0.2 : 0.05);
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.reference(184, new MethodRef("java.lang.Math", "random", "()D")), this.push(rand), 152, 156);
                }
            });
            if (lava) {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(134, this.push(Float.valueOf((float)Math.PI)), 106, 13, 106, this.push(Float.valueOf(16.0f)), 110);
                    }
                });
            }
            this.patches.add(new TileSizePatch.ArraySizePatch(256, "int_numPixels"));
            this.patches.add(new TileSizePatch.WhilePatch(256, "int_numPixels"));
            this.patches.add(new TileSizePatch.WhilePatch(16, "int_size"));
            this.patches.add(new TileSizePatch.BitMaskPatch(255, "int_numPixelsMinus1"));
            this.patches.add(new TileSizePatch.BitMaskPatch(15, "int_sizeMinus1"));
            this.patches.add(new TileSizePatch.MultiplyPatch(16, "int_size"));
        }

        public String getDeobfClass() {
            return this.name;
        }
    }

    private class FireMod
    extends ClassMod {
        FireMod() {
            this.classSignatures.add(new ConstSignature(new MethodRef("java.lang.Math", "random", "()D")));
            this.classSignatures.add(new FixedBytecodeSignature(17, 1, 64, 188, 6, 181, BinaryRegex.any(2), 42, 17, 1, 64, 188, 6, 181, BinaryRegex.any(2), 177));
            this.patches.add(new TileSizePatch(Float.valueOf(1.06f), "float_flameNudge"));
            this.patches.add(new TileSizePatch(Float.valueOf(1.0600001f), "float_flameNudge"));
            this.patches.add(new TileSizePatch.ArraySizePatch(320, "int_flameArraySize"));
            this.patches.add(new TileSizePatch.WhilePatch(256, "int_numPixels"));
            this.patches.add(new TileSizePatch.WhilePatch(20, "int_flameHeight"));
            this.patches.add(new TileSizePatch.WhilePatch(16, "int_size"));
            this.patches.add(new TileSizePatch.ModPatch(20, "int_flameHeight"));
            this.patches.add(new TileSizePatch.IfLessPatch(19, "int_flameHeightMinus1"));
            this.patches.add(new TileSizePatch.MultiplyPatch(16, "int_size"){

                public boolean filterMethod() {
                    return !this.getMethodInfo().isConstructor();
                }
            });
        }
    }

    private class CompassMod
    extends ClassMod {
        CompassMod() {
            this.classSignatures.add(new ConstSignature("/gui/items.png"));
            this.classSignatures.add(new ConstSignature("/misc/dial.png").negate(true));
            this.classSignatures.add(new ConstSignature(new MethodRef("java.lang.Math", "sin", "(D)D")));
            this.classSignatures.add(new FixedBytecodeSignature(42, 17, 1, 0, 188, 10, 181, BinaryRegex.any(2), 42));
            this.patches.add(new TileSizePatch(7.5, "double_compassCenterMin"));
            this.patches.add(new TileSizePatch(8.5, "double_compassCenterMax"));
            this.patches.add(new TileSizePatch.ArraySizePatch(256, "int_numPixels"));
            this.patches.add(new TileSizePatch.MultiplyPatch(16, "int_size"));
            this.patches.add(new TileSizePatch.WhilePatch(256, "int_numPixels"));
            this.patches.add(new TileSizePatch(-4, "int_compassCrossMin"));
            this.patches.add(new TileSizePatch.IfGreaterPatch(4, "int_compassCrossMax"));
            this.patches.add(new TileSizePatch(-8, "int_compassNeedleMin"));
            this.patches.add(new TileSizePatch.IfGreaterPatch(16, "int_compassNeedleMax"));
            this.patches.add(new TileSizePatch.GetRGBPatch());
        }
    }

    private class TextureFXMod
    extends ClassMod {
        TextureFXMod() {
            FieldRef imageData = new FieldRef(this.getDeobfClass(), "imageData", "[B");
            FieldRef tileNumber = new FieldRef(this.getDeobfClass(), "tileNumber", "I");
            FieldRef tileSize = new FieldRef(this.getDeobfClass(), "tileSize", "I");
            FieldRef tileImage = new FieldRef(this.getDeobfClass(), "tileImage", "I");
            MethodRef bindImage = new MethodRef(this.getDeobfClass(), "bindImage", "(LRenderEngine;)V");
            this.classSignatures.add(new FixedBytecodeSignature(17, 4, 0, 188, 8));
            this.classSignatures.add(new FixedBytecodeSignature(BinaryRegex.begin(), 177, BinaryRegex.end()).setMethodName("onTick"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, imageData));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, tileNumber, null, tileSize, tileImage));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, bindImage));
            this.patches.add(new TileSizePatch.ArraySizePatch(1024, "int_numBytes"));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "check for bindImage recursion (end)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "bindImageEnd", "()V"))});
                }
            }.targetMethod(bindImage));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "check for bindImage recursion (start)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "bindImageBegin", "()Z")), 154, TextureFXMod.this.branch("A"), 177, TextureFXMod.this.label("A"));
                }
            }.targetMethod(bindImage));
        }
    }

    private class RenderEngineMod
    extends BaseMod.RenderEngineMod {
        RenderEngineMod() {
            JavaRef getInputStream;
            int getInputStreamOpcode;
            MethodRef updateDynamicTextures = new MethodRef(this.getDeobfClass(), "updateDynamicTextures", "()V");
            final MethodRef readTextureImage = new MethodRef(this.getDeobfClass(), "readTextureImage", "(Ljava/io/InputStream;)Ljava/awt/image/BufferedImage;");
            final MethodRef setupTexture = new MethodRef(this.getDeobfClass(), "setupTexture", "(Ljava/awt/image/BufferedImage;I)V");
            MethodRef registerTextureFX = new MethodRef(this.getDeobfClass(), "registerTextureFX", "(LTextureFX;)V");
            MethodRef refreshTextures = new MethodRef(this.getDeobfClass(), "refreshTextures", "()V");
            final FieldRef imageData = new FieldRef(this.getDeobfClass(), "imageData", "Ljava/nio/ByteBuffer;");
            final FieldRef textureList = new FieldRef(this.getDeobfClass(), "textureList", "Ljava/util/List;");
            MethodRef getTexture = new MethodRef(this.getDeobfClass(), "getTexture", "(Ljava/lang/String;)I");
            MethodRef getImageRGB = new MethodRef(this.getDeobfClass(), "getImageRGB", "(Ljava/awt/image/BufferedImage;[I)[I");
            MethodRef readTextureImageData = new MethodRef(this.getDeobfClass(), "readTextureImageData", "(Ljava/lang/String;)[I");
            if (HDTexture.this.haveITexturePack) {
                getInputStreamOpcode = 185;
                getInputStream = new InterfaceMethodRef("ITexturePack", "getInputStream", "(Ljava/lang/String;)Ljava/io/InputStream;");
            } else {
                getInputStreamOpcode = 182;
                getInputStream = new MethodRef("TexturePackBase", "getInputStream", "(Ljava/lang/String;)Ljava/io/InputStream;");
            }
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("%clamp%"));
                }
            }.setMethod(refreshTextures));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.push(-1), 60);
                }
            }.setMethod(updateDynamicTextures));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, imageData));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, textureList));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, registerTextureFX));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, readTextureImage));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, setupTexture));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, getTexture));
            if (HDTexture.this.haveGetImageRGB) {
                this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, getImageRGB));
            }
            if (HDTexture.this.haveColorizerWater) {
                this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, readTextureImageData));
            }
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    String op = this.getCaptureGroup(1)[0] == 112 ? "%" : "/";
                    return String.format("(i %1$s 16) * 16 + j * 16 -> (i %1$s 16) * int_size + j * int_size", op);
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(16), BinaryRegex.capture(BinaryRegex.subset(new byte[]{112, 108}, true)), this.push(16), 104, BinaryRegex.capture(BinaryRegex.any(1, 3)), this.push(16), 104);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.push(16), this.getCaptureGroup(1), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_size", "I")), 104, this.getCaptureGroup(2), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_size", "I")), 104);
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "glTexSubImage2D(...,16,16) -> glTexSubImage2D(...,int_size,int_size)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(16), this.push(16), this.push(6408), this.push(5121));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_size", "I")), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_size", "I")), this.push(6408), this.push(5121));
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "readTextureImage(getInputStream(...)) -> getImage(...)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.reference(getInputStreamOpcode, getInputStream), this.reference(183, readTextureImage));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "getImage", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/awt/image/BufferedImage;"))});
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "getInputStream(...), readTextureImage -> getImage(...)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(44, BinaryRegex.any(0, 6), 43, this.reference(getInputStreamOpcode, getInputStream), BytecodeMatcher.anyASTORE, BytecodeMatcher.anyALOAD, 199, BinaryRegex.any(2), 42, 42, 180, BinaryRegex.any(2), BytecodeMatcher.anyILOAD, this.reference(182, setupTexture), 167, BinaryRegex.any(2), 42, 42, BytecodeMatcher.anyALOAD, this.reference(183, readTextureImage));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, 43, this.reference(184, new MethodRef("com.pclewis.mcpatcher.TexturePackAPI", "getImage", "(Ljava/lang/String;)Ljava/awt/image/BufferedImage;")));
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "imageData.clear(), .put(), .limit() -> imageData = TextureUtils.getByteBuffer()";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, imageData), this.reference(182, new MethodRef("java/nio/ByteBuffer", "clear", "()Ljava/nio/Buffer;")), 87, 42, this.reference(180, imageData), BinaryRegex.capture(BinaryRegex.any(2, 5)), this.reference(182, new MethodRef("java/nio/ByteBuffer", "put", "([B)Ljava/nio/ByteBuffer;")), 87, 42, this.reference(180, imageData), 3, this.reference(182, new MethodRef("java/nio/ByteBuffer", "position", "(I)Ljava/nio/Buffer;")), BinaryRegex.backReference(1), 190, this.reference(182, new MethodRef("java/nio/Buffer", "limit", "(I)Ljava/nio/Buffer;")), 87);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, 42, this.reference(180, imageData), this.getCaptureGroup(1), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "getByteBuffer", "(Ljava/nio/ByteBuffer;[B)Ljava/nio/ByteBuffer;")), this.reference(181, imageData));
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "call TextureUtils.registerTextureFX";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), BinaryRegex.any(0, 50), BinaryRegex.end());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, textureList), 43, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "registerTextureFX", "(Ljava/util/List;LTextureFX;)V")), 177);
                }
            }.targetMethod(registerTextureFX));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "null check in setupTexture";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, 199, RenderEngineMod.this.branch("A"), 177, RenderEngineMod.this.label("A"));
                }
            }.targetMethod(setupTexture));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "null check in getImageRGB";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, 199, RenderEngineMod.this.branch("A"), 44, 176, RenderEngineMod.this.label("A"));
                }
            }.targetMethod(getImageRGB));
            this.patches.add(new TileSizePatch(0x100000, "int_glBufferSize"));
            this.patches.add(new AddMethodPatch(new MethodRef(this.getDeobfClass(), "reloadTextures", "(Lnet/minecraft/client/Minecraft;)V")){

                public byte[] generateMethod() throws IOException {
                    return this.buildCode(42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_glBufferSize", "I")), this.reference(184, new MethodRef("GLAllocation", "createDirectByteBuffer", "(I)Ljava/nio/ByteBuffer;")), this.reference(181, imageData), 42, this.reference(182, new MethodRef(RenderEngineMod.this.getDeobfClass(), "refreshTextures", "()V")), 42, this.reference(180, textureList), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "refreshTextureFX", "(Ljava/util/List;)V")), 177);
                }
            });
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "update custom animations";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.CustomAnimation", "updateAll", "()V"))});
                }
            }.targetMethod(updateDynamicTextures));
        }
    }
}

