/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.ModConfigPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HDTextureConfig
extends ModConfigPanel {
    private JPanel panel;
    private JComboBox waterCombo;
    private JComboBox lavaCombo;
    private JComboBox fireCombo;
    private JComboBox portalCombo;
    private JCheckBox textureCacheCheckBox;
    private JCheckBox shrinkGLMemoryCheckBox;
    private JComboBox otherCombo;
    private JCheckBox zombieHackCheckBox;
    private AnimationComboListener[] comboListeners = new AnimationComboListener[4];

    HDTextureConfig() {
        this.$$$setupUI$$$();
        this.comboListeners[0] = new AnimationComboListener(this.waterCombo, "Water");
        this.comboListeners[1] = new AnimationComboListener(this.lavaCombo, "Lava");
        this.comboListeners[2] = new AnimationComboListener(this.fireCombo, "Fire");
        this.comboListeners[3] = new AnimationComboListener(this.portalCombo, "Portal");
        this.waterCombo.addItemListener(this.comboListeners[0]);
        this.lavaCombo.addItemListener(this.comboListeners[1]);
        this.fireCombo.addItemListener(this.comboListeners[2]);
        this.portalCombo.addItemListener(this.comboListeners[3]);
        this.otherCombo.addItem("Not Animated");
        this.otherCombo.addItem("Custom Animated");
        this.otherCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    switch (HDTextureConfig.this.otherCombo.getSelectedIndex()) {
                        case 0: {
                            MCPatcherUtils.set("HD Textures", "customOther", false);
                            break;
                        }
                        case 1: {
                            MCPatcherUtils.set("HD Textures", "customOther", true);
                            break;
                        }
                    }
                }
            }
        });
        this.textureCacheCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MCPatcherUtils.set("HD Textures", "useTextureCache", HDTextureConfig.this.textureCacheCheckBox.isSelected());
            }
        });
        this.shrinkGLMemoryCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MCPatcherUtils.set("HD Textures", "reclaimGLMemory", HDTextureConfig.this.shrinkGLMemoryCheckBox.isSelected());
            }
        });
        this.zombieHackCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MCPatcherUtils.set("HD Textures", "zombieHack", HDTextureConfig.this.zombieHackCheckBox.isSelected());
            }
        });
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void load() {
        for (AnimationComboListener listener : this.comboListeners) {
            listener.load();
        }
        this.otherCombo.setSelectedIndex(MCPatcherUtils.getBoolean("HD Textures", "customOther", true) ? 1 : 0);
        boolean is64bit = false;
        try {
            String datamodel = System.getProperty("sun.arch.data.model");
            String arch = System.getProperty("os.arch");
            is64bit = datamodel != null ? Integer.parseInt(datamodel) >= 64 : (arch != null ? arch.contains("64") : false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.textureCacheCheckBox.setSelected(MCPatcherUtils.getBoolean("HD Textures", "useTextureCache", is64bit));
        this.shrinkGLMemoryCheckBox.setSelected(MCPatcherUtils.getBoolean("HD Textures", "reclaimGLMemory", false));
        this.zombieHackCheckBox.setSelected(MCPatcherUtils.getBoolean("HD Textures", "zombieHack", true));
    }

    public void save() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JComboBox jComboBox5;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Water");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Lava");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Fire");
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Portal");
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.lavaCombo = jComboBox5 = new JComboBox();
        jPanel2.add(jComboBox5, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.waterCombo = jComboBox4 = new JComboBox();
        jPanel2.add(jComboBox4, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.fireCombo = jComboBox3 = new JComboBox();
        jPanel2.add(jComboBox3, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.portalCombo = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Other");
        jPanel2.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.otherCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.textureCacheCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setToolTipText("Better performance when switching texture packs, but uses more memory.");
        jCheckBox3.setText("Enable texture cache");
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.shrinkGLMemoryCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setToolTipText("Shrink GL buffer size when possible.");
        jCheckBox2.setText("Reclaim GL memory");
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.zombieHackCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText("Automatically resizes /mob/zombie.png from 64x32 to 64x64 as needed.");
        jCheckBox.setText("Enable zombie texture compatibility fix");
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private static class AnimationComboListener
    implements ItemListener {
        private static final int OPT_DEFAULT = 0;
        private static final int OPT_NOT_ANIMATED = 1;
        private static final int OPT_CUSTOM_ANIMATED = 2;
        private final JComboBox comboBox;
        private final String animatedTag;
        private final String customTag;

        public AnimationComboListener(JComboBox comboBox, String tag) {
            this.comboBox = comboBox;
            this.customTag = "custom" + tag;
            this.animatedTag = "animated" + tag;
            comboBox.addItem("Default");
            comboBox.addItem("Not Animated");
            comboBox.addItem("Custom Animated");
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                boolean anim;
                boolean custom;
                switch (this.comboBox.getSelectedIndex()) {
                    case 0: {
                        custom = false;
                        anim = true;
                        break;
                    }
                    case 1: {
                        custom = false;
                        anim = false;
                        break;
                    }
                    case 2: {
                        custom = true;
                        anim = true;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                MCPatcherUtils.set("HD Textures", this.customTag, custom);
                MCPatcherUtils.set("HD Textures", this.animatedTag, anim);
            }
        }

        public void load() {
            if (MCPatcherUtils.getBoolean("HD Textures", this.customTag, true)) {
                this.comboBox.setSelectedIndex(2);
            } else if (MCPatcherUtils.getBoolean("HD Textures", this.animatedTag, true)) {
                this.comboBox.setSelectedIndex(0);
            } else {
                this.comboBox.setSelectedIndex(1);
            }
        }
    }
}

