/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import com.pclewis.mcpatcher.mod.MobOverlay;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.NBTTagCompound;

public class MobRandomizer {
    private static final HashMap<String, MobEntry> mobHash = new HashMap();

    public static String randomTexture(EntityLiving entity) {
        return MobRandomizer.randomTexture(entity, entity.getEntityTexture());
    }

    public static String randomTexture(EntityLiving entity, String texture) {
        if (!texture.startsWith("/mob/") || !texture.endsWith(".png")) {
            return texture;
        }
        ExtraInfo info = ExtraInfo.getInfo(entity);
        MobEntry mobEntry = mobHash.get(texture);
        if (mobEntry == null) {
            mobEntry = new MobEntry(texture);
            mobHash.put(texture, mobEntry);
        }
        return mobEntry.getSkin(info.skin, info.origX, info.origY, info.origZ, info.origBiome);
    }

    public static String randomTexture(Object entity, String texture) {
        if (entity instanceof EntityLiving) {
            return MobRandomizer.randomTexture((EntityLiving)entity, texture);
        }
        return texture;
    }

    static {
        TexturePackAPI.ChangeHandler.register(new TexturePackAPI.ChangeHandler("Random Mobs", 2){

            protected void onChange() {
                mobHash.clear();
                MobOverlay.reset();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SkinEntry {
        final int[] skins;
        final HashSet<String> biomes;
        final int minHeight;
        final int maxHeight;

        static SkinEntry load(Properties properties, int index, int limit) {
            int i;
            int[] skins;
            String skinList = properties.getProperty("skins." + index, "").trim().toLowerCase();
            if (skinList.equals("*") || skinList.equals("all") || skinList.equals("any")) {
                skins = new int[limit];
                for (i = 0; i < skins.length; ++i) {
                    skins[i] = i;
                }
            } else {
                skins = MCPatcherUtils.parseIntegerList(skinList, 1, limit);
                if (skins.length <= 0) {
                    return null;
                }
                i = 0;
                while (i < skins.length) {
                    int n = i++;
                    skins[n] = skins[n] - 1;
                }
            }
            HashSet<String> biomes = new HashSet<String>();
            String biomeList = properties.getProperty("biomes." + index, "").trim().toLowerCase();
            if (!biomeList.equals("")) {
                Collections.addAll(biomes, biomeList.split("\\s+"));
            }
            if (biomes.isEmpty()) {
                biomes = null;
            }
            int maxHeight = -1;
            int minHeight = -1;
            try {
                maxHeight = Integer.parseInt(properties.getProperty("maxHeight." + index, "-1").trim());
                minHeight = Integer.parseInt(properties.getProperty("minHeight." + index, "-1").trim());
                if (minHeight < 0 || minHeight > maxHeight) {
                    minHeight = -1;
                    maxHeight = -1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return new SkinEntry(skins, biomes, minHeight, maxHeight);
        }

        SkinEntry(int[] skins, HashSet<String> biomes, int minHeight, int maxHeight) {
            this.skins = skins;
            this.biomes = biomes;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        boolean match(int i, int j, int k, String biome) {
            if (this.biomes != null && !this.biomes.contains(biome)) {
                return false;
            }
            return this.minHeight < 0 || j >= this.minHeight && j <= this.maxHeight;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("skins:");
            for (int i : this.skins) {
                sb.append(' ').append(i + 1);
            }
            if (this.biomes != null) {
                sb.append(", biomes:");
                for (String s : this.biomes) {
                    sb.append(' ').append(s);
                }
            }
            if (this.minHeight >= 0) {
                sb.append(", height: ").append(this.minHeight).append('-').append(this.maxHeight);
            }
            return sb.toString();
        }
    }

    private static class MobEntry {
        final String baseSkin;
        final ArrayList<String> allSkins;
        final int skinCount;
        final ArrayList<SkinEntry> entries;

        MobEntry(String baseSkin) {
            String skin;
            this.baseSkin = baseSkin;
            this.allSkins = new ArrayList();
            this.allSkins.add(baseSkin);
            int i = 2;
            while (TexturePackAPI.hasResource(skin = baseSkin.replace(".png", "" + i + ".png"))) {
                this.allSkins.add(skin);
                ++i;
            }
            this.skinCount = this.allSkins.size();
            if (this.skinCount <= 1) {
                this.entries = null;
                return;
            }
            MCPatcherUtils.debug("found %d variations for %s", this.skinCount, baseSkin);
            String filename = baseSkin.replace(".png", ".properties");
            String altFilename = filename.replaceFirst("_(eyes|overlay|tame|angry|collar|fur|invul)\\.properties$", ".properties");
            Properties properties = TexturePackAPI.getProperties(filename);
            if (properties == null && !filename.equals(altFilename) && (properties = TexturePackAPI.getProperties(altFilename)) != null) {
                MCPatcherUtils.debug("using %s for %s", altFilename, baseSkin);
            }
            ArrayList<SkinEntry> tmpEntries = new ArrayList<SkinEntry>();
            if (properties != null) {
                int i2 = 0;
                while (true) {
                    SkinEntry entry;
                    if ((entry = SkinEntry.load(properties, i2, this.skinCount)) == null) {
                        if (i2 > 0) {
                            break;
                        }
                    } else {
                        MCPatcherUtils.debug("  %s", entry.toString());
                        tmpEntries.add(entry);
                    }
                    ++i2;
                }
            }
            this.entries = tmpEntries.isEmpty() ? null : tmpEntries;
        }

        String getSkin(long key, int i, int j, int k, String biome) {
            if (this.entries == null) {
                int index = (int)(key % (long)this.skinCount);
                if (index < 0) {
                    index += this.skinCount;
                }
                return this.allSkins.get(index);
            }
            for (SkinEntry entry : this.entries) {
                if (!entry.match(i, j, k, biome)) continue;
                int n = entry.skins.length;
                int index = (int)(key % (long)n);
                if (index < 0) {
                    index += n;
                }
                return this.allSkins.get(entry.skins[index]);
            }
            return this.baseSkin;
        }
    }

    public static final class ExtraInfo {
        private static final String SKIN_TAG = "randomMobsSkin";
        private static final String ORIG_X_TAG = "origX";
        private static final String ORIG_Y_TAG = "origY";
        private static final String ORIG_Z_TAG = "origZ";
        private static final long MULTIPLIER = 25214903917L;
        private static final long ADDEND = 11L;
        private static final long MASK = 0xFFFFFFFFFFFFL;
        private static Method getBiomeNameAt;
        private static final HashMap<Integer, ExtraInfo> allInfo;
        public final long skin;
        public final int origX;
        public final int origY;
        public final int origZ;
        public final String origBiome;

        ExtraInfo(EntityLiving entity) {
            this.skin = ExtraInfo.getSkinId(entity.entityId);
            this.origX = (int)entity.posX;
            this.origY = (int)entity.posY;
            this.origZ = (int)entity.posZ;
            this.origBiome = ExtraInfo.getBiome(this.origX, this.origY, this.origZ);
        }

        ExtraInfo(long skin, int origX, int origY, int origZ) {
            this.skin = skin;
            this.origX = origX;
            this.origY = origY;
            this.origZ = origZ;
            this.origBiome = ExtraInfo.getBiome(origX, origY, origZ);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ExtraInfo getInfo(EntityLiving entity) {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                if (entity.randomMobsInfo == null) {
                    entity.randomMobsInfo = allInfo.get(entity.entityId);
                    if (entity.randomMobsInfo == null) {
                        entity.randomMobsInfo = new ExtraInfo(entity);
                        ExtraInfo.putInfo(entity);
                    }
                }
            }
            return entity.randomMobsInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void putInfo(EntityLiving entity) {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                allInfo.put(entity.entityId, entity.randomMobsInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void clearInfo() {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                allInfo.clear();
            }
        }

        public String toString() {
            return String.format("%s{%d, %d, %d, %d, %s}", this.getClass().getName(), this.skin, this.origX, this.origY, this.origZ, this.origBiome);
        }

        private static long getSkinId(int entityId) {
            long n = entityId;
            n = n ^ n << 16 ^ n << 32 ^ n << 48;
            n = 25214903917L * n + 11L;
            n = 25214903917L * n + 11L;
            return (n &= 0xFFFFFFFFFFFFL) >> 32 ^ n;
        }

        private static String getBiome(int x, int y, int z) {
            if (getBiomeNameAt != null) {
                try {
                    String biome = (String)getBiomeNameAt.invoke(null, x, y, z);
                    if (biome != null) {
                        return biome.toLowerCase().replace(" ", "");
                    }
                }
                catch (Throwable e) {
                    getBiomeNameAt = null;
                    e.printStackTrace();
                }
            }
            return null;
        }

        public static void readFromNBT(EntityLiving entity, NBTTagCompound nbt) {
            long skin = nbt.getLong(SKIN_TAG);
            entity.randomMobsInfo = skin == 0L ? new ExtraInfo(entity) : new ExtraInfo(skin, nbt.getInteger(ORIG_X_TAG), nbt.getInteger(ORIG_Y_TAG), nbt.getInteger(ORIG_Z_TAG));
            ExtraInfo.putInfo(entity);
        }

        public static void writeToNBT(EntityLiving entity, NBTTagCompound nbt) {
            ExtraInfo info = ExtraInfo.getInfo(entity);
            if (info != null) {
                nbt.setLong(SKIN_TAG, info.skin);
                nbt.setInteger(ORIG_X_TAG, info.origX);
                nbt.setInteger(ORIG_Y_TAG, info.origY);
                nbt.setInteger(ORIG_Z_TAG, info.origZ);
            }
        }

        static {
            allInfo = new HashMap();
            try {
                Class<?> biomeHelperClass = Class.forName("com.pclewis.mcpatcher.mod.BiomeHelper");
                getBiomeNameAt = biomeHelperClass.getDeclaredMethod("getBiomeNameAt", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

