/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.CTMUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.src.Tessellator;

public class SuperTessellator
extends Tessellator {
    private static final Integer MAGIC_VALUE = 305419896;
    static SuperTessellator instance;
    private final HashMap<Integer, Tessellator> children = new HashMap();
    private final Field[] fieldsToCopy;
    private final boolean isForge;

    public SuperTessellator(int bufferSize) {
        super(bufferSize);
        MCPatcherUtils.info("new %s(%d)", ((Object)((Object)this)).getClass().getSimpleName(), bufferSize);
        this.isForge = false;
        this.fieldsToCopy = this.getFieldsToCopy();
        instance = this;
    }

    public SuperTessellator() {
        MCPatcherUtils.info("new %s()", ((Object)((Object)this)).getClass().getSimpleName());
        this.isForge = true;
        this.fieldsToCopy = this.getFieldsToCopy();
        instance = this;
    }

    Tessellator getTessellator(int texture) {
        if (texture == CTMUtils.terrainTexture) {
            return this;
        }
        Tessellator newTessellator = this.children.get(texture);
        if (newTessellator == null) {
            MCPatcherUtils.info("new tessellator for texture %d", texture);
            newTessellator = this.isForge ? new Tessellator() : new Tessellator(Math.max(this.bufferSize / 16, 131072));
            newTessellator.texture = texture;
            this.copyFields(newTessellator, true);
            this.children.put(texture, newTessellator);
        } else {
            this.copyFields(newTessellator, false);
        }
        return newTessellator;
    }

    void clearTessellators() {
        this.children.clear();
    }

    private Field[] getFieldsToCopy() {
        int saveBufferSize;
        if (this.isForge) {
            saveBufferSize = 0;
        } else {
            saveBufferSize = this.bufferSize;
            this.bufferSize = MAGIC_VALUE;
        }
        int saveVertexCount = this.vertexCount;
        int saveAddedVertices = this.addedVertices;
        int saveRawBufferIndex = this.rawBufferIndex;
        int saveTexture = this.texture;
        this.vertexCount = MAGIC_VALUE;
        this.addedVertices = MAGIC_VALUE;
        this.rawBufferIndex = MAGIC_VALUE;
        this.texture = MAGIC_VALUE;
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field f : Tessellator.class.getDeclaredFields()) {
            try {
                Class<?> type = f.getType();
                int modifiers = f.getModifiers();
                if (Modifier.isStatic(modifiers) || !type.isPrimitive() || f.getName().equals("rawBufferSize")) continue;
                f.setAccessible(true);
                if (type == Integer.TYPE && MAGIC_VALUE.equals(f.get((Object)this))) continue;
                MCPatcherUtils.debug("  copy %s %s %s", Modifier.toString(f.getModifiers()), f.getType().toString(), f.getName());
                fields.add(f);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (!this.isForge) {
            this.bufferSize = saveBufferSize;
        }
        this.vertexCount = saveVertexCount;
        this.addedVertices = saveAddedVertices;
        this.rawBufferIndex = saveRawBufferIndex;
        this.texture = saveTexture;
        return fields.toArray(new Field[fields.size()]);
    }

    private void copyFields(Tessellator newTessellator, boolean isNew) {
        for (Field f : this.fieldsToCopy) {
            try {
                Object value = f.get((Object)this);
                if (isNew) {
                    MCPatcherUtils.debug("  copy %s %s %s = %s", Modifier.toString(f.getModifiers()), f.getType().toString(), f.getName(), value.toString());
                }
                f.set(newTessellator, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.isDrawing && !newTessellator.isDrawing) {
            newTessellator.startDrawing(this.drawMode);
        } else if (!this.isDrawing && newTessellator.isDrawing) {
            newTessellator.reset();
        }
    }

    public void reset() {
        super.reset();
        for (Tessellator t : this.children.values()) {
            t.reset();
        }
    }

    public int draw() {
        int total = 0;
        for (Tessellator t : this.children.values()) {
            total += t.draw();
        }
        return total + super.draw();
    }

    public void startDrawing(int drawMode) {
        super.startDrawing(drawMode);
        for (Tessellator t : this.children.values()) {
            t.startDrawing(drawMode);
        }
    }
}

