/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import com.pclewis.mcpatcher.mod.CTMUtils;
import com.pclewis.mcpatcher.mod.RenderPassAPI;
import java.awt.image.BufferedImage;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.RenderBlocks;

abstract class TileOverride {
    static final int BOTTOM_FACE = 0;
    static final int TOP_FACE = 1;
    static final int NORTH_FACE = 2;
    static final int SOUTH_FACE = 3;
    static final int WEST_FACE = 4;
    static final int EAST_FACE = 5;
    private static final int[][] ROTATE_UV_MAP = new int[][]{{4, 5, 2, 3, 1, 0, 2, -2, 2, -2, 0, 0}, {2, 3, 1, 0, 4, 5, 0, 0, 0, 0, -2, 2}};
    private static final int[] GO_DOWN = new int[]{0, -1, 0};
    private static final int[] GO_UP = new int[]{0, 1, 0};
    private static final int[] GO_NORTH = new int[]{0, 0, -1};
    private static final int[] GO_SOUTH = new int[]{0, 0, 1};
    private static final int[] GO_WEST = new int[]{-1, 0, 0};
    private static final int[] GO_EAST = new int[]{1, 0, 0};
    private static final int[][][] NEIGHBOR_OFFSET = new int[][][]{new int[][]{GO_WEST, TileOverride.add(GO_WEST, GO_SOUTH), GO_SOUTH, TileOverride.add(GO_EAST, GO_SOUTH), GO_EAST, TileOverride.add(GO_EAST, GO_NORTH), GO_NORTH, TileOverride.add(GO_WEST, GO_NORTH)}, new int[][]{GO_WEST, TileOverride.add(GO_WEST, GO_SOUTH), GO_SOUTH, TileOverride.add(GO_EAST, GO_SOUTH), GO_EAST, TileOverride.add(GO_EAST, GO_NORTH), GO_NORTH, TileOverride.add(GO_WEST, GO_NORTH)}, new int[][]{GO_EAST, TileOverride.add(GO_EAST, GO_DOWN), GO_DOWN, TileOverride.add(GO_WEST, GO_DOWN), GO_WEST, TileOverride.add(GO_WEST, GO_UP), GO_UP, TileOverride.add(GO_EAST, GO_UP)}, new int[][]{GO_WEST, TileOverride.add(GO_WEST, GO_DOWN), GO_DOWN, TileOverride.add(GO_EAST, GO_DOWN), GO_EAST, TileOverride.add(GO_EAST, GO_UP), GO_UP, TileOverride.add(GO_WEST, GO_UP)}, new int[][]{GO_NORTH, TileOverride.add(GO_NORTH, GO_DOWN), GO_DOWN, TileOverride.add(GO_SOUTH, GO_DOWN), GO_SOUTH, TileOverride.add(GO_SOUTH, GO_UP), GO_UP, TileOverride.add(GO_NORTH, GO_UP)}, new int[][]{GO_SOUTH, TileOverride.add(GO_SOUTH, GO_DOWN), GO_DOWN, TileOverride.add(GO_NORTH, GO_DOWN), GO_NORTH, TileOverride.add(GO_NORTH, GO_UP), GO_UP, TileOverride.add(GO_SOUTH, GO_UP)}};
    final String filePrefix;
    final String textureName;
    final int texture;
    final int renderPass;
    final int[] blockIDs;
    final int[] tileIDs;
    final int faces;
    final int metadata;
    final boolean connectByTile;
    final int[] tileMap;
    boolean disabled;
    int[] reorient;
    int metamask;
    int rotateUV;

    static TileOverride create(String filePrefix, Properties properties) {
        if (filePrefix == null) {
            return null;
        }
        if (properties == null) {
            properties = TexturePackAPI.getProperties(filePrefix + ".properties");
        }
        if (properties == null) {
            return null;
        }
        String method = properties.getProperty("method", "default").trim().toLowerCase();
        TileOverride override = null;
        if (method.equals("default") || method.equals("glass") || method.equals("ctm")) {
            override = new CTM(filePrefix, properties);
        } else if (method.equals("random")) {
            override = new Random1(filePrefix, properties);
        } else if (method.equals("fixed") || method.equals("static")) {
            override = new Fixed(filePrefix, properties);
        } else if (method.equals("bookshelf") || method.equals("horizontal")) {
            override = new Horizontal(filePrefix, properties);
        } else if (method.equals("vertical")) {
            override = new Vertical(filePrefix, properties);
        } else if (method.equals("sandstone") || method.equals("top")) {
            override = new Top(filePrefix, properties);
        } else if (method.equals("repeat") || method.equals("pattern")) {
            override = new Repeat(filePrefix, properties);
        } else {
            MCPatcherUtils.error("%s.properties: unknown method \"%s\"", filePrefix, method);
        }
        if (override != null && !override.disabled) {
            if (override.tileMap == null || override.tileMap.length == 0) {
                override.error("no tile map given", new Object[0]);
            } else {
                String status = override.checkTileMap();
                if (status != null) {
                    override.error("invalid %s tile map: %s", override.getMethod(), status);
                }
            }
        }
        return override == null || override.disabled ? null : override;
    }

    static TileOverride create(BufferedImage image, int tileID) {
        CTM override = new CTM(image, tileID);
        return override.disabled ? null : override;
    }

    private TileOverride(BufferedImage image, int tileID) {
        this.filePrefix = null;
        this.textureName = null;
        this.texture = MCPatcherUtils.getMinecraft().renderEngine.allocateAndSetupTexture(image);
        this.renderPass = -1;
        this.blockIDs = new int[0];
        this.tileIDs = new int[]{tileID};
        this.faces = -1;
        this.metadata = -1;
        this.connectByTile = true;
        this.tileMap = null;
    }

    private TileOverride(String filePrefix, Properties properties) {
        this.filePrefix = filePrefix;
        this.textureName = properties.getProperty("source", filePrefix + ".png");
        this.texture = CTMUtils.getTexture(this.textureName);
        if (this.texture < 0) {
            if (properties.contains("source")) {
                this.error("source texture %s not found", this.textureName);
            } else {
                this.disabled = true;
            }
        }
        int pass = 0;
        try {
            pass = Integer.parseInt(properties.getProperty("renderPass", "-1"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.renderPass = pass;
        this.blockIDs = this.getIDList(properties, "blockIDs", "block", Block.blocksList.length - 1);
        this.tileIDs = this.getIDList(properties, "tileIDs", "terrain", 255);
        if (this.blockIDs.length == 0 && this.tileIDs.length == 0) {
            this.error("no block or tile IDs matched", new Object[0]);
        }
        int flags = 0;
        for (String val : properties.getProperty("faces", "all").trim().toLowerCase().split("\\s+")) {
            if (val.equals("bottom")) {
                flags |= 1;
                continue;
            }
            if (val.equals("top")) {
                flags |= 2;
                continue;
            }
            if (val.equals("north")) {
                flags |= 4;
                continue;
            }
            if (val.equals("south")) {
                flags |= 8;
                continue;
            }
            if (val.equals("east")) {
                flags |= 0x20;
                continue;
            }
            if (val.equals("west")) {
                flags |= 0x10;
                continue;
            }
            if (val.equals("side") || val.equals("sides")) {
                flags |= 0x3C;
                continue;
            }
            if (!val.equals("all")) continue;
            flags = -1;
        }
        this.faces = flags;
        int meta = 0;
        for (int i : MCPatcherUtils.parseIntegerList(properties.getProperty("metadata", "0-31"), 0, 31)) {
            meta |= 1 << i;
        }
        this.metadata = meta;
        String connectType = properties.getProperty("connect", "").trim().toLowerCase();
        this.connectByTile = "".equals(connectType) ? this.tileIDs.length > 0 : connectType.equals("tile");
        String tileList = properties.getProperty("tiles", "");
        this.tileMap = tileList.equals("") ? this.getDefaultTileMap() : MCPatcherUtils.parseIntegerList(tileList, 0, 255);
        if (this.renderPass > 3) {
            this.error("renderPass must be 0-3", new Object[0]);
        } else if (this.renderPass >= 0 && this.tileIDs.length > 0) {
            this.error("renderPass=%d must be block-based not tile-based", this.renderPass);
        }
    }

    private int[] getIDList(Properties properties, String key, String type, int maxID) {
        int[] list = MCPatcherUtils.parseIntegerList(properties.getProperty(key, "").trim(), 0, maxID);
        if (list.length > 0) {
            return list;
        }
        Matcher m = Pattern.compile("/" + type + "(\\d+)").matcher(this.filePrefix);
        if (m.find()) {
            try {
                list = new int[]{Integer.parseInt(m.group(1))};
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private static int[] add(int[] a, int[] b) {
        if (a.length != b.length) {
            throw new RuntimeException("arrays to add are not same length");
        }
        int[] c = new int[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    int[] getDefaultTileMap() {
        return null;
    }

    String checkTileMap() {
        return null;
    }

    boolean requiresFace() {
        return false;
    }

    final void error(String format, Object ... params) {
        if (this.filePrefix != null && !this.filePrefix.equals("/ctm")) {
            MCPatcherUtils.error(this.filePrefix + ".properties: " + format, params);
        }
        this.disabled = true;
    }

    final boolean shouldConnect(IBlockAccess blockAccess, Block block, int tileNum, int i, int j, int k, int face, int[] offset) {
        int meta = blockAccess.getBlockMetadata(i, j, k);
        int neighborID = blockAccess.getBlockId(i += offset[0], j += offset[1], k += offset[2]);
        Block neighbor = Block.blocksList[neighborID];
        if (this.exclude(blockAccess, neighbor, tileNum, i, j, k, face)) {
            return false;
        }
        if (this.metamask != -1 && (blockAccess.getBlockMetadata(i, j, k) & ~this.metamask) != (meta & ~this.metamask)) {
            return false;
        }
        if (this.connectByTile) {
            return neighbor.getBlockTexture(blockAccess, i, j, k, face) == tileNum;
        }
        return neighborID == block.blockID;
    }

    final int reorient(int face) {
        if (face < 0 || face > 5 || this.reorient == null) {
            return face;
        }
        return this.reorient[face];
    }

    final boolean exclude(IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
        int meta;
        if (block == null) {
            return true;
        }
        if (RenderPassAPI.instance.skipThisRenderPass(block, this.renderPass)) {
            return true;
        }
        if ((this.faces & 1 << this.reorient(face)) == 0) {
            return true;
        }
        return this.metadata != -1 && (meta = blockAccess.getBlockMetadata(i, j, k)) >= 0 && meta < 32 && (this.metadata & (1 << meta | 1 << (meta & this.metamask))) == 0;
    }

    final int getTile(RenderBlocks renderBlocks, IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
        if (face < 0 && this.requiresFace()) {
            this.error("method=%s is not supported for non-standard blocks", this.getMethod());
            return -1;
        }
        this.reorient = null;
        this.metamask = -1;
        this.rotateUV = 0;
        if (block.blockID == 17) {
            this.metamask = -13;
            int orientation = blockAccess.getBlockMetadata(i, j, k) & 0xC;
            if (orientation == 4) {
                this.reorient = ROTATE_UV_MAP[0];
                this.rotateUV = ROTATE_UV_MAP[0][face + 6];
            } else if (orientation == 8) {
                this.reorient = ROTATE_UV_MAP[1];
                this.rotateUV = ROTATE_UV_MAP[1][face + 6];
            }
        }
        if (this.exclude(blockAccess, block, origTexture, i, j, k, face)) {
            return -1;
        }
        return this.getTileImpl(blockAccess, block, origTexture, i, j, k, face);
    }

    final int rotateUV(int neighbor) {
        return neighbor + this.rotateUV & 7;
    }

    private static int[] compose(int[] map1, int[] map2) {
        int[] newMap = new int[map2.length];
        for (int i = 0; i < map2.length; ++i) {
            newMap[i] = map1[map2[i]];
        }
        return newMap;
    }

    abstract String getMethod();

    abstract int getTileImpl(IBlockAccess var1, Block var2, int var3, int var4, int var5, int var6, int var7);

    static final class Fixed
    extends TileOverride {
        private Fixed(String filePrefix, Properties properties) {
            super(filePrefix, properties);
        }

        String getMethod() {
            return "fixed";
        }

        String checkTileMap() {
            if (this.tileMap.length == 1) {
                return null;
            }
            return "requires exactly 1 tile";
        }

        int getTileImpl(IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
            return this.tileMap[0];
        }
    }

    static final class Repeat
    extends TileOverride {
        private final int width;
        private final int height;
        private final int symmetry;

        Repeat(String filePrefix, Properties properties) {
            super(filePrefix, properties);
            String sym;
            int w = 0;
            int h = 0;
            try {
                w = Integer.parseInt(properties.getProperty("width", "0"));
                h = Integer.parseInt(properties.getProperty("height", "0"));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            this.width = w;
            this.height = h;
            if (this.width <= 0 || this.height <= 0 || this.width * this.height > 256) {
                this.error("invalid width and height (%dx%d)", this.width, this.height);
            }
            this.symmetry = (sym = properties.getProperty("symmetry", "none")).equals("opposite") ? -2 : -1;
        }

        String getMethod() {
            return "repeat";
        }

        String checkTileMap() {
            if (this.tileMap.length == this.width * this.height) {
                return null;
            }
            return String.format("requires exactly %dx%d tiles", this.width, this.height);
        }

        int getTileImpl(IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
            int y;
            int x;
            if (face < 0) {
                face = 0;
            }
            face = this.reorient(face) & this.symmetry;
            switch (face) {
                case 0: 
                case 1: {
                    x = i;
                    y = k;
                    break;
                }
                case 2: {
                    x = -i - 1;
                    y = -j;
                    break;
                }
                case 3: {
                    x = i;
                    y = -j;
                    break;
                }
                case 4: {
                    x = k;
                    y = -j;
                    break;
                }
                case 5: {
                    x = -k - 1;
                    y = -j;
                    break;
                }
                default: {
                    return -1;
                }
            }
            if ((x %= this.width) < 0) {
                x += this.width;
            }
            if ((y %= this.height) < 0) {
                y += this.height;
            }
            return this.tileMap[this.width * y + x];
        }
    }

    static final class Random1
    extends TileOverride {
        private static final long P1 = 31024237183253L;
        private static final long P2 = 37916421967133L;
        private static final long P3 = 247193919306661L;
        private static final long P4 = 179199247101619L;
        private static final long MULTIPLIER = 25214903917L;
        private static final long ADDEND = 11L;
        private final int symmetry;
        private final int[] weight;
        private final int sum;

        private Random1(String filePrefix, Properties properties) {
            super(filePrefix, properties);
            String sym = properties.getProperty("symmetry", "none");
            this.symmetry = sym.equals("all") ? 6 : (sym.equals("opposite") ? 2 : 1);
            boolean useWeight = false;
            int sum1 = 0;
            int[] wt = null;
            if (this.tileMap != null) {
                wt = new int[this.tileMap.length];
                String[] list = properties.getProperty("weights", "").split("\\s+");
                for (int i = 0; i < this.tileMap.length; ++i) {
                    wt[i] = i < list.length && list[i].matches("^\\d+$") ? Math.max(Integer.parseInt(list[i]), 0) : 1;
                    if (i > 0 && wt[i] != wt[0]) {
                        useWeight = true;
                    }
                    sum1 += wt[i];
                }
            }
            this.sum = sum1;
            this.weight = (int[])(useWeight && this.sum > 0 ? wt : null);
        }

        String getMethod() {
            return "random";
        }

        int getTileImpl(IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
            if (this.tileMap.length == 1) {
                return this.tileMap[0];
            }
            if (face < 0) {
                face = 0;
            }
            face = this.reorient(face) / this.symmetry;
            long n = 31024237183253L * (long)i * ((long)i + 11L) + 37916421967133L * (long)j * ((long)j + 11L) + 247193919306661L * (long)k * ((long)k + 11L) + 179199247101619L * (long)face * ((long)face + 11L);
            n = 25214903917L * (n + (long)i + (long)j + (long)k + (long)face) + 11L;
            int index = (int)(n >> 32 ^ n) & Integer.MAX_VALUE;
            if (this.weight == null) {
                index %= this.tileMap.length;
            } else {
                int m = index % this.sum;
                for (index = 0; index < this.weight.length - 1 && m >= this.weight[index]; m -= this.weight[index], ++index) {
                }
            }
            return this.tileMap[index];
        }
    }

    static final class Top
    extends TileOverride {
        private static final int[] defaultTileMap = new int[]{66};

        private Top(String filePrefix, Properties properties) {
            super(filePrefix, properties);
        }

        String getMethod() {
            return "top";
        }

        int[] getDefaultTileMap() {
            return defaultTileMap;
        }

        String checkTileMap() {
            if (this.tileMap.length == 1) {
                return null;
            }
            return "requires exactly 1 tile";
        }

        int getTileImpl(IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
            if (face < 0) {
                face = 2;
            } else if (this.reorient(face) <= 1) {
                return -1;
            }
            int[][] offsets = NEIGHBOR_OFFSET[face];
            if (this.shouldConnect(blockAccess, block, origTexture, i, j, k, face, offsets[this.rotateUV(6)])) {
                return this.tileMap[0];
            }
            return -1;
        }
    }

    static final class Vertical
    extends TileOverride {
        private static final int[] defaultTileMap = new int[]{48, 32, 16, 0};
        private static final int[] neighborMap = new int[]{3, 2, 0, 1};
        private final int[] neighborTileMap;

        private Vertical(String filePrefix, Properties properties) {
            super(filePrefix, properties);
            this.neighborTileMap = TileOverride.compose(this.tileMap, Vertical.neighborMap);
        }

        String getMethod() {
            return "vertical";
        }

        int[] getDefaultTileMap() {
            return defaultTileMap;
        }

        String checkTileMap() {
            if (this.tileMap.length == 4) {
                return null;
            }
            return "requires exactly 4 tiles";
        }

        int getTileImpl(IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
            if (face < 0) {
                face = 2;
            } else if (this.reorient(face) <= 1) {
                return -1;
            }
            int[][] offsets = NEIGHBOR_OFFSET[face];
            int neighborBits = 0;
            if (this.shouldConnect(blockAccess, block, origTexture, i, j, k, face, offsets[this.rotateUV(2)])) {
                neighborBits |= 1;
            }
            if (this.shouldConnect(blockAccess, block, origTexture, i, j, k, face, offsets[this.rotateUV(6)])) {
                neighborBits |= 2;
            }
            return this.neighborTileMap[neighborBits];
        }
    }

    static final class Horizontal
    extends TileOverride {
        private static final int[] defaultTileMap = new int[]{12, 13, 14, 15};
        private static final int[] neighborMap = new int[]{3, 2, 0, 1};
        private final int[] neighborTileMap;

        private Horizontal(String filePrefix, Properties properties) {
            super(filePrefix, properties);
            this.neighborTileMap = TileOverride.compose(this.tileMap, Horizontal.neighborMap);
        }

        String getMethod() {
            return "horizontal";
        }

        int[] getDefaultTileMap() {
            return defaultTileMap;
        }

        String checkTileMap() {
            if (this.tileMap.length == 4) {
                return null;
            }
            return "requires exactly 4 tiles";
        }

        int getTileImpl(IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
            if (face < 0) {
                face = 2;
            } else if (this.reorient(face) <= 1) {
                return -1;
            }
            int[][] offsets = NEIGHBOR_OFFSET[face];
            int neighborBits = 0;
            if (this.shouldConnect(blockAccess, block, origTexture, i, j, k, face, offsets[this.rotateUV(0)])) {
                neighborBits |= 1;
            }
            if (this.shouldConnect(blockAccess, block, origTexture, i, j, k, face, offsets[this.rotateUV(4)])) {
                neighborBits |= 2;
            }
            return this.neighborTileMap[neighborBits];
        }
    }

    static final class CTM
    extends TileOverride {
        private static final int[] defaultTileMap = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59};
        private static final int[] neighborMap = new int[]{0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 36, 17, 36, 17, 24, 19, 24, 43, 36, 17, 36, 17, 24, 19, 24, 43, 16, 18, 16, 18, 6, 46, 6, 21, 16, 18, 16, 18, 28, 9, 28, 22, 36, 17, 36, 17, 24, 19, 24, 43, 36, 17, 36, 17, 24, 19, 24, 43, 37, 40, 37, 40, 30, 8, 30, 34, 37, 40, 37, 40, 25, 23, 25, 45, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 36, 39, 36, 39, 24, 41, 24, 27, 36, 39, 36, 39, 24, 41, 24, 27, 16, 42, 16, 42, 6, 20, 6, 10, 16, 42, 16, 42, 28, 35, 28, 44, 36, 39, 36, 39, 24, 41, 24, 27, 36, 39, 36, 39, 24, 41, 24, 27, 37, 38, 37, 38, 30, 11, 30, 32, 37, 38, 37, 38, 25, 33, 25, 26};
        private final int[] neighborTileMap;

        private CTM(BufferedImage image, int tileID) {
            super(image, tileID);
            this.neighborTileMap = TileOverride.compose(CTM.defaultTileMap, CTM.neighborMap);
        }

        private CTM(String filePrefix, Properties properties) {
            super(filePrefix, properties);
            this.neighborTileMap = TileOverride.compose(this.tileMap, CTM.neighborMap);
        }

        String getMethod() {
            return "ctm";
        }

        int[] getDefaultTileMap() {
            return defaultTileMap;
        }

        String checkTileMap() {
            if (this.tileMap.length >= 47) {
                return null;
            }
            return "requires at least 47 tiles";
        }

        boolean requiresFace() {
            return true;
        }

        int getTileImpl(IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
            int[][] offsets = NEIGHBOR_OFFSET[face];
            int neighborBits = 0;
            for (int bit = 0; bit < 8; ++bit) {
                if (!this.shouldConnect(blockAccess, block, origTexture, i, j, k, face, offsets[bit])) continue;
                neighborBits |= 1 << bit;
            }
            return this.neighborTileMap[neighborBits];
        }
    }
}

