/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.ClassPatch;
import com.pclewis.mcpatcher.FieldRef;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.FieldInfo;

public class AddFieldPatch
extends ClassPatch {
    private FieldRef fieldRef;
    private int accessFlags;
    private boolean allowDuplicate;

    public AddFieldPatch(FieldRef fieldRef) {
        this(fieldRef, 1);
    }

    public AddFieldPatch(FieldRef fieldRef, int accessFlags) {
        this.fieldRef = fieldRef;
        this.accessFlags = accessFlags;
        this.allowDuplicate(true);
    }

    public AddFieldPatch(String name, String type) {
        this(new FieldRef(null, name, type));
    }

    public AddFieldPatch(String name, String type, int accessFlags) {
        this(new FieldRef(null, name, type), accessFlags);
    }

    public AddFieldPatch(String name) {
        this(name, 1);
    }

    public AddFieldPatch(String name, int accessFlags) {
        this(new FieldRef(null, name, null), accessFlags);
    }

    public AddFieldPatch allowDuplicate(boolean allowDuplicate) {
        this.allowDuplicate = allowDuplicate;
        this.optional = allowDuplicate;
        return this;
    }

    public String getDescriptor() {
        return this.fieldRef.getType();
    }

    public String getDescription() {
        return String.format("insert field %s %s", this.fieldRef.getName(), this.getDescriptor());
    }

    boolean apply(ClassFile classFile) throws BadBytecode, DuplicateMemberException {
        FieldInfo fieldInfo = new FieldInfo(classFile.getConstPool(), this.fieldRef.getName(), this.classMod.getClassMap().mapTypeString(this.getDescriptor()));
        fieldInfo.setAccessFlags(this.accessFlags);
        try {
            classFile.addField(fieldInfo);
            this.recordPatch();
        }
        catch (DuplicateMemberException e) {
            if (this.allowDuplicate) {
                for (Object o : classFile.getFields()) {
                    FieldInfo conflictField = (FieldInfo)o;
                    if (!conflictField.getName().equals(fieldInfo.getName())) continue;
                    if (!conflictField.getDescriptor().equals(fieldInfo.getDescriptor()) || conflictField.getAccessFlags() != fieldInfo.getAccessFlags()) break;
                    return false;
                }
                throw e;
            }
            throw e;
        }
        return true;
    }
}

