/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassSignature;
import com.pclewis.mcpatcher.ConstPoolUtils;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BytecodeSignature
extends ClassSignature {
    MethodRef deobfMethod;
    ArrayList<String> deobfTypes;
    ArrayList<String> obfTypes;
    private final HashMap<Integer, JavaRef> xrefs = new HashMap();
    boolean constructorOnly;
    boolean staticInitializerOnly;
    protected BytecodeMatcher matcher;

    public abstract String getMatchExpression();

    void initMatcher() {
        this.matcher = new BytecodeMatcher(this.getMatchExpression());
    }

    @Override
    void setClassMod(ClassMod classMod) {
        super.setClassMod(classMod);
        if (this.deobfMethod != null && this.deobfMethod.getClassName() == null) {
            this.deobfMethod = new MethodRef(classMod.getDeobfClass(), this.deobfMethod.getName(), this.deobfMethod.getType());
        }
    }

    private boolean filterMethod1() {
        MethodInfo methodInfo = this.getMethodInfo();
        if (this.constructorOnly && !methodInfo.isConstructor()) {
            return false;
        }
        if (this.staticInitializerOnly && !methodInfo.isStaticInitializer()) {
            return false;
        }
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return false;
        }
        if (this.getClassMap().hasMap((JavaRef)this.deobfMethod)) {
            MethodRef obfTarget = (MethodRef)this.getClassMap().map((JavaRef)this.deobfMethod);
            if (!methodInfo.getName().equals(obfTarget.getName())) {
                return false;
            }
        }
        if (this.deobfMethod != null && this.deobfMethod.getType() != null) {
            this.deobfTypes = ConstPoolUtils.parseDescriptor(this.deobfMethod.getType());
            this.obfTypes = ConstPoolUtils.parseDescriptor(methodInfo.getDescriptor());
            if (!this.isPotentialTypeMatch(this.deobfTypes, this.obfTypes)) {
                return false;
            }
        }
        return this.filterMethod();
    }

    private boolean isPotentialTypeMatch(ArrayList<String> deobfTypes, ArrayList<String> obfTypes) {
        if (deobfTypes.size() != obfTypes.size()) {
            return false;
        }
        for (int i = 0; i < deobfTypes.size(); ++i) {
            String deobfType = deobfTypes.get(i);
            String obfType = obfTypes.get(i);
            String deobfClass = deobfType.replaceFirst("^\\[+", "");
            String obfClass = obfType.replaceFirst("^\\[+", "");
            if (deobfType.length() - deobfClass.length() != obfType.length() - obfClass.length()) {
                return false;
            }
            if (deobfClass.charAt(0) == 'L' && obfClass.charAt(0) == 'L') {
                String deobfMapping;
                boolean obfIsMC;
                deobfClass = ClassMap.descriptorToClassName(deobfClass);
                obfClass = ClassMap.descriptorToClassName(obfClass);
                boolean deobfIsMC = !deobfClass.contains(".") || deobfClass.startsWith("net.minecraft.");
                boolean bl = obfIsMC = !obfClass.matches(".*[^a-z].*") || obfClass.startsWith("net.minecraft.");
                if (deobfIsMC != obfIsMC) {
                    return false;
                }
                if (!(deobfIsMC ? this.classMod.getClassMap().hasMap(deobfClass) && !(deobfMapping = this.classMod.getClassMap().map(deobfClass).replace('/', '.')).equals(obfClass) : !deobfClass.equals(obfClass))) continue;
                return false;
            }
            if (deobfClass.equals(obfClass)) continue;
            return false;
        }
        return true;
    }

    private boolean isPotentialTypeMatch(String deobfDesc, String obfDesc) {
        return deobfDesc == null && obfDesc == null || this.isPotentialTypeMatch(ConstPoolUtils.parseDescriptor(deobfDesc), ConstPoolUtils.parseDescriptor(obfDesc));
    }

    @Override
    public boolean match(String filename, ClassFile classFile, ClassMap tempClassMap) {
        boolean matched = false;
        String className = ClassMap.filenameToClassName(filename);
        for (Object o : classFile.getMethods()) {
            MethodInfo methodInfo;
            this.classMod.methodInfo = methodInfo = (MethodInfo)o;
            if (this.deobfMethod != null && this.deobfMethod.getType() != null) {
                this.deobfTypes = ConstPoolUtils.parseDescriptor(this.deobfMethod.getType());
                this.obfTypes = ConstPoolUtils.parseDescriptor(methodInfo.getDescriptor());
            }
            if (!this.match(className, methodInfo, tempClassMap)) continue;
            matched = true;
            break;
        }
        this.classMod.methodInfo = null;
        return matched;
    }

    boolean match(String className, MethodInfo methodInfo, ClassMap tempClassMap) {
        if (!this.filterMethod1()) {
            return false;
        }
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        CodeIterator codeIterator = codeAttribute.iterator();
        this.initMatcher();
        try {
            int offset = 0;
            while (offset < codeIterator.getCodeLength() && this.matcher.match(methodInfo, offset)) {
                if (this.afterMatch1(className, tempClassMap)) {
                    return true;
                }
                offset = codeIterator.next();
            }
        }
        catch (BadBytecode e) {
            Logger.log(e);
        }
        return false;
    }

    private boolean afterMatch1(String className, ClassMap tempClassMap) {
        MethodInfo methodInfo = this.getMethodInfo();
        ConstPool constPool = methodInfo.getConstPool();
        ArrayList<JavaRef> tempMappings = new ArrayList<JavaRef>();
        for (Map.Entry<Integer, JavaRef> entry : this.xrefs.entrySet()) {
            int captureGroup = entry.getKey();
            JavaRef xref = entry.getValue();
            byte[] code = this.matcher.getCaptureGroup(captureGroup);
            int index = Util.demarshal(code, 1, 2);
            ConstPoolUtils.matchOpcodeToRefType(code[0], xref);
            ConstPoolUtils.matchConstPoolTagToRefType(constPool.getTag(index), xref);
            JavaRef newRef = ConstPoolUtils.getRefForIndex(constPool, index);
            if (!this.isPotentialTypeMatch(xref.getType(), newRef.getType())) {
                if (this.deobfMethod != null) {
                    Logger.log(3, "method %s %s matches %s %s, but", methodInfo.getName(), methodInfo.getDescriptor(), this.deobfMethod.getName(), this.deobfMethod.getType());
                }
                Logger.log(3, "method %s %s failed xref #%d %s %s -> %s %s", methodInfo.getName(), methodInfo.getDescriptor(), captureGroup, xref.getName(), xref.getType(), newRef.getName(), newRef.getType());
                return false;
            }
            tempMappings.add(xref);
            tempMappings.add(newRef);
        }
        if (className != null && tempClassMap != null) {
            int i = 0;
            while (i + 1 < tempMappings.size()) {
                tempClassMap.addMap((JavaRef)tempMappings.get(i), (JavaRef)tempMappings.get(i + 1));
                i += 2;
            }
            if (this.deobfMethod != null) {
                String deobfName = this.classMod.getDeobfClass();
                tempClassMap.addClassMap(deobfName, className);
                tempClassMap.addMethodMap(deobfName, this.deobfMethod.getName(), methodInfo.getName(), methodInfo.getDescriptor());
                if (this.deobfTypes != null && this.obfTypes != null) {
                    for (int i2 = 0; i2 < this.deobfTypes.size(); ++i2) {
                        String desc = ClassMap.descriptorToClassName(this.deobfTypes.get(i2));
                        String obf = ClassMap.descriptorToClassName(this.obfTypes.get(i2));
                        if (obf.equals(desc)) continue;
                        tempClassMap.addClassMap(desc, obf);
                    }
                }
            }
        }
        return this.afterMatch();
    }

    public BytecodeSignature setMethodName(String methodName) {
        return this.setMethod(new MethodRef(null, methodName, null));
    }

    public BytecodeSignature setMethod(MethodRef methodRef) {
        this.deobfMethod = methodRef;
        return this;
    }

    public BytecodeSignature addXref(int captureGroup, JavaRef javaRef) {
        this.xrefs.put(captureGroup, javaRef);
        return this;
    }

    public BytecodeSignature matchConstructorOnly(boolean only) {
        this.constructorOnly = only;
        return this;
    }

    public BytecodeSignature matchStaticInitializerOnly(boolean only) {
        this.staticInitializerOnly = only;
        return this;
    }

    public boolean filterMethod() {
        return true;
    }

    public void afterMatch(ClassFile classFile, MethodInfo methodInfo) {
    }

    @Override
    public boolean afterMatch() {
        this.afterMatch(this.getClassFile(), this.getMethodInfo());
        return true;
    }

    protected final byte[] getCaptureGroup(int group) {
        return this.matcher.getCaptureGroup(group);
    }

    protected final byte[] getMatch() {
        return this.matcher.getMatch();
    }
}

