/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassPatch;
import com.pclewis.mcpatcher.ClassSignature;
import com.pclewis.mcpatcher.ConstPoolUtils;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.PatchComponent;
import com.pclewis.mcpatcher.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Mnemonic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassMod
implements PatchComponent {
    protected Mod mod;
    protected ArrayList<String> prerequisiteClasses = new ArrayList();
    protected ArrayList<ClassSignature> classSignatures = new ArrayList();
    protected ArrayList<ClassPatch> patches = new ArrayList();
    protected ArrayList<MemberMapper> memberMappers = new ArrayList();
    protected boolean global = false;
    protected String parentClass;
    protected String[] interfaces;
    Collection<String> targetClasses = new HashSet<String>();
    ArrayList<String> errors = new ArrayList();
    boolean addToConstPool = false;
    ClassFile classFile;
    MethodInfo methodInfo;
    int bestMatchCount;
    String bestMatch;
    private ArrayList<Label> labels = new ArrayList();
    private HashMap<String, Integer> labelPositions = new HashMap();
    boolean matchAddedFiles;

    boolean matchClassFile(String filename, ClassFile classFile) {
        this.addToConstPool = false;
        this.classFile = classFile;
        if (!this.filterFile(filename)) {
            return false;
        }
        ClassMap newMap = new ClassMap();
        String deobfName = this.getDeobfClass();
        int sigIndex = 0;
        for (ClassSignature cs : this.classSignatures) {
            boolean found = false;
            if (cs.match(filename, classFile, newMap)) {
                found = true;
            }
            if (found == cs.negate) {
                return false;
            }
            newMap.addClassMap(deobfName, ClassMap.filenameToClassName(filename));
            if (this.bestMatch == null || sigIndex > this.bestMatchCount) {
                this.bestMatch = filename;
                this.bestMatchCount = sigIndex;
            }
            ++sigIndex;
        }
        for (ClassSignature cs : this.classSignatures) {
            this.addToConstPool = false;
            if (cs.afterMatch()) continue;
            return false;
        }
        this.targetClasses.add(classFile.getName());
        if (this.targetClasses.size() == 1 && !this.global) {
            this.mod.classMap.merge(newMap);
            if (this.parentClass != null) {
                this.mod.classMap.addClassMap(this.parentClass, classFile.getSuperclass());
                this.mod.classMap.addInheritance(this.parentClass, deobfName);
            }
            if (this.interfaces != null) {
                String[] obfInterfaces = classFile.getInterfaces();
                for (int i = 0; i < Math.min(this.interfaces.length, obfInterfaces.length); ++i) {
                    this.mod.classMap.addClassMap(this.interfaces[i], obfInterfaces[i]);
                    this.mod.classMap.addInterface(this.interfaces[i], deobfName);
                }
            }
        }
        return true;
    }

    public String getDeobfClass() {
        return this.getClass().getSimpleName().replaceFirst("^_", "").replaceFirst("Mod$", "");
    }

    boolean okToApply() {
        return this.errors.size() == 0;
    }

    void addError(String error) {
        this.errors.add(error);
    }

    List<String> getTargetClasses() {
        ArrayList<String> sortedList = new ArrayList<String>(this.targetClasses.size());
        sortedList.addAll(this.targetClasses);
        Collections.sort(sortedList);
        return sortedList;
    }

    protected boolean filterFile(String filename) {
        String className = ClassMap.filenameToClassName(filename);
        if (this.global) {
            return !className.startsWith("com.jcraft.") && !className.startsWith("paulscode.");
        }
        return className.startsWith("net.minecraft.client.") || className.matches("^[a-z]{1,4}$");
    }

    protected boolean mapClassMembers(String filename, ClassFile classFile) throws Exception {
        boolean ok = true;
        for (MemberMapper mapper : this.memberMappers) {
            String mapperType = mapper.getMapperType();
            mapper.mapDescriptor(this.mod.getClassMap());
            for (Object o : mapper.getMatchingObjects(classFile)) {
                if (!mapper.match(o)) continue;
                mapper.updateClassMap(this.getClassMap(), classFile, o);
                mapper.afterMatch();
            }
            if (mapper.allMatched()) continue;
            this.addError(String.format("no match found for %s %s", mapperType, mapper.getName()));
            Logger.log(3, "no match found for %s %s", mapperType, mapper.getName());
            ok = false;
        }
        return ok;
    }

    public void prePatch(String filename, ClassFile classFile) throws Exception {
    }

    public void postPatch(String filename, ClassFile classFile) throws Exception {
    }

    protected void addPrerequisiteClass(String className) {
        this.prerequisiteClasses.add(className);
    }

    protected void addClassSignature(ClassSignature classSignature) {
        classSignature.classMod = this;
        this.classSignatures.add(classSignature);
    }

    protected void addPatch(ClassPatch classPatch) {
        classPatch.classMod = this;
        this.patches.add(classPatch);
    }

    protected void addMemberMapper(MemberMapper memberMapper) {
        this.memberMappers.add(memberMapper);
    }

    protected void setMultipleMatchesAllowed(boolean match) {
        this.global = match;
    }

    protected void setMatchAddedFiles(boolean match) {
        if (match) {
            this.matchAddedFiles = true;
            this.setMultipleMatchesAllowed(true);
        } else {
            this.matchAddedFiles = false;
        }
    }

    protected void setParentClass(String className) {
        this.parentClass = className;
    }

    protected void setInterfaces(String ... interfaces) {
        this.interfaces = (String[])interfaces.clone();
    }

    protected final Label label(String key) {
        return new Label(key, true);
    }

    protected final Label branch(String key) {
        return new Label(key, false);
    }

    void resetLabels() {
        this.labels.clear();
        this.labelPositions.clear();
    }

    void resolveLabels(byte[] code, int start, int labelOffset) {
        for (Map.Entry<String, Integer> e : this.labelPositions.entrySet()) {
            Logger.log(5, "label %s -> instruction %d", e.getKey(), start + e.getValue());
        }
        for (Label label : this.labels) {
            if (!this.labelPositions.containsKey(label.name)) {
                throw new RuntimeException("no label " + label.name + " defined");
            }
            int to = this.labelPositions.get(label.name);
            int diff = to - label.from + 1;
            int codepos = label.from + labelOffset;
            Logger.log(5, "branch offset %s %s -> %+d @%d", Mnemonic.OPCODE[code[codepos - 1] & 0xFF].toUpperCase(), label.name, diff, label.from - 1 + start);
            code[codepos] = Util.b(diff, 1);
            code[codepos + 1] = Util.b(diff, 0);
        }
    }

    @Override
    public final ClassFile getClassFile() {
        return this.classFile;
    }

    @Override
    public final MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    @Override
    public final String buildExpression(Object ... objects) {
        return BinaryRegex.build(objects);
    }

    @Override
    public final byte[] buildCode(Object ... objects) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.buildCode1(baos, objects);
        return baos.toByteArray();
    }

    private void buildCode1(ByteArrayOutputStream baos, Object[] objects) throws IOException {
        for (Object o : objects) {
            if (o instanceof Byte) {
                baos.write(((Byte)o).byteValue());
                continue;
            }
            if (o instanceof byte[]) {
                baos.write((byte[])o);
                continue;
            }
            if (o instanceof Integer) {
                baos.write((Integer)o);
                continue;
            }
            if (o instanceof int[]) {
                for (int i : (int[])o) {
                    baos.write(i);
                }
                continue;
            }
            if (o instanceof Label) {
                Label label = (Label)o;
                if (label.save) {
                    int offset = baos.size();
                    if (this.labelPositions.containsKey(label.name)) {
                        throw new RuntimeException("label " + label.name + " already defined");
                    }
                    this.labelPositions.put(label.name, offset);
                    continue;
                }
                label.from = baos.size();
                this.labels.add(label);
                baos.write(0);
                baos.write(0);
                continue;
            }
            if (o instanceof Object[]) {
                this.buildCode1(baos, (Object[])o);
                continue;
            }
            throw new AssertionError((Object)("invalid type: " + o.getClass().toString()));
        }
    }

    @Override
    public final Object push(Object value) {
        return ConstPoolUtils.push(this.getMethodInfo().getConstPool(), value, this.addToConstPool);
    }

    @Override
    public final byte[] reference(int opcode, JavaRef ref) {
        return ConstPoolUtils.reference(this.getMethodInfo().getConstPool(), opcode, this.map(ref), this.addToConstPool);
    }

    @Override
    public final Mod getMod() {
        return this.mod;
    }

    @Override
    public final ClassMap getClassMap() {
        return this.mod.getClassMap();
    }

    @Override
    public final JavaRef map(JavaRef ref) {
        return this.mod.getClassMap().map(ref);
    }

    public class MethodMapper
    extends MemberMapper {
        public MethodMapper(MethodRef ... refs) {
            super(refs);
        }

        public MethodMapper(String[] names, String descriptor) {
            super(names, descriptor);
        }

        public MethodMapper(String name, String descriptor) {
            super(name, descriptor);
        }

        public MethodMapper mapToInterface(int mapInterface) {
            this.mapInterface = mapInterface;
            return this;
        }

        protected final String getMapperType() {
            return "method";
        }

        protected boolean match(Object o) {
            MethodInfo methodInfo = (MethodInfo)o;
            return this.matchInfo(methodInfo.getDescriptor(), methodInfo.getAccessFlags());
        }

        protected JavaRef getObfRef(String className, Object o) {
            MethodInfo methodInfo = (MethodInfo)o;
            return new MethodRef(className, methodInfo.getName(), methodInfo.getDescriptor());
        }

        protected String[] describeMatch(Object o) {
            MethodInfo methodInfo = (MethodInfo)o;
            return new String[]{methodInfo.getName(), methodInfo.getDescriptor()};
        }

        protected void updateClassMap11(ClassMap classMap, ClassFile classFile, Object o) {
            super.updateClassMap(classMap, classFile, o);
            JavaRef ref = this.getRef();
            if (ref != null) {
                MethodInfo methodInfo = (MethodInfo)o;
                Logger.log(3, "method %s matches %s %s", ref.getName(), methodInfo.getName(), methodInfo.getDescriptor());
            }
        }

        protected List getMatchingObjects(ClassFile classFile) {
            return classFile.getMethods();
        }
    }

    public class FieldMapper
    extends MemberMapper {
        public FieldMapper(FieldRef ... refs) {
            super(refs);
        }

        public FieldMapper(String[] names, String descriptor) {
            super(names, descriptor);
        }

        public FieldMapper(String name, String descriptor) {
            super(name, descriptor);
        }

        protected final String getMapperType() {
            return "field";
        }

        protected boolean match(Object o) {
            FieldInfo fieldInfo = (FieldInfo)o;
            return this.matchInfo(fieldInfo.getDescriptor(), fieldInfo.getAccessFlags());
        }

        protected JavaRef getObfRef(String className, Object o) {
            FieldInfo fieldInfo = (FieldInfo)o;
            return new FieldRef(className, fieldInfo.getName(), fieldInfo.getDescriptor());
        }

        protected String[] describeMatch(Object o) {
            FieldInfo fieldInfo = (FieldInfo)o;
            return new String[]{fieldInfo.getName(), fieldInfo.getDescriptor()};
        }

        protected void updateClassMap11(ClassMap classMap, ClassFile classFile, Object o) {
            super.updateClassMap(classMap, classFile, o);
            JavaRef ref = this.getRef();
            if (ref != null) {
                FieldInfo fieldInfo = (FieldInfo)o;
                Logger.log(3, "field %s matches %s %s", ref.getName(), fieldInfo.getName(), fieldInfo.getDescriptor());
            }
        }

        protected List getMatchingObjects(ClassFile classFile) {
            return classFile.getFields();
        }
    }

    public abstract class MemberMapper {
        protected JavaRef[] refs;
        protected String descriptor;
        private int mapSuperclass;
        int mapInterface = -1;
        private int setAccessFlags;
        private int clearAccessFlags;
        private int count;

        MemberMapper(JavaRef ... refs) {
            this.refs = (JavaRef[])refs.clone();
            for (JavaRef ref : refs) {
                if (ref == null || ref.getType() == null) continue;
                return;
            }
            throw new RuntimeException("refs list has no descriptor");
        }

        MemberMapper(String[] names, String descriptor) {
            this.refs = new JavaRef[names.length];
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                if (this instanceof FieldMapper) {
                    this.refs[i] = new FieldRef(null, names[i], descriptor);
                    continue;
                }
                if (this instanceof MethodMapper) {
                    this.refs[i] = new MethodRef(null, names[i], descriptor);
                    continue;
                }
                throw new IllegalArgumentException("invalid type " + this.getClass().getName());
            }
        }

        MemberMapper(String name, String descriptor) {
            this(new String[]{name}, descriptor);
        }

        public MemberMapper accessFlag(int flags, boolean set) {
            if (set) {
                this.setAccessFlags |= flags;
            } else {
                this.clearAccessFlags |= flags;
            }
            return this;
        }

        public MemberMapper mapToSuperclass(int ancestry) {
            if (ancestry > 1) {
                throw new IllegalArgumentException("ancestry " + ancestry + " is not supported");
            }
            this.mapSuperclass = ancestry;
            return this;
        }

        void mapDescriptor(ClassMap classMap) {
            this.count = 0;
            for (JavaRef ref : this.refs) {
                if (ref == null || ref.getType() == null) continue;
                this.descriptor = classMap.mapTypeString(ref.getType());
                return;
            }
        }

        boolean matchInfo(String descriptor, int flags) {
            return descriptor.equals(this.descriptor) && (flags & this.setAccessFlags) == this.setAccessFlags && (flags & this.clearAccessFlags) == 0;
        }

        JavaRef getRef() {
            return this.count < this.refs.length ? this.refs[this.count] : null;
        }

        String getClassName() {
            JavaRef ref = this.getRef();
            if (ref == null) {
                return null;
            }
            if (ref.getClassName() == null || ref.getClassName().equals("")) {
                return ClassMod.this.getDeobfClass();
            }
            return ref.getClassName();
        }

        String getName() {
            JavaRef ref = this.getRef();
            return ref == null ? null : ref.getName();
        }

        void afterMatch() {
            ++this.count;
        }

        boolean allMatched() {
            return this.count >= this.refs.length;
        }

        protected abstract String getMapperType();

        protected abstract List getMatchingObjects(ClassFile var1);

        protected abstract boolean match(Object var1);

        protected abstract JavaRef getObfRef(String var1, Object var2);

        protected abstract String[] describeMatch(Object var1);

        protected void updateClassMap(ClassMap classMap, ClassFile classFile, Object o) {
            JavaRef ref = this.getRef();
            if (ref != null) {
                String prefix;
                String obfClassName;
                if (this.mapSuperclass == 1) {
                    obfClassName = classFile.getSuperclass();
                    prefix = this.getClassName() + '.';
                } else if (this.mapInterface >= 0) {
                    obfClassName = classFile.getInterfaces()[this.mapInterface];
                    prefix = this.getClassName() + '.';
                } else {
                    obfClassName = classFile.getName();
                    prefix = "";
                }
                JavaRef obfRef = this.getObfRef(obfClassName, o);
                String[] s = this.describeMatch(o);
                Logger.log(3, "%s %s matches %s%s %s", this.getMapperType(), ref.getName(), prefix, s[0], s[1]);
                classMap.addMap(ref, obfRef);
            }
        }
    }

    public static final class Label {
        String name;
        boolean save;
        int from;

        Label(String name, boolean save) {
            this.name = name;
            this.save = save;
        }
    }
}

