/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.MCPatcherUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Config {
    private File xmlFile = null;
    Document xml;
    Element selectedProfile;
    static final String TAG_ROOT = "mcpatcherProfile";
    static final String TAG_CONFIG1 = "config";
    static final String TAG_SELECTED_PROFILE = "selectedProfile";
    static final String TAG_LAST_MOD_DIRECTORY = "lastModDirectory";
    static final String TAG_DEBUG = "debug";
    static final String TAG_JAVA_HEAP_SIZE = "javaHeapSize";
    static final String TAG_LAST_VERSION = "lastVersion";
    static final String TAG_BETA_WARNING_SHOWN = "betaWarningShown";
    static final String TAG_LOGGING = "logging";
    static final String TAG_LEVEL = "level";
    static final String TAG_MODS = "mods";
    static final String ATTR_PROFILE = "profile";
    static final String TAG_MOD = "mod";
    static final String TAG_CATEGORY = "category";
    static final String TAG_NAME = "name";
    static final String TAG_TYPE = "type";
    static final String TAG_PATH = "path";
    static final String TAG_FILES = "files";
    static final String TAG_FILE = "file";
    static final String TAG_FROM = "from";
    static final String TAG_TO = "to";
    static final String TAG_CLASS = "class";
    static final String TAG_ENABLED = "enabled";
    static final String ATTR_VERSION = "version";
    static final String VAL_BUILTIN = "builtIn";
    static final String VAL_EXTERNAL_ZIP = "externalZip";
    static final String VAL_EXTERNAL_JAR = "externalJar";
    private static final int XML_INDENT_AMOUNT = 2;
    private static final String XSLT_REFORMAT = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:output method=\"xml\" omit-xml-declaration=\"no\"/><xsl:strip-space elements=\"*\"/><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template></xsl:stylesheet>";

    Config(File minecraftDir) throws ParserConfigurationException {
        this.xmlFile = new File(minecraftDir, "mcpatcher.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        boolean save = false;
        if (this.xmlFile.exists()) {
            try {
                this.xml = builder.parse(this.xmlFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.xml == null) {
            this.xml = builder.newDocument();
            this.buildNewProperties();
            save = true;
        }
        if (save) {
            this.saveProperties();
        }
    }

    Element getElement(Element parent, String tag) {
        Element element;
        if (parent == null) {
            return null;
        }
        NodeList list = parent.getElementsByTagName(tag);
        if (list.getLength() == 0) {
            element = this.xml.createElement(tag);
            parent.appendChild(element);
        } else {
            element = (Element)list.item(0);
        }
        return element;
    }

    String getText(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 3: {
                return ((Text)node).getData();
            }
            case 2: {
                return ((Attr)node).getValue();
            }
            case 1: {
                NodeList list = node.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node1 = list.item(i);
                    if (node1.getNodeType() != 3) continue;
                    return ((Text)node1).getData();
                }
                break;
            }
        }
        return null;
    }

    void setText(Element parent, String tag, String value) {
        if (parent == null) {
            return;
        }
        Element element = this.getElement(parent, tag);
        while (element.hasChildNodes()) {
            element.removeChild(element.getFirstChild());
        }
        Text text = this.xml.createTextNode(value);
        element.appendChild(text);
    }

    void remove(Node node) {
        if (node != null) {
            Node parent = node.getParentNode();
            parent.removeChild(node);
        }
    }

    String getText(Element parent, String tag) {
        return this.getText(this.getElement(parent, tag));
    }

    Element getRoot() {
        if (this.xml == null) {
            return null;
        }
        Element root = this.xml.getDocumentElement();
        if (root == null) {
            root = this.xml.createElement(TAG_ROOT);
            this.xml.appendChild(root);
        }
        return root;
    }

    Element getConfig() {
        return this.getElement(this.getRoot(), TAG_CONFIG1);
    }

    Element getConfig(String tag) {
        return this.getElement(this.getConfig(), tag);
    }

    String getConfigValue(String tag) {
        return this.getText(this.getConfig(tag));
    }

    void setConfigValue(String tag, String value) {
        Element element = this.getConfig(tag);
        if (element != null) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getFirstChild());
            }
            element.appendChild(this.xml.createTextNode(value));
        }
    }

    static String getDefaultProfileName(String mcVersion) {
        return "Minecraft " + mcVersion;
    }

    static boolean isDefaultProfile(String profileName) {
        return profileName.startsWith("Minecraft ");
    }

    void setDefaultProfileName(String profileName) {
        Element root = this.getRoot();
        NodeList list = root.getElementsByTagName(TAG_MODS);
        String name = this.getConfigValue(TAG_SELECTED_PROFILE);
        if (name == null || name.equals("")) {
            this.setConfigValue(TAG_SELECTED_PROFILE, profileName);
        }
        boolean found = false;
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            Node node = list.item(i);
            if (!(node instanceof Element) || (name = (element = (Element)node).getAttribute(ATTR_PROFILE)) != null && !name.equals("")) continue;
            if (found) {
                root.removeChild(element);
                continue;
            }
            element.setAttribute(ATTR_PROFILE, profileName);
            found = true;
        }
    }

    Element findProfileByName(String profileName, boolean create) {
        String name;
        Element element;
        Node node;
        int i;
        Element profile = null;
        Element root = this.getRoot();
        NodeList list = root.getElementsByTagName(TAG_MODS);
        for (i = 0; i < list.getLength(); ++i) {
            node = list.item(i);
            if (!(node instanceof Element)) continue;
            element = (Element)node;
            name = element.getAttribute(ATTR_PROFILE);
            if (profileName != null && !profileName.equals(name)) continue;
            return element;
        }
        if (create) {
            profile = this.xml.createElement(TAG_MODS);
            if (this.selectedProfile != null) {
                list = this.selectedProfile.getElementsByTagName(TAG_MOD);
                for (i = 0; i < list.getLength(); ++i) {
                    node = list.item(i);
                    if (!(node instanceof Element) || !VAL_BUILTIN.equals(name = this.getText(element = (Element)node, TAG_TYPE))) continue;
                    profile.appendChild(node.cloneNode(true));
                }
            }
            profile.setAttribute(ATTR_PROFILE, profileName);
            root.appendChild(profile);
        }
        return profile;
    }

    void selectProfile() {
        this.selectProfile(this.getConfigValue(TAG_SELECTED_PROFILE));
    }

    void selectProfile(String profileName) {
        this.selectedProfile = this.findProfileByName(profileName, true);
        this.setConfigValue(TAG_SELECTED_PROFILE, profileName);
    }

    void deleteProfile(String profileName) {
        Element root = this.getRoot();
        Element profile = this.findProfileByName(profileName, false);
        if (profile != null) {
            if (profile == this.selectedProfile) {
                this.selectedProfile = null;
            }
            root.removeChild(profile);
        }
        this.getMods();
    }

    void renameProfile(String oldName, String newName) {
        Element profile;
        if (!oldName.equals(newName) && (profile = this.findProfileByName(oldName, false)) != null) {
            profile.setAttribute(ATTR_PROFILE, newName);
            String selectedProfile = this.getConfigValue(TAG_SELECTED_PROFILE);
            if (oldName.equals(selectedProfile)) {
                this.setConfigValue(TAG_SELECTED_PROFILE, newName);
            }
        }
    }

    void rewriteModPaths(File oldDir, File newDir) {
        NodeList profiles = this.getRoot().getElementsByTagName(TAG_MODS);
        for (int i = 0; i < profiles.getLength(); ++i) {
            Element profile = (Element)profiles.item(i);
            this.rewriteModPaths(profile, oldDir, newDir);
        }
    }

    void rewriteModPaths(Element profile, File oldDir, File newDir) {
        NodeList mods = profile.getElementsByTagName(TAG_MOD);
        for (int i = 0; i < mods.getLength(); ++i) {
            File currentFile;
            String currentPath;
            Element mod = (Element)mods.item(i);
            String type = this.getText(mod, TAG_TYPE);
            if (!VAL_EXTERNAL_ZIP.equals(type) || (currentPath = this.getText(mod, TAG_PATH)) == null || currentPath.equals("") || !oldDir.equals((currentFile = new File(currentPath)).getParentFile())) continue;
            this.setText(mod, TAG_PATH, new File(newDir, currentFile.getName()).getPath());
        }
    }

    ArrayList<String> getProfiles() {
        ArrayList<String> profiles = new ArrayList<String>();
        Element root = this.getRoot();
        NodeList list = root.getElementsByTagName(TAG_MODS);
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            String name;
            Node node = list.item(i);
            if (!(node instanceof Element) || (name = (element = (Element)node).getAttribute(ATTR_PROFILE)) == null || name.equals("")) continue;
            profiles.add(name);
        }
        Collections.sort(profiles);
        return profiles;
    }

    Element getMods() {
        if (this.selectedProfile == null) {
            this.selectProfile();
        }
        return this.selectedProfile;
    }

    boolean hasMod(String mod) {
        Element parent = this.getMods();
        if (parent != null) {
            NodeList list = parent.getElementsByTagName(TAG_MOD);
            for (int i = 0; i < list.getLength(); ++i) {
                Element element = (Element)list.item(i);
                NodeList list1 = element.getElementsByTagName(TAG_NAME);
                if (list1.getLength() <= 0 || !mod.equals(this.getText(element = (Element)list1.item(0)))) continue;
                return true;
            }
        }
        return false;
    }

    Element getMod(String mod) {
        Element parent = this.getMods();
        if (parent == null) {
            return null;
        }
        NodeList list = parent.getElementsByTagName(TAG_MOD);
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            Node node = list.item(i);
            if (!(node instanceof Element) || !mod.equals(this.getText(element = (Element)node, TAG_NAME))) continue;
            return element;
        }
        Element element = this.xml.createElement(TAG_MOD);
        parent.appendChild(element);
        Element element1 = this.xml.createElement(TAG_NAME);
        Text text = this.xml.createTextNode(mod);
        element1.appendChild(text);
        element.appendChild(element1);
        element1 = this.xml.createElement(TAG_ENABLED);
        element.appendChild(element1);
        element1 = this.xml.createElement(TAG_TYPE);
        element.appendChild(element1);
        return element;
    }

    void setModEnabled(String mod, boolean enabled) {
        this.setText(this.getMod(mod), TAG_ENABLED, Boolean.toString(enabled));
    }

    Element getModConfig(String mod) {
        return this.getElement(this.getMod(mod), TAG_CONFIG1);
    }

    Element getModConfig(String mod, String tag) {
        return this.getElement(this.getModConfig(mod), tag);
    }

    String getModConfigValue(String mod, String tag) {
        return this.getText(this.getModConfig(mod, tag));
    }

    void setModConfigValue(String mod, String tag, String value) {
        Element element = this.getModConfig(mod, tag);
        if (element != null) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getFirstChild());
            }
            element.appendChild(this.xml.createTextNode(value));
        }
    }

    private Element getLogLevelElement(String category) {
        Element config = this.getConfig();
        NodeList list = config.getElementsByTagName(TAG_LOGGING);
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            if (!category.equals(element.getAttribute(TAG_CATEGORY))) continue;
            return element;
        }
        Element element = this.xml.createElement(TAG_LOGGING);
        config.appendChild(element);
        element.setAttribute(TAG_CATEGORY, category);
        return element;
    }

    void setLogLevel(String category, Level level) {
        this.getLogLevelElement(category).setAttribute(TAG_LEVEL, level.toString());
    }

    Level getLogLevel(String category) {
        Level level = Level.INFO;
        Element element = this.getLogLevelElement(category);
        try {
            String attribute = element.getAttribute(TAG_LEVEL);
            if (attribute != null) {
                level = Level.parse(attribute.trim().toUpperCase());
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        element.setAttribute(TAG_LEVEL, level.toString());
        return level;
    }

    private void buildNewProperties() {
        if (this.xml != null) {
            this.getRoot();
            this.getConfig();
            if (this.selectedProfile != null) {
                this.getMods();
                this.setText(this.getMod("HD Textures"), TAG_ENABLED, "true");
                this.setText(this.getMod("HD Font"), TAG_ENABLED, "true");
                this.setText(this.getMod("Better Grass"), TAG_ENABLED, "false");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveProperties() {
        boolean saved = false;
        if (this.xml != null && this.xmlFile != null) {
            FileOutputStream os = null;
            try {
                Transformer trans;
                TransformerFactory factory = TransformerFactory.newInstance();
                try {
                    factory.setAttribute("indent-number", 2);
                    trans = factory.newTransformer(new StreamSource(new StringReader(XSLT_REFORMAT)));
                    trans.setOutputProperty("indent", "yes");
                    trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                }
                catch (Throwable e) {
                    trans = factory.newTransformer();
                }
                DOMSource source = new DOMSource(this.xml);
                os = new FileOutputStream(this.xmlFile);
                trans.transform(source, new StreamResult(new OutputStreamWriter((OutputStream)os, "UTF-8")));
                saved = true;
                MCPatcherUtils.close(os);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(os);
            }
        }
        return saved;
    }
}

