/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassPatch;
import com.pclewis.mcpatcher.ClassSignature;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MCPatcher;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.ModConfigPanel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mod {
    protected String name = "";
    protected String author = "";
    protected String website = "";
    protected String version = "";
    protected String description = "";
    protected ModConfigPanel configPanel = null;
    protected ArrayList<ClassMod> classMods = new ArrayList();
    protected ArrayList<String> filesToAdd = new ArrayList();
    protected boolean defaultEnabled = true;
    protected ClassMap classMap = new ClassMap();
    private ArrayList<String> errors = new ArrayList();
    private boolean enabled = false;
    boolean internal = false;
    File customJar = null;
    ArrayList<Dependency> dependencies = new ArrayList();
    HashMap<String, String> filesAdded = new HashMap();

    public Mod() {
        this.addDependency("__Base");
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getLoggingCategories() {
        return new String[]{this.getName()};
    }

    public void close() {
    }

    public ClassMap getClassMap() {
        return this.classMap;
    }

    public static MinecraftVersion getMinecraftVersion() {
        return MCPatcher.minecraft == null ? null : MCPatcher.minecraft.getVersion();
    }

    void setRefs() {
        for (ClassMod classMod : this.getClassMods()) {
            classMod.mod = this;
            classMod.bestMatch = null;
            classMod.bestMatchCount = 0;
            for (ClassSignature classSignature : classMod.classSignatures) {
                classSignature.setClassMod(classMod);
            }
            for (ClassPatch classPatch : classMod.patches) {
                classPatch.setClassMod(classMod);
            }
        }
    }

    void resetCounts() {
        this.filesAdded.clear();
        for (ClassMod classMod : this.getClassMods()) {
            for (ClassPatch classPatch : classMod.patches) {
                classPatch.numMatches.clear();
            }
        }
    }

    ArrayList<ClassMod> getClassMods() {
        return this.classMods;
    }

    boolean okToApply() {
        return this.errors.size() == 0 && this.getErrors().size() == 0;
    }

    protected final void addError(String error) {
        this.errors.add(error);
    }

    protected Mod clearPatches() {
        for (ClassMod classMod : this.classMods) {
            classMod.patches.clear();
        }
        this.filesToAdd.clear();
        return this;
    }

    protected void addClassMod(ClassMod classMod) {
        classMod.mod = this;
        this.classMods.add(classMod);
    }

    protected void addFile(String filename) {
        this.filesToAdd.add(filename);
    }

    protected void addClassFile(String className) {
        this.addFile(ClassMap.classNameToFilename(className));
    }

    ArrayList<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>(this.errors);
        for (ClassMod classMod : this.classMods) {
            if (classMod.okToApply()) continue;
            for (String s : classMod.errors) {
                errors.add(String.format("%s: %s", classMod.getDeobfClass(), s));
            }
        }
        return errors;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    void loadOptions() {
        if (this.configPanel != null) {
            this.configPanel.load();
        }
    }

    public InputStream openFile(String name) throws IOException {
        InputStream inputStream = null;
        URL url = this.getClass().getResource(name);
        if (url != null) {
            url = new URL(url.toString().replaceAll("!(?=.*!)", "%21"));
            inputStream = url.openStream();
        }
        if (inputStream == null) {
            Logger.log(0, "WARNING: openStream failed, retrying with getResourceAsStream", new Object[0]);
            inputStream = this.getClass().getResourceAsStream(name);
        }
        if (inputStream == null) {
            Logger.log(0, "WARNING: getResourceAsStream failed, retrying with getContextClassLoader", new Object[0]);
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        }
        if (inputStream == null) {
            Logger.log(0, "WARNING: getContextClassLoader failed, giving up", new Object[0]);
        }
        return inputStream;
    }

    protected final void addDependency(String name) {
        this.dependencies.add(new Dependency(name, true));
    }

    protected final void addConflict(String name) {
        this.dependencies.add(new Dependency(name, false));
    }

    class Dependency {
        String name;
        boolean required;

        Dependency(String name, boolean required) {
            this.name = name;
            this.required = required;
        }
    }
}

