/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.OrSignature;
import java.io.IOException;

public class BetterGlass
extends Mod {
    private static final int EXTRA_PASSES = 2;
    private static final MethodRef glEnable = new MethodRef("org.lwjgl.opengl.GL11", "glEnable", "(I)V");
    private static final MethodRef glDisable = new MethodRef("org.lwjgl.opengl.GL11", "glDisable", "(I)V");
    private static final MethodRef glDepthMask = new MethodRef("org.lwjgl.opengl.GL11", "glDepthMask", "(Z)V");
    private static final MethodRef glShadeModel = new MethodRef("org.lwjgl.opengl.GL11", "glShadeModel", "(I)V");
    private static final MethodRef glCallList = new MethodRef("org.lwjgl.opengl.GL11", "glCallList", "(I)V");
    private static final MethodRef getRenderBlockPass = new MethodRef("Block", "getRenderBlockPass", "()I");
    private static final MethodRef enableLightmap = new MethodRef("EntityRenderer", "enableLightmap", "(D)V");
    private static final MethodRef disableLightmap = new MethodRef("EntityRenderer", "disableLightmap", "(D)V");

    public BetterGlass(MinecraftVersion minecraftVersion) {
        this.name = "Better Glass";
        this.author = "MCPatcher";
        this.description = "Enables partial transparency for glass blocks.";
        this.version = "1.9";
        this.addDependency("__TexturePackBase");
        this.addDependency("Connected Textures");
        this.addClassMod(new BaseMod.MinecraftMod());
        this.addClassMod(new BaseMod.BlockMod());
        this.addClassMod(new BaseMod.IBlockAccessMod());
        this.addClassMod(new WorldRendererMod());
        this.addClassMod(new EntityRendererMod());
        this.addClassMod(new RenderGlobalMod());
        this.addClassMod(new RenderBlocksMod());
        this.addClassFile("com.pclewis.mcpatcher.mod.RenderPass");
        this.addClassFile("com.pclewis.mcpatcher.mod.RenderPass$1");
        this.addClassFile("com.pclewis.mcpatcher.mod.RenderPass$2");
    }

    private class RenderBlocksMod
    extends BaseMod.RenderBlocksMod {
        RenderBlocksMod() {
            MethodRef renderStandardBlockWithAmbientOcclusion = new MethodRef(this.getDeobfClass(), "renderStandardBlockWithAmbientOcclusion", "(LBlock;IIIFFF)Z");
            FieldRef renderAllFaces = new FieldRef(this.getDeobfClass(), "renderAllFaces", "Z");
            FieldRef blockAccess = new FieldRef(this.getDeobfClass(), "blockAccess", "LIBlockAccess;");
            final MethodRef shouldSideBeRendered = new MethodRef("Block", "shouldSideBeRendered", "(LIBlockAccess;IIII)Z");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(983055));
                }
            }.setMethod(renderStandardBlockWithAmbientOcclusion));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), 154, BinaryRegex.any(2), 43, 42, BytecodeMatcher.captureReference(180), 28, 29, this.push(1), 100, 21, 4, this.push(0), BytecodeMatcher.captureReference(182), 153, BinaryRegex.any(2));
                }
            }.setMethod(renderStandardBlockWithAmbientOcclusion).addXref(1, renderAllFaces).addXref(2, blockAccess).addXref(3, shouldSideBeRendered));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "override AO block brightness for extra render passes";
                }

                public String getMatchExpression() {
                    return this.buildExpression(153, BinaryRegex.any(2), BinaryRegex.capture(BytecodeMatcher.anyFLOAD), 167, BinaryRegex.any(2), this.push(Float.valueOf(1.0f)), BinaryRegex.capture(BinaryRegex.or(BinaryRegex.build(this.push(Float.valueOf(0.5f))), BinaryRegex.build(this.push(Float.valueOf(0.6f))), BinaryRegex.build(this.push(Float.valueOf(0.8f))))), 106);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(153, RenderBlocksMod.this.branch("A"), this.getCaptureGroup(1), 167, RenderBlocksMod.this.branch("B"), RenderBlocksMod.this.label("A"), this.push(Float.valueOf(1.0f)), RenderBlocksMod.this.label("B"), this.getCaptureGroup(2), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.RenderPass", "getAOBaseMultiplier", "(F)F")), 106);
                }
            }.targetMethod(renderStandardBlockWithAmbientOcclusion));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "render all sides of adjacent blocks";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, shouldSideBeRendered)});
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.RenderPass", "shouldSideBeRendered", "(LBlock;LIBlockAccess;IIII)Z"))});
                }
            });
        }
    }

    private class RenderGlobalMod
    extends ClassMod {
        RenderGlobalMod() {
            FieldRef glRenderListBase = new FieldRef(this.getDeobfClass(), "glRenderListBase", "I");
            MethodRef loadRenderers = new MethodRef(this.getDeobfClass(), "loadRenderers", "()V");
            MethodRef renderAllRenderLists = new MethodRef(this.getDeobfClass(), "renderAllRenderLists", "(ID)V");
            final MethodRef generateDisplayLists = new MethodRef("GLAllocation", "generateDisplayLists", "(I)I");
            this.addClassSignature(new ConstSignature("smoke"));
            this.addClassSignature(new ConstSignature("/environment/clouds.png"));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(3), 104, BytecodeMatcher.captureReference(184), BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, generateDisplayLists).addXref(2, glRenderListBase));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyILOAD, this.push(16), 108, this.push(1), 96);
                }
            }.setMethod(loadRenderers));
            this.addClassSignature(new OrSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.anyReference(180), 58, BinaryRegex.capture(BinaryRegex.any()), 25, BinaryRegex.backReference(1), 190, BinaryRegex.build(54, BinaryRegex.any()));
                }
            }.setMethod(renderAllRenderLists), new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(0), 54, BinaryRegex.capture(BinaryRegex.any()), 21, BinaryRegex.backReference(1), 42, BytecodeMatcher.captureReference(180), 190, BytecodeMatcher.IF_ICMPGE_or_IF_ICMPLT, BinaryRegex.any(2), 42, BinaryRegex.backReference(2), 21, BinaryRegex.backReference(1), 50);
                }
            }.setMethod(renderAllRenderLists)));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "increase gl render lists per chunk from 3 to 5 (init)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(3), BinaryRegex.lookAhead(BinaryRegex.build(104, this.reference(184, generateDisplayLists)), true));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.push(5));
                }
            }.matchConstructorOnly(true));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "increase gl render lists per chunk from 3 to 5 (loop)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(132, BinaryRegex.capture(BinaryRegex.any()), 3);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(132, this.getCaptureGroup(1), 5);
                }
            }.targetMethod(loadRenderers));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "set up lightmap for extra render passes";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.lookBehind(BinaryRegex.build(42, BytecodeMatcher.anyReference(180), BytecodeMatcher.anyReference(180), 40), true), this.reference(182, enableLightmap));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(27, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.RenderPass", "enableDisableLightmap", "(LEntityRenderer;DI)V")));
                }
            }.targetMethod(renderAllRenderLists));
        }
    }

    private class EntityRendererMod
    extends ClassMod {
        EntityRendererMod() {
            MethodRef renderWorld = new MethodRef(this.getDeobfClass(), "renderWorld", "(FJ)V");
            final MethodRef renderRainSnow = new MethodRef(this.getDeobfClass(), "renderRainSnow", "(F)V");
            final MethodRef sortAndRender = new MethodRef("RenderGlobal", "sortAndRender", "(LEntityLiving;ID)I");
            final MethodRef doRenderPass = new MethodRef("com.pclewis.mcpatcher.mod.RenderPass", "doRenderPass", "(LRenderGlobal;LEntityLiving;ID)V");
            this.addClassSignature(new ConstSignature("/terrain.png"));
            this.addClassSignature(new ConstSignature("/environment/snow.png"));
            this.addClassSignature(new ConstSignature("ambient.weather.rain"));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(25, 5, 25, 4, this.push(1), 35, 141, BytecodeMatcher.captureReference(182), 54, BinaryRegex.any());
                }
            }.setMethod(renderWorld).addXref(1, sortAndRender));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(3553), this.reference(184, glDisable));
                }
            }.setMethod(disableLightmap));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(3553), this.reference(184, glEnable));
                }
            }.setMethod(enableLightmap));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/environment/snow.png"));
                }
            }.setMethod(renderRainSnow));
            this.addPatch(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "set gl shade model";
                }

                public String getMatchExpression() {
                    return this.buildExpression(153, BinaryRegex.any(2), this.push(7425), this.reference(184, glShadeModel));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.RenderPass", "setAmbientOcclusion", "(Z)Z"))});
                }
            });
            this.addPatch(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "do extra render pass 2";
                }

                public String getMatchExpression() {
                    return this.buildExpression(25, 5, 25, 4, this.push(0), 35, 141, this.reference(182, sortAndRender), 87);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(25, 5, 25, 4, this.push(2), 35, 141, this.reference(184, doRenderPass));
                }
            });
            this.addPatch(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "do extra render pass 3";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(1), this.reference(184, glDepthMask), this.push(2884), this.reference(184, glEnable), this.push(3042), this.reference(184, glDisable));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, 35, this.reference(182, renderRainSnow), 25, 5, 25, 4, this.push(3), 35, 141, this.reference(184, doRenderPass));
                }
            }.targetMethod(renderWorld));
        }
    }

    private class WorldRendererMod
    extends ClassMod {
        private int loopRegister;

        WorldRendererMod() {
            MethodRef updateRenderer = new MethodRef(this.getDeobfClass(), "updateRenderer", "()V");
            final FieldRef glRenderList = new FieldRef(this.getDeobfClass(), "glRenderList", "I");
            final FieldRef skipRenderPass = new FieldRef(this.getDeobfClass(), "skipRenderPass", "[Z");
            final MethodRef startPass = new MethodRef("com.pclewis.mcpatcher.mod.RenderPass", "start", "(I)V");
            final MethodRef canRenderInPass1 = new MethodRef("forge/ForgeHooksClient", "canRenderInPass", "(LBlock;I)Z");
            final MethodRef canRenderInPass2 = new MethodRef("Block", "canRenderInPass", "(I)Z");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyALOAD, BytecodeMatcher.captureReference(182), 54, BinaryRegex.capture(BinaryRegex.any()), BinaryRegex.any(0, 30), 21, BinaryRegex.backReference(2), 21, BinaryRegex.any(), 159, BinaryRegex.any(2), this.push(1), 54, BinaryRegex.any());
                }
            }.setMethod(updateRenderer).addXref(1, getRenderBlockPass));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), this.push(2), 96, this.reference(184, glCallList));
                }
            }.addXref(1, glRenderList));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(skipRenderPass));
            this.addPatch(new RenderPassPatch("init"){

                protected String getPrefix() {
                    return this.buildExpression(42);
                }

                protected String getSuffix() {
                    return this.buildExpression(188, 4, this.reference(181, skipRenderPass));
                }
            }.matchConstructorOnly(true));
            this.addPatch(new RenderPassPatch("loop"){

                protected String getPrefix() {
                    return this.buildExpression(BytecodeMatcher.anyILOAD);
                }

                protected String getSuffix() {
                    return this.buildExpression(BytecodeMatcher.IF_ICMPLT_or_IF_ICMPGE, BinaryRegex.any(2));
                }
            });
            this.addPatch(new RenderPassPatch("occlusion"){

                protected String getPrefix() {
                    return this.buildExpression(42, this.reference(180, glRenderList));
                }

                protected String getSuffix() {
                    return this.buildExpression(96);
                }
            });
            this.addPatch(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "pre render pass";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(0), 54, BinaryRegex.capture(BinaryRegex.any()), this.push(0), 54, BinaryRegex.any(), this.push(0), 54, BinaryRegex.any());
                }

                public byte[] getInsertBytes() throws IOException {
                    WorldRendererMod.this.loopRegister = (this.getCaptureGroup(1)[0] & 0xFF) - 1;
                    Logger.log(3, "loop register %d", WorldRendererMod.this.loopRegister);
                    return this.buildCode(21, WorldRendererMod.this.loopRegister, this.reference(184, startPass));
                }
            }.targetMethod(updateRenderer));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "prevent early loop exit";
                }

                public String getMatchExpression() {
                    return this.buildExpression(21, WorldRendererMod.this.loopRegister + 1, 154, BinaryRegex.any(2), 167, BinaryRegex.any(2));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[0]);
                }
            }.targetMethod(updateRenderer));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "increase render passes from 2 to 4 (&&)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, skipRenderPass), this.push(0), 51, 153, BinaryRegex.any(2), 42, this.reference(180, skipRenderPass), this.push(1), 51, 153, BinaryRegex.any(2), this.push(1), BinaryRegex.or(BinaryRegex.build(172), BinaryRegex.build(167, BinaryRegex.any(2))), this.push(0), 172);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, skipRenderPass), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.RenderPass", "skipAllRenderPasses", "([Z)Z")), 172);
                }
            });
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "set up extra render pass";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, getRenderBlockPass)});
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.RenderPass", "getBlockRenderPass", "(LBlock;)I"))});
                }
            }.targetMethod(updateRenderer));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "set up extra render pass (forge)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(new Object[]{this.reference(184, canRenderInPass1)}), BinaryRegex.build(new Object[]{this.reference(182, canRenderInPass2)})));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(92, this.getMatch(), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.RenderPass", "canRenderInPass", "(LBlock;IZ)Z")));
                }
            }.targetMethod(updateRenderer));
        }

        private abstract class RenderPassPatch
        extends BytecodePatch {
            private final String tag;

            RenderPassPatch(String tag) {
                this.tag = tag;
            }

            public String getDescription() {
                return "increase render passes from 2 to 4 (" + this.tag + ")";
            }

            public final String getMatchExpression() {
                return this.buildExpression(BinaryRegex.lookBehind(this.getPrefix(), true), this.push(2), BinaryRegex.lookAhead(this.getSuffix(), true));
            }

            public final byte[] getReplacementBytes() throws IOException {
                return this.buildCode(this.push(4));
            }

            protected abstract String getPrefix();

            protected abstract String getSuffix();
        }
    }
}

