/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.AddFieldPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.InterfaceMethodRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import java.io.IOException;

public class BetterGrass
extends Mod {
    private static final String field_MATRIX = "grassMatrix";
    private static final String fieldtype_MATRIX = "[[I";
    final MethodRef getBlockTexture = new MethodRef("Block", "getBlockTexture", "(LIBlockAccess;IIII)I");
    private final boolean haveAO;

    public BetterGrass(MinecraftVersion minecraftVersion) {
        this.name = "Better Grass";
        this.author = "MCPatcher";
        this.description = "Improves the look of the sides of grass blocks. Inspired by MrMessiah's mod.";
        this.version = "1.1";
        this.defaultEnabled = false;
        this.haveAO = minecraftVersion.compareTo("Beta 1.6") >= 0;
        this.addClassMod(new BlockMod());
        this.addClassMod(new BlockGrassMod("Grass", 2, 3, 0));
        if (minecraftVersion.compareTo("Beta 1.9 Prerelease 1") >= 0) {
            this.addClassMod(new BlockGrassMod("Mycelium", 110, 77, 78));
        }
        this.addClassMod(new BaseMod.IBlockAccessMod().mapMaterial());
        this.addClassMod(new RenderBlocksMod());
    }

    public String[] getLoggingCategories() {
        return null;
    }

    private class RenderBlocksMod
    extends BaseMod.RenderBlocksMod {
        private final FieldRef blockAccess = new FieldRef(this.getDeobfClass(), "blockAccess", "LIBlockAccess;");
        private final MethodRef renderStandardBlockWithColorMultiplier = new MethodRef(this.getDeobfClass(), "renderStandardBlockWithColorMultiplier", "(LBlock;IIIFFF)Z");
        private final MethodRef getBlockTexture = new MethodRef("Block", "getBlockTexture", "(LIBlockAccess;IIII)I");

        RenderBlocksMod() {
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(0.5f)), BytecodeMatcher.anyFSTORE, this.push(Float.valueOf(1.0f)), BytecodeMatcher.anyFSTORE, this.push(Float.valueOf(0.8f)), BytecodeMatcher.anyFSTORE, this.push(Float.valueOf(0.6f)), BytecodeMatcher.anyFSTORE);
                }
            }.setMethod(this.renderStandardBlockWithColorMultiplier));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.blockAccess));
            this.addPatch(new BytecodePatch(){
                private int redMultiplier;
                private int greenMultiplier;
                private int blueMultiplier;
                {
                    this.addPreMatchSignature(new BytecodeSignature(){

                        public String getMatchExpression() {
                            return this.buildExpression(this.push(Float.valueOf(0.5f)), 56, BinaryRegex.any(), this.push(Float.valueOf(1.0f)), 56, BinaryRegex.capture(BinaryRegex.any()), this.push(Float.valueOf(0.8f)), 56, BinaryRegex.any(), this.push(Float.valueOf(0.6f)), 56, BinaryRegex.any(), BinaryRegex.any(0, 20), 23, BinaryRegex.backReference(1), 23, 5, 106, 56, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.backReference(1), 23, 6, 106, 56, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.backReference(1), 23, 7, 106, 56, BinaryRegex.capture(BinaryRegex.any()));
                        }

                        public boolean afterMatch() {
                            redMultiplier = this.matcher.getCaptureGroup(2)[0] & 0xFF;
                            greenMultiplier = this.matcher.getCaptureGroup(3)[0] & 0xFF;
                            blueMultiplier = this.matcher.getCaptureGroup(4)[0] & 0xFF;
                            Logger.log(3, "non-AO multipliers (R G B) = (%d %d %d)", redMultiplier, greenMultiplier, blueMultiplier);
                            return true;
                        }
                    });
                }

                public String getDescription() {
                    return "if (getBlockTexture == 0) useBiomeColor = true (non-AO pre-1.8)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(25, BinaryRegex.capture(BinaryRegex.any()), BytecodeMatcher.anyFLOAD, 23, BinaryRegex.capture(BinaryRegex.any()), 106, BytecodeMatcher.anyFLOAD, 23, BinaryRegex.backReference(3), 106, BytecodeMatcher.anyFLOAD, 23, BinaryRegex.backReference(3), 106, BytecodeMatcher.captureReference(182))), BinaryRegex.capture(BinaryRegex.build(43, 42, this.reference(180, new FieldRef("RenderBlocks", "blockAccess", "LIBlockAccess;")), 28, 29, 21, 4, BinaryRegex.any(1, 2), this.reference(182, new MethodRef("Block", "getBlockTexture", "(LIBlockAccess;IIII)I")))), 54, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(5), 89, 54, this.getCaptureGroup(6), 154, RenderBlocksMod.this.branch("A"), 25, this.getCaptureGroup(2), 23, this.redMultiplier, 23, this.getCaptureGroup(3), 106, 23, this.greenMultiplier, 23, this.getCaptureGroup(3), 106, 23, this.blueMultiplier, 23, this.getCaptureGroup(3), 106, this.getCaptureGroup(4), 167, RenderBlocksMod.this.branch("B"), RenderBlocksMod.this.label("A"), this.getCaptureGroup(1), RenderBlocksMod.this.label("B"));
                }
            }.targetMethod(this.renderStandardBlockWithColorMultiplier));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "if (getBlockTexture == 0) useBiomeColor = true (non-AO post-1.8)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(43, 42, this.reference(180, new FieldRef("RenderBlocks", "blockAccess", "LIBlockAccess;")), 28, 29, 21, 4, BinaryRegex.any(1, 2), this.reference(182, new MethodRef("Block", "getBlockTexture", "(LIBlockAccess;IIII)I")), 54, BinaryRegex.capture(BinaryRegex.any()))), BinaryRegex.capture(BinaryRegex.build(BinaryRegex.nonGreedy(BinaryRegex.any(20, 60)), 25, BinaryRegex.capture(BinaryRegex.any()), BytecodeMatcher.anyFLOAD, 23, BinaryRegex.capture(BinaryRegex.any()), 106, BytecodeMatcher.anyFLOAD, 23, BinaryRegex.capture(BinaryRegex.any()), 106, BytecodeMatcher.anyFLOAD, 23, BinaryRegex.capture(BinaryRegex.any()), 106, BytecodeMatcher.captureReference(182))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), 21, this.getCaptureGroup(2), 154, RenderBlocksMod.this.branch("A"), 25, this.getCaptureGroup(4), 23, 5, 23, this.getCaptureGroup(5), 106, 23, 6, 23, this.getCaptureGroup(6), 106, 23, 7, 23, this.getCaptureGroup(7), 106, this.getCaptureGroup(8), RenderBlocksMod.this.label("A"), this.getCaptureGroup(3));
                }
            }.targetMethod(this.renderStandardBlockWithColorMultiplier));
            if (BetterGrass.this.haveAO) {
                this.setupAO();
            }
        }

        private void setupAO() {
            MethodRef renderStandardBlockWithAmbientOcclusion = new MethodRef(this.getDeobfClass(), "renderStandardBlockWithAmbientOcclusion", "(LBlock;IIIFFF)Z");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(983055));
                }
            }.setMethod(renderStandardBlockWithAmbientOcclusion));
            this.addPatch(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "if (getBlockTexture == 0) useBiomeColor = true (AO)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(0), BinaryRegex.or(BinaryRegex.build(89, 54, BinaryRegex.capture(BinaryRegex.any()), 89, 54, BinaryRegex.capture(BinaryRegex.any()), 89, 54, BinaryRegex.capture(BinaryRegex.any()), 89, 54, BinaryRegex.capture(BinaryRegex.any())), BinaryRegex.build(54, BinaryRegex.capture(BinaryRegex.any()), this.push(0), 54, BinaryRegex.capture(BinaryRegex.any()), this.push(0), 54, BinaryRegex.capture(BinaryRegex.any()), this.push(0), 54, BinaryRegex.capture(BinaryRegex.any()), this.push(0))), BytecodeMatcher.anyISTORE);
                }

                public byte[] getInsertBytes() throws IOException {
                    byte[][] m;
                    int southFace = m[(m = new byte[][]{this.getCaptureGroup(1), this.getCaptureGroup(2), this.getCaptureGroup(3), this.getCaptureGroup(4), this.getCaptureGroup(5), this.getCaptureGroup(6), this.getCaptureGroup(7), this.getCaptureGroup(8)})[0] == null ? 4 : 0][0] & 0xFF;
                    int northFace = m[m[1] == null ? 5 : 1][0] & 0xFF;
                    int westFace = m[m[2] == null ? 6 : 2][0] & 0xFF;
                    int eastFace = m[m[3] == null ? 7 : 3][0] & 0xFF;
                    Logger.log(5, "AO faces (N S E W) = (%d %d %d %d)", northFace, southFace, eastFace, westFace);
                    return this.buildCode(this.getCodeForFace(eastFace, 2, "east"), this.getCodeForFace(westFace, 3, "west"), this.getCodeForFace(northFace, 4, "north"), this.getCodeForFace(southFace, 5, "south"));
                }

                private Object[] getCodeForFace(int register, int face, String label) {
                    return new Object[]{43, 42, this.reference(180, RenderBlocksMod.this.blockAccess), 28, 29, 21, 4, this.push(face), this.reference(182, RenderBlocksMod.this.getBlockTexture), 154, RenderBlocksMod.this.branch(label), 4, BytecodeMatcher.registerLoadStore(54, register), RenderBlocksMod.this.label(label)};
                }
            }.targetMethod(renderStandardBlockWithAmbientOcclusion));
        }
    }

    private class BlockGrassMod
    extends ClassMod {
        private final String blockName;

        BlockGrassMod(String blockName, final int blockID, final int halfTextureID, final int fullTextureID) {
            this.blockName = blockName;
            final FieldRef snow = new FieldRef("Material", "snow", "LMaterial;");
            final FieldRef builtSnow = new FieldRef("Material", "builtSnow", "LMaterial;");
            final FieldRef grassMatrix = new FieldRef(this.getDeobfClass(), BetterGrass.field_MATRIX, BetterGrass.fieldtype_MATRIX);
            final InterfaceMethodRef getBlockMaterial = new InterfaceMethodRef("IBlockAccess", "getBlockMaterial", "(III)LMaterial;");
            final InterfaceMethodRef getBlockId = new InterfaceMethodRef("IBlockAccess", "getBlockId", "(III)I");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.captureReference(185), 58, BinaryRegex.capture(BinaryRegex.any()), BinaryRegex.any(0, 20), 25, BinaryRegex.backReference(2), BytecodeMatcher.captureReference(178), 165, BinaryRegex.any(2), 25, BinaryRegex.backReference(2), BytecodeMatcher.captureReference(178), BytecodeMatcher.IF_ACMPNE_or_IF_ACMPEQ, BinaryRegex.any(2), BinaryRegex.or(BinaryRegex.build(this.push(68)), BinaryRegex.build(this.push(halfTextureID))), BinaryRegex.or(BinaryRegex.build(172), BinaryRegex.build(167, BinaryRegex.any(2))), BinaryRegex.or(BinaryRegex.build(this.push(68)), BinaryRegex.build(this.push(halfTextureID))), 172);
                }
            }.addXref(1, getBlockMaterial).addXref(3, snow).addXref(4, builtSnow).setMethod(BetterGrass.this.getBlockTexture));
            this.addPatch(new AddFieldPatch(grassMatrix, 9));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "initialize grassMatrix";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(178, grassMatrix), 199, BlockGrassMod.this.branch("A"), this.push(4), this.push(2), this.reference(197, new ClassRef(BetterGrass.fieldtype_MATRIX)), 2, this.reference(179, grassMatrix), this.reference(178, grassMatrix), this.push(0), 50, this.push(1), this.push(-1), 79, this.reference(178, grassMatrix), this.push(1), 50, this.push(1), this.push(1), 79, this.reference(178, grassMatrix), this.push(2), 50, this.push(0), this.push(-1), 79, this.reference(178, grassMatrix), this.push(3), 50, this.push(0), this.push(1), 79, BlockGrassMod.this.label("A"), 177);
                }
            }.matchConstructorOnly(true));
            this.addPatch(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "check surrounding blocks in getBlockTexture";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.reference(185, getBlockMaterial), 58, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getInsertBytes() throws IOException {
                    int material = this.getCaptureGroup(1)[0] & 0xFF;
                    return this.buildCode(132, 5, -2, 25, material, this.reference(178, snow), 165, BlockGrassMod.this.branch("A"), 25, material, this.reference(178, builtSnow), 165, BlockGrassMod.this.branch("A"), 25, 1, 21, 2, this.reference(178, grassMatrix), 21, 5, 50, this.push(0), 46, 96, 21, 3, this.push(1), 100, 21, 4, this.reference(178, grassMatrix), 21, 5, 50, this.push(1), 46, 96, this.reference(185, getBlockId), this.push(blockID), 159, BlockGrassMod.this.branch("B"), this.push(halfTextureID), 172, BlockGrassMod.this.label("B"), this.push(fullTextureID), 172, BlockGrassMod.this.label("A"), 25, 1, 21, 2, this.reference(178, grassMatrix), 21, 5, 50, this.push(0), 46, 96, 21, 3, 21, 4, this.reference(178, grassMatrix), 21, 5, 50, this.push(1), 46, 96, this.reference(185, getBlockMaterial), 58, material, 25, material, this.reference(178, snow), 165, BlockGrassMod.this.branch("C"), 25, material, this.reference(178, builtSnow), 165, BlockGrassMod.this.branch("C"), this.push(68), 172, BlockGrassMod.this.label("C"), this.push(66), 172);
                }
            }.targetMethod(BetterGrass.this.getBlockTexture));
        }

        public String getDeobfClass() {
            return "Block" + this.blockName;
        }
    }

    private class BlockMod
    extends BaseMod.BlockMod {
        BlockMod() {
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(BetterGrass.this.getBlockTexture));
        }
    }
}

