/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.pclewis.mcpatcher.AddFieldPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.InterfaceMethodRef;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MakeMemberPublicPatch;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.ModConfigPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javassist.bytecode.MethodInfo;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConnectedTextures
extends Mod {
    public ConnectedTextures(MinecraftVersion minecraftVersion) {
        this.name = "Connected Textures";
        this.author = "MCPatcher";
        this.description = "Connects adjacent blocks of the same type.";
        this.version = "1.5";
        this.addDependency("__TexturePackBase");
        this.configPanel = new ConfigPanel();
        this.addClassMod(new MinecraftMod());
        this.addClassMod(new RenderEngineMod());
        this.addClassMod(new BaseMod.IBlockAccessMod());
        this.addClassMod(new BlockMod());
        this.addClassMod(new TessellatorMod(minecraftVersion));
        this.addClassMod(new RenderBlocksMod());
        this.addClassMod(new WorldRendererMod());
        this.addClassFile("com.pclewis.mcpatcher.mod.CTMUtils");
        this.addClassFile("com.pclewis.mcpatcher.mod.CTMUtils$1");
        this.addClassFile("com.pclewis.mcpatcher.mod.SuperTessellator");
        this.addClassFile("com.pclewis.mcpatcher.mod.TileOverride");
        this.addClassFile("com.pclewis.mcpatcher.mod.TileOverride$CTM");
        this.addClassFile("com.pclewis.mcpatcher.mod.TileOverride$Random1");
        this.addClassFile("com.pclewis.mcpatcher.mod.TileOverride$Fixed");
        this.addClassFile("com.pclewis.mcpatcher.mod.TileOverride$Horizontal");
        this.addClassFile("com.pclewis.mcpatcher.mod.TileOverride$Vertical");
        this.addClassFile("com.pclewis.mcpatcher.mod.TileOverride$Top");
        this.addClassFile("com.pclewis.mcpatcher.mod.TileOverride$Repeat");
        this.addClassFile("com.pclewis.mcpatcher.mod.GlassPaneRenderer");
        this.addClassFile("com.pclewis.mcpatcher.mod.RenderPassAPI");
        this.getClassMap().addInheritance("Tessellator", "com.pclewis.mcpatcher.mod.SuperTessellator");
    }

    private class WorldRendererMod
    extends ClassMod {
        WorldRendererMod() {
            MethodRef updateRenderer = new MethodRef(this.getDeobfClass(), "updateRenderer", "()V");
            final MethodRef start = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "start", "()V");
            final MethodRef finish = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "finish", "()V");
            this.addClassSignature(new ConstSignature(new MethodRef("org.lwjgl.opengl.GL11", "glNewList", "(II)V")));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(1.000001f)));
                }
            }.setMethod(updateRenderer));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "pre render world";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, start)});
                }
            }.targetMethod(updateRenderer));
            this.addPatch(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "post render world";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, finish)});
                }
            }.targetMethod(updateRenderer));
        }
    }

    private class RenderBlocksMod
    extends BaseMod.RenderBlocksMod {
        private final MethodRef[] faceMethods = new MethodRef[6];
        private final FieldRef overrideBlockTexture = new FieldRef(this.getDeobfClass(), "overrideBlockTexture", "I");
        private final FieldRef blockAccess = new FieldRef(this.getDeobfClass(), "blockAccess", "LIBlockAccess;");
        private final FieldRef instance = new FieldRef("Tessellator", "instance", "LTessellator;");
        private final MethodRef renderStandardBlock = new MethodRef(this.getDeobfClass(), "renderStandardBlock", "(LBlock;III)Z");
        private final MethodRef drawCrossedSquares;
        private final MethodRef renderBlockPane = new MethodRef(this.getDeobfClass(), "renderBlockPane", "(LBlockPane;III)Z");
        private final MethodRef addVertexWithUV = new MethodRef("Tessellator", "addVertexWithUV", "(DDDDD)V");
        private final MethodRef setup = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "setup", "(LRenderBlocks;LBlock;IIIII)Z");
        private final MethodRef setupNoFace = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "setup", "(LRenderBlocks;LBlock;IIII)Z");
        private final MethodRef reset = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "reset", "()V");
        private final FieldRef newTextureIndex = new FieldRef("com.pclewis.mcpatcher.mod.CTMUtils", "newTextureIndex", "I");
        private final FieldRef newTessellator = new FieldRef("com.pclewis.mcpatcher.mod.CTMUtils", "newTessellator", "LTessellator;");
        private final MethodRef skipDefaultRendering = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "skipDefaultRendering", "(LBlock;)Z");

        RenderBlocksMod() {
            this.drawCrossedSquares = Mod.getMinecraftVersion().compareTo("12w34a") >= 0 ? new MethodRef(this.getDeobfClass(), "drawCrossedSquares", "(LBlock;IDDDF)V") : new MethodRef(this.getDeobfClass(), "drawCrossedSquares", "(LBlock;IDDD)V");
            this.setupBlockFace(0, "Bottom");
            this.setupBlockFace(1, "Top");
            this.setupBlockFace(2, "North");
            this.setupBlockFace(3, "South");
            this.setupBlockFace(4, "West");
            this.setupBlockFace(5, "East");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, 43, 28, 29, 21, 4, BytecodeMatcher.captureReference(182), 87, 42, this.push(156), BytecodeMatcher.captureReference(181));
                }
            }.addXref(1, this.renderStandardBlock).addXref(2, this.overrideBlockTexture));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(21, 5, this.push(18), BytecodeMatcher.IF_ICMPNE_or_IF_ICMPEQ, BinaryRegex.any(2), 42, 43, BytecodeMatcher.anyReference(192), 28, 29, 21, 4, BytecodeMatcher.captureReference(182), 172);
                }
            }.addXref(1, this.renderBlockPane));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.blockAccess));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.faceMethods));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.drawCrossedSquares));
            this.addPatch(new BytecodePatch.InsertBefore(){
                private int tessellatorRegister;
                private JavaRef renderBlockPaneMapped;
                {
                    this.addPreMatchSignature(new BytecodeSignature(){

                        public String getMatchExpression() {
                            return this.buildExpression(this.reference(178, RenderBlocksMod.this.instance), 58, BinaryRegex.capture(BinaryRegex.any()));
                        }

                        public boolean afterMatch() {
                            tessellatorRegister = this.getCaptureGroup(1)[0] & 0xFF;
                            return true;
                        }
                    });
                }

                public String getDescription() {
                    return "override texture (other blocks)";
                }

                public boolean filterMethod() {
                    MethodInfo methodInfo;
                    if (this.renderBlockPaneMapped == null) {
                        this.renderBlockPaneMapped = this.map(RenderBlocksMod.this.renderBlockPane);
                    }
                    return (methodInfo = this.getMethodInfo()).getDescriptor().matches("^\\(L[a-z]+;III.*") && (!methodInfo.getDescriptor().equals(this.renderBlockPaneMapped.getType()) || !methodInfo.getName().equals(this.renderBlockPaneMapped.getName()));
                }

                public String getMatchExpression() {
                    return this.buildExpression(21, BinaryRegex.capture(BinaryRegex.any()), this.push(15), 126, this.push(4), 120, 54, BinaryRegex.any(), 21, BinaryRegex.backReference(1), this.push(240), 126, 54, BinaryRegex.any());
                }

                public byte[] getInsertBytes() throws IOException {
                    Logger.log(5, "tessellator register %d", this.tessellatorRegister);
                    return this.buildCode(42, this.reference(180, RenderBlocksMod.this.overrideBlockTexture), 156, RenderBlocksMod.this.branch("A"), 42, 43, 28, 29, 21, 4, 21, this.getCaptureGroup(1), this.reference(184, RenderBlocksMod.this.setupNoFace), 153, RenderBlocksMod.this.branch("A"), this.reference(178, RenderBlocksMod.this.newTextureIndex), 54, this.getCaptureGroup(1), this.reference(178, RenderBlocksMod.this.newTessellator), 58, this.tessellatorRegister, 167, RenderBlocksMod.this.branch("B"), RenderBlocksMod.this.label("A"), 43, this.reference(184, RenderBlocksMod.this.skipDefaultRendering), 153, RenderBlocksMod.this.branch("B"), this.push(0), 172, RenderBlocksMod.this.label("B"));
                }
            });
            this.addPatch(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "override texture (crossed squares)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.reference(178, RenderBlocksMod.this.instance), 58, BinaryRegex.capture(BinaryRegex.any()), 43, 3, 28, BytecodeMatcher.anyReference(182), 54, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, RenderBlocksMod.this.overrideBlockTexture), 156, RenderBlocksMod.this.branch("A"), 42, 43, 41, 142, 24, 5, 142, 24, 7, 142, 21, this.getCaptureGroup(2), this.reference(184, RenderBlocksMod.this.setupNoFace), 153, RenderBlocksMod.this.branch("A"), this.reference(178, RenderBlocksMod.this.newTextureIndex), 54, this.getCaptureGroup(2), this.reference(178, RenderBlocksMod.this.newTessellator), 58, this.getCaptureGroup(1), 167, RenderBlocksMod.this.branch("B"), RenderBlocksMod.this.label("A"), 43, this.reference(184, RenderBlocksMod.this.skipDefaultRendering), 153, RenderBlocksMod.this.branch("B"), 177, RenderBlocksMod.this.label("B"));
                }
            }.targetMethod(this.drawCrossedSquares));
            this.addPatch(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "override texture (glass pane)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(43, 42, this.reference(180, RenderBlocksMod.this.blockAccess), 28, this.push(1), 96, 29, 21, 4, BytecodeMatcher.anyReference(185), BytecodeMatcher.anyReference(182), 54, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getInsertBytes() throws IOException {
                    int reg = this.getCaptureGroup(1)[0] & 0xFF;
                    Logger.log(5, "glass side connect flags (%d %d %d %d)", reg - 3, reg - 2, reg - 1, reg);
                    return this.buildCode(42, 42, this.reference(180, RenderBlocksMod.this.overrideBlockTexture), 43, 28, 29, 21, 4, 21, reg - 3, 21, reg - 2, 21, reg - 1, 21, reg, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.GlassPaneRenderer", "render", "(LRenderBlocks;ILBlock;IIIZZZZ)V")));
                }
            }.targetMethod(this.renderBlockPane));
            this.addPatch(new BytecodePatch(){
                private int[] sideUVRegisters;
                {
                    this.addPreMatchSignature(new BytecodeSignature(){

                        public String getMatchExpression() {
                            return this.buildExpression(BytecodeMatcher.anyILOAD, this.push(7), 96, 134, this.push(Float.valueOf(256.0f)), 110, 141, 57, BinaryRegex.capture(BinaryRegex.any()));
                        }

                        public boolean afterMatch() {
                            int reg = this.getCaptureGroup(1)[0] & 0xFF;
                            6.access$3002(this, new int[]{reg, reg + 2, reg + 4, reg + 6, reg + 8});
                            Logger.log(3, "glass side texture uv registers (%d %d %d %d %d)", reg, reg + 2, reg + 4, reg + 6, reg + 8);
                            return true;
                        }
                    });
                }

                public String getDescription() {
                    return "disable default rendering (glass pane faces)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.repeat(BinaryRegex.build(25, BinaryRegex.any(), BinaryRegex.nonGreedy(BinaryRegex.any(0, 15)), 24, BinaryRegex.subset(this.sideUVRegisters, false), 24, BinaryRegex.subset(this.sideUVRegisters, false), this.reference(182, RenderBlocksMod.this.addVertexWithUV)), 8));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.GlassPaneRenderer", "active", "Z")), 154, RenderBlocksMod.this.branch("A"), this.getMatch(), RenderBlocksMod.this.label("A"));
                }

                static /* synthetic */ int[] access$3002(6 x0, int[] x1) {
                    x0.sideUVRegisters = x1;
                    return x1;
                }
            }.targetMethod(this.renderBlockPane));
        }

        private void setupBlockFace(final int face, final String direction) {
            this.faceMethods[face] = new MethodRef(this.getDeobfClass(), "render" + direction + "Face", "(LBlock;DDDI)V");
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "override texture (" + direction.toLowerCase() + " face)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(this.reference(178, RenderBlocksMod.this.instance), 58, BinaryRegex.capture(BinaryRegex.any()), 42, this.reference(180, RenderBlocksMod.this.overrideBlockTexture))), 155, BinaryRegex.any(2), BinaryRegex.capture(BinaryRegex.build(42, this.reference(180, RenderBlocksMod.this.overrideBlockTexture), 54, BinaryRegex.capture(BinaryRegex.any()))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), 155, RenderBlocksMod.this.branch("A"), this.getCaptureGroup(3), this.reference(184, RenderBlocksMod.this.reset), 167, RenderBlocksMod.this.branch("C"), RenderBlocksMod.this.label("A"), 42, 43, 40, 142, 24, 4, 142, 24, 6, 142, this.push(face), 21, this.getCaptureGroup(4), this.reference(184, RenderBlocksMod.this.setup), 153, RenderBlocksMod.this.branch("B"), this.reference(178, RenderBlocksMod.this.newTextureIndex), 54, this.getCaptureGroup(4), this.reference(178, RenderBlocksMod.this.newTessellator), 58, this.getCaptureGroup(2), 167, RenderBlocksMod.this.branch("C"), RenderBlocksMod.this.label("B"), 43, this.reference(184, RenderBlocksMod.this.skipDefaultRendering), 153, RenderBlocksMod.this.branch("C"), 177, RenderBlocksMod.this.label("C"));
                }
            }.targetMethod(this.faceMethods[face]));
        }
    }

    private class TessellatorMod
    extends BaseMod.TessellatorMod {
        TessellatorMod(MinecraftVersion minecraftVersion) {
            super(minecraftVersion);
            final MethodRef constructor = new MethodRef(this.getDeobfClass(), "<init>", "(I)V");
            final MethodRef constructor0 = new MethodRef(this.getDeobfClass(), "<init>", "()V");
            final MethodRef reset = new MethodRef(this.getDeobfClass(), "reset", "()V");
            FieldRef isDrawing = new FieldRef(this.getDeobfClass(), "isDrawing", "Z");
            FieldRef drawMode = new FieldRef(this.getDeobfClass(), "drawMode", "I");
            final FieldRef texture = new FieldRef(this.getDeobfClass(), "texture", "I");
            FieldRef bufferSize = new FieldRef(this.getDeobfClass(), "bufferSize", "I");
            FieldRef addedVertices = new FieldRef(this.getDeobfClass(), "addedVertices", "I");
            FieldRef vertexCount = new FieldRef(this.getDeobfClass(), "vertexCount", "I");
            FieldRef rawBufferIndex = new FieldRef(this.getDeobfClass(), "rawBufferIndex", "I");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), this.push(4), 112, BinaryRegex.any(0, 1000), 42, 89, BytecodeMatcher.captureReference(180), 4, 96, BytecodeMatcher.anyReference(181), 42, 89, BytecodeMatcher.captureReference(180), this.push(8), 96, BytecodeMatcher.anyReference(181));
                }
            }.setMethod(this.addVertex).addXref(1, addedVertices).addXref(2, vertexCount).addXref(3, rawBufferIndex));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.captureReference(180), BinaryRegex.any(0, 50), this.push("Already tesselating!"), BinaryRegex.any(0, 100), 42, BytecodeMatcher.captureReference(183), 42, 27, BytecodeMatcher.captureReference(181));
                }
            }.setMethod(this.startDrawing).addXref(1, isDrawing).addXref(2, reset).addXref(3, drawMode));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, this.push(7), BytecodeMatcher.captureReference(182), 177, BinaryRegex.end());
                }
            }.setMethod(this.startDrawingQuads).addXref(1, this.startDrawing));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, 27, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, bufferSize));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.instance).accessFlag(8, true));
            for (JavaRef ref : new JavaRef[]{constructor, this.startDrawing, isDrawing, drawMode, this.draw, reset, bufferSize, addedVertices, vertexCount, rawBufferIndex}) {
                this.addPatch(new MakeMemberPublicPatch(ref));
            }
            this.addPatch(new AddFieldPatch(texture));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "replace tessellator instance";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.reference(187, new ClassRef("Tessellator")), 89, BinaryRegex.capture(BinaryRegex.optional(BytecodeMatcher.anyLDC)), BinaryRegex.capture(BinaryRegex.or(BinaryRegex.build(new Object[]{this.reference(183, constructor)}), BinaryRegex.build(new Object[]{this.reference(183, constructor0)}))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    boolean isForge = this.getCaptureGroup(1).length == 0;
                    return this.buildCode(this.reference(187, new ClassRef("com.pclewis.mcpatcher.mod.SuperTessellator")), 89, this.getCaptureGroup(1), this.reference(183, new MethodRef("com.pclewis.mcpatcher.mod.SuperTessellator", "<init>", isForge ? "()V" : "(I)V")));
                }
            }.matchStaticInitializerOnly(true));
            this.addPatch(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "initialize texture field to -1";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.push(-1), this.reference(181, texture));
                }
            }.matchConstructorOnly(true));
            this.addPatch(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "bind texture before drawing";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(42, BytecodeMatcher.anyReference(180)), BytecodeMatcher.anyReference(178)), this.reference(182, new MethodRef("java/nio/IntBuffer", "clear", "()Ljava/nio/Buffer;")), 87);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, texture), 155, TessellatorMod.this.branch("A"), this.push(3553), 42, this.reference(180, texture), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glBindTexture", "(II)V")), TessellatorMod.this.label("A"));
                }
            }.targetMethod(this.draw));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "fix references to reset method";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(183, reset)});
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(182, reset)});
                }
            });
        }
    }

    private class BlockMod
    extends BaseMod.BlockMod {
        BlockMod() {
            FieldRef blockMaterial = new FieldRef(this.getDeobfClass(), "blockMaterial", "LMaterial;");
            MethodRef getBlockTexture = new MethodRef(this.getDeobfClass(), "getBlockTexture", "(LIBlockAccess;IIII)I");
            InterfaceMethodRef getBlockMetadata = new InterfaceMethodRef("IBlockAccess", "getBlockMetadata", "(III)I");
            MethodRef getBlockTextureFromSideAndMetadata = new MethodRef(this.getDeobfClass(), "getBlockTextureFromSideAndMetadata", "(II)I");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 21, 5, 43, 28, 29, 21, 4, BytecodeMatcher.captureReference(185), BytecodeMatcher.captureReference(182), 172, BinaryRegex.end());
                }
            }.setMethod(getBlockTexture).addXref(1, getBlockMetadata).addXref(2, getBlockTextureFromSideAndMetadata));
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(" is already occupied by "));
                }
            }.matchConstructorOnly(true).setMethod(new MethodRef(this.getDeobfClass(), "<init>", "(ILMaterial;)V")));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(blockMaterial).accessFlag(1, true));
        }
    }

    private class RenderEngineMod
    extends ClassMod {
        RenderEngineMod() {
            MethodRef glTexSubImage2D = new MethodRef("org.lwjgl.opengl.GL11", "glTexSubImage2D", "(IIIIIIIILjava/nio/ByteBuffer;)V");
            MethodRef allocateAndSetupTexture = new MethodRef(this.getDeobfClass(), "allocateAndSetupTexture", "(Ljava/awt/image/BufferedImage;)I");
            MethodRef getTexture = new MethodRef(this.getDeobfClass(), "getTexture", "(Ljava/lang/String;)I");
            this.addClassSignature(new ConstSignature("%clamp%"));
            this.addClassSignature(new ConstSignature("%blur%"));
            this.addClassSignature(new ConstSignature(glTexSubImage2D));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(getTexture).accessFlag(1, true).accessFlag(8, false));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(allocateAndSetupTexture).accessFlag(1, true).accessFlag(8, false));
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod() {
            FieldRef renderEngine = new FieldRef(this.getDeobfClass(), "renderEngine", "LRenderEngine;");
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(renderEngine));
        }
    }

    private class ConfigPanel
    extends ModConfigPanel {
        private JPanel panel;
        private JCheckBox glassCheckBox;
        private JCheckBox glassPaneCheckBox;
        private JCheckBox bookshelfCheckBox;
        private JCheckBox sandstoneCheckBox;
        private JCheckBox standardCheckBox;
        private JCheckBox nonStandardCheckBox;
        private JCheckBox outlineCheckBox;

        public ConfigPanel() {
            this.$$$setupUI$$$();
            this.glassCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "glass", ConfigPanel.this.glassCheckBox.isSelected());
                }
            });
            this.glassPaneCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "glassPane", ConfigPanel.this.glassPaneCheckBox.isSelected());
                }
            });
            this.bookshelfCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "bookshelf", ConfigPanel.this.bookshelfCheckBox.isSelected());
                }
            });
            this.sandstoneCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "sandstone", ConfigPanel.this.sandstoneCheckBox.isSelected());
                }
            });
            this.standardCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "standard", ConfigPanel.this.standardCheckBox.isSelected());
                }
            });
            this.nonStandardCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "nonStandard", ConfigPanel.this.nonStandardCheckBox.isSelected());
                }
            });
            this.outlineCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "outline", ConfigPanel.this.outlineCheckBox.isSelected());
                }
            });
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public void load() {
            this.glassCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "glass", true));
            this.glassPaneCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "glassPane", true));
            this.bookshelfCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "bookshelf", true));
            this.sandstoneCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "sandstone", true));
            this.standardCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "standard", true));
            this.nonStandardCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "nonStandard", true));
            this.outlineCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "outline", false));
        }

        public void save() {
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JPanel jPanel;
            this.panel = jPanel = new JPanel();
            jPanel.setLayout(new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.glassCheckBox = jCheckBox7 = new JCheckBox();
            jCheckBox7.setText("Glass blocks");
            jPanel.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.glassPaneCheckBox = jCheckBox6 = new JCheckBox();
            jCheckBox6.setText("Glass panes");
            jPanel.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.bookshelfCheckBox = jCheckBox5 = new JCheckBox();
            jCheckBox5.setText("Bookshelves");
            jPanel.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.sandstoneCheckBox = jCheckBox4 = new JCheckBox();
            jCheckBox4.setText("Sandstone");
            jPanel.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.standardCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setText("Other standard blocks");
            jCheckBox3.setToolTipText("Standard 6-sixed blocks");
            jPanel.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Apply replacement textures to:");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.outlineCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("<html>Outline mode <font color=\"#ff0000\">(Experimental)</font></html>");
            jPanel.add((Component)jCheckBox2, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.nonStandardCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("Non-standard blocks");
            jCheckBox.setToolTipText("Covers most other block types (flowers, grass, etc.)");
            jPanel.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

