/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.AddMethodPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BaseTexturePackMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.FixedBytecodeSignature;
import com.pclewis.mcpatcher.InterfaceMethodRef;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.MakeMemberPublicPatch;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.mod.HDTextureConfig;
import com.pclewis.mcpatcher.mod.TileSizePatch;
import java.io.IOException;

public class HDTexture
extends BaseTexturePackMod {
    private final boolean haveColorizerWater;
    private final boolean haveGetImageRGB;
    private final int updateDynamicTextureVersion;

    public HDTexture(MinecraftVersion minecraftVersion) {
        super(minecraftVersion);
        this.clearPatches();
        this.name = "HD Textures";
        this.author = "MCPatcher";
        this.description = "Provides support for high-resolution texture packs and custom animations.";
        this.version = "1.5";
        this.configPanel = new HDTextureConfig();
        this.addDependency("__TexturePackBase");
        this.haveColorizerWater = minecraftVersion.compareTo("Beta 1.6") >= 0;
        boolean bl = this.haveGetImageRGB = minecraftVersion.compareTo("Beta 1.6") >= 0;
        this.updateDynamicTextureVersion = minecraftVersion.compareTo("1.0.0") < 0 ? 0 : (minecraftVersion.compareTo("12w34a") < 0 ? 1 : 2);
        this.addClassMod(new RenderEngineMod());
        this.addClassMod(new TextureFXMod());
        this.addClassMod(new CompassMod());
        this.addClassMod(new FireMod());
        this.addClassMod(new FluidMod("StillLava"));
        this.addClassMod(new FluidMod("FlowLava"));
        this.addClassMod(new FluidMod("StillWater"));
        this.addClassMod(new FluidMod("FlowWater"));
        this.addClassMod(new ItemRendererMod());
        this.addClassMod(new WatchMod());
        this.addClassMod(new PortalMod());
        this.addClassMod(new MinecraftMod());
        this.addClassMod(new BaseMod.GLAllocationMod());
        this.addClassMod(new ColorizerMod("ColorizerWater", this.haveColorizerWater ? "/misc/watercolor.png" : "/misc/foliagecolor.png"));
        this.addClassMod(new ColorizerMod("ColorizerGrass", "/misc/grasscolor.png"));
        this.addClassMod(new ColorizerMod("ColorizerFoliage", "/misc/foliagecolor.png"));
        if (minecraftVersion.compareTo("12w22a") < 0) {
            this.addClassMod(new GuiContainerCreativeMod());
        }
        this.addClassFile("com.pclewis.mcpatcher.mod.TileSize");
        this.addClassFile("com.pclewis.mcpatcher.mod.TextureUtils");
        this.addClassFile("com.pclewis.mcpatcher.mod.TextureUtils$1");
        this.addClassFile("com.pclewis.mcpatcher.mod.TextureUtils$2");
        this.addClassFile("com.pclewis.mcpatcher.mod.CustomAnimation");
        this.addClassFile("com.pclewis.mcpatcher.mod.CustomAnimation$Delegate");
        this.addClassFile("com.pclewis.mcpatcher.mod.CustomAnimation$Tile");
        this.addClassFile("com.pclewis.mcpatcher.mod.CustomAnimation$Strip");
        this.addClassFile("com.pclewis.mcpatcher.mod.FancyCompass");
        this.addClassFile("com.pclewis.mcpatcher.mod.MipmapHelper");
    }

    public String[] getLoggingCategories() {
        return new String[]{this.name, "Mipmap"};
    }

    private class GuiContainerCreativeMod
    extends ClassMod {
        GuiContainerCreativeMod() {
            this.setMultipleMatchesAllowed(true);
            this.addClassSignature(new ConstSignature("/gui/allitems.png"));
            this.addPatch(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "use allitemsx.png for creative mode inventory background";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/gui/allitems.png"));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.push(true), this.reference(179, new FieldRef("com.pclewis.mcpatcher.mod.TextureUtils", "oldCreativeGui", "Z")));
                }
            });
        }
    }

    private class ColorizerMod
    extends ClassMod {
        private final String name;

        ColorizerMod(String name, String resource) {
            this.name = name;
            FieldRef colorBuffer = new FieldRef(this.getDeobfClass(), "colorBuffer", "[I");
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(colorBuffer));
            this.addPatch(new MakeMemberPublicPatch(colorBuffer));
            if (HDTexture.this.haveColorizerWater) {
                this.addPrerequisiteClass("Minecraft");
            } else {
                this.addClassSignature(new ConstSignature(resource));
            }
        }

        public String getDeobfClass() {
            return this.name;
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod() {
            FieldRef renderEngine = new FieldRef(this.getDeobfClass(), "renderEngine", "LRenderEngine;");
            if (HDTexture.this.haveColorizerWater) {
                this.addColorizerSignature("Water");
                this.addColorizerSignature("Grass");
                this.addColorizerSignature("Foliage");
            }
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(renderEngine));
        }

        private void addColorizerSignature(final String name) {
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/misc/" + name.toLowerCase() + "color.png"), BytecodeMatcher.anyReference(182), BytecodeMatcher.captureReference(184));
                }
            }.addXref(1, new MethodRef("Colorizer" + name, "loadColorBuffer", "([I)V")));
        }
    }

    private class PortalMod
    extends ClassMod {
        PortalMod() {
            this.setParentClass("TextureFX");
            final MethodRef atan2 = new MethodRef("java.lang.Math", "atan2", "(DD)D");
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(23, BinaryRegex.any(), 141, 23, BinaryRegex.any(), 141, this.reference(184, atan2), 144);
                }
            }.matchConstructorOnly(true));
            this.addPatch(new TileSizePatch(Float.valueOf(16.0f), "float_size"));
            this.addPatch(new TileSizePatch.WhilePatch(16, "int_size"));
            this.addPatch(new TileSizePatch.ArraySize2DPatch(1024, "int_numBytes", 32));
            this.addPatch(new TileSizePatch.MultiplyPatch(16, "int_size"));
            this.addPatch(new TileSizePatch.MultiplyPatch(8, "int_sizeHalf"));
            this.addPatch(new TileSizePatch.WhilePatch(256, "int_numPixels"));
            this.addPatch(new TileSizePatch.IfLessPatch(256, "int_numPixels"));
        }
    }

    private class WatchMod
    extends ClassMod {
        public WatchMod() {
            this.setParentClass("TextureFX");
            this.addClassSignature(new ConstSignature("/misc/dial.png"));
            this.addPatch(new TileSizePatch(16.0, "double_size"));
            this.addPatch(new TileSizePatch(15.0, "double_sizeMinus1"));
            this.addPatch(new TileSizePatch.GetRGBPatch());
            this.addPatch(new TileSizePatch.ArraySizePatch(256, "int_numPixels"));
            this.addPatch(new TileSizePatch.MultiplyPatch(16, "int_size"));
            this.addPatch(new TileSizePatch.WhilePatch(256, "int_numPixels"));
            this.addPatch(new TileSizePatch.BitMaskPatch(15, "int_sizeMinus1"));
            this.addPatch(new TileSizePatch.DivPatch(16, "int_size"));
            this.addPatch(new TileSizePatch.ModPatch(16, "int_size").addPreMatchSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Math.PI));
                }
            }));
        }
    }

    private class ItemRendererMod
    extends ClassMod {
        ItemRendererMod() {
            this.addClassSignature(new ConstSignature(Float.valueOf(-0.9375f)));
            this.addClassSignature(new ConstSignature(Float.valueOf(0.0625f)));
            this.addClassSignature(new ConstSignature(Float.valueOf(0.001953125f)));
            this.addPatch(new TileSizePatch.ToolPixelTopPatch());
            this.addPatch(new TileSizePatch(Float.valueOf(16.0f), "float_size"));
            this.addPatch(new TileSizePatch.WhilePatch(16, "int_size"));
            this.addPatch(new TileSizePatch.ToolTexPatch());
            this.addPatch(new TileSizePatch(Float.valueOf(0.001953125f), "float_texNudge"));
        }
    }

    private class FluidMod
    extends ClassMod {
        private String name;

        FluidMod(String name) {
            byte[] byArray;
            this.setParentClass("TextureFX");
            this.name = name;
            boolean lava = name.contains("Lava");
            boolean flow = name.contains("Flow");
            Object[] objectArray = new Object[7];
            objectArray[0] = 42;
            objectArray[1] = 178;
            objectArray[2] = BinaryRegex.any(2);
            objectArray[3] = 180;
            objectArray[4] = BinaryRegex.any(2);
            if (flow) {
                byte[] byArray2 = new byte[2];
                byArray2[0] = 4;
                byArray = byArray2;
                byArray2[1] = 96;
            } else {
                byArray = new byte[]{};
            }
            objectArray[5] = byArray;
            objectArray[6] = 183;
            this.addClassSignature(new FixedBytecodeSignature(objectArray));
            final double rand = lava ? 0.005 : (flow ? 0.2 : 0.05);
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.reference(184, new MethodRef("java.lang.Math", "random", "()D")), this.push(rand), 152, 156);
                }
            });
            if (lava) {
                this.addClassSignature(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(134, this.push(Float.valueOf((float)Math.PI)), 106, 13, 106, this.push(Float.valueOf(16.0f)), 110);
                    }
                });
            }
            this.addPatch(new TileSizePatch.ArraySizePatch(256, "int_numPixels"));
            this.addPatch(new TileSizePatch.WhilePatch(256, "int_numPixels"));
            this.addPatch(new TileSizePatch.WhilePatch(16, "int_size"));
            this.addPatch(new TileSizePatch.BitMaskPatch(255, "int_numPixelsMinus1"));
            this.addPatch(new TileSizePatch.BitMaskPatch(15, "int_sizeMinus1"));
            this.addPatch(new TileSizePatch.MultiplyPatch(16, "int_size"));
        }

        public String getDeobfClass() {
            return this.name;
        }
    }

    private class FireMod
    extends ClassMod {
        FireMod() {
            this.setParentClass("TextureFX");
            this.addClassSignature(new ConstSignature(new MethodRef("java.lang.Math", "random", "()D")));
            this.addClassSignature(new FixedBytecodeSignature(17, 1, 64, 188, 6, 181, BinaryRegex.any(2), 42, 17, 1, 64, 188, 6, 181, BinaryRegex.any(2), 177));
            this.addPatch(new TileSizePatch(Float.valueOf(1.06f), "float_flameNudge"));
            this.addPatch(new TileSizePatch(Float.valueOf(1.0600001f), "float_flameNudge"));
            this.addPatch(new TileSizePatch.ArraySizePatch(320, "int_flameArraySize"));
            this.addPatch(new TileSizePatch.WhilePatch(256, "int_numPixels"));
            this.addPatch(new TileSizePatch.WhilePatch(20, "int_flameHeight"));
            this.addPatch(new TileSizePatch.WhilePatch(16, "int_size"));
            this.addPatch(new TileSizePatch.ModPatch(20, "int_flameHeight"));
            this.addPatch(new TileSizePatch.IfLessPatch(19, "int_flameHeightMinus1"));
            this.addPatch(new TileSizePatch.MultiplyPatch(16, "int_size"){

                public boolean filterMethod() {
                    return !this.getMethodInfo().isConstructor();
                }
            });
        }
    }

    private class CompassMod
    extends ClassMod {
        CompassMod() {
            this.setParentClass("TextureFX");
            FieldRef currentAngle = new FieldRef(this.getDeobfClass(), "currentAngle", "D");
            FieldRef targetAngle = new FieldRef(this.getDeobfClass(), "targetAngle", "D");
            this.addClassSignature(new ConstSignature("/gui/items.png"));
            this.addClassSignature(new ConstSignature("/misc/dial.png").negate(true));
            this.addClassSignature(new ConstSignature(new MethodRef("java.lang.Math", "sin", "(D)D")));
            this.addClassSignature(new FixedBytecodeSignature(42, 17, 1, 0, 188, 10, 181, BinaryRegex.any(2), 42));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(currentAngle, targetAngle));
            this.addPatch(new TileSizePatch(7.5, "double_compassCenterMin"));
            this.addPatch(new TileSizePatch(8.5, "double_compassCenterMax"));
            this.addPatch(new TileSizePatch.ArraySizePatch(256, "int_numPixels"));
            this.addPatch(new TileSizePatch.MultiplyPatch(16, "int_size"));
            this.addPatch(new TileSizePatch.WhilePatch(256, "int_numPixels"));
            this.addPatch(new TileSizePatch(-4, "int_compassCrossMin"));
            this.addPatch(new TileSizePatch.IfGreaterPatch(4, "int_compassCrossMax"));
            this.addPatch(new TileSizePatch(-8, "int_compassNeedleMin"));
            this.addPatch(new TileSizePatch.IfGreaterPatch(16, "int_compassNeedleMax"));
            this.addPatch(new TileSizePatch.GetRGBPatch());
        }
    }

    private class TextureFXMod
    extends ClassMod {
        TextureFXMod() {
            FieldRef imageData = new FieldRef(this.getDeobfClass(), "imageData", "[B");
            FieldRef tileNumber = new FieldRef(this.getDeobfClass(), "tileNumber", "I");
            FieldRef tileSize = new FieldRef(this.getDeobfClass(), "tileSize", "I");
            FieldRef tileImage = new FieldRef(this.getDeobfClass(), "tileImage", "I");
            MethodRef bindImage = new MethodRef(this.getDeobfClass(), "bindImage", "(LRenderEngine;)V");
            this.addClassSignature(new FixedBytecodeSignature(17, 4, 0, 188, 8));
            this.addClassSignature(new FixedBytecodeSignature(BinaryRegex.begin(), 177, BinaryRegex.end()).setMethodName("onTick"));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(imageData));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(tileNumber, null, tileSize, tileImage));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(bindImage));
            this.addPatch(new TileSizePatch.ArraySizePatch(1024, "int_numBytes"));
            this.addPatch(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "check for bindImage recursion (end)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "bindImageEnd", "()V"))});
                }
            }.targetMethod(bindImage));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "check for bindImage recursion (start)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "bindImageBegin", "()Z")), 154, TextureFXMod.this.branch("A"), 177, TextureFXMod.this.label("A"));
                }
            }.targetMethod(bindImage));
        }
    }

    private class RenderEngineMod
    extends BaseMod.RenderEngineMod {
        private final MethodRef updateDynamicTextures = new MethodRef(this.getDeobfClass(), "updateDynamicTextures", "()V");
        private final MethodRef readTextureImage = new MethodRef(this.getDeobfClass(), "readTextureImage", "(Ljava/io/InputStream;)Ljava/awt/image/BufferedImage;");
        private final MethodRef setupTexture = new MethodRef(this.getDeobfClass(), "setupTexture", "(Ljava/awt/image/BufferedImage;I)V");
        private final MethodRef registerTextureFX = new MethodRef(this.getDeobfClass(), "registerTextureFX", "(LTextureFX;)V");
        private final MethodRef refreshTextures = new MethodRef(this.getDeobfClass(), "refreshTextures", "()V");
        private final FieldRef clampTexture = new FieldRef(this.getDeobfClass(), "clampTexture", "Z");
        private final FieldRef blurTexture = new FieldRef(this.getDeobfClass(), "blurTexture", "Z");
        private final FieldRef imageData = new FieldRef(this.getDeobfClass(), "imageData", "Ljava/nio/ByteBuffer;");
        private final FieldRef textureList = new FieldRef(this.getDeobfClass(), "textureList", "Ljava/util/List;");
        private final MethodRef getTexture = new MethodRef(this.getDeobfClass(), "getTexture", "(Ljava/lang/String;)I");
        private final MethodRef getImageRGB = new MethodRef(this.getDeobfClass(), "getImageRGB", "(Ljava/awt/image/BufferedImage;[I)[I");
        private final MethodRef readTextureImageData = new MethodRef(this.getDeobfClass(), "readTextureImageData", "(Ljava/lang/String;)[I");
        private final MethodRef allocateAndSetupTexture = new MethodRef(this.getDeobfClass(), "allocateAndSetupTexture", "(Ljava/awt/image/BufferedImage;)I");
        private final int getInputStreamOpcode;
        private final JavaRef getInputStream;

        RenderEngineMod() {
            if (HDTexture.this.haveITexturePack) {
                this.getInputStreamOpcode = 185;
                this.getInputStream = new InterfaceMethodRef("ITexturePack", "getInputStream", "(Ljava/lang/String;)Ljava/io/InputStream;");
            } else {
                this.getInputStreamOpcode = 182;
                this.getInputStream = new MethodRef("TexturePackBase", "getInputStream", "(Ljava/lang/String;)Ljava/io/InputStream;");
            }
            this.addClassSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("%clamp%"));
                }
            }.setMethod(this.refreshTextures));
            if (HDTexture.this.updateDynamicTextureVersion >= 1) {
                this.addClassSignature(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(BinaryRegex.begin(), this.push(-1), 60);
                    }
                }.setMethod(this.updateDynamicTextures));
            } else {
                this.addClassSignature(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glTexSubImage2D", "(IIIIIIIILjava/nio/ByteBuffer;)V"))});
                    }
                }.setMethod(this.updateDynamicTextures));
            }
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.imageData));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.textureList));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.clampTexture, this.blurTexture).accessFlag(1, true).accessFlag(8, false));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.registerTextureFX));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.readTextureImage));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.setupTexture));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.getTexture));
            if (HDTexture.this.haveGetImageRGB) {
                this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.getImageRGB));
            }
            if (HDTexture.this.haveColorizerWater) {
                this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.readTextureImageData));
            }
            this.memberMappers.add((ClassMod)this.new ClassMod.MethodMapper(this.allocateAndSetupTexture));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    String op = this.getCaptureGroup(1)[0] == 112 ? "%" : "/";
                    return String.format("(i %1$s 16) * 16 + j * 16 -> (i %1$s 16) * int_size + j * int_size", op);
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(16), BinaryRegex.capture(BinaryRegex.subset(new byte[]{112, 108}, true)), this.push(16), 104, BinaryRegex.capture(BinaryRegex.any(1, 3)), this.push(16), 104);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.push(16), this.getCaptureGroup(1), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_size", "I")), 104, this.getCaptureGroup(2), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_size", "I")), 104);
                }
            });
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "glTexSubImage2D(...,16,16) -> glTexSubImage2D(...,int_size,int_size)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(16), this.push(16), this.push(6408), this.push(5121));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_size", "I")), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_size", "I")), this.push(6408), this.push(5121));
                }
            });
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "readTextureImage(getInputStream(...)) -> getImage(...)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.reference(RenderEngineMod.this.getInputStreamOpcode, RenderEngineMod.this.getInputStream), this.reference(183, RenderEngineMod.this.readTextureImage));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "getImage", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/awt/image/BufferedImage;"))});
                }
            });
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "getInputStream(...), readTextureImage -> getImage(...)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(44, BinaryRegex.any(0, 6), 43, this.reference(RenderEngineMod.this.getInputStreamOpcode, RenderEngineMod.this.getInputStream), BytecodeMatcher.anyASTORE, BytecodeMatcher.anyALOAD, 199, BinaryRegex.any(2), 42, 42, 180, BinaryRegex.any(2), BytecodeMatcher.anyILOAD, this.reference(182, RenderEngineMod.this.setupTexture), 167, BinaryRegex.any(2), 42, 42, BytecodeMatcher.anyALOAD, this.reference(183, RenderEngineMod.this.readTextureImage));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, 43, this.reference(184, new MethodRef("com.pclewis.mcpatcher.TexturePackAPI", "getImage", "(Ljava/lang/String;)Ljava/awt/image/BufferedImage;")));
                }
            });
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "imageData.clear(), .put(), .limit() -> imageData = TextureUtils.getByteBuffer()";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, RenderEngineMod.this.imageData), this.reference(182, new MethodRef("java/nio/ByteBuffer", "clear", "()Ljava/nio/Buffer;")), 87, 42, this.reference(180, RenderEngineMod.this.imageData), BinaryRegex.capture(BinaryRegex.any(2, 5)), this.reference(182, new MethodRef("java/nio/ByteBuffer", "put", "([B)Ljava/nio/ByteBuffer;")), 87, 42, this.reference(180, RenderEngineMod.this.imageData), 3, this.reference(182, new MethodRef("java/nio/ByteBuffer", "position", "(I)Ljava/nio/Buffer;")), BinaryRegex.backReference(1), 190, this.reference(182, new MethodRef("java/nio/Buffer", "limit", "(I)Ljava/nio/Buffer;")), 87);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, 42, this.reference(180, RenderEngineMod.this.imageData), this.getCaptureGroup(1), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "getByteBuffer", "(Ljava/nio/ByteBuffer;[B)Ljava/nio/ByteBuffer;")), this.reference(181, RenderEngineMod.this.imageData));
                }
            });
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "call TextureUtils.registerTextureFX";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), BinaryRegex.any(0, 50), BinaryRegex.end());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, RenderEngineMod.this.textureList), 43, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "registerTextureFX", "(Ljava/util/List;LTextureFX;)V")), 177);
                }
            }.targetMethod(this.registerTextureFX));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "null check in setupTexture";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, 199, RenderEngineMod.this.branch("A"), 177, RenderEngineMod.this.label("A"));
                }
            }.targetMethod(this.setupTexture));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "null check in getImageRGB";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, 199, RenderEngineMod.this.branch("A"), 44, 176, RenderEngineMod.this.label("A"));
                }
            }.targetMethod(this.getImageRGB));
            this.addPatch(new TileSizePatch(0x100000, "int_glBufferSize"));
            this.addPatch(new AddMethodPatch(new MethodRef(this.getDeobfClass(), "reloadTextures", "(Lnet/minecraft/client/Minecraft;)V")){

                public byte[] generateMethod() throws IOException {
                    return this.buildCode(42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.TileSize", "int_glBufferSize", "I")), this.reference(184, new MethodRef("GLAllocation", "createDirectByteBuffer", "(I)Ljava/nio/ByteBuffer;")), this.reference(181, RenderEngineMod.this.imageData), 42, this.reference(182, new MethodRef(RenderEngineMod.this.getDeobfClass(), "refreshTextures", "()V")), 42, this.reference(180, RenderEngineMod.this.textureList), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.TextureUtils", "refreshTextureFX", "(Ljava/util/List;)V")), 177);
                }
            });
            this.addPatch(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "update custom animations";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.CustomAnimation", "updateAll", "()V"))});
                }
            }.targetMethod(this.updateDynamicTextures));
            this.addMipmappingPatches();
        }

        private void addMipmappingPatches() {
            if (HDTexture.this.updateDynamicTextureVersion <= 0) {
                return;
            }
            MethodRef updateDynamicTexture = HDTexture.this.updateDynamicTextureVersion == 1 ? this.updateDynamicTextures : new MethodRef(this.getDeobfClass(), "updateDynamicTexture", "(LTextureFX;I)I");
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(updateDynamicTexture));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "override mipmap level in setupTexture";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.lookBehind(BinaryRegex.build(this.push(3553)), true), this.push(0), BinaryRegex.lookAhead(BinaryRegex.build(this.push(6408), BytecodeMatcher.anyILOAD, BytecodeMatcher.anyILOAD, this.push(0), this.push(6408), this.push(5121), 42, this.reference(180, RenderEngineMod.this.imageData), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glTexImage2D", "(IIIIIIIILjava/nio/ByteBuffer;)V"))), true));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.MipmapHelper", "currentLevel", "I"))});
                }
            }.targetMethod(this.setupTexture));
            this.addPatch(new BytecodePatch(){

                public String getDescription() {
                    return "preserve texture parameters during mipmap creation";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), BinaryRegex.capture(BinaryRegex.nonGreedy(BinaryRegex.any(0, 300))), BinaryRegex.capture(BinaryRegex.build(43, this.reference(182, new MethodRef("java/awt/image/BufferedImage", "getWidth", "()I")))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.MipmapHelper", "currentLevel", "I")), 154, RenderEngineMod.this.branch("A"), this.getCaptureGroup(1), RenderEngineMod.this.label("A"), this.getCaptureGroup(2));
                }
            }.targetMethod(this.setupTexture));
            this.addPatch(new BytecodePatch(){
                private byte[] pushTextureName;
                private int position;
                {
                    this.addPreMatchSignature(new BytecodeSignature(){

                        public String getMatchExpression() {
                            return this.buildExpression(BinaryRegex.capture(BytecodeMatcher.anyALOAD), this.push("##"), this.reference(182, new MethodRef("java/lang/String", "startsWith", "(Ljava/lang/String;)Z")));
                        }

                        public boolean afterMatch() {
                            16.access$1602(this, this.getCaptureGroup(1));
                            position = this.matcher.getStart();
                            return true;
                        }
                    });
                }

                public String getDescription() {
                    return "generate mipmaps during texture setup";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, RenderEngineMod.this.setupTexture)});
                }

                public byte[] getReplacementBytes() throws IOException {
                    if (this.matcher.getStart() < this.position) {
                        return null;
                    }
                    return this.buildCode(this.pushTextureName, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.MipmapHelper", "setupTexture", "(LRenderEngine;Ljava/awt/image/BufferedImage;ILjava/lang/String;)V")));
                }

                static /* synthetic */ byte[] access$1602(16 x0, byte[] x1) {
                    x0.pushTextureName = x1;
                    return x1;
                }
            });
            this.addPatch(new BytecodePatch(){
                private byte[] loadTextureFX = new byte[]{43};
                {
                    if (HDTexture.this.updateDynamicTextureVersion < 2) {
                        this.addPreMatchSignature(new BytecodeSignature(){

                            public String getMatchExpression() {
                                return this.buildExpression(BytecodeMatcher.anyALOAD, this.reference(185, new InterfaceMethodRef("java/util/Iterator", "next", "()Ljava/lang/Object;")), this.reference(192, new ClassRef("TextureFX")), BinaryRegex.capture(BytecodeMatcher.anyASTORE));
                            }

                            public boolean afterMatch() {
                                17.access$1802(this, BytecodeMatcher.flipLoadStore(this.getCaptureGroup(1)));
                                return true;
                            }
                        });
                    }
                }

                public String getDescription() {
                    return "update mipmaps for animations";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glTexSubImage2D", "(IIIIIIIILjava/nio/ByteBuffer;)V"))});
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.loadTextureFX, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.MipmapHelper", "glTexSubImage2D", "(IIIIIIIILjava/nio/ByteBuffer;LTextureFX;)V")));
                }

                static /* synthetic */ byte[] access$1802(17 x0, byte[] x1) {
                    x0.loadTextureFX = x1;
                    return x1;
                }
            }.targetMethod(updateDynamicTexture));
        }
    }
}

