/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCLogger;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import com.pclewis.mcpatcher.mod.Colorizer;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import net.minecraft.src.EntityRenderer;
import net.minecraft.src.World;

public final class Lightmap {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    private static final String LIGHTMAP_FORMAT = "/environment/lightmap%d.png";
    private static final int LIGHTMAP_SIZE = 16;
    private static final int HEIGHT_WITHOUT_NIGHTVISION = 32;
    private static final int HEIGHT_WITH_NIGHTVISION = 64;
    private static final boolean useLightmaps = MCPatcherUtils.getBoolean("Custom Colors", "lightmaps", true);
    private static final HashMap<Integer, Lightmap> lightmaps = new HashMap();
    private final int width;
    private final boolean customNightvision;
    private final int[] origMap;
    private final boolean valid;
    private final int[] newMap = new int[256];
    private final float[] sunrgb = new float[48];
    private final float[] torchrgb = new float[48];
    private final float[] sunrgbnv = new float[48];
    private final float[] torchrgbnv = new float[48];
    private final float[] rgb = new float[3];

    static void clear() {
        lightmaps.clear();
    }

    public static boolean computeLightmap(EntityRenderer renderer, World world, float partialTick) {
        if (world == null || !useLightmaps) {
            return false;
        }
        Lightmap lightmap = null;
        int worldType = world.worldProvider.worldType;
        if (lightmaps.containsKey(worldType)) {
            lightmap = lightmaps.get(worldType);
        } else {
            String name = String.format(LIGHTMAP_FORMAT, worldType);
            BufferedImage image = TexturePackAPI.getImage(name);
            if (image != null) {
                lightmap = new Lightmap(name, image);
                if (!lightmap.valid) {
                    lightmap = null;
                }
            }
            lightmaps.put(worldType, lightmap);
        }
        return lightmap != null && lightmap.compute(renderer, world, partialTick);
    }

    private Lightmap(String name, BufferedImage image) {
        this.width = image.getWidth();
        int height = image.getHeight();
        this.customNightvision = height == 64;
        this.origMap = new int[this.width * height];
        image.getRGB(0, 0, this.width, height, this.origMap, 0, this.width);
        boolean bl = this.valid = height == 32 || height == 64;
        if (!this.valid) {
            logger.severe("%s must be exactly %d or %d pixels high", name, 32, 64);
        }
    }

    private boolean compute(EntityRenderer renderer, World world, float partialTick) {
        float sun = Colorizer.clamp(world.lightningFlash > 0 ? 1.0f : 1.1666666f * (world.getSunAngle(1.0f) - 0.2f)) * (float)(this.width - 1);
        float torch = Colorizer.clamp(renderer.torchFlickerX + 0.5f) * (float)(this.width - 1);
        float nightVisionStrength = renderer.getNightVisionStrength(partialTick);
        float gamma = Colorizer.clamp(MCPatcherUtils.getMinecraft().gameSettings.gammaSetting);
        for (int i = 0; i < 16; ++i) {
            Lightmap.interpolate(this.origMap, i * this.width, sun, this.sunrgb, 3 * i);
            Lightmap.interpolate(this.origMap, (i + 16) * this.width, torch, this.torchrgb, 3 * i);
            if (!this.customNightvision || !(nightVisionStrength > 0.0f)) continue;
            Lightmap.interpolate(this.origMap, (i + 32) * this.width, sun, this.sunrgbnv, 3 * i);
            Lightmap.interpolate(this.origMap, (i + 48) * this.width, torch, this.torchrgbnv, 3 * i);
        }
        for (int s = 0; s < 16; ++s) {
            for (int t = 0; t < 16; ++t) {
                int k;
                for (k = 0; k < 3; ++k) {
                    this.rgb[k] = Colorizer.clamp(this.sunrgb[3 * s + k] + this.torchrgb[3 * t + k]);
                }
                if (nightVisionStrength > 0.0f) {
                    if (this.customNightvision) {
                        for (k = 0; k < 3; ++k) {
                            this.rgb[k] = Colorizer.clamp((1.0f - nightVisionStrength) * this.rgb[k] + nightVisionStrength * (this.sunrgbnv[3 * s + k] + this.torchrgbnv[3 * t + k]));
                        }
                    } else {
                        float nightVisionMultiplier = Math.max(Math.max(this.rgb[0], this.rgb[1]), this.rgb[2]);
                        if (nightVisionMultiplier > 0.0f) {
                            nightVisionMultiplier = 1.0f - nightVisionStrength + nightVisionStrength / nightVisionMultiplier;
                            for (int k2 = 0; k2 < 3; ++k2) {
                                this.rgb[k2] = Colorizer.clamp(this.rgb[k2] * nightVisionMultiplier);
                            }
                        }
                    }
                }
                if (gamma != 0.0f) {
                    for (int k3 = 0; k3 < 3; ++k3) {
                        float tmp = 1.0f - this.rgb[k3];
                        tmp = 1.0f - tmp * tmp * tmp * tmp;
                        this.rgb[k3] = gamma * tmp + (1.0f - gamma) * this.rgb[k3];
                    }
                }
                this.newMap[s * 16 + t] = 0xFF000000 | Colorizer.float3ToInt(this.rgb);
            }
        }
        MCPatcherUtils.getMinecraft().renderEngine.createTextureFromBytes(this.newMap, 16, 16, renderer.lightmapTexture);
        return true;
    }

    private static void interpolate(int[] map, int offset1, float x, float[] rgb, int offset2) {
        int x1;
        int x0 = (int)Math.floor(x);
        if (x0 == (x1 = (int)Math.ceil(x))) {
            Colorizer.intToFloat3(map[offset1 + x0], rgb, offset2);
        } else {
            float xf = x - (float)x0;
            float xg = 1.0f - xf;
            float[] rgb0 = new float[3];
            float[] rgb1 = new float[3];
            Colorizer.intToFloat3(map[offset1 + x0], rgb0);
            Colorizer.intToFloat3(map[offset1 + x1], rgb1);
            for (int i = 0; i < 3; ++i) {
                rgb[offset2 + i] = xg * rgb0[i] + xf * rgb1[i];
            }
        }
    }
}

