/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCLogger;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import com.pclewis.mcpatcher.WeightedIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;

class MobRuleList {
    private static final MCLogger logger = MCLogger.getLogger("Random Mobs");
    public static final String ALTERNATIVES_REGEX = "_(eyes|overlay|tame|angry|collar|fur|invul)\\.properties$";
    private static final HashMap<String, MobRuleList> allRules = new HashMap();
    private final String baseSkin;
    private final ArrayList<String> allSkins;
    private final int skinCount;
    private final ArrayList<MobRuleEntry> entries;

    MobRuleList(String baseSkin) {
        String skin;
        this.baseSkin = baseSkin;
        this.allSkins = new ArrayList();
        this.allSkins.add(baseSkin);
        int i = 2;
        while (TexturePackAPI.hasResource(skin = baseSkin.replace(".png", "" + i + ".png"))) {
            this.allSkins.add(skin);
            ++i;
        }
        this.skinCount = this.allSkins.size();
        if (this.skinCount <= 1) {
            this.entries = null;
            return;
        }
        logger.fine("found %d variations for %s", this.skinCount, baseSkin);
        String filename = baseSkin.replace(".png", ".properties");
        String altFilename = filename.replaceFirst(ALTERNATIVES_REGEX, ".properties");
        Properties properties = TexturePackAPI.getProperties(filename);
        if (properties == null && !filename.equals(altFilename) && (properties = TexturePackAPI.getProperties(altFilename)) != null) {
            logger.fine("using %s for %s", altFilename, baseSkin);
        }
        ArrayList<MobRuleEntry> tmpEntries = new ArrayList<MobRuleEntry>();
        if (properties != null) {
            int i2 = 0;
            while (true) {
                MobRuleEntry entry;
                if ((entry = MobRuleEntry.load(properties, i2, this.skinCount)) == null) {
                    if (i2 > 0) {
                        break;
                    }
                } else {
                    logger.fine("  %s", entry.toString());
                    tmpEntries.add(entry);
                }
                ++i2;
            }
        }
        this.entries = tmpEntries.isEmpty() ? null : tmpEntries;
    }

    String getSkin(long key, int i, int j, int k, String biome) {
        if (this.entries == null) {
            int index = (int)(key % (long)this.skinCount);
            if (index < 0) {
                index += this.skinCount;
            }
            return this.allSkins.get(index);
        }
        for (MobRuleEntry entry : this.entries) {
            if (!entry.match(i, j, k, biome)) continue;
            int index = entry.weightedIndex.choose(key);
            return this.allSkins.get(entry.skins[index]);
        }
        return this.baseSkin;
    }

    static MobRuleList get(String texture) {
        MobRuleList list = allRules.get(texture);
        if (list == null) {
            list = new MobRuleList(texture);
            allRules.put(texture, list);
        }
        return list;
    }

    static void clear() {
        allRules.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MobRuleEntry {
        final int[] skins;
        final WeightedIndex weightedIndex;
        private final HashSet<String> biomes;
        private final int minHeight;
        private final int maxHeight;

        static MobRuleEntry load(Properties properties, int index, int limit) {
            WeightedIndex chooser;
            int i;
            int[] skins;
            String skinList = properties.getProperty("skins." + index, "").trim().toLowerCase();
            if (skinList.equals("*") || skinList.equals("all") || skinList.equals("any")) {
                skins = new int[limit];
                for (i = 0; i < skins.length; ++i) {
                    skins[i] = i;
                }
            } else {
                skins = MCPatcherUtils.parseIntegerList(skinList, 1, limit);
                if (skins.length <= 0) {
                    return null;
                }
                i = 0;
                while (i < skins.length) {
                    int n = i++;
                    skins[n] = skins[n] - 1;
                }
            }
            if ((chooser = WeightedIndex.create(skins.length, properties.getProperty("weights." + index, ""))) == null) {
                return null;
            }
            HashSet<String> biomes = new HashSet<String>();
            String biomeList = properties.getProperty("biomes." + index, "").trim().toLowerCase();
            if (!biomeList.equals("")) {
                Collections.addAll(biomes, biomeList.split("\\s+"));
            }
            if (biomes.isEmpty()) {
                biomes = null;
            }
            int maxHeight = -1;
            int minHeight = -1;
            try {
                maxHeight = Integer.parseInt(properties.getProperty("maxHeight." + index, "-1").trim());
                minHeight = Integer.parseInt(properties.getProperty("minHeight." + index, "-1").trim());
                if (minHeight < 0 || minHeight > maxHeight) {
                    minHeight = -1;
                    maxHeight = -1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return new MobRuleEntry(skins, chooser, biomes, minHeight, maxHeight);
        }

        MobRuleEntry(int[] skins, WeightedIndex weightedIndex, HashSet<String> biomes, int minHeight, int maxHeight) {
            this.skins = skins;
            this.weightedIndex = weightedIndex;
            this.biomes = biomes;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        boolean match(int i, int j, int k, String biome) {
            if (this.biomes != null && !this.biomes.contains(biome)) {
                return false;
            }
            return this.minHeight < 0 || j >= this.minHeight && j <= this.maxHeight;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("skins:");
            for (int i : this.skins) {
                sb.append(' ').append(i + 1);
            }
            if (this.biomes != null) {
                sb.append(", biomes:");
                for (String s : this.biomes) {
                    sb.append(' ').append(s);
                }
            }
            if (this.minHeight >= 0) {
                sb.append(", height: ").append(this.minHeight).append('-').append(this.maxHeight);
            }
            sb.append(", weights: ").append(this.weightedIndex.toString());
            return sb.toString();
        }
    }
}

