/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCLogger;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.Tessellator;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class SkyRenderer {
    private static final MCLogger logger = MCLogger.getLogger("Better Skies");
    private static RenderEngine renderEngine;
    private static double worldTime;
    private static float celestialAngle;
    private static float rainStrength;
    private static final HashMap<Integer, WorldEntry> worldSkies;
    private static WorldEntry currentWorld;
    public static boolean active;

    public static void setup(World world, RenderEngine renderEngine, float partialTick, float celestialAngle) {
        if (TexturePackAPI.isDefaultTexturePack()) {
            active = false;
        } else {
            int worldType = MCPatcherUtils.getMinecraft().getWorld().worldProvider.worldType;
            WorldEntry newEntry = SkyRenderer.getWorldEntry(worldType);
            if (newEntry != currentWorld && currentWorld != null) {
                currentWorld.unloadTextures();
            }
            if (active = (currentWorld = newEntry).active()) {
                SkyRenderer.renderEngine = renderEngine;
                worldTime = (float)world.getWorldTime() + partialTick;
                rainStrength = 1.0f - world.getRainStrength(partialTick);
                SkyRenderer.celestialAngle = celestialAngle;
            }
        }
    }

    public static void renderAll() {
        if (active) {
            currentWorld.renderAll(Tessellator.instance);
        }
    }

    public static String setupCelestialObject(String defaultTexture) {
        if (active) {
            Layer.clearBlendingMethod();
            Layer layer = currentWorld.getCelestialObject(defaultTexture);
            if (layer != null) {
                layer.setBlendingMethod(rainStrength);
                return layer.texture;
            }
        }
        return defaultTexture;
    }

    private static WorldEntry getWorldEntry(int worldType) {
        WorldEntry entry = worldSkies.get(worldType);
        if (entry == null) {
            entry = new WorldEntry(worldType);
            worldSkies.put(worldType, entry);
        }
        return entry;
    }

    static {
        worldSkies = new HashMap();
        TexturePackAPI.ChangeHandler.register(new TexturePackAPI.ChangeHandler("Better Skies", 2){

            protected void onChange() {
                worldSkies.clear();
                World world = MCPatcherUtils.getMinecraft().getWorld();
                if (world != null) {
                    SkyRenderer.getWorldEntry(world.worldProvider.worldType);
                }
            }
        });
    }

    private static class Layer {
        private static final int SECS_PER_DAY = 86400;
        private static final int TICKS_PER_DAY = 24000;
        private static final double TOD_OFFSET = -0.25;
        private static final double SKY_DISTANCE = 100.0;
        private static final int METHOD_ADD = 1;
        private static final int METHOD_SUBTRACT = 2;
        private static final int METHOD_MULTIPLY = 3;
        private static final int METHOD_DODGE = 4;
        private static final int METHOD_BURN = 5;
        private static final int METHOD_SCREEN = 6;
        private static final int METHOD_REPLACE = 7;
        private String prefix;
        private Properties properties;
        private String texture;
        private boolean fade;
        private boolean rotate;
        private float[] axis;
        private float speed;
        private int blendMethod;
        private double a;
        private double b;
        private double c;
        boolean valid;
        float brightness;

        static Layer create(String prefix) {
            Properties properties = TexturePackAPI.getProperties(prefix + ".properties");
            if (properties == null) {
                return null;
            }
            return new Layer(prefix, properties);
        }

        Layer(String prefix, Properties properties) {
            this.prefix = prefix;
            this.properties = properties;
            this.valid = true;
            this.valid = this.readTexture() && this.readRotation() & this.readBlendingMethod() && this.readFadeTimers();
        }

        private boolean readTexture() {
            this.texture = this.properties.getProperty("source", this.prefix + ".png");
            if (TexturePackAPI.hasResource(this.texture)) {
                return true;
            }
            return this.addError("source texture %s not found", this.texture);
        }

        private boolean readRotation() {
            this.rotate = Boolean.parseBoolean(this.properties.getProperty("rotate", "true"));
            if (this.rotate) {
                try {
                    this.speed = Float.parseFloat(this.properties.getProperty("speed", "1.0"));
                }
                catch (NumberFormatException e) {
                    return this.addError("invalid rotation speed", new Object[0]);
                }
                String value = this.properties.getProperty("axis", "0.0 0.0 1.0").trim().toLowerCase();
                String[] tokens = value.split("\\s+");
                if (tokens.length == 3) {
                    float z;
                    float y;
                    float x;
                    try {
                        x = Float.parseFloat(tokens[0]);
                        y = Float.parseFloat(tokens[1]);
                        z = Float.parseFloat(tokens[2]);
                    }
                    catch (NumberFormatException e) {
                        return this.addError("invalid rotation axis", new Object[0]);
                    }
                    if (x * x + y * y + z * z == 0.0f) {
                        return this.addError("rotation axis cannot be 0", new Object[0]);
                    }
                    this.axis = new float[]{z, y, -x};
                } else {
                    return this.addError("invalid rotate value %s", value);
                }
            }
            return true;
        }

        private boolean readBlendingMethod() {
            String value = this.properties.getProperty("blend", "add").trim().toLowerCase();
            if (value.equals("add")) {
                this.blendMethod = 1;
            } else if (value.equals("subtract")) {
                this.blendMethod = 2;
            } else if (value.equals("multiply")) {
                this.blendMethod = 3;
            } else if (value.equals("dodge")) {
                this.blendMethod = 4;
            } else if (value.equals("burn")) {
                this.blendMethod = 5;
            } else if (value.equals("screen")) {
                this.blendMethod = 6;
            } else if (value.equals("replace")) {
                this.blendMethod = 7;
            } else {
                return this.addError("unknown blend method %s", value);
            }
            return true;
        }

        private boolean readFadeTimers() {
            int endFadeIn;
            this.fade = Boolean.parseBoolean(this.properties.getProperty("fade", "true"));
            if (!this.fade) {
                return true;
            }
            int startFadeIn = this.parseTime(this.properties, "startFadeIn");
            int endFadeOut = this.parseTime(this.properties, "endFadeOut");
            if (!this.valid) {
                return false;
            }
            for (endFadeIn = this.parseTime(this.properties, "endFadeIn"); endFadeIn <= startFadeIn; endFadeIn += 86400) {
            }
            while (endFadeOut <= endFadeIn) {
                endFadeOut += 86400;
            }
            if (endFadeOut - startFadeIn >= 86400) {
                return this.addError("fade times must fall within a 24 hour period", new Object[0]);
            }
            int startFadeOut = startFadeIn + endFadeOut - endFadeIn;
            double s0 = Layer.normalize(startFadeIn, 86400, -0.25);
            double s1 = Layer.normalize(endFadeIn, 86400, -0.25);
            double e0 = Layer.normalize(startFadeOut, 86400, -0.25);
            double e1 = Layer.normalize(endFadeOut, 86400, -0.25);
            double det = Math.cos(s0) * Math.sin(s1) + Math.cos(e1) * Math.sin(s0) + Math.cos(s1) * Math.sin(e1) - Math.cos(s0) * Math.sin(e1) - Math.cos(s1) * Math.sin(s0) - Math.cos(e1) * Math.sin(s1);
            if (det == 0.0) {
                return this.addError("determinant is 0", new Object[0]);
            }
            this.a = (Math.sin(e1) - Math.sin(s0)) / det;
            this.b = (Math.cos(s0) - Math.cos(e1)) / det;
            this.c = (Math.cos(e1) * Math.sin(s0) - Math.cos(s0) * Math.sin(e1)) / det;
            logger.finer("%s.properties: y = %f cos x + %f sin x + %f", this.prefix, this.a, this.b, this.c);
            logger.finer("  at %f: %f", s0, this.f(s0));
            logger.finer("  at %f: %f", s1, this.f(s1));
            logger.finer("  at %f: %f", e0, this.f(e0));
            logger.finer("  at %f: %f", e1, this.f(e1));
            return true;
        }

        private boolean addError(String format, Object ... params) {
            logger.severe(this.prefix + ".properties: " + format, params);
            this.valid = false;
            return false;
        }

        private int parseTime(Properties properties, String key) {
            String s = properties.getProperty(key, "").trim();
            if ("".equals(s)) {
                this.addError("missing value for %s", key);
                return -1;
            }
            String[] t = s.split(":");
            if (t.length >= 2) {
                try {
                    int hh = Integer.parseInt(t[0].trim());
                    int mm = Integer.parseInt(t[1].trim());
                    int ss = t.length >= 3 ? Integer.parseInt(t[2].trim()) : 0;
                    return (3600 * hh + 60 * mm + ss) % 86400;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.addError("invalid %s time %s", key, s);
            return -1;
        }

        private static double normalize(double time, int period, double offset) {
            return Math.PI * 2 * (time / (double)period + offset);
        }

        private double f(double x) {
            return this.a * Math.cos(x) + this.b * Math.sin(x) + this.c;
        }

        boolean prepare() {
            this.brightness = rainStrength;
            if (this.fade) {
                double x = Layer.normalize(worldTime, 24000, 0.0);
                this.brightness *= (float)this.f(x);
            }
            if (this.brightness <= 0.0f) {
                return false;
            }
            if (this.brightness > 1.0f) {
                this.brightness = 1.0f;
            }
            return true;
        }

        boolean render(Tessellator tessellator) {
            renderEngine.bindTexture(renderEngine.getTexture(this.texture));
            this.setBlendingMethod(this.brightness);
            GL11.glPushMatrix();
            if (this.rotate) {
                GL11.glRotatef((float)(celestialAngle * 360.0f * this.speed), (float)this.axis[0], (float)this.axis[1], (float)this.axis[2]);
            }
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 4);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Layer.drawTile(tessellator, 1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Layer.drawTile(tessellator, 0);
            GL11.glPopMatrix();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 5);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 2);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 3);
            GL11.glPopMatrix();
            return true;
        }

        private static void drawTile(Tessellator tessellator, int tile) {
            double tileX = (double)(tile % 3) / 3.0;
            double tileY = (double)(tile / 3) / 2.0;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(-100.0, -100.0, -100.0, tileX, tileY);
            tessellator.addVertexWithUV(-100.0, -100.0, 100.0, tileX, tileY + 0.5);
            tessellator.addVertexWithUV(100.0, -100.0, 100.0, tileX + 0.3333333333333333, tileY + 0.5);
            tessellator.addVertexWithUV(100.0, -100.0, -100.0, tileX + 0.3333333333333333, tileY);
            tessellator.draw();
        }

        void setBlendingMethod(float brightness) {
            if (this.blendMethod == 1 || this.blendMethod == 7) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
            } else if (this.blendMethod == 3) {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)brightness);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            }
            switch (this.blendMethod) {
                case 1: {
                    GL11.glDisable((int)3008);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)1);
                    break;
                }
                case 2: {
                    GL11.glDisable((int)3008);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)775, (int)0);
                    break;
                }
                case 3: {
                    GL11.glDisable((int)3008);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)774, (int)771);
                    break;
                }
                case 4: {
                    GL11.glDisable((int)3008);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)1, (int)1);
                    break;
                }
                case 5: {
                    GL11.glDisable((int)3008);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)0, (int)769);
                    break;
                }
                case 6: {
                    GL11.glDisable((int)3008);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)1, (int)769);
                    break;
                }
                case 7: {
                    GL11.glEnable((int)3008);
                    GL11.glDisable((int)3042);
                    break;
                }
            }
            GL11.glEnable((int)3553);
        }

        static void clearBlendingMethod() {
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)rainStrength);
        }
    }

    private static class WorldEntry {
        private final int worldType;
        private final ArrayList<Layer> skies;
        private final HashMap<String, Layer> objects;
        private final HashSet<String> textures;

        WorldEntry(int worldType) {
            this.worldType = worldType;
            this.skies = new ArrayList();
            this.objects = new HashMap();
            this.textures = new HashSet();
            this.loadSkies();
            this.loadCelestialObject("sun", "/terrain/sun.png");
            this.loadCelestialObject("moon", "/terrain/moon_phases.png");
        }

        private void loadSkies() {
            int i = -1;
            while (true) {
                String prefix;
                Layer layer;
                if ((layer = Layer.create(prefix = "/terrain/sky" + this.worldType + "/sky" + (i < 0 ? "" : "" + i))) == null) {
                    if (i > 0) {
                        break;
                    }
                } else if (layer.valid) {
                    logger.fine("loaded %s.properties", prefix);
                    this.skies.add(layer);
                    this.textures.add(layer.texture);
                }
                ++i;
            }
        }

        private void loadCelestialObject(String objName, String textureName) {
            String prefix = "/terrain/sky" + this.worldType + "/" + objName;
            Properties properties = TexturePackAPI.getProperties(prefix + ".properties");
            if (properties != null) {
                properties.setProperty("fade", "false");
                properties.setProperty("rotate", "true");
                Layer layer = new Layer(prefix, properties);
                if (layer.valid) {
                    logger.fine("using %s.properties (%s) for the %s", prefix, layer.texture, objName);
                    this.objects.put(textureName, layer);
                }
            }
        }

        boolean active() {
            return !this.skies.isEmpty() || !this.objects.isEmpty();
        }

        void renderAll(Tessellator tessellator) {
            HashSet<String> texturesNeeded = new HashSet<String>();
            for (Layer layer : this.skies) {
                if (!layer.prepare()) continue;
                texturesNeeded.add(layer.texture);
            }
            HashSet<String> texturesToUnload = new HashSet<String>();
            texturesToUnload.addAll(this.textures);
            texturesToUnload.removeAll(texturesNeeded);
            for (String s : texturesToUnload) {
                TexturePackAPI.unloadTexture(s);
            }
            for (Layer layer : this.skies) {
                if (!(layer.brightness > 0.0f)) continue;
                layer.render(tessellator);
                Layer.clearBlendingMethod();
            }
        }

        Layer getCelestialObject(String defaultTexture) {
            return this.objects.get(defaultTexture);
        }

        void unloadTextures() {
            for (Layer layer : this.skies) {
                TexturePackAPI.unloadTexture(layer.texture);
            }
        }
    }
}

