/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCLogger;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.TexturePackAPI;
import com.pclewis.mcpatcher.mod.CustomAnimation;
import com.pclewis.mcpatcher.mod.FancyCompass;
import com.pclewis.mcpatcher.mod.MipmapHelper;
import com.pclewis.mcpatcher.mod.TileSize;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.ColorizerWater;
import net.minecraft.src.Compass;
import net.minecraft.src.Fire;
import net.minecraft.src.FlowLava;
import net.minecraft.src.FlowWater;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.Portal;
import net.minecraft.src.StillLava;
import net.minecraft.src.StillWater;
import net.minecraft.src.TextureFX;
import net.minecraft.src.Watch;
import org.lwjgl.opengl.PixelFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureUtils {
    private static final MCLogger logger = MCLogger.getLogger("HD Textures");
    private static final boolean animatedFire = MCPatcherUtils.getBoolean("HD Textures", "animatedFire", true);
    private static final boolean animatedLava = MCPatcherUtils.getBoolean("HD Textures", "animatedLava", true);
    private static final boolean animatedWater = MCPatcherUtils.getBoolean("HD Textures", "animatedWater", true);
    private static final boolean animatedPortal = MCPatcherUtils.getBoolean("HD Textures", "animatedPortal", true);
    private static final boolean customFire = MCPatcherUtils.getBoolean("HD Textures", "customFire", true);
    private static final boolean customLava = MCPatcherUtils.getBoolean("HD Textures", "customLava", true);
    private static final boolean customWater = MCPatcherUtils.getBoolean("HD Textures", "customWater", true);
    private static final boolean customPortal = MCPatcherUtils.getBoolean("HD Textures", "customPortal", true);
    private static final boolean customOther = MCPatcherUtils.getBoolean("HD Textures", "customOther", true);
    private static final boolean fancyCompass = MCPatcherUtils.getBoolean("HD Textures", "fancyCompass", true);
    private static final boolean useTextureCache = false;
    private static final boolean reclaimGLMemory = false;
    private static final boolean useZombieHack = MCPatcherUtils.getBoolean("HD Textures", "zombieHack", true);
    private static final int zombieAspectRatio = TextureUtils.getAspectRatio("/mob/zombie.png");
    private static final int pigZombieAspectRatio = TextureUtils.getAspectRatio("/mob/pigzombie.png");
    private static final int aaSamples = MCPatcherUtils.getInt("HD Textures", "antiAliasing", 0);
    private static final int LAVA_STILL_TEXTURE_INDEX = 237;
    private static final int LAVA_FLOWING_TEXTURE_INDEX = 238;
    private static final int WATER_STILL_TEXTURE_INDEX = 205;
    private static final int WATER_FLOWING_TEXTURE_INDEX = 206;
    private static final int FIRE_E_W_TEXTURE_INDEX = 31;
    private static final int FIRE_N_S_TEXTURE_INDEX = 47;
    private static final int PORTAL_TEXTURE_INDEX = 14;
    private static final String ALL_ITEMS = "/gui/allitems.png";
    private static final String ALL_ITEMSX = "/gui/allitemsx.png";
    private static boolean enableResizing = true;
    private static final HashMap<String, Integer> expectedColumns = new HashMap();
    private static final HashMap<String, BufferedImage> imageCache = new HashMap();
    private static boolean bindImageReentry;
    public static boolean oldCreativeGui;

    private static int getAspectRatio(String texture) {
        BufferedImage image;
        int ratio = 0;
        if (useZombieHack && (image = MCPatcherUtils.readImage(TextureUtils.class.getResourceAsStream(texture))) != null) {
            int height;
            int width = image.getWidth();
            if (width == 2 * (height = image.getHeight())) {
                ratio = 2;
            } else if (width == height) {
                ratio = 1;
            }
        }
        return ratio;
    }

    public static void registerTextureFX(List<TextureFX> textureList, TextureFX textureFX) {
        TextureFX fx = TextureUtils.refreshTextureFX(textureFX);
        if (fx != null) {
            logger.finer("registering new TextureFX class %s", textureFX.getClass().getName());
            textureList.add(fx);
            fx.onTick();
        }
    }

    private static TextureFX refreshTextureFX(TextureFX textureFX) {
        if (textureFX instanceof Compass || textureFX instanceof Watch || textureFX instanceof StillLava || textureFX instanceof FlowLava || textureFX instanceof StillWater || textureFX instanceof FlowWater || textureFX instanceof Fire || textureFX instanceof Portal) {
            return null;
        }
        Class<?> textureFXClass = textureFX.getClass();
        logger.info("attempting to refresh unknown animation %s", textureFXClass.getName());
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        block12: for (int i = 0; i < 3; ++i) {
            try {
                switch (i) {
                    case 0: {
                        Constructor<?> constructor = textureFXClass.getConstructor(Minecraft.class, Integer.TYPE);
                        textureFX = (TextureFX)constructor.newInstance(minecraft, TileSize.int_size);
                        break block12;
                    }
                    case 1: {
                        Constructor<?> constructor = textureFXClass.getConstructor(Minecraft.class);
                        textureFX = (TextureFX)constructor.newInstance(minecraft);
                        break block12;
                    }
                    case 2: {
                        Constructor<?> constructor = textureFXClass.getConstructor(new Class[0]);
                        textureFX = (TextureFX)constructor.newInstance(new Object[0]);
                        break block12;
                    }
                }
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (textureFX.imageData.length < TileSize.int_numBytes) {
            logger.finer("resizing %s buffer from %d to %d bytes", textureFXClass.getName(), textureFX.imageData.length, TileSize.int_numBytes);
            textureFX.imageData = new byte[TileSize.int_numBytes];
        }
        try {
            Method setup = textureFXClass.getDeclaredMethod("setup", new Class[0]);
            setup.setAccessible(true);
            logger.info("calling %s", setup);
            setup.invoke((Object)textureFX, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return textureFX;
    }

    public static void refreshTextureFX(List<TextureFX> textureList) {
        ArrayList<TextureFX> savedTextureFX = new ArrayList<TextureFX>();
        for (TextureFX t : textureList) {
            TextureFX fx = TextureUtils.refreshTextureFX(t);
            if (fx == null) continue;
            savedTextureFX.add(fx);
        }
        textureList.clear();
        CustomAnimation.clear();
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        if (!fancyCompass || !FancyCompass.refresh()) {
            textureList.add((TextureFX)new Compass(minecraft));
        }
        textureList.add((TextureFX)new Watch(minecraft));
        boolean isDefault = TexturePackAPI.isDefaultTexturePack();
        if (!isDefault && customLava) {
            CustomAnimation.addStripOrTile("/terrain.png", "lava_still", 237, 1, -1, -1);
            CustomAnimation.addStripOrTile("/terrain.png", "lava_flowing", 238, 2, 3, 6);
        } else if (animatedLava) {
            textureList.add((TextureFX)new StillLava());
            textureList.add((TextureFX)new FlowLava());
        }
        if (!isDefault && customWater) {
            CustomAnimation.addStripOrTile("/terrain.png", "water_still", 205, 1, -1, -1);
            CustomAnimation.addStripOrTile("/terrain.png", "water_flowing", 206, 2, 0, 0);
        } else if (animatedWater) {
            textureList.add((TextureFX)new StillWater());
            textureList.add((TextureFX)new FlowWater());
        }
        if (!isDefault && customFire && TexturePackAPI.hasResource("/anim/custom_fire_e_w.png") && TexturePackAPI.hasResource("/anim/custom_fire_n_s.png")) {
            CustomAnimation.addStrip("/terrain.png", "fire_n_s", 47, 1);
            CustomAnimation.addStrip("/terrain.png", "fire_e_w", 31, 1);
        } else if (animatedFire) {
            textureList.add((TextureFX)new Fire(0));
            textureList.add((TextureFX)new Fire(1));
        }
        if (!isDefault && customPortal && TexturePackAPI.hasResource("/anim/custom_portal.png")) {
            CustomAnimation.addStrip("/terrain.png", "portal", 14, 1);
        } else if (animatedPortal) {
            textureList.add((TextureFX)new Portal());
        }
        if (customOther) {
            TextureUtils.addOtherTextureFX("/terrain.png", "terrain");
            TextureUtils.addOtherTextureFX("/gui/items.png", "item");
            for (String name : TexturePackAPI.listResources("/anim/", ".properties")) {
                if (TextureUtils.isCustomTerrainItemResource(name)) continue;
                CustomAnimation.addStrip(TexturePackAPI.getProperties(name));
            }
        }
        for (TextureFX t : savedTextureFX) {
            textureList.add(t);
        }
        for (TextureFX t : textureList) {
            t.onTick();
        }
        CustomAnimation.updateAll();
    }

    private static void addOtherTextureFX(String textureName, String imageName) {
        for (int tileNum = 0; tileNum < 256; ++tileNum) {
            String resource = "/anim/custom_" + imageName + "_" + tileNum + ".png";
            if (!TexturePackAPI.hasResource(resource)) continue;
            CustomAnimation.addStrip(textureName, imageName + "_" + tileNum, tileNum, 1);
        }
    }

    public static ByteBuffer getByteBuffer(ByteBuffer buffer, byte[] data) {
        buffer.clear();
        int have = buffer.capacity();
        int needed = data.length;
        if (needed > have) {
            logger.finest("resizing gl buffer from 0x%x to 0x%x", have, needed);
            buffer = GLAllocation.createDirectByteBuffer((int)needed);
        }
        buffer.put(data);
        buffer.position(0).limit(needed);
        TileSize.int_glBufferSize = needed;
        return buffer;
    }

    private static boolean isCustomTerrainItemResource(String resource) {
        return (resource = resource.replaceFirst("^/anim", "").replaceFirst("\\.(png|properties)$", "")).equals("/custom_lava_still") || resource.equals("/custom_lava_flowing") || resource.equals("/custom_water_still") || resource.equals("/custom_water_flowing") || resource.equals("/custom_fire_n_s") || resource.equals("/custom_fire_e_w") || resource.equals("/custom_portal") || resource.matches("^/custom_(terrain|item)_\\d+$");
    }

    public static BufferedImage getImage(Object o1, Object o2, String resource) throws IOException {
        return TexturePackAPI.getImage(resource);
    }

    private static boolean setTileSize() {
        int size = TextureUtils.getTileSize();
        if (size == TileSize.int_size) {
            logger.fine("tile size %d unchanged", size);
            return false;
        }
        logger.fine("setting tile size to %d (was %d)", size, TileSize.int_size);
        TileSize.setTileSize(size);
        return true;
    }

    private static int getTileSize() {
        int size = 0;
        enableResizing = false;
        for (Map.Entry<String, Integer> entry : expectedColumns.entrySet()) {
            BufferedImage image = TexturePackAPI.getImage(entry.getKey());
            if (image == null) continue;
            int newSize = image.getWidth() / entry.getValue();
            logger.fine("%s tile size is %d", entry.getKey(), newSize);
            size = Math.max(size, newSize);
        }
        enableResizing = true;
        return size > 0 ? size : 16;
    }

    static BufferedImage resizeImage(BufferedImage image, int width) {
        if (width == image.getWidth()) {
            return image;
        }
        int height = image.getHeight() * width / image.getWidth();
        logger.finer("resizing to %dx%d", width, height);
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = newImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, width, height, null);
        return newImage;
    }

    private static void refreshColorizer(int[] colorBuffer, String resource) {
        BufferedImage image = TexturePackAPI.getImage(resource);
        logger.fine("reloading %s", resource);
        if (image != null) {
            image.getRGB(0, 0, 256, 256, colorBuffer, 0, 256);
        }
    }

    public static boolean bindImageBegin() {
        if (bindImageReentry) {
            logger.warning("caught TextureFX.bindImage recursion", new Object[0]);
            return false;
        }
        bindImageReentry = true;
        return true;
    }

    public static void bindImageEnd() {
        bindImageReentry = false;
    }

    public static PixelFormat getAAPixelFormat(PixelFormat format) {
        return aaSamples > 0 ? format.withSamples(aaSamples) : format;
    }

    static {
        expectedColumns.put("/terrain.png", 16);
        expectedColumns.put("/gui/items.png", 16);
        expectedColumns.put("/misc/dial.png", 1);
        logger.fine("/mob/zombie.png aspect ratio is %d:1", zombieAspectRatio);
        logger.fine("/mob/pigzombie.png aspect ratio is %d:1", pigZombieAspectRatio);
        TexturePackAPI.instance = new TexturePackAPI(){

            protected InputStream getInputStreamImpl(String s) {
                InputStream input;
                if (oldCreativeGui && s.equals(TextureUtils.ALL_ITEMS) && (input = super.getInputStreamImpl(TextureUtils.ALL_ITEMSX)) != null) {
                    return input;
                }
                input = super.getInputStreamImpl(s);
                if (input == null && s.startsWith("/anim/custom_")) {
                    input = super.getInputStreamImpl(s.substring(5));
                }
                return input;
            }

            protected BufferedImage getImageImpl(String s) {
                Integer i;
                BufferedImage image = super.getImageImpl(s);
                if (image == null) {
                    return null;
                }
                int width = image.getWidth();
                int height = image.getHeight();
                logger.finer("opened %s %dx%d", s, width, height);
                if (enableResizing && (i = (Integer)expectedColumns.get(s)) != null && width != i * TileSize.int_size) {
                    image = TextureUtils.resizeImage(image, i * TileSize.int_size);
                }
                if (s.matches("^/mob/.*_eyes\\d*\\.png$")) {
                    int p = 0;
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            int argb = image.getRGB(x, y);
                            if ((argb & 0xFF000000) != 0 || argb == 0) continue;
                            image.setRGB(x, y, 0);
                            ++p;
                        }
                    }
                    if (p > 0) {
                        logger.finest("  fixed %d transparent pixels", p, s);
                    }
                }
                image = this.resizeMobTexture("zombie", zombieAspectRatio, s, image);
                image = this.resizeMobTexture("pigzombie", pigZombieAspectRatio, s, image);
                return image;
            }

            private BufferedImage resizeMobTexture(String mob, int aspectRatio, String texture, BufferedImage image) {
                if (aspectRatio != 0 && texture.matches("/mob/" + mob + "\\d*\\.png")) {
                    int width = image.getWidth();
                    int height = image.getHeight();
                    if (aspectRatio == 1 && width == 2 * height) {
                        logger.fine("resizing %s to %dx%d", texture, width, 2 * height);
                        BufferedImage newImage = new BufferedImage(width, 2 * height, 2);
                        Graphics2D graphics2D = newImage.createGraphics();
                        graphics2D.drawImage(image, 0, 0, width, height, 0, 0, width, height, null);
                        image = newImage;
                    } else if (aspectRatio == 2 && width == height) {
                        logger.fine("resizing %s to %dx%d", texture, width, height / 2);
                        BufferedImage newImage = new BufferedImage(width, height / 2, 2);
                        Graphics2D graphics2D = newImage.createGraphics();
                        graphics2D.drawImage(image, 0, 0, width, height / 2, 0, 0, width, height / 2, null);
                        image = newImage;
                    }
                }
                return image;
            }
        };
        TexturePackAPI.ChangeHandler.register(new TexturePackAPI.ChangeHandler("HD Textures", 1){

            protected void onChange() {
                imageCache.clear();
                MipmapHelper.reset();
                TextureUtils.setTileSize();
                Minecraft minecraft = MCPatcherUtils.getMinecraft();
                minecraft.renderEngine.reloadTextures(minecraft);
                if (ColorizerWater.colorBuffer != ColorizerFoliage.colorBuffer) {
                    TextureUtils.refreshColorizer(ColorizerWater.colorBuffer, "/misc/watercolor.png");
                }
                TextureUtils.refreshColorizer(ColorizerGrass.colorBuffer, "/misc/grasscolor.png");
                TextureUtils.refreshColorizer(ColorizerFoliage.colorBuffer, "/misc/foliagecolor.png");
            }
        });
    }
}

