/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.login;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.kc.main.Main;
import net.minecraft.launcher.authentication.AuthenticationDatabase;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.authentication.exceptions.AuthenticationException;
import net.minecraft.launcher.authentication.exceptions.InvalidCredentialsException;
import net.minecraft.launcher.authentication.yggdrasil.YggdrasilAuthenticationService;
import net.minecraft.launcher.ui.popups.login.LogInPopup;
import org.apache.commons.lang3.ArrayUtils;

public class LogInForm
extends JPanel
implements ActionListener {
    public final LogInPopup popup;
    public final JTextField usernameField = new JTextField();
    private final JComboBox userDropdown = new JComboBox();
    private final JPanel userDropdownPanel = new JPanel();
    private final AuthenticationService authentication = new YggdrasilAuthenticationService();

    public LogInForm(LogInPopup popup) {
        this.popup = popup;
        this.usernameField.addActionListener(this);
        this.createInterface();
    }

    protected void createInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.weightx = 1.0;
        this.add(Box.createGlue());
        JLabel usernameLabel = new JLabel("Username:");
        Font labelFont = usernameLabel.getFont().deriveFont(1);
        Font smalltextFont = usernameLabel.getFont().deriveFont((float)labelFont.getSize() - 2.0f);
        usernameLabel.setFont(labelFont);
        this.add((Component)usernameLabel, constraints);
        this.add((Component)this.usernameField, constraints);
        this.add(Box.createVerticalStrut(10), constraints);
        this.createUserDropdownPanel(labelFont);
        this.add((Component)this.userDropdownPanel, constraints);
        this.add(Box.createVerticalStrut(10), constraints);
    }

    protected void createUserDropdownPanel(Font labelFont) {
        this.userDropdownPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.weightx = 1.0;
        this.userDropdownPanel.add(Box.createVerticalStrut(8), constraints);
        JLabel userDropdownLabel = new JLabel("Character Name:");
        userDropdownLabel.setFont(labelFont);
        this.userDropdownPanel.add((Component)userDropdownLabel, constraints);
        this.userDropdownPanel.add((Component)this.userDropdown, constraints);
        this.userDropdownPanel.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.usernameField) {
            String name = this.usernameField.getText().toLowerCase();
            if (name.equalsIgnoreCase("")) {
                this.popup.getErrorForm().displayError(new String[]{"Sorry, but you can't have a blank username.", "Please choose another username!"});
            } else if (Main.dnames.contains(name.toLowerCase())) {
                this.popup.getErrorForm().displayError(new String[]{"Sorry, you aren't allowed to use this username!", "Please choose another username!"});
            } else {
                this.tryLogIn();
            }
        }
    }

    public void tryLogIn() {
        if (this.authentication.isLoggedIn() && this.authentication.getSelectedProfile() == null && ArrayUtils.isNotEmpty(this.authentication.getAvailableProfiles())) {
            this.popup.setCanLogIn(false);
            GameProfile selectedProfile = null;
            for (GameProfile profile : this.authentication.getAvailableProfiles()) {
                if (!profile.getName().equals(this.userDropdown.getSelectedItem())) continue;
                selectedProfile = profile;
                break;
            }
            if (selectedProfile == null) {
                selectedProfile = this.authentication.getAvailableProfiles()[0];
            }
            final GameProfile finalSelectedProfile = selectedProfile;
            this.popup.getLauncher().getVersionManager().getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LogInForm.this.authentication.selectGameProfile(finalSelectedProfile);
                        LogInForm.this.popup.getLauncher().getProfileManager().getAuthDatabase().register(LogInForm.this.authentication.getSelectedProfile().getId(), LogInForm.this.authentication);
                        LogInForm.this.popup.setLoggedIn(LogInForm.this.authentication.getSelectedProfile().getId());
                    }
                    catch (InvalidCredentialsException ex) {
                        LogInForm.this.popup.getLauncher().println(ex);
                        LogInForm.this.popup.getErrorForm().displayError(new String[]{"Sorry, but we couldn't log you in right now.", "Please try again later."});
                        LogInForm.this.popup.setCanLogIn(true);
                    }
                    catch (AuthenticationException ex) {
                        LogInForm.this.popup.getLauncher().println(ex);
                        LogInForm.this.popup.getErrorForm().displayError(new String[]{"Sorry, but we couldn't connect to our servers.", "Please make sure that you are online and that Minecraft is not blocked."});
                        LogInForm.this.popup.setCanLogIn(true);
                    }
                }
            });
        } else {
            this.popup.setCanLogIn(false);
            this.authentication.logOut();
            this.authentication.setUsername(this.usernameField.getText());
            this.authentication.setPassword("genericPassword");
            this.popup.getLauncher().getVersionManager().getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LogInForm.this.authentication.logIn();
                        AuthenticationDatabase authDatabase = LogInForm.this.popup.getLauncher().getProfileManager().getAuthDatabase();
                        if (LogInForm.this.authentication.getSelectedProfile() == null) {
                            if (ArrayUtils.isNotEmpty(LogInForm.this.authentication.getAvailableProfiles())) {
                                for (GameProfile profile : LogInForm.this.authentication.getAvailableProfiles()) {
                                    LogInForm.this.userDropdown.addItem(profile.getName());
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        LogInForm.this.usernameField.setEditable(false);
                                        LogInForm.this.userDropdownPanel.setVisible(true);
                                        LogInForm.this.popup.repack();
                                        LogInForm.this.popup.setCanLogIn(true);
                                    }
                                });
                            } else {
                                String uuid = "demo-" + LogInForm.this.authentication.getUsername();
                                authDatabase.register(uuid, LogInForm.this.authentication);
                                LogInForm.this.popup.setLoggedIn(uuid);
                            }
                        } else {
                            authDatabase.register(LogInForm.this.authentication.getSelectedProfile().getId(), LogInForm.this.authentication);
                            LogInForm.this.popup.setLoggedIn(LogInForm.this.authentication.getSelectedProfile().getId());
                        }
                    }
                    catch (InvalidCredentialsException ex) {
                        LogInForm.this.popup.getLauncher().println(ex);
                        LogInForm.this.popup.getErrorForm().displayError(new String[]{"Sorry, but your username or password is incorrect!", "Please try again. If you need help, try the 'Forgot Password' link."});
                        LogInForm.this.popup.setCanLogIn(true);
                    }
                    catch (AuthenticationException ex) {
                        LogInForm.this.popup.getLauncher().println(ex);
                        LogInForm.this.popup.getErrorForm().displayError(new String[]{"Sorry, but we couldn't connect to our servers.", "Please make sure that you are online and that Minecraft is not blocked."});
                        LogInForm.this.popup.setCanLogIn(true);
                    }
                }
            });
        }
    }
}

