/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import com.google.gson.Gson;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessLauncher;
import net.minecraft.launcher.process.JavaProcessRunnable;
import net.minecraft.launcher.profile.LauncherVisibilityRule;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.ui.tabs.CrashReportTab;
import net.minecraft.launcher.updater.DateTypeAdapter;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.updater.download.DownloadJob;
import net.minecraft.launcher.updater.download.DownloadListener;
import net.minecraft.launcher.updater.download.Downloadable;
import net.minecraft.launcher.updater.download.assets.AssetIndex;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Library;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;

public class GameLauncher
implements JavaProcessRunnable,
DownloadListener {
    private final Object lock = new Object();
    private final DateTypeAdapter dateAdapter = new DateTypeAdapter();
    private final Gson gson = new Gson();
    private final Launcher launcher;
    private final List<DownloadJob> jobs = new ArrayList<DownloadJob>();
    private CompleteVersion version;
    private LauncherVisibilityRule visibilityRule;
    private boolean isWorking;
    private File nativeDir;

    public GameLauncher(Launcher launcher) {
        this.launcher = launcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorking(boolean working) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nativeDir != null) {
                Launcher.getInstance().println("Deleting " + this.nativeDir);
                if (!this.nativeDir.isDirectory() || FileUtils.deleteQuietly(this.nativeDir)) {
                    this.nativeDir = null;
                } else {
                    Launcher.getInstance().println("Couldn't delete " + this.nativeDir + " - scheduling for deletion upon exit");
                    try {
                        FileUtils.forceDeleteOnExit(this.nativeDir);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.isWorking = working;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GameLauncher.this.launcher.getLauncherPanel().getBottomBar().getPlayButtonPanel().checkState();
                }
            });
        }
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playGame() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isWorking) {
                Launcher.getInstance().println("Tried to play game but game is already starting!");
                return;
            }
            this.setWorking(true);
        }
        Launcher.getInstance().println("Getting syncinfo for selected version");
        Profile profile = this.launcher.getProfileManager().getSelectedProfile();
        String lastVersionId = profile.getLastVersionId();
        VersionSyncInfo syncInfo = null;
        this.visibilityRule = profile.getLauncherVisibilityOnGameClose() == null ? Profile.DEFAULT_LAUNCHER_VISIBILITY : profile.getLauncherVisibilityOnGameClose();
        if (lastVersionId != null) {
            syncInfo = this.launcher.getVersionManager().getVersionSyncInfo(lastVersionId);
        }
        if (syncInfo == null || syncInfo.getLatestVersion() == null) {
            syncInfo = this.launcher.getVersionManager().getVersions(profile.getVersionFilter()).get(0);
        }
        if (syncInfo == null) {
            Launcher.getInstance().println("Tried to launch a version without a version being selected...");
            this.setWorking(false);
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            Launcher.getInstance().println("Queueing library & version downloads");
            try {
                this.version = this.launcher.getVersionManager().getLatestCompleteVersion(syncInfo);
            }
            catch (IOException e) {
                Launcher.getInstance().println("Couldn't get complete version info for " + syncInfo.getLatestVersion(), e);
                this.setWorking(false);
                return;
            }
            if (syncInfo.getRemoteVersion() != null && syncInfo.getLatestSource() != VersionSyncInfo.VersionSource.REMOTE && !this.version.isSynced()) {
                try {
                    CompleteVersion remoteVersion = this.launcher.getVersionManager().getRemoteVersionList().getCompleteVersion(syncInfo.getRemoteVersion());
                    this.launcher.getVersionManager().getLocalVersionList().removeVersion(this.version);
                    this.launcher.getVersionManager().getLocalVersionList().addVersion(remoteVersion);
                    ((LocalVersionList)this.launcher.getVersionManager().getLocalVersionList()).saveVersion(remoteVersion);
                    this.version = remoteVersion;
                }
                catch (IOException e) {
                    Launcher.getInstance().println("Couldn't sync local and remote versions", e);
                }
                this.version.setSynced(true);
            }
            if (!this.version.appliesToCurrentEnvironment()) {
                String reason = this.version.getIncompatibilityReason();
                if (reason == null) {
                    reason = "This version is incompatible with your computer. Please try another one by going into Edit Profile and selecting one through the dropdown. Sorry!";
                }
                Launcher.getInstance().println("Version " + this.version.getId() + " is incompatible with current environment: " + reason);
                JOptionPane.showMessageDialog(this.launcher.getFrame(), reason, "Cannot play game", 0);
                this.setWorking(false);
                return;
            }
            if (!syncInfo.isInstalled()) {
                try {
                    VersionList localVersionList = this.launcher.getVersionManager().getLocalVersionList();
                    if (localVersionList instanceof LocalVersionList) {
                        ((LocalVersionList)localVersionList).saveVersion(this.version);
                        Launcher.getInstance().println("Installed " + syncInfo.getLatestVersion());
                    }
                }
                catch (IOException e) {
                    Launcher.getInstance().println("Couldn't save version info to install " + syncInfo.getLatestVersion(), e);
                    this.setWorking(false);
                    return;
                }
            }
            try {
                DownloadJob librariesJob = new DownloadJob("Version & Libraries", false, this);
                this.addJob(librariesJob);
                this.launcher.getVersionManager().downloadVersion(syncInfo, librariesJob);
                librariesJob.startDownloading(this.launcher.getDownloaderExecutorService());
                this.migrateOldAssets();
                DownloadJob resourceJob = new DownloadJob("Resources", true, this);
                this.addJob(resourceJob);
                this.launcher.getVersionManager().downloadResources(resourceJob, this.version);
                resourceJob.startDownloading(this.launcher.getDownloaderExecutorService());
            }
            catch (IOException e) {
                Launcher.getInstance().println("Couldn't get version info for " + syncInfo.getLatestVersion(), e);
                this.setWorking(false);
                return;
            }
        }
    }

    private File getAssetObject(String name) throws IOException {
        File assetsDir = new File(this.launcher.getWorkingDirectory(), "assets");
        File indexDir = new File(assetsDir, "indexes");
        File objectsDir = new File(assetsDir, "objects");
        String assetVersion = this.version.getAssets() == null ? "legacy" : this.version.getAssets();
        File indexFile = new File(indexDir, assetVersion + ".json");
        AssetIndex index = this.gson.fromJson(FileUtils.readFileToString(indexFile, Charsets.UTF_8), AssetIndex.class);
        String hash = index.getFileMap().get(name).getHash();
        return new File(objectsDir, hash.substring(0, 2) + "/" + hash);
    }

    private File reconstructAssets() throws IOException {
        File assetsDir = new File(this.launcher.getWorkingDirectory(), "assets");
        File indexDir = new File(assetsDir, "indexes");
        File objectDir = new File(assetsDir, "objects");
        String assetVersion = this.version.getAssets() == null ? "legacy" : this.version.getAssets();
        File indexFile = new File(indexDir, assetVersion + ".json");
        File virtualRoot = new File(new File(assetsDir, "virtual"), assetVersion);
        if (!indexFile.isFile()) {
            Launcher.getInstance().println("No assets index file " + virtualRoot + "; can't reconstruct assets");
            return virtualRoot;
        }
        AssetIndex index = this.gson.fromJson(FileUtils.readFileToString(indexFile, Charsets.UTF_8), AssetIndex.class);
        if (index.isVirtual()) {
            Launcher.getInstance().println("Reconstructing virtual assets folder at " + virtualRoot);
            for (Map.Entry<String, AssetIndex.AssetObject> entry : index.getFileMap().entrySet()) {
                File target = new File(virtualRoot, entry.getKey());
                File original = new File(new File(objectDir, entry.getValue().getHash().substring(0, 2)), entry.getValue().getHash());
                if (target.isFile()) continue;
                FileUtils.copyFile(original, target, false);
            }
            FileUtils.writeStringToFile(new File(virtualRoot, ".lastused"), this.dateAdapter.serializeToString(new Date()));
        }
        return virtualRoot;
    }

    private void migrateOldAssets() {
        File sourceDir = new File(this.launcher.getWorkingDirectory(), "assets");
        File objectsDir = new File(sourceDir, "objects");
        if (!sourceDir.isDirectory()) {
            return;
        }
        IOFileFilter migratableFilter = FileFilterUtils.notFileFilter(FileFilterUtils.or(FileFilterUtils.nameFileFilter("indexes"), FileFilterUtils.nameFileFilter("objects"), FileFilterUtils.nameFileFilter("virtual")));
        Collection<File> fColl = FileUtils.listFiles(sourceDir, TrueFileFilter.TRUE, migratableFilter);
        TreeSet<File> ftree = new TreeSet<File>(fColl);
        for (File file : ftree) {
            String hash = Downloadable.getDigest(file, "SHA-1", 40);
            File destinationFile = new File(objectsDir, hash.substring(0, 2) + "/" + hash);
            if (!destinationFile.exists()) {
                Launcher.getInstance().println("Migrated old asset " + file.toString() + " into " + destinationFile.toString());
                try {
                    FileUtils.copyFile(file, destinationFile);
                }
                catch (IOException e) {
                    Launcher.getInstance().println("Couldn't migrate old asset", e);
                }
            }
            FileUtils.deleteQuietly(file);
        }
        File[] assets = sourceDir.listFiles();
        if (assets != null) {
            for (File file : assets) {
                if (file.getName().equals("indexes") || file.getName().equals("objects") || file.getName().equals("virtual")) continue;
                Launcher.getInstance().println("Cleaning up old assets directory " + file.toString() + " after migration");
                FileUtils.deleteQuietly(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackNatives(File targetDir) throws IOException {
        OperatingSystem os = OperatingSystem.getCurrentPlatform();
        Collection<Library> libraries = this.version.getRelevantLibraries();
        for (Library library : libraries) {
            Map<OperatingSystem, String> nativesPerOs = library.getNatives();
            if (nativesPerOs == null || nativesPerOs.get((Object)os) == null) continue;
            File file = new File(this.launcher.getWorkingDirectory(), "libraries/" + library.getArtifactPath(nativesPerOs.get((Object)os)));
            ZipFile zip = new ZipFile(file);
            ExtractRules extractRules = library.getExtractRules();
            try {
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (extractRules != null && !extractRules.shouldExtract(entry.getName())) continue;
                    File targetFile = new File(targetDir, entry.getName());
                    if (targetFile.getParentFile() != null) {
                        targetFile.getParentFile().mkdirs();
                    }
                    if (entry.isDirectory()) continue;
                    BufferedInputStream inputStream = new BufferedInputStream(zip.getInputStream(entry));
                    byte[] buffer = new byte[2048];
                    FileOutputStream outputStream = new FileOutputStream(targetFile);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                    try {
                        int length;
                        while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                            bufferedOutputStream.write(buffer, 0, length);
                        }
                    }
                    finally {
                        Downloadable.closeSilently(bufferedOutputStream);
                        Downloadable.closeSilently(outputStream);
                        Downloadable.closeSilently(inputStream);
                    }
                }
            }
            finally {
                zip.close();
            }
        }
    }

    protected void launchGame() throws IOException {
        File assetsDir;
        Launcher.getInstance().println("Launching game");
        Profile selectedProfile = this.launcher.getProfileManager().getSelectedProfile();
        if (this.version == null) {
            Launcher.getInstance().println("Aborting launch; version is null?");
            return;
        }
        this.cleanOldNatives();
        this.nativeDir = new File(this.launcher.getWorkingDirectory(), "versions/" + this.version.getId() + "/" + this.version.getId() + "-natives-" + System.nanoTime());
        if (!this.nativeDir.isDirectory()) {
            this.nativeDir.mkdirs();
        }
        Launcher.getInstance().println("Unpacking natives to " + this.nativeDir);
        try {
            this.unpackNatives(this.nativeDir);
        }
        catch (IOException e) {
            Launcher.getInstance().println("Couldn't unpack natives!", e);
            return;
        }
        try {
            assetsDir = this.reconstructAssets();
        }
        catch (IOException e) {
            Launcher.getInstance().println("Couldn't unpack natives!", e);
            return;
        }
        File gameDirectory = selectedProfile.getGameDir() == null ? this.launcher.getWorkingDirectory() : selectedProfile.getGameDir();
        Launcher.getInstance().println("Launching in " + gameDirectory);
        if (!gameDirectory.exists()) {
            if (!gameDirectory.mkdirs()) {
                Launcher.getInstance().println("Aborting launch; couldn't create game directory");
            }
        } else if (!gameDirectory.isDirectory()) {
            Launcher.getInstance().println("Aborting launch; game directory is not actually a directory");
            return;
        }
        JavaProcessLauncher processLauncher = new JavaProcessLauncher(selectedProfile.getJavaPath(), new String[0]);
        processLauncher.directory(gameDirectory);
        OperatingSystem os = OperatingSystem.getCurrentPlatform();
        if (os.equals((Object)OperatingSystem.OSX)) {
            processLauncher.addCommands(new String[]{"-Xdock:icon=" + this.getAssetObject("icons/minecraft.icns").getAbsolutePath(), "-Xdock:name=Minecraft"});
        } else if (os.equals((Object)OperatingSystem.WINDOWS)) {
            processLauncher.addCommands(new String[]{"-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump"});
        }
        String profileArgs = selectedProfile.getJavaArgs();
        if (profileArgs != null) {
            processLauncher.addSplitCommands(profileArgs);
        } else {
            boolean is32Bit = "32".equals(System.getProperty("sun.arch.data.model"));
            String defaultArgument = is32Bit ? "-Xmx512M" : "-Xmx1G";
            processLauncher.addSplitCommands(defaultArgument);
        }
        processLauncher.addCommands(new String[]{"-Djava.library.path=" + this.nativeDir.getAbsolutePath()});
        processLauncher.addCommands(new String[]{"-cp", this.constructClassPath(this.version)});
        processLauncher.addCommands(new String[]{this.version.getMainClass()});
        Launcher.getInstance().println("Half command: " + StringUtils.join(processLauncher.getFullCommands(), " "));
        AuthenticationService auth = this.launcher.getProfileManager().getAuthDatabase().getByUUID(selectedProfile.getPlayerUUID());
        String[] args = this.getMinecraftArguments(this.version, selectedProfile, gameDirectory, assetsDir, auth);
        if (args == null) {
            return;
        }
        processLauncher.addCommands(args);
        Proxy proxy = this.launcher.getProxy();
        PasswordAuthentication proxyAuth = this.launcher.getProxyAuth();
        if (!proxy.equals(Proxy.NO_PROXY)) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            processLauncher.addCommands(new String[]{"--proxyHost", address.getHostName()});
            processLauncher.addCommands(new String[]{"--proxyPort", Integer.toString(address.getPort())});
            if (proxyAuth != null) {
                processLauncher.addCommands(new String[]{"--proxyUser", proxyAuth.getUserName()});
                processLauncher.addCommands(new String[]{"--proxyPass", new String(proxyAuth.getPassword())});
            }
        }
        processLauncher.addCommands(this.launcher.getAdditionalArgs());
        if (auth == null || auth.getSelectedProfile() == null) {
            processLauncher.addCommands(new String[]{"--demo"});
        }
        if (selectedProfile.getResolution() != null) {
            processLauncher.addCommands(new String[]{"--width", String.valueOf(selectedProfile.getResolution().getWidth())});
            processLauncher.addCommands(new String[]{"--height", String.valueOf(selectedProfile.getResolution().getHeight())});
        }
        try {
            Launcher.getInstance().println("Running " + StringUtils.join(processLauncher.getFullCommands(), " "));
            JavaProcess process = processLauncher.start();
            process.safeSetExitRunnable(this);
            if (this.visibilityRule != LauncherVisibilityRule.DO_NOTHING) {
                this.launcher.getFrame().setVisible(false);
            }
        }
        catch (IOException e) {
            Launcher.getInstance().println("Couldn't launch game", e);
            this.setWorking(false);
            return;
        }
    }

    private String[] getMinecraftArguments(CompleteVersion version, Profile selectedProfile, File gameDirectory, File assetsDirectory, AuthenticationService authentication) {
        if (version.getMinecraftArguments() == null) {
            Launcher.getInstance().println("Can't run version, missing minecraftArguments");
            this.setWorking(false);
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StrSubstitutor substitutor = new StrSubstitutor(map);
        String[] split = version.getMinecraftArguments().split(" ");
        map.put("auth_access_token", "-");
        map.put("user_properties", "{}");
        map.put("auth_username", authentication.getUsername());
        map.put("auth_session", "-");
        if (authentication.getSelectedProfile() != null) {
            map.put("auth_player_name", authentication.getSelectedProfile().getName());
            map.put("auth_uuid", authentication.getSelectedProfile().getId());
        } else {
            map.put("auth_player_name", "Player");
            map.put("auth_uuid", new UUID(0L, 0L).toString());
        }
        map.put("profile_name", selectedProfile.getName());
        map.put("version_name", version.getId());
        map.put("game_directory", gameDirectory.getAbsolutePath());
        map.put("game_assets", assetsDirectory.getAbsolutePath());
        map.put("assets_root", new File(this.launcher.getWorkingDirectory(), "assets").getAbsolutePath());
        map.put("assets_index_name", version.getAssets() == null ? "legacy" : version.getAssets());
        for (int i = 0; i < split.length; ++i) {
            split[i] = substitutor.replace(split[i]);
        }
        return split;
    }

    public void cleanOldNatives() {
        File root = new File(this.launcher.getWorkingDirectory(), "versions/");
        AgeFileFilter ageFilter = new AgeFileFilter(System.currentTimeMillis() - 3600L);
        for (File version : root.listFiles(DirectoryFileFilter.DIRECTORY)) {
            File[] fileList;
            for (File folder : fileList = version.listFiles(FileFilterUtils.and(new PrefixFileFilter(version.getName() + "-natives-"), ageFilter))) {
                FileUtils.deleteQuietly(folder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackNatives(CompleteVersion version, File targetDir) throws IOException {
        OperatingSystem os = OperatingSystem.getCurrentPlatform();
        Collection<Library> libraries = version.getRelevantLibraries();
        for (Library library : libraries) {
            Map<OperatingSystem, String> nativesPerOs = library.getNatives();
            if (nativesPerOs == null || nativesPerOs.get((Object)os) == null) continue;
            File file = new File(this.launcher.getWorkingDirectory(), "libraries/" + library.getArtifactPath(nativesPerOs.get((Object)os)));
            ZipFile zip = new ZipFile(file);
            ExtractRules extractRules = library.getExtractRules();
            try {
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (extractRules != null && !extractRules.shouldExtract(entry.getName())) continue;
                    File targetFile = new File(targetDir, entry.getName());
                    if (targetFile.getParentFile() != null) {
                        targetFile.getParentFile().mkdirs();
                    }
                    if (entry.isDirectory()) continue;
                    BufferedInputStream inputStream = new BufferedInputStream(zip.getInputStream(entry));
                    byte[] buffer = new byte[2048];
                    FileOutputStream outputStream = new FileOutputStream(targetFile);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                    try {
                        int length;
                        while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                            bufferedOutputStream.write(buffer, 0, length);
                        }
                    }
                    finally {
                        Downloadable.closeSilently(bufferedOutputStream);
                        Downloadable.closeSilently(outputStream);
                        Downloadable.closeSilently(inputStream);
                    }
                }
            }
            finally {
                zip.close();
            }
        }
    }

    private String constructClassPath(CompleteVersion version) {
        StringBuilder result = new StringBuilder();
        Collection<File> classPath = version.getClassPath(OperatingSystem.getCurrentPlatform(), this.launcher.getWorkingDirectory());
        String separator = System.getProperty("path.separator");
        for (File file : classPath) {
            if (!file.isFile()) {
                throw new RuntimeException("Classpath file not found: " + file);
            }
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(file.getAbsolutePath());
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onJavaProcessEnded(JavaProcess process) {
        block10: {
            String errorText;
            block12: {
                int exitCode;
                block11: {
                    exitCode = process.getExitCode();
                    if (exitCode != 0) break block11;
                    Launcher.getInstance().println("Game ended with no troubles detected (exit code " + exitCode + ")");
                    if (this.visibilityRule == LauncherVisibilityRule.CLOSE_LAUNCHER) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GameLauncher.this.launcher.println("Following visibility rule and exiting launcher as the game has ended");
                                GameLauncher.this.launcher.closeLauncher();
                            }
                        });
                    } else if (this.visibilityRule == LauncherVisibilityRule.HIDE_LAUNCHER) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GameLauncher.this.launcher.println("Following visibility rule and showing launcher as the game has ended");
                                GameLauncher.this.launcher.getFrame().setVisible(true);
                            }
                        });
                    }
                    break block10;
                }
                Launcher.getInstance().println("Game ended with bad state (exit code " + exitCode + ")");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GameLauncher.this.launcher.println("Ignoring visibility rule and showing launcher due to a game crash");
                        GameLauncher.this.launcher.getFrame().setVisible(true);
                    }
                });
                errorText = null;
                String[] sysOut = process.getSysOutLines().getItems();
                for (int i = sysOut.length - 1; i >= 0; --i) {
                    String line = sysOut[i];
                    String crashIdentifier = "#@!@#";
                    int pos = line.lastIndexOf(crashIdentifier);
                    if (pos < 0 || pos >= line.length() - crashIdentifier.length() - 1) continue;
                    errorText = line.substring(pos + crashIdentifier.length()).trim();
                    break;
                }
                if (errorText == null) break block10;
                File file = new File(errorText);
                if (!file.isFile()) break block12;
                Launcher.getInstance().println("Crash report detected, opening: " + errorText);
                FileInputStream inputStream = null;
                try {
                    String line;
                    inputStream = new FileInputStream(file);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    StringBuilder result = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        if (result.length() > 0) {
                            result.append("\n");
                        }
                        result.append(line);
                    }
                    reader.close();
                    this.launcher.getLauncherPanel().getTabPanel().setCrashReport(new CrashReportTab(this.launcher, this.version, file, result.toString()));
                }
                catch (IOException e) {
                    try {
                        Launcher.getInstance().println("Couldn't open crash report", e);
                    }
                    catch (Throwable throwable) {
                        Downloadable.closeSilently(inputStream);
                        throw throwable;
                    }
                    Downloadable.closeSilently(inputStream);
                    break block10;
                }
                Downloadable.closeSilently(inputStream);
                break block10;
            }
            Launcher.getInstance().println("Crash report detected, but unknown format: " + errorText);
        }
        this.setWorking(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadJobFinished(DownloadJob job) {
        this.updateProgressBar();
        Object object = this.lock;
        synchronized (object) {
            if (job.getFailures() > 0) {
                this.launcher.println("Job '" + job.getName() + "' finished with " + job.getFailures() + " failure(s)!");
                this.setWorking(false);
            } else {
                this.launcher.println("Job '" + job.getName() + "' finished successfully");
                if (this.isWorking() && !this.hasRemainingJobs()) {
                    try {
                        this.launchGame();
                    }
                    catch (Throwable ex) {
                        Launcher.getInstance().println("Fatal error launching game. Report this to http://mojang.atlassian.net please!", ex);
                    }
                }
            }
        }
    }

    @Override
    public void onDownloadJobProgressChanged(DownloadJob job) {
        this.updateProgressBar();
    }

    protected void updateProgressBar() {
        final float progress = this.getProgress();
        final boolean hasTasks = this.hasRemainingJobs();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GameLauncher.this.launcher.getLauncherPanel().getProgressBar().setVisible(hasTasks);
                GameLauncher.this.launcher.getLauncherPanel().getProgressBar().setValue((int)(progress * 100.0f));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float getProgress() {
        Object object = this.lock;
        synchronized (object) {
            float max = 0.0f;
            float result = 0.0f;
            for (DownloadJob job : this.jobs) {
                float progress = job.getProgress();
                if (!(progress >= 0.0f)) continue;
                result += progress;
                max += 1.0f;
            }
            return result / max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemainingJobs() {
        Object object = this.lock;
        synchronized (object) {
            for (DownloadJob job : this.jobs) {
                if (job.isComplete()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(DownloadJob job) {
        Object object = this.lock;
        synchronized (object) {
            this.jobs.add(job);
        }
    }
}

